% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_prop}
\alias{get_prop}
\title{Generic function to extract a property from a model summary}
\usage{
get_prop(
  xpdb,
  prop,
  .problem = NULL,
  .subprob = NULL,
  .method = NULL,
  .tail = 1
)
}
\arguments{
\item{xpdb}{<\code{xpose_data}\link[xpose:xpose_data]{xpose::xpose_data}> object}

\item{prop}{<\code{character}> Property to extract}

\item{.problem}{<\code{numeric}> Problem number to use. Uses the xpose default if not provided.}

\item{.subprob}{<\code{numeric}> Subproblem number to use. Uses the xpose default if not provided.}

\item{.method}{<\code{character}> Method to use. Uses the xpose default if not provided.}

\item{.tail}{<\code{numeric}> Length of terminal values to pull when there are more than 1 result}
}
\value{
Exact value for the property
}
\description{
Generic function to extract a property from a model summary
}
\examples{

data("xpdb_ex_pk", package = "xpose")

get_prop(xpdb_ex_pk, "descr")
}
