% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xplot_rocplot.R
\name{xplot_rocplot}
\alias{xplot_rocplot}
\title{Default xpose ROC plot function}
\usage{
xplot_rocplot(
  xpdb,
  mapping = NULL,
  type = "c",
  guide = TRUE,
  xscale = "continuous",
  yscale = "continuous",
  group = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  tag = NULL,
  plot_name = "xplot_rocplot",
  gg_theme,
  xp_theme,
  opt,
  quiet,
  thres_fixed = 0.5,
  like_col = NULL,
  obs_col = NULL,
  obs_target = NULL,
  auc_sprintf = "AUC: \%.3f",
  ...
)
}
\arguments{
\item{xpdb}{<\code{xp_xtras}> or <\code{xpose_data}> object}

\item{mapping}{\code{ggplot2} style mapping}

\item{type}{See Details.}

\item{guide}{Should the guide (e.g. unity line) be displayed.}

\item{xscale}{Defaults to \code{continuous}.}

\item{yscale}{Defaults to \code{continuous}.}

\item{group}{Grouping for curves or points}

\item{title}{Plot title}

\item{subtitle}{Plot subtitle}

\item{caption}{Plot caption}

\item{tag}{Plot tag}

\item{plot_name}{Metadata name of plot}

\item{gg_theme}{As in \code{xpose}}

\item{xp_theme}{As in \code{xpose}}

\item{opt}{Processing options for fetched data}

\item{quiet}{Silence extra debugging output}

\item{thres_fixed}{Fixed threshold value for space}

\item{like_col}{Column for likelihood/probability value}

\item{obs_col}{Column for observed value}

\item{obs_target}{Target observed value for likelihood}

\item{auc_sprintf}{Format to apply to AUC label}

\item{...}{Any additional aesthetics.}
}
\value{
The desired plot
}
\description{
Manually generate ROCs from an xpdb object.
}
\details{
For type-based customization of plots:
\itemize{
\item \code{c} ROC curve (using \code{geom_path})
\item \code{k} Key points on ROC curve (where on curve the
threshold is \code{thres_fixed}) (using \code{geom_point})
\item \code{p} ROC space points (using \code{geom_point})
\item \code{t} ROC space text (using \code{geom_text})
\item \code{a} AUC in bottom right (using \code{geom_label})
}
}
