\encoding{UTF-8}
\name{LawMethods}
\alias{LawMethods}
\alias{rand}
\alias{rand-method}
\alias{cdf}
\alias{quant}
\alias{char}
\alias{dens}

\title{Methods for an Object of Class \code{yuima.law}}
\description{Methods for an object of class \code{\link{yuima.law}}.}
\usage{
rand(object, n, param, ...)
dens(object, x, param, log = FALSE, ...)
cdf(object, q, param, ...)
quant(object, p, param, ...)
}
\arguments{
  \item{object}{ an object of class \code{\link{yuima.law}}}
  \item{n}{sample size of random number to be generated by means of the method \code{rand}.}
  \item{param}{vector containing model parameters}
  \item{...}{additional arguments.}
  \item{x}{vector containing values for the evaluation of the density using the method \code{dens}.}
  \item{log}{logical variable. If TRUE the method \code{dens} returns the log density at \code{x}}
  \item{q}{a  vector for the evaluation of the cdf.}
  \item{p}{a set of probabilities for the evaluation of the quantile function.}
}

\value{
\item{rand}{returns a vector of random numbers.}
\item{dens}{returns the density at \code{x}.}
\item{cdf}{returns the cumulative distribution function at \code{q}.}
\item{quant}{returns the quantile function at \code{p}.}
}
\author{
YUIMA TEAM}
\note{ There may be missing information in the description. Please contribute with suggestions and fixings.

Contacts: Lorenzo Mercuri \email{lorenzo.mercuri@unimi.it}}
