% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codec.R
\docType{class}
\name{zarr_codec_transpose}
\alias{zarr_codec_transpose}
\title{Zarr transpose codec}
\description{
The Zarr "transpose" codec registers the storage order of a data
object relative to the canonical row-major ordering of Zarr. If the
registered ordering is different from the native ordering on the platform
where the array is being read, the data object will be permuted upon
reading.

R data is arranged in column-major order. The most efficient storage
arrangement between Zarr and R is thus column-major ordering, avoiding
encoding to the canonical row-major ordering during storage and decoding to
column-major ordering during a read. If the storage arrangement is not
row-major ordering, a transpose codec must be added to the array
definition. Note that within R, both writing and reading are no-ops when
data is stored in column-major ordering. On the other hand, when no
transpose codec is defined for the array, there will be an automatic
transpose of the data on writing and reading to maintain compatibility with
the Zarr specification. Using the \link{array_builder} will automatically add
the transpose codec to the array definition.

For maximum portability (e.g. with Zarr implementations outside of R that
do not implement the transpose codec), data should be stored in row-major
order, which can be achieved by not including this codec in the array
definition.
}
\section{Super classes}{
\code{\link[zarr:zarr_extension]{zarr::zarr_extension}} -> \code{\link[zarr:zarr_codec]{zarr::zarr_codec}} -> \code{zarr_codec_transpose}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{order}}{Set or retrieve the 0-based ordering of the dimensions of
the array when storing}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-zarr_codec_transpose-new}{\code{zarr_codec_transpose$new()}}
\item \href{#method-zarr_codec_transpose-copy}{\code{zarr_codec_transpose$copy()}}
\item \href{#method-zarr_codec_transpose-encode}{\code{zarr_codec_transpose$encode()}}
\item \href{#method-zarr_codec_transpose-decode}{\code{zarr_codec_transpose$decode()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="zarr" data-topic="zarr_codec" data-id="metadata_fragment"><a href='../../zarr/html/zarr_codec.html#method-zarr_codec-metadata_fragment'><code>zarr::zarr_codec$metadata_fragment()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zarr" data-topic="zarr_codec" data-id="print"><a href='../../zarr/html/zarr_codec.html#method-zarr_codec-print'><code>zarr::zarr_codec$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_codec_transpose-new"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_codec_transpose-new}{}}}
\subsection{Method \code{new()}}{
Create a new "transpose" codec object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_codec_transpose$new(shape_length, configuration = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{shape_length}}{The length of the shape of the array that this codec
operates on.}

\item{\code{configuration}}{Optional. A list with the configuration parameters
for this codec. The element \code{order} specifies the ordering of the
dimensions of the shape relative to the Zarr canonical arrangement. An
integer vector with a length equal to argument
\code{shape_length}. The ordering must be 0-based. If not given, the default R
ordering is used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_codec_transpose-copy"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_codec_transpose-copy}{}}}
\subsection{Method \code{copy()}}{
Create a new, independent copy of this codec.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_codec_transpose$copy()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An instance of \code{zarr_codec_transpose}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_codec_transpose-encode"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_codec_transpose-encode}{}}}
\subsection{Method \code{encode()}}{
This method permutes a data object to match the desired
dimension ordering.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_codec_transpose$encode(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be permuted, an R matrix or array.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The permuted data object, a matrix or array in Zarr store
dimension order.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_codec_transpose-decode"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_codec_transpose-decode}{}}}
\subsection{Method \code{decode()}}{
This method permutes a data object from a Zarr store to an
R matrix or array.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_codec_transpose$decode(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be permuted, from a Zarr store.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The permuted data object, an R matrix or array.
}
}
}
