



















//! ## Matrix Representation



























//! ## Portability and Performance

















//! ## Features

//! ### `std`



//! This crate can be used without the standard library (`#![no_std]`) by











//! [`target-cpu`](https://doc.rust-lang.org/rustc/codegen-options/index.html#target-cpu)

//! [`target-feature`](https://doc.rust-lang.org/rustc/codegen-options/index.html#target-feature)


//! ### `threading`







//! ### `cgemm`








//! ### `constconf`







//! ## Other Notes




//! ## Rust Version







#![doc(html_root_url = "https://docs.rs/matrixmultiply/0.3/")]
#![cfg_attr(not(feature = "std"), no_std)]

#[cfg(not(feature = "std"))]
extern crate alloc;
#[cfg(feature = "std")]
extern crate core;

#[macro_use]
mod debugmacros;
#[macro_use]
mod loopmacros;

mod archparam_defaults;

#[cfg(feature = "constconf")]
mod archparam;
#[cfg(feature = "constconf")]
mod constparse;

#[cfg(not(feature = "constconf"))]
pub(crate) use archparam_defaults as archparam;

mod gemm;
mod kernel;
mod packing;
mod ptr;
mod threading;

mod aligned_alloc;
mod util;

#[macro_use]
mod archmacros;
#[cfg(any(target_arch = "x86", target_arch = "x86_64"))]
#[macro_use]
mod x86;
#[cfg(any(target_arch = "aarch64"))]
#[macro_use]
mod aarch64;

mod dgemm_kernel;
mod sgemm_kernel;

pub use crate::gemm::dgemm;
pub use crate::gemm::sgemm;

#[cfg(feature = "cgemm")]
#[macro_use]
mod cgemm_common;
#[cfg(feature = "cgemm")]
mod cgemm_kernel;
#[cfg(feature = "cgemm")]
mod zgemm_kernel;

#[cfg(feature = "cgemm")]
pub use crate::gemm::cgemm;
#[cfg(feature = "cgemm")]
pub use crate::gemm::zgemm;
#[cfg(feature = "cgemm")]
pub use crate::gemm::CGemmOption;
