#!/bin/bash
# tex->pdf

if [ $# -eq 0 ]
  then
    echo "No arguments supplied"
    echo "converting all tex-files to a gif image:"
    for file in *.tex ; do
      STEM=`basename $file .tex`
      echo "convert $file ..." 
      latex $file
      latex $file
      dvips $STEM.dvi
      ps2pdf $STEM.ps 
      magick convert -delay 5 -density 100x100 -alpha remove $STEM.pdf -loop 0 $STEM.gif
      echo "... done $STEM.gif"
    done
  else
    STEM=`basename $1 .tex`
    echo "convert $1 ..." 
    latex $1
    latex $1
    dvips $STEM.dvi
    ps2pdf $STEM.ps 
    magick convert -delay 5 -density 100x100 -alpha remove $STEM.pdf -loop 0 $STEM.gif
    echo "... done $STEM.gif"
fi
rm *.aux
rm *.log
rm *.ps
rm *.pdf
rm *.dvi