Package Name: fariscovernew

Author: Faris Hameed
Email: classsec81@gmail.com

License: LaTeX Project Public License (LPPL) version 1.3c

Version: 1.0
Date: 2026-02-16

============================================================
fariscovernew — Modern Title Page Generator for Arabic and English
============================================================

Description
-----------
fariscovernew is a LaTeX package for generating modern and highly
customizable title pages (cover pages) for Arabic and English documents.

The package supports multiple visual styles, dynamic color schemes,
font customization, and advanced geometric layouts including layered
diamond compositions.

It is designed for use with XeLaTeX or LuaLaTeX.

Main Features
-------------
• Arabic and English language support
• Multiple cover styles:
  triple
  diagonal
  wave
  badge
  diamond
  minimal
  ribbon
  sidebar
  corner
  diamondx (advanced layered geometry)

• Customizable:
  - Title and subtitle font sizes
  - Main and accent colors
  - Font families
  - Subtitle ratio
  - Advanced geometric parameters (diamondx mode)

Compilation
-----------
This package requires:

  XeLaTeX or LuaLaTeX
  fontspec
  polyglossia
  xcolor
  tikz

Basic Usage
-----------
Load the package:

  \usepackage{fariscovernew}

Create a title page:

  \FarisTitlePage[Lang][TitlePt][SubtitlePt][Color][MainFont][SubFont][SubRatio]{Title}{Subtitle}

Environment alternative:

  \begin{FarisTitlePageEnv}[...]{Title}{Subtitle}
  \end{FarisTitlePageEnv}

Advanced Style (diamondx)
--------------------------
Additional commands for advanced geometric customization:

  \FarisDiamondBackComplementOn
  \FarisDiamondBackComplementOff
  \FarisSetDiamondTints{<front>}{<back>}
  \FarisSetDiamondBackTintII{<value>}
  \FarisSetDiamondAnglePair{<angle>}
  \FarisSetDiamondAngles{<A>}{<B>}
  \FarisSetDiamondBackDelta{<delta>}
  \FarisSetDiamondTriadOffset{<offset>}

Documentation
-------------
See the included guide file:
  guide_fariscovernew_full.tex

Installation
------------
Place fariscovernew.sty in your local texmf tree or install it
via your TeX distribution package manager after CTAN approval.

Engine requirement: XeLaTeX or LuaLaTeX

License
-------
This work may be distributed and/or modified under the
conditions of the LaTeX Project Public License (LPPL),
either version 1.3c of this license or (at your option)
any later version.

The latest version of the license is available at:
  https://www.latex-project.org/lppl.txt

Maintainer
----------
Faris Hameed
classsec81@gmail.com
