# 史记五帝本纪

本示例展示了 `luatex-cn` 宏包在处理复杂古籍排版时的强大功能，特别是针对传统《史记》版本的重现。

## 来源与背景
- **原件来源**：[Internet Archive](https://archive.org/details/06054495.cn/page/n145/mode/2up)
- colored-example.jpg 来自[台湾国立故宫博物院](https://theme.npm.edu.tw/selection/Article.aspx?sNo=04001076)。
- **年代**：清代刻本风格
- **内容**：摘自《史记·五帝本纪第一》

## 排版特点
- **乌丝栏**：正文带有传统的垂直黑色细线格（乌丝栏）。
- **排版缩进**：演示了段落首行的传统缩进处理。
- **版心设计**：自定义版心文字（书名、卷号），并带有典型的“单鱼尾”装饰。
- **字体风格**：采用了楷书手写体（模仿刻本效果）。
- **加注系统**：实现了复杂的夹注（文字中间的小字解释）。
- **印章覆盖**：演示了如何使用绝对定位将印章（红色图片）透明覆盖在文字之上，模拟古籍中的馆藏印效果。

## 我们做了什么
1.  **参数配置**：在 `.cfg` 文件中精确定义了版面尺寸、栏数及间距，以匹配原件比例。
2.  **印章渲染**：利用 Lua 驱动的定位逻辑，将印章图片精确放置在页面的特定位置。
3.  **版心自动生成**：利用 `banxin` 模块自动在每页中间生成书名、卷名及页码。
4.  **注文排版**：测试了注文在不同位置的自动折行与对齐。