; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

define i8 @select_condition_implies_highbits_op1(i8 %xx, i8 noundef %y) {
; CHECK-LABEL: @select_condition_implies_highbits_op1(
; CHECK-NEXT:    [[X:%.*]] = and i8 [[XX:%.*]], 15
; CHECK-NEXT:    [[COND:%.*]] = icmp ult i8 [[Y:%.*]], 3
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND]], i8 [[Y]], i8 [[X]]
; CHECK-NEXT:    [[R:%.*]] = or disjoint i8 [[SEL]], 32
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = and i8 %xx, 15
  %cond = icmp ult i8 %y, 3
  %sel = select i1 %cond, i8 %y, i8 %x
  %r = add i8 %sel, 32
  ret i8 %r
}

define i8 @select_condition_implies_highbits_op1_maybe_undef_fail(i8 %xx, i8 %y) {
; CHECK-LABEL: @select_condition_implies_highbits_op1_maybe_undef_fail(
; CHECK-NEXT:    [[X:%.*]] = and i8 [[XX:%.*]], 15
; CHECK-NEXT:    [[COND:%.*]] = icmp ult i8 [[Y:%.*]], 3
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND]], i8 [[Y]], i8 [[X]]
; CHECK-NEXT:    [[R:%.*]] = add i8 [[SEL]], 32
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = and i8 %xx, 15
  %cond = icmp ult i8 %y, 3
  %sel = select i1 %cond, i8 %y, i8 %x
  %r = add i8 %sel, 32
  ret i8 %r
}

define i8 @select_condition_implies_highbits_op2(i8 %xx, i8 noundef %y) {
; CHECK-LABEL: @select_condition_implies_highbits_op2(
; CHECK-NEXT:    [[X:%.*]] = and i8 [[XX:%.*]], 15
; CHECK-NEXT:    [[COND:%.*]] = icmp ugt i8 [[Y:%.*]], 3
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND]], i8 [[X]], i8 [[Y]]
; CHECK-NEXT:    [[R:%.*]] = or disjoint i8 [[SEL]], 32
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = and i8 %xx, 15
  %cond = icmp ugt i8 %y, 3
  %sel = select i1 %cond, i8 %x, i8 %y
  %r = add i8 %sel, 32
  ret i8 %r
}

define i8 @select_condition_implies_highbits_op1_and(i8 %xx, i8 noundef %y, i1 %other_cond) {
; CHECK-LABEL: @select_condition_implies_highbits_op1_and(
; CHECK-NEXT:    [[X:%.*]] = and i8 [[XX:%.*]], 15
; CHECK-NEXT:    [[COND0:%.*]] = icmp ult i8 [[Y:%.*]], 3
; CHECK-NEXT:    [[COND:%.*]] = and i1 [[COND0]], [[OTHER_COND:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND]], i8 [[Y]], i8 [[X]]
; CHECK-NEXT:    [[R:%.*]] = or disjoint i8 [[SEL]], 32
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = and i8 %xx, 15
  %cond0 = icmp ult i8 %y, 3
  %cond = and i1 %cond0, %other_cond
  %sel = select i1 %cond, i8 %y, i8 %x
  %r = add i8 %sel, 32
  ret i8 %r
}

define i8 @select_condition_implies_highbits_op2_or(i8 %xx, i8 noundef %y, i1 %other_cond) {
; CHECK-LABEL: @select_condition_implies_highbits_op2_or(
; CHECK-NEXT:    [[X:%.*]] = and i8 [[XX:%.*]], 15
; CHECK-NEXT:    [[COND0:%.*]] = icmp ugt i8 [[Y:%.*]], 3
; CHECK-NEXT:    [[COND:%.*]] = or i1 [[COND0]], [[OTHER_COND:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND]], i8 [[X]], i8 [[Y]]
; CHECK-NEXT:    [[R:%.*]] = or disjoint i8 [[SEL]], 32
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = and i8 %xx, 15
  %cond0 = icmp ugt i8 %y, 3
  %cond = or i1 %cond0, %other_cond
  %sel = select i1 %cond, i8 %x, i8 %y
  %r = add i8 %sel, 32
  ret i8 %r
}
