; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -verify-machineinstrs -stop-before=ppc-vsx-copy -vec-extabi \
; RUN:     -mcpu=pwr7  -mtriple powerpc64-ibm-aix-xcoff < %s | \
; RUN: FileCheck %s

;; Fixed vector arguments to variadic functions are passed differently than
;; either arguments to non-variadic functions or arguments passed through
;; ellipses.
define double @callee(i32 signext %count, <4 x i32> %vsi, double %next, ...) {
  ; CHECK-LABEL: name: callee
  ; CHECK: bb.0.entry:
  ; CHECK:   liveins: $x8, $x9, $x10
  ; CHECK:   [[COPY:%[0-9]+]]:g8rc = COPY $x10
  ; CHECK:   [[COPY1:%[0-9]+]]:g8rc = COPY $x9
  ; CHECK:   [[COPY2:%[0-9]+]]:g8rc = COPY $x8
  ; CHECK:   STD [[COPY2]], 0, %fixed-stack.0 :: (store (s64) into %fixed-stack.0)
  ; CHECK:   STD [[COPY1]], 8, %fixed-stack.0 :: (store (s64) into %fixed-stack.0 + 8)
  ; CHECK:   STD [[COPY]], 16, %fixed-stack.0 :: (store (s64))
  ; CHECK:   LIFETIME_START %stack.0.arg_list
  ; CHECK:   [[ADDI8_:%[0-9]+]]:g8rc = ADDI8 %fixed-stack.0, 0
  ; CHECK:   STD killed [[ADDI8_]], 0, %stack.0.arg_list :: (store (s64) into %ir.arg_list)
  ; CHECK:   [[ADDI8_1:%[0-9]+]]:g8rc = ADDI8 %fixed-stack.0, 15
  ; CHECK:   [[RLDICR:%[0-9]+]]:g8rc_and_g8rc_nox0 = RLDICR killed [[ADDI8_1]], 0, 59
  ; CHECK:   [[LFD:%[0-9]+]]:f8rc = LFD 16, killed [[RLDICR]] :: (load (s64) from %ir.argp.next, align 16)
  ; CHECK:   LIFETIME_END %stack.0.arg_list
  ; CHECK:   $f1 = COPY [[LFD]]
  ; CHECK:   BLR8 implicit $lr8, implicit $rm, implicit $f1
entry:
  %arg_list = alloca ptr, align 8
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg_list)
  call void @llvm.va_start(ptr nonnull %arg_list)
  %argp.cur = load ptr, ptr %arg_list, align 8
  %0 = ptrtoint ptr %argp.cur to i64
  %1 = add i64 %0, 15
  %2 = and i64 %1, -16
  %argp.cur.aligned = inttoptr i64 %2 to ptr
  %argp.next = getelementptr inbounds i8, ptr %argp.cur.aligned, i64 16
  %argp.next3 = getelementptr inbounds i8, ptr %argp.cur.aligned, i64 24
  store ptr %argp.next3, ptr %arg_list, align 8
  %3 = load double, ptr %argp.next, align 16
  call void @llvm.va_end(ptr nonnull %arg_list)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg_list)
  ret double %3
}

declare void @llvm.lifetime.start.p0(i64 immarg, ptr nocapture)

declare void @llvm.va_start(ptr)

declare void @llvm.va_end(ptr)

declare void @llvm.lifetime.end.p0(i64 immarg, ptr nocapture)
