; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=instcombine < %s | FileCheck %s
target triple = "aarch64-unknown-linux-gnu"

define void @test_prf(ptr %base){
; CHECK-LABEL: define void @test_prf(
; CHECK-SAME: ptr [[BASE:%.*]]) {
; CHECK-NEXT:    ret void
;
  tail call void @llvm.aarch64.sve.prf.nxv16i1(<vscale x 16 x i1> zeroinitializer, ptr %base, i32 1)
  ret void
}

define void @test_prfb_gather_index(ptr %base, <vscale x 2 x i64> %indexes){
; CHECK-LABEL: define void @test_prfb_gather_index(
; CHECK-SAME: ptr [[BASE:%.*]], <vscale x 2 x i64> [[INDEXES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfb.gather.index.nx2vi64(<vscale x 2 x i1> zeroinitializer, ptr %base, <vscale x 2 x i64> %indexes, i32 1)
  ret void
}

define void @test_prfb_gather_scalar_offset(<vscale x 4 x i32> %bases){
; CHECK-LABEL: define void @test_prfb_gather_scalar_offset(
; CHECK-SAME: <vscale x 4 x i32> [[BASES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfb.gather.scalar.offset.nx4vi32(<vscale x 4 x i1> zeroinitializer, <vscale x 4 x i32> %bases, i64 7, i32 1)
  ret void
}

define void @test_prfb_gather_sxtw_index(ptr %base, <vscale x 4 x i32> %indexes){
; CHECK-LABEL: define void @test_prfb_gather_sxtw_index(
; CHECK-SAME: ptr [[BASE:%.*]], <vscale x 4 x i32> [[INDEXES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfb.gather.sxtw.index.nx4vi32(<vscale x 4 x i1> zeroinitializer, ptr %base, <vscale x 4 x i32> %indexes, i32 1)
  ret void
}

define void @test_prfb_gather_uxtw_index(ptr %base, <vscale x 4 x i32> %indexes){
; CHECK-LABEL: define void @test_prfb_gather_uxtw_index(
; CHECK-SAME: ptr [[BASE:%.*]], <vscale x 4 x i32> [[INDEXES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfb.gather.uxtw.index.nx4vi32(<vscale x 4 x i1> zeroinitializer, ptr %base, <vscale x 4 x i32> %indexes, i32 1)
  ret void
}

define void @test_prfd_gather_index(ptr %base, <vscale x 2 x i64> %indexes){
; CHECK-LABEL: define void @test_prfd_gather_index(
; CHECK-SAME: ptr [[BASE:%.*]], <vscale x 2 x i64> [[INDEXES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfd.gather.index.nx2vi64(<vscale x 2 x i1> zeroinitializer, ptr %base, <vscale x 2 x i64> %indexes, i32 1)
  ret void
}

define void @test_prfd_gather_scalar_offset(<vscale x 4 x i32> %bases){
; CHECK-LABEL: define void @test_prfd_gather_scalar_offset(
; CHECK-SAME: <vscale x 4 x i32> [[BASES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfd.gather.scalar.offset.nx4vi32(<vscale x 4 x i1> zeroinitializer, <vscale x 4 x i32> %bases, i64 7, i32 1)
  ret void
}

define void @test_prfd_gather_sxtw_index(ptr %base, <vscale x 4 x i32> %indexes){
; CHECK-LABEL: define void @test_prfd_gather_sxtw_index(
; CHECK-SAME: ptr [[BASE:%.*]], <vscale x 4 x i32> [[INDEXES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfd.gather.sxtw.index.nx4vi32(<vscale x 4 x i1> zeroinitializer, ptr %base, <vscale x 4 x i32> %indexes, i32 1)
  ret void
}

define void @test_prfd_gather_uxtw_index(ptr %base, <vscale x 4 x i32> %indexes){
; CHECK-LABEL: define void @test_prfd_gather_uxtw_index(
; CHECK-SAME: ptr [[BASE:%.*]], <vscale x 4 x i32> [[INDEXES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfd.gather.uxtw.index.nx4vi32(<vscale x 4 x i1> zeroinitializer, ptr %base, <vscale x 4 x i32> %indexes, i32 1)
  ret void
}

define void @test_prfh_gather_index(ptr %base, <vscale x 2 x i64> %indexes){
; CHECK-LABEL: define void @test_prfh_gather_index(
; CHECK-SAME: ptr [[BASE:%.*]], <vscale x 2 x i64> [[INDEXES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfh.gather.index.nx2vi64(<vscale x 2 x i1> zeroinitializer, ptr %base, <vscale x 2 x i64> %indexes, i32 1)
  ret void
}

define void @test_prfh_gather_scalar_offset(<vscale x 4 x i32> %bases){
; CHECK-LABEL: define void @test_prfh_gather_scalar_offset(
; CHECK-SAME: <vscale x 4 x i32> [[BASES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfh.gather.scalar.offset.nx4vi32(<vscale x 4 x i1> zeroinitializer, <vscale x 4 x i32> %bases, i64 7, i32 1)
  ret void
}

define void @test_prfh_gather_sxtw_index(ptr %base, <vscale x 4 x i32> %indexes){
; CHECK-LABEL: define void @test_prfh_gather_sxtw_index(
; CHECK-SAME: ptr [[BASE:%.*]], <vscale x 4 x i32> [[INDEXES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfh.gather.sxtw.index.nx4vi32(<vscale x 4 x i1> zeroinitializer, ptr %base, <vscale x 4 x i32> %indexes, i32 1)
  ret void
}

define void @test_prfh_gather_uxtw_index(ptr %base, <vscale x 4 x i32> %indexes){
; CHECK-LABEL: define void @test_prfh_gather_uxtw_index(
; CHECK-SAME: ptr [[BASE:%.*]], <vscale x 4 x i32> [[INDEXES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfh.gather.uxtw.index.nx4vi32(<vscale x 4 x i1> zeroinitializer, ptr %base, <vscale x 4 x i32> %indexes, i32 1)
  ret void
}

define void @test_prfw_gather_index(ptr %base, <vscale x 2 x i64> %indexes){
; CHECK-LABEL: define void @test_prfw_gather_index(
; CHECK-SAME: ptr [[BASE:%.*]], <vscale x 2 x i64> [[INDEXES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfw.gather.index.nx2vi64(<vscale x 2 x i1> zeroinitializer, ptr %base, <vscale x 2 x i64> %indexes, i32 1)
  ret void
}

define void @test_prfw_gather_scalar_offset(<vscale x 4 x i32> %bases){
; CHECK-LABEL: define void @test_prfw_gather_scalar_offset(
; CHECK-SAME: <vscale x 4 x i32> [[BASES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfw.gather.scalar.offset.nx4vi32(<vscale x 4 x i1> zeroinitializer, <vscale x 4 x i32> %bases, i64 7, i32 1)
  ret void
}

define void @test_prfw_gather_sxtw_index(ptr %base, <vscale x 4 x i32> %indexes){
; CHECK-LABEL: define void @test_prfw_gather_sxtw_index(
; CHECK-SAME: ptr [[BASE:%.*]], <vscale x 4 x i32> [[INDEXES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfw.gather.sxtw.index.nx4vi32(<vscale x 4 x i1> zeroinitializer, ptr %base, <vscale x 4 x i32> %indexes, i32 1)
  ret void
}

define void @test_prfw_gather_uxtw_index(ptr %base, <vscale x 4 x i32> %indexes){
; CHECK-LABEL: define void @test_prfw_gather_uxtw_index(
; CHECK-SAME: ptr [[BASE:%.*]], <vscale x 4 x i32> [[INDEXES:%.*]]) {
; CHECK-NEXT:    ret void
;
  call void @llvm.aarch64.sve.prfw.gather.uxtw.index.nx4vi32(<vscale x 4 x i1> zeroinitializer, ptr %base, <vscale x 4 x i32> %indexes, i32 1)
  ret void
}
