; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 < %s | FileCheck -check-prefixes=GCN,GFX9,GFX9-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 < %s | FileCheck -check-prefixes=GCN,GFX9,GFX9-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1030 < %s | FileCheck -check-prefixes=GCN,GFX1011,GFX10,GFX10-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1030 < %s | FileCheck -check-prefixes=GCN,GFX1011,GFX10,GFX10-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 -mattr=+real-true16 -amdgpu-enable-delay-alu=0 < %s | FileCheck -check-prefixes=GCN,GFX1011,GFX11,GFX11-SDAG,GFX11-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 -mattr=-real-true16 -amdgpu-enable-delay-alu=0 < %s | FileCheck -check-prefixes=GCN,GFX1011,GFX11,GFX11-SDAG,GFX11-SDAG-FAKE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 -mattr=+real-true16 -amdgpu-enable-delay-alu=0 < %s | FileCheck -check-prefixes=GCN,GFX1011,GFX11,GFX11-GISEL,GFX11-GISEL-TRUE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 -mattr=-real-true16 -amdgpu-enable-delay-alu=0 < %s | FileCheck -check-prefixes=GCN,GFX1011,GFX11,GFX11-GISEL,GFX11-GISEL-FAKE16 %s

; Test fmul by power of 2 which is better emitted as ldexp

declare half @llvm.fabs.f16(half)
declare <2 x half> @llvm.fabs.v2f16(<2 x half>)
declare float @llvm.fabs.f32(float)
declare <2 x float> @llvm.fabs.v2f32(<2 x float>)
declare double @llvm.fabs.f64(double)
declare <2 x double> @llvm.fabs.v2f64(<2 x double>)
declare i32 @llvm.amdgcn.readfirstlane(i32)

define float @v_mul_42_f32(float %x) {
; GCN-LABEL: v_mul_42_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x42280000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 42.0
  ret float %mul
}

define double @v_mul_42_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_42_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, 0x40450000
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], s[4:5]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_42_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x40450000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_mul_42_f64:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_mul_f64 v[0:1], 0x40450000, v[0:1]
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 42.0
  ret double %mul
}

define half @v_mul_42_f16(half %x) {
; GFX9-LABEL: v_mul_42_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0x5140, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_42_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0x5140, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_42_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x5140, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_42_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x5140, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_42_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x5140, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_42_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x5140, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 42.0
  ret half %mul
}

define <2 x half> @v_mul_42_v2f16(<2 x half> %x) {
; GFX9-SDAG-LABEL: v_mul_42_v2f16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0x5140
; GFX9-SDAG-NEXT:    v_pk_mul_f16 v0, v0, s4 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_42_v2f16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0x51405140
; GFX9-GISEL-NEXT:    v_pk_mul_f16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_42_v2f16:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_mul_f16 v0, 0x5140, v0 op_sel_hi:[0,1]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_42_v2f16:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_mul_f16 v0, 0x51405140, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_42_v2f16:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_pk_mul_f16 v0, 0x5140, v0 op_sel_hi:[0,1]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_42_v2f16:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_mul_f16 v0, 0x51405140, v0
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul <2 x half> %x, <half 42.0, half 42.0>
  ret <2 x half> %mul
}

; 0x1p-17
define float @v_mul_0x1pn17_f32(float %x) {
; GCN-LABEL: v_mul_0x1pn17_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x37000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 0.00000762939453125
  ret float %mul
}

; 0x1p-16
define float @v_mul_0x1pn16_f32(float %x) {
; GCN-LABEL: v_mul_0x1pn16_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x37800000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 0.0000152587890625
  ret float %mul
}

; 0x1p-15
define float @v_mul_0x1pn15_f32(float %x) {
; GCN-LABEL: v_mul_0x1pn15_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x38000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 0.000030517578125
  ret float %mul
}

define float @v_mul_neg256_f32(float %x) {
; GCN-LABEL: v_mul_neg256_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0xc3800000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, -256.0
  ret float %mul
}

define float @v_mul_neg128_f32(float %x) {
; GCN-LABEL: v_mul_neg128_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0xc3000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, -128.0
  ret float %mul
}

define float @v_mul_neg64_f32(float %x) {
; GCN-LABEL: v_mul_neg64_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0xc2800000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, -64.0
  ret float %mul
}

define float @v_mul_neg32_f32(float %x) {
; GCN-LABEL: v_mul_neg32_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0xc2000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, -32.0
  ret float %mul
}

define float @v_mul_neg16_f32(float %x) {
; GCN-LABEL: v_mul_neg16_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0xc1800000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, -16.0
  ret float %mul
}

define float @v_mul_neg8_f32(float %x) {
; GCN-LABEL: v_mul_neg8_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0xc1000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, -8.0
  ret float %mul
}

define float @v_mul_neg4_f32(float %x) {
; GCN-LABEL: v_mul_neg4_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, -4.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, -4.0
  ret float %mul
}

define float @v_mul_neg2_f32(float %x) {
; GCN-LABEL: v_mul_neg2_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, -2.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, -2.0
  ret float %mul
}

define float @v_mul_neg1_f32(float %x) {
; GCN-LABEL: v_mul_neg1_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, -1.0
  ret float %mul
}

define float @v_mul_neg_half_f32(float %x) {
; GCN-LABEL: v_mul_neg_half_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, -0.5, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, -0.5
  ret float %mul
}

define float @v_mul_neg_quarter_f32(float %x) {
; GCN-LABEL: v_mul_neg_quarter_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0xbe800000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, -0.25
  ret float %mul
}

define float @v_mul_quarter_f32(float %x) {
; GCN-LABEL: v_mul_quarter_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x3e800000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 0.25
  ret float %mul
}

define float @v_mul_half_f32(float %x) {
; GCN-LABEL: v_mul_half_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0.5, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 0.5
  ret float %mul
}

define float @v_mul_1_f32(float %x) {
; GCN-LABEL: v_mul_1_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 1.0
  ret float %mul
}

define float @v_mul_2_f32(float %x) {
; GFX9-SDAG-LABEL: v_mul_2_f32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_f32_e32 v0, v0, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_2_f32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mul_f32_e32 v0, 2.0, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_2_f32:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_f32_e32 v0, v0, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_2_f32:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f32_e32 v0, 2.0, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_2_f32:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_f32_e32 v0, v0, v0
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_2_f32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f32_e32 v0, 2.0, v0
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 2.0
  ret float %mul
}

define float @v_mul_4_f32(float %x) {
; GCN-LABEL: v_mul_4_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 4.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 4.0
  ret float %mul
}

define float @v_mul_8_f32(float %x) {
; GCN-LABEL: v_mul_8_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x41000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 8.0
  ret float %mul
}

define float @v_mul_16_f32(float %x) {
; GCN-LABEL: v_mul_16_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x41800000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 16.0
  ret float %mul
}

define float @v_mul_32_f32(float %x) {
; GCN-LABEL: v_mul_32_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x42000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 32.0
  ret float %mul
}

define float @v_mul_64_f32(float %x) {
; GCN-LABEL: v_mul_64_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x42800000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 64.0
  ret float %mul
}

define float @v_mul_128_f32(float %x) {
; GCN-LABEL: v_mul_128_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x43000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 128.0
  ret float %mul
}

define float @v_mul_256_f32(float %x) {
; GCN-LABEL: v_mul_256_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x43800000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 256.0
  ret float %mul
}

; 0x1p+63
define float @v_mul_0x1p63_f32(float %x) {
; GCN-LABEL: v_mul_0x1p63_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x5f000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 9223372036854775808.0
  ret float %mul
}

; 0x1p+64
define float @v_mul_0x1p64_f32(float %x) {
; GCN-LABEL: v_mul_0x1p64_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x5f800000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 18446744073709551616.0
  ret float %mul
}

; 0x1p+65
define float @v_mul_0x1p65_f32(float %x) {
; GCN-LABEL: v_mul_0x1p65_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x60000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, 36893488147419103232.0
  ret float %mul
}

; Check that this doesn't interfer with fma formation
define float @v_fma_mul_add_32_f32(float %x, float %y) {
; GFX9-SDAG-LABEL: v_fma_mul_add_32_f32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0x42000000
; GFX9-SDAG-NEXT:    v_fma_f32 v0, v0, s4, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_fma_mul_add_32_f32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX9-GISEL-NEXT:    v_fma_f32 v0, v0, v2, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_fma_mul_add_32_f32:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_fmamk_f32 v0, v0, 0x42000000, v1
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract float %x, 32.0
  %fma = fadd contract float %mul, %y
  ret float %fma
}

define float @v_fma_mul_sub_32_f32(float %x, float %y) {
; GFX9-SDAG-LABEL: v_fma_mul_sub_32_f32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0x42000000
; GFX9-SDAG-NEXT:    v_fma_f32 v0, v0, s4, -v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_fma_mul_sub_32_f32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX9-GISEL-NEXT:    v_fma_f32 v0, v0, v2, -v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_fma_mul_sub_32_f32:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_fma_f32 v0, 0x42000000, v0, -v1
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract float %x, 32.0
  %fma = fsub contract float %mul, %y
  ret float %fma
}

define float @v_fma_mul_add_neg32_f32(float %x, float %y) {
; GFX9-SDAG-LABEL: v_fma_mul_add_neg32_f32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0xc2000000
; GFX9-SDAG-NEXT:    v_fma_f32 v0, v0, s4, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_fma_mul_add_neg32_f32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0xc2000000
; GFX9-GISEL-NEXT:    v_fma_f32 v0, v0, v2, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_fma_mul_add_neg32_f32:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_fmamk_f32 v0, v0, 0xc2000000, v1
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract float %x, -32.0
  %fma = fadd contract float %mul, %y
  ret float %fma
}

define float @v_mul_fabs_32_f32(float %x) {
; GFX9-SDAG-LABEL: v_mul_fabs_32_f32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0x42000000
; GFX9-SDAG-NEXT:    v_mul_f32_e64 v0, |v0|, s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_fabs_32_f32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0x42000000
; GFX9-GISEL-NEXT:    v_mul_f32_e64 v0, |v0|, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_mul_fabs_32_f32:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_mul_f32_e64 v0, 0x42000000, |v0|
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %x.fabs = call float @llvm.fabs.f32(float %x)
  %mul = fmul float %x.fabs, 32.0
  ret float %mul
}

define float @v_mul_add_fma_fabs_32_f32(float %x, float %y) {
; GFX9-SDAG-LABEL: v_mul_add_fma_fabs_32_f32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0x42000000
; GFX9-SDAG-NEXT:    v_fma_f32 v0, |v0|, s4, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_add_fma_fabs_32_f32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX9-GISEL-NEXT:    v_fma_f32 v0, |v0|, v2, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_mul_add_fma_fabs_32_f32:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_fma_f32 v0, 0x42000000, |v0|, v1
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %x.fabs = call float @llvm.fabs.f32(float %x)
  %mul = fmul contract float %x.fabs, 32.0
  %fma = fadd contract float %mul, %y
  ret float %fma
}

define <2 x float> @v_mul_16_v2f32(<2 x float> %x) {
; GFX9-LABEL: v_mul_16_v2f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f32_e32 v0, 0x41800000, v0
; GFX9-NEXT:    v_mul_f32_e32 v1, 0x41800000, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_16_v2f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f32_e32 v0, 0x41800000, v0
; GFX10-NEXT:    v_mul_f32_e32 v1, 0x41800000, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_mul_16_v2f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mul_f32 v0, 0x41800000, v0 :: v_dual_mul_f32 v1, 0x41800000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul <2 x float> %x, <float 16.0, float 16.0>
  ret <2 x float> %mul
}

define <2 x float> @v_mul_neg16_v2f32(<2 x float> %x) {
; GFX9-LABEL: v_mul_neg16_v2f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f32_e32 v0, 0xc1800000, v0
; GFX9-NEXT:    v_mul_f32_e32 v1, 0xc1800000, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_neg16_v2f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f32_e32 v0, 0xc1800000, v0
; GFX10-NEXT:    v_mul_f32_e32 v1, 0xc1800000, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_mul_neg16_v2f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mul_f32 v0, 0xc1800000, v0 :: v_dual_mul_f32 v1, 0xc1800000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul <2 x float> %x, <float -16.0, float -16.0>
  ret <2 x float> %mul
}

define <2 x float> @v_mul_fabs_16_v2f32(<2 x float> %x) {
; GFX9-SDAG-LABEL: v_mul_fabs_16_v2f32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0x41800000
; GFX9-SDAG-NEXT:    v_mul_f32_e64 v0, |v0|, s4
; GFX9-SDAG-NEXT:    v_mul_f32_e64 v1, |v1|, s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_fabs_16_v2f32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0x41800000
; GFX9-GISEL-NEXT:    v_mul_f32_e64 v0, |v0|, v2
; GFX9-GISEL-NEXT:    v_mul_f32_e64 v1, |v1|, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_mul_fabs_16_v2f32:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_mul_f32_e64 v0, 0x41800000, |v0|
; GFX1011-NEXT:    v_mul_f32_e64 v1, 0x41800000, |v1|
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %x.fabs = call <2 x float> @llvm.fabs.v2f32(<2 x float> %x)
  %mul = fmul <2 x float> %x.fabs, <float 16.0, float 16.0>
  ret <2 x float> %mul
}

define <2 x float> @v_fma_mul_add_32_v2f32(<2 x float> %x, <2 x float> %y) {
; GFX9-SDAG-LABEL: v_fma_mul_add_32_v2f32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0x42000000
; GFX9-SDAG-NEXT:    v_fma_f32 v0, v0, s4, v2
; GFX9-SDAG-NEXT:    v_fma_f32 v1, v1, s4, v3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_fma_mul_add_32_v2f32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0x42000000
; GFX9-GISEL-NEXT:    v_fma_f32 v0, v0, v4, v2
; GFX9-GISEL-NEXT:    v_fma_f32 v1, v1, v4, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fma_mul_add_32_v2f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_fmamk_f32 v0, v0, 0x42000000, v2
; GFX10-NEXT:    v_fmamk_f32 v1, v1, 0x42000000, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fma_mul_add_32_v2f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_fmamk_f32 v0, v0, 0x42000000, v2 :: v_dual_fmamk_f32 v1, v1, 0x42000000, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract <2 x float> %x, <float 32.0, float 32.0>
  %fma = fadd contract <2 x float> %mul, %y
  ret <2 x float> %fma
}

define amdgpu_ps i32 @s_mul_neg64_f32(float inreg %x) {
; GFX9-LABEL: s_mul_neg64_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xc2800000
; GFX9-NEXT:    v_mul_f32_e32 v0, s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX1011-LABEL: s_mul_neg64_f32:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    v_mul_f32_e64 v0, 0xc2800000, s0
; GFX1011-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1011-NEXT:    ; return to shader part epilog
  %mul = fmul float %x, -64.0
  %cast = bitcast float %mul to i32
  %readfirstlane = call i32 @llvm.amdgcn.readfirstlane(i32 %cast)
  ret i32 %readfirstlane
}

define amdgpu_ps i32 @s_mul_32_f32(float inreg %x) {
; GFX9-LABEL: s_mul_32_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42000000
; GFX9-NEXT:    v_mul_f32_e32 v0, s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX1011-LABEL: s_mul_32_f32:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    v_mul_f32_e64 v0, 0x42000000, s0
; GFX1011-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1011-NEXT:    ; return to shader part epilog
  %mul = fmul float %x, 32.0
  %cast = bitcast float %mul to i32
  %readfirstlane = call i32 @llvm.amdgcn.readfirstlane(i32 %cast)
  ret i32 %readfirstlane
}

define amdgpu_ps i32 @s_mul_fma_32_f32(float inreg %x, float inreg %y) {
; GFX9-LABEL: s_mul_fma_32_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42000000
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_fma_f32 v0, s0, v0, v1
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-SDAG-LABEL: s_mul_fma_32_f32:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v0, s1
; GFX10-SDAG-NEXT:    v_fmamk_f32 v0, s0, 0x42000000, v0
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-SDAG-NEXT:    ; return to shader part epilog
;
; GFX10-GISEL-LABEL: s_mul_fma_32_f32:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v0, s1
; GFX10-GISEL-NEXT:    v_fmac_f32_e64 v0, 0x42000000, s0
; GFX10-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-GISEL-NEXT:    ; return to shader part epilog
;
; GFX11-SDAG-LABEL: s_mul_fma_32_f32:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-SDAG-NEXT:    v_fmamk_f32 v0, s0, 0x42000000, v0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-SDAG-NEXT:    ; return to shader part epilog
;
; GFX11-GISEL-LABEL: s_mul_fma_32_f32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-GISEL-NEXT:    v_fmac_f32_e64 v0, 0x42000000, s0
; GFX11-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-GISEL-NEXT:    ; return to shader part epilog
  %mul = fmul contract float %x, 32.0
  %fma = fadd contract float %mul, %y
  %cast = bitcast float %fma to i32
  %readfirstlane = call i32 @llvm.amdgcn.readfirstlane(i32 %cast)
  ret i32 %readfirstlane
}

; 0x1p-1031
define double @v_mul_0x1pn1031_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_0x1pn1031_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0xfbf9
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_0x1pn1031_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x800
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_0x1pn1031_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0xfffffbf9
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_0x1pn1031_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x800, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_0x1pn1031_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0xfffffbf9
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_0x1pn1031_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x800, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 4.34584737989687770135e-311
  ret double %mul
}

; 0x1p-1022
define double @v_mul_0x1pn1022_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_0x1pn1022_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0xfc02
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_0x1pn1022_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x100000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_0x1pn1022_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0xfffffc02
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_0x1pn1022_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x100000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_0x1pn1022_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0xfffffc02
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_0x1pn1022_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x100000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 2.22507385850720138309e-308
  ret double %mul
}

; 0x1p-1021
define double @v_mul_0x1pn1021_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_0x1pn1021_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0xfc03
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_0x1pn1021_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x200000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_0x1pn1021_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0xfffffc03
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_0x1pn1021_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x200000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_0x1pn1021_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0xfffffc03
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_0x1pn1021_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x200000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 4.45014771701440276618e-308
  ret double %mul
}

; 0x1p-64
define double @v_mul_0x1pn64_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_0x1pn64_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0xffc0
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_0x1pn64_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x3bf00000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_0x1pn64_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0xffffffc0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_0x1pn64_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x3bf00000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_0x1pn64_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0xffffffc0
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_0x1pn64_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x3bf00000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 5.42101086242752217004e-20
  ret double %mul
}

; 0x1p-17
define double @v_mul_0x1pn17_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_0x1pn17_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0xffef
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_0x1pn17_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x3ee00000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_0x1pn17_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0xffffffef
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_0x1pn17_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x3ee00000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_0x1pn17_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0xffffffef
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_0x1pn17_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x3ee00000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 0.00000762939453125
  ret double %mul
}

; 0x1p-16
define double @v_mul_0x1pn16_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_0x1pn16_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], -16
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_0x1pn16_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x3ef00000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_0x1pn16_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], -16
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_0x1pn16_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x3ef00000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_0x1pn16_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], -16
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_0x1pn16_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x3ef00000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 0.0000152587890625
  ret double %mul
}

; 0x1p-15
define double @v_mul_0x1pn15_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_0x1pn15_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], -15
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_0x1pn15_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0.5
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_0x1pn15_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], -15
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_0x1pn15_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x3f000000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_0x1pn15_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], -15
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_0x1pn15_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x3f000000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 0.000030517578125
  ret double %mul
}

define double @v_mul_neg256_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_neg256_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 8
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_neg256_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xc0700000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_neg256_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 8
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_neg256_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0700000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_neg256_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 8
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_neg256_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0700000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, -256.0
  ret double %mul
}

define double @v_mul_neg128_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_neg128_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 7
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_neg128_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xc0600000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_neg128_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 7
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_neg128_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0600000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_neg128_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 7
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_neg128_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0600000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, -128.0
  ret double %mul
}

define double @v_mul_neg64_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_neg64_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 6
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_neg64_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xc0500000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_neg64_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 6
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_neg64_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0500000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_neg64_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 6
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_neg64_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0500000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, -64.0
  ret double %mul
}

define double @v_mul_neg32_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_neg32_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 5
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_neg32_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xc0400000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_neg32_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 5
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_neg32_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0400000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_neg32_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 5
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_neg32_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0400000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, -32.0
  ret double %mul
}

define double @v_mul_neg16_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_neg16_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_neg16_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xc0300000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_neg16_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 4
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_neg16_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0300000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_neg16_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 4
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_neg16_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0300000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, -16.0
  ret double %mul
}

define double @v_mul_neg8_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_neg8_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_neg8_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xc0200000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_neg8_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_neg8_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0200000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_neg8_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 3
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_neg8_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0200000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, -8.0
  ret double %mul
}

define double @v_mul_neg4_f64(double %x) {
; GCN-LABEL: v_mul_neg4_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f64 v[0:1], v[0:1], -4.0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, -4.0
  ret double %mul
}

define double @v_mul_neg2_f64(double %x) {
; GCN-LABEL: v_mul_neg2_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f64 v[0:1], v[0:1], -2.0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, -2.0
  ret double %mul
}

define double @v_mul_0_f64(double %x) {
; GCN-LABEL: v_mul_0_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f64 v[0:1], v[0:1], 0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 0.0
  ret double %mul
}

define double @v_mul_neg1_f64(double %x) {
; GCN-LABEL: v_mul_neg1_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, -1.0
  ret double %mul
}

define double @v_mul_neg_half_f64(double %x) {
; GCN-LABEL: v_mul_neg_half_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f64 v[0:1], v[0:1], -0.5
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, -0.5
  ret double %mul
}

define double @v_mul_neg_quarter_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_neg_quarter_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], -2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_neg_quarter_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xbfd00000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_neg_quarter_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], -2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_neg_quarter_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0xbfd00000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_neg_quarter_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], -2
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_neg_quarter_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0xbfd00000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, -0.25
  ret double %mul
}

define double @v_mul_quarter_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_quarter_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], -2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_quarter_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x3fd00000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_quarter_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], -2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_quarter_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x3fd00000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_quarter_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], -2
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_quarter_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x3fd00000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 0.25
  ret double %mul
}

define double @v_mul_half_f64(double %x) {
; GCN-LABEL: v_mul_half_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f64 v[0:1], v[0:1], 0.5
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 0.5
  ret double %mul
}

define double @v_mul_1_f64(double %x) {
; GCN-LABEL: v_mul_1_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 1.0
  ret double %mul
}

define double @v_mul_2_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_2_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[0:1]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_2_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], 2.0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_2_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[0:1]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_2_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], 2.0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_2_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[0:1]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_2_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], 2.0
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 2.0
  ret double %mul
}

define double @v_mul_4_f64(double %x) {
; GCN-LABEL: v_mul_4_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f64 v[0:1], v[0:1], 4.0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 4.0
  ret double %mul
}

define double @v_mul_8_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_8_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_8_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x40200000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_8_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_8_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40200000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_8_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 3
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_8_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40200000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 8.0
  ret double %mul
}

define double @v_mul_16_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_16_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_16_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x40300000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_16_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 4
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_16_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40300000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_16_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 4
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_16_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40300000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 16.0
  ret double %mul
}

define double @v_mul_32_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_32_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 5
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_32_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x40400000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_32_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 5
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_32_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40400000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_32_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 5
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_32_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40400000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 32.0
  ret double %mul
}

define double @v_mul_64_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_64_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 6
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_64_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x40500000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_64_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 6
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_64_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40500000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_64_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 6
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_64_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40500000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 64.0
  ret double %mul
}

define double @v_mul_128_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_128_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 7
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_128_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x40600000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_128_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 7
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_128_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40600000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_128_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 7
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_128_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40600000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 128.0
  ret double %mul
}

define double @v_mul_256_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_256_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 8
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_256_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x40700000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_256_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 8
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_256_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40700000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_256_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 8
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_256_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40700000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 256.0
  ret double %mul
}

; 0x1p+63
define double @v_mul_0x1p63_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_0x1p63_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 63
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_0x1p63_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x43e00000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_0x1p63_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 63
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_0x1p63_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x43e00000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_0x1p63_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 63
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_0x1p63_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x43e00000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 9223372036854775808.0
  ret double %mul
}

; 0x1p+64
define double @v_mul_0x1p64_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_0x1p64_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 64
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_0x1p64_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x43f00000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_0x1p64_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 64
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_0x1p64_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x43f00000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_0x1p64_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 64
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_0x1p64_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x43f00000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 18446744073709551616.0
  ret double %mul
}

; 0x1p+65
define double @v_mul_0x1p65_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_0x1p65_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0x41
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_0x1p65_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_bfrev_b32_e32 v3, 34
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_0x1p65_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0x41
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_0x1p65_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x44000000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_0x1p65_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0x41
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_0x1p65_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x44000000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 36893488147419103232.0
  ret double %mul
}

define amdgpu_ps <2 x i32> @s_mul_0x1p65_f64(double inreg %x, double inreg %y) {
; GFX9-SDAG-LABEL: s_mul_0x1p65_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 0x41
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], s[0:1], v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-SDAG-NEXT:    ; return to shader part epilog
;
; GFX9-GISEL-LABEL: s_mul_0x1p65_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-GISEL-NEXT:    v_bfrev_b32_e32 v1, 34
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], s[0:1], v[0:1]
; GFX9-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-GISEL-NEXT:    ; return to shader part epilog
;
; GFX10-SDAG-LABEL: s_mul_0x1p65_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], s[0:1], 0x41
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-SDAG-NEXT:    ; return to shader part epilog
;
; GFX10-GISEL-LABEL: s_mul_0x1p65_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x44000000, s[0:1]
; GFX10-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-GISEL-NEXT:    ; return to shader part epilog
;
; GFX11-SDAG-LABEL: s_mul_0x1p65_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], s[0:1], 0x41
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; GFX11-SDAG-NEXT:    ; return to shader part epilog
;
; GFX11-GISEL-LABEL: s_mul_0x1p65_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x44000000, s[0:1]
; GFX11-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; GFX11-GISEL-NEXT:    ; return to shader part epilog
  %mul = fmul contract double %x, 36893488147419103232.0
  %cast = bitcast double %mul to <2 x i32>
  %cast.0 = extractelement <2 x i32> %cast, i32 0
  %cast.1 = extractelement <2 x i32> %cast, i32 1
  %readlane.0 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.0)
  %readlane.1 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.1)
  %insert.0 = insertelement <2 x i32> poison, i32 %readlane.0, i32 0
  %insert.1 = insertelement <2 x i32> %insert.0, i32 %readlane.1, i32 1
  ret <2 x i32> %insert.1
}

; 0x1p+128
define double @v_mul_0x1p128_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_0x1p128_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0x80
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_0x1p128_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x47f00000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_0x1p128_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0x80
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_0x1p128_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x47f00000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_0x1p128_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0x80
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_0x1p128_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x47f00000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 3.40282366920938463463e+38
  ret double %mul
}

; 0x1p+1022
define double @v_mul_0x1p1022_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_0x1p1022_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0x3fe
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_0x1p1022_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7fd00000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_0x1p1022_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0x3fe
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_0x1p1022_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x7fd00000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_0x1p1022_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0x3fe
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_0x1p1022_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x7fd00000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 4.49423283715578976932e+307
  ret double %mul
}

; 0x1p+1023
define double @v_mul_0x1p1023_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_0x1p1023_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0x3ff
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_0x1p1023_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7fe00000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_0x1p1023_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0x3ff
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_0x1p1023_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x7fe00000, v[0:1]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_0x1p1023_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 0x3ff
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_0x1p1023_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x7fe00000, v[0:1]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 8.98846567431157953865e+307
  ret double %mul
}

; Check that this doesn't interfer with fma formation
define double @v_fma_mul_add_32_f64(double %x, double %y) {
; GFX9-SDAG-LABEL: v_fma_mul_add_32_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, 0x40400000
; GFX9-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], s[4:5], v[2:3]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_fma_mul_add_32_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v5, 0x40400000
; GFX9-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[4:5], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_fma_mul_add_32_f64:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_fma_f64 v[0:1], 0x40400000, v[0:1], v[2:3]
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract double %x, 32.0
  %fma = fadd contract double %mul, %y
  ret double %fma
}

define <2 x double> @v_fma_mul_add_32_v2f64(<2 x double> %x, <2 x double> %y) {
; GFX9-LABEL: v_fma_mul_add_32_v2f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s4, 0
; GFX9-NEXT:    s_mov_b32 s5, 0x40400000
; GFX9-NEXT:    v_fma_f64 v[0:1], v[0:1], s[4:5], v[4:5]
; GFX9-NEXT:    v_fma_f64 v[2:3], v[2:3], s[4:5], v[6:7]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_fma_mul_add_32_v2f64:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_fma_f64 v[0:1], 0x40400000, v[0:1], v[4:5]
; GFX1011-NEXT:    v_fma_f64 v[2:3], 0x40400000, v[2:3], v[6:7]
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract <2 x double> %x, <double 32.0, double 32.0>
  %fma = fadd contract <2 x double> %mul, %y
  ret <2 x double> %fma
}

define <2 x double> @v_fma_mul_add_2_v2f64(<2 x double> %x, <2 x double> %y) {
; GCN-LABEL: v_fma_mul_add_2_v2f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_fma_f64 v[0:1], v[0:1], 2.0, v[4:5]
; GCN-NEXT:    v_fma_f64 v[2:3], v[2:3], 2.0, v[6:7]
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract <2 x double> %x, <double 2.0, double 2.0>
  %fma = fadd contract <2 x double> %mul, %y
  ret <2 x double> %fma
}

define <2 x double> @v_fma_mul_add_4_v2f64(<2 x double> %x, <2 x double> %y) {
; GCN-LABEL: v_fma_mul_add_4_v2f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_fma_f64 v[0:1], v[0:1], 4.0, v[4:5]
; GCN-NEXT:    v_fma_f64 v[2:3], v[2:3], 4.0, v[6:7]
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract <2 x double> %x, <double 4.0, double 4.0>
  %fma = fadd contract <2 x double> %mul, %y
  ret <2 x double> %fma
}

define double @v_fma_mul_add_2_f64(double %x, double %y) {
; GCN-LABEL: v_fma_mul_add_2_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_fma_f64 v[0:1], v[0:1], 2.0, v[2:3]
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract double %x, 2.0
  %fma = fadd contract double %mul, %y
  ret double %fma
}

define double @v_fma_mul_add_4_f64(double %x, double %y) {
; GCN-LABEL: v_fma_mul_add_4_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_fma_f64 v[0:1], v[0:1], 4.0, v[2:3]
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract double %x, 4.0
  %fma = fadd contract double %mul, %y
  ret double %fma
}

define double @v_fma_mul_add_neg4_f64(double %x, double %y) {
; GCN-LABEL: v_fma_mul_add_neg4_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_fma_f64 v[0:1], v[0:1], -4.0, v[2:3]
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract double %x, -4.0
  %fma = fadd contract double %mul, %y
  ret double %fma
}

define double @v_mul_add_32_f64(double %x, double %y) {
; GFX9-SDAG-LABEL: v_mul_add_32_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 5
; GFX9-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_add_32_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v5, 0x40400000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX9-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_add_32_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 5
; GFX10-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_add_32_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40400000, v[0:1]
; GFX10-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_add_32_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 5
; GFX11-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_add_32_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40400000, v[0:1]
; GFX11-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 32.0
  %fma = fadd double %mul, %y
  ret double %fma
}

define double @v_mul_add_2_f64(double %x, double %y) {
; GFX9-SDAG-LABEL: v_mul_add_2_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[0:1]
; GFX9-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_add_2_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], 2.0
; GFX9-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_add_2_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[0:1]
; GFX10-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_add_2_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], 2.0
; GFX10-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_add_2_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[0:1]
; GFX11-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_add_2_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], 2.0
; GFX11-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 2.0
  %fma = fadd double %mul, %y
  ret double %fma
}

define double @v_mul_add_4_f64(double %x, double %y) {
; GFX9-SDAG-LABEL: v_mul_add_4_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[0:1]
; GFX9-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_add_4_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], 2.0
; GFX9-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_add_4_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[0:1]
; GFX10-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_add_4_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], 2.0
; GFX10-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_add_4_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[0:1]
; GFX11-SDAG-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_add_4_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], 2.0
; GFX11-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul double %x, 2.0
  %fma = fadd double %mul, %y
  ret double %fma
}

define double @v_fma_mul_sub_32_f64(double %x, double %y) {
; GFX9-SDAG-LABEL: v_fma_mul_sub_32_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, 0x40400000
; GFX9-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], s[4:5], -v[2:3]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_fma_mul_sub_32_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v5, 0x40400000
; GFX9-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[4:5], -v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_fma_mul_sub_32_f64:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_fma_f64 v[0:1], 0x40400000, v[0:1], -v[2:3]
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract double %x, 32.0
  %fma = fsub contract double %mul, %y
  ret double %fma
}

define double @v_fma_mul_add_neg32_f64(double %x, double %y) {
; GFX9-SDAG-LABEL: v_fma_mul_add_neg32_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, 0xc0400000
; GFX9-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], s[4:5], v[2:3]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_fma_mul_add_neg32_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v5, 0xc0400000
; GFX9-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[4:5], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_fma_mul_add_neg32_f64:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_fma_f64 v[0:1], 0xc0400000, v[0:1], v[2:3]
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract double %x, -32.0
  %fma = fadd contract double %mul, %y
  ret double %fma
}

define double @v_mul_fabs_32_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_fabs_32_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, 5
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_fabs_32_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x40400000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_fabs_32_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, 5
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_fabs_32_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40400000, |v[0:1]|
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_fabs_32_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, 5
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_fabs_32_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40400000, |v[0:1]|
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %x.fabs = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %x.fabs, 32.0
  ret double %mul
}

define double @v_mul_add_fma_fabs_32_f64(double %x, double %y) {
; GFX9-SDAG-LABEL: v_mul_add_fma_fabs_32_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, 0x40400000
; GFX9-SDAG-NEXT:    v_fma_f64 v[0:1], |v[0:1]|, s[4:5], v[2:3]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_add_fma_fabs_32_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v5, 0x40400000
; GFX9-GISEL-NEXT:    v_fma_f64 v[0:1], |v[0:1]|, v[4:5], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_mul_add_fma_fabs_32_f64:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_fma_f64 v[0:1], 0x40400000, |v[0:1]|, v[2:3]
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %x.fabs = call double @llvm.fabs.f64(double %x)
  %mul = fmul contract double %x.fabs, 32.0
  %fma = fadd contract double %mul, %y
  ret double %fma
}

define <2 x double> @v_mul_16_v2f64(<2 x double> %x) {
; GFX9-SDAG-LABEL: v_mul_16_v2f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 4
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], 4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_16_v2f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s4, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s5, 0x40300000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], s[4:5]
; GFX9-GISEL-NEXT:    v_mul_f64 v[2:3], v[2:3], s[4:5]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_16_v2f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 4
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], 4
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_16_v2f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40300000, v[0:1]
; GFX10-GISEL-NEXT:    v_mul_f64 v[2:3], 0x40300000, v[2:3]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_16_v2f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 4
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], 4
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_16_v2f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40300000, v[0:1]
; GFX11-GISEL-NEXT:    v_mul_f64 v[2:3], 0x40300000, v[2:3]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul <2 x double> %x, <double 16.0, double 16.0>
  ret <2 x double> %mul
}

define <2 x double> @v_mul_neg16_v2f64(<2 x double> %x) {
; GFX9-SDAG-LABEL: v_mul_neg16_v2f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 4
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[2:3], -v[2:3], 4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_neg16_v2f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s4, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s5, 0xc0300000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], s[4:5]
; GFX9-GISEL-NEXT:    v_mul_f64 v[2:3], v[2:3], s[4:5]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_neg16_v2f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 4
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[2:3], -v[2:3], 4
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_neg16_v2f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0300000, v[0:1]
; GFX10-GISEL-NEXT:    v_mul_f64 v[2:3], 0xc0300000, v[2:3]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_neg16_v2f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[0:1], 4
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[2:3], -v[2:3], 4
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_neg16_v2f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0300000, v[0:1]
; GFX11-GISEL-NEXT:    v_mul_f64 v[2:3], 0xc0300000, v[2:3]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul <2 x double> %x, <double -16.0, double -16.0>
  ret <2 x double> %mul
}

define <2 x double> @v_mul_fabs_16_v2f64(<2 x double> %x) {
; GFX9-SDAG-LABEL: v_mul_fabs_16_v2f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, 4
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[2:3], |v[2:3]|, 4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_fabs_16_v2f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s4, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s5, 0x40300000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, s[4:5]
; GFX9-GISEL-NEXT:    v_mul_f64 v[2:3], |v[2:3]|, s[4:5]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_fabs_16_v2f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, 4
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[2:3], |v[2:3]|, 4
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_fabs_16_v2f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40300000, |v[0:1]|
; GFX10-GISEL-NEXT:    v_mul_f64 v[2:3], 0x40300000, |v[2:3]|
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_fabs_16_v2f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, 4
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[2:3], |v[2:3]|, 4
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_fabs_16_v2f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40300000, |v[0:1]|
; GFX11-GISEL-NEXT:    v_mul_f64 v[2:3], 0x40300000, |v[2:3]|
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %x.fabs = call <2 x double> @llvm.fabs.v2f64(<2 x double> %x)
  %mul = fmul <2 x double> %x.fabs, <double 16.0, double 16.0>
  ret <2 x double> %mul
}

define amdgpu_ps <2 x i32> @s_mul_32_f64(double inreg %x, double inreg %y) {
; GFX9-SDAG-LABEL: s_mul_32_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], s[0:1], 5
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-SDAG-NEXT:    ; return to shader part epilog
;
; GFX9-GISEL-LABEL: s_mul_32_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40400000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], s[0:1], v[0:1]
; GFX9-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-GISEL-NEXT:    ; return to shader part epilog
;
; GFX10-SDAG-LABEL: s_mul_32_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], s[0:1], 5
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-SDAG-NEXT:    ; return to shader part epilog
;
; GFX10-GISEL-LABEL: s_mul_32_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40400000, s[0:1]
; GFX10-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-GISEL-NEXT:    ; return to shader part epilog
;
; GFX11-SDAG-LABEL: s_mul_32_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], s[0:1], 5
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; GFX11-SDAG-NEXT:    ; return to shader part epilog
;
; GFX11-GISEL-LABEL: s_mul_32_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40400000, s[0:1]
; GFX11-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; GFX11-GISEL-NEXT:    ; return to shader part epilog
  %mul = fmul contract double %x, 32.0
  %cast = bitcast double %mul to <2 x i32>
  %cast.0 = extractelement <2 x i32> %cast, i32 0
  %cast.1 = extractelement <2 x i32> %cast, i32 1
  %readlane.0 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.0)
  %readlane.1 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.1)
  %insert.0 = insertelement <2 x i32> poison, i32 %readlane.0, i32 0
  %insert.1 = insertelement <2 x i32> %insert.0, i32 %readlane.1, i32 1
  ret <2 x i32> %insert.1
}

; 0x1p-23
define half @v_mul_0x1pn23_f16(half %x) {
; GFX9-LABEL: v_mul_0x1pn23_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 2, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_0x1pn23_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_0x1pn23_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 2, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_0x1pn23_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 2, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_0x1pn23_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 2, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_0x1pn23_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 2, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 0xH0002
  ret half %mul
}

; 0x1p-17
define half @v_mul_0x1pn17_f16(half %x) {
; GFX9-LABEL: v_mul_0x1pn17_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0x80, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_0x1pn17_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0x80, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_0x1pn17_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x80, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_0x1pn17_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x80, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_0x1pn17_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x80, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_0x1pn17_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x80, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 0.00000762939453125
  ret half %mul
}

; 0x1p-16
define half @v_mul_0x1pn16_f16(half %x) {
; GFX9-LABEL: v_mul_0x1pn16_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0x100, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_0x1pn16_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0x100, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_0x1pn16_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x100, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_0x1pn16_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x100, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_0x1pn16_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x100, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_0x1pn16_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x100, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 0.0000152587890625
  ret half %mul
}

; 0x1p-15
define half @v_mul_0x1pn15_f16(half %x) {
; GFX9-LABEL: v_mul_0x1pn15_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0x200, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_0x1pn15_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0x200, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_0x1pn15_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x200, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_0x1pn15_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x200, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_0x1pn15_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x200, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_0x1pn15_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x200, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 0.000030517578125
  ret half %mul
}

define half @v_mul_neg256_f16(half %x) {
; GFX9-LABEL: v_mul_neg256_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0xdc00, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_neg256_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0xdc00, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_neg256_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0xdc00, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_neg256_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0xdc00, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_neg256_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0xdc00, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_neg256_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0xdc00, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, -256.0
  ret half %mul
}

define half @v_mul_neg128_f16(half %x) {
; GFX9-LABEL: v_mul_neg128_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0xd800, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_neg128_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0xd800, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_neg128_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0xd800, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_neg128_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0xd800, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_neg128_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0xd800, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_neg128_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0xd800, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, -128.0
  ret half %mul
}

define half @v_mul_neg64_f16(half %x) {
; GFX9-LABEL: v_mul_neg64_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0xd400, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_neg64_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0xd400, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_neg64_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0xd400, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_neg64_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0xd400, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_neg64_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0xd400, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_neg64_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0xd400, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, -64.0
  ret half %mul
}

define half @v_mul_neg32_f16(half %x) {
; GFX9-LABEL: v_mul_neg32_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0xd000, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_neg32_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0xd000, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_neg32_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0xd000, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_neg32_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0xd000, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_neg32_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0xd000, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_neg32_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0xd000, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, -32.0
  ret half %mul
}

define half @v_mul_neg16_f16(half %x) {
; GFX9-LABEL: v_mul_neg16_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0xcc00, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_neg16_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0xcc00, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_neg16_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0xcc00, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_neg16_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0xcc00, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_neg16_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0xcc00, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_neg16_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0xcc00, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, -16.0
  ret half %mul
}

define half @v_mul_neg8_f16(half %x) {
; GFX9-LABEL: v_mul_neg8_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0xc800, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_neg8_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0xc800, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_neg8_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0xc800, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_neg8_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0xc800, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_neg8_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0xc800, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_neg8_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0xc800, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, -8.0
  ret half %mul
}

define half @v_mul_neg4_f16(half %x) {
; GFX9-LABEL: v_mul_neg4_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, -4.0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_neg4_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, -4.0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_neg4_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, -4.0, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_neg4_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, -4.0, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_neg4_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, -4.0, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_neg4_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, -4.0, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, -4.0
  ret half %mul
}

define half @v_mul_neg2_f16(half %x) {
; GFX9-LABEL: v_mul_neg2_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, -2.0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_neg2_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, -2.0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_neg2_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, -2.0, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_neg2_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, -2.0, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_neg2_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, -2.0, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_neg2_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, -2.0, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, -2.0
  ret half %mul
}

define half @v_mul_neg1_f16(half %x) {
; GFX9-LABEL: v_mul_neg1_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_neg1_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_neg1_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_xor_b16 v0.l, 0x8000, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_neg1_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_neg1_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_xor_b16 v0.l, 0x8000, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_neg1_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, -1.0
  ret half %mul
}

define half @v_mul_neg_half_f16(half %x) {
; GFX9-LABEL: v_mul_neg_half_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, -0.5, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_neg_half_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, -0.5, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_neg_half_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, -0.5, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_neg_half_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, -0.5, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_neg_half_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, -0.5, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_neg_half_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, -0.5, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, -0.5
  ret half %mul
}

define half @v_mul_neg_quarter_f16(half %x) {
; GFX9-LABEL: v_mul_neg_quarter_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0xb400, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_neg_quarter_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0xb400, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_neg_quarter_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0xb400, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_neg_quarter_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0xb400, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_neg_quarter_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0xb400, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_neg_quarter_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0xb400, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, -0.25
  ret half %mul
}

define half @v_mul_quarter_f16(half %x) {
; GFX9-LABEL: v_mul_quarter_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0x3400, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_quarter_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0x3400, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_quarter_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x3400, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_quarter_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x3400, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_quarter_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x3400, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_quarter_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x3400, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 0.25
  ret half %mul
}

define half @v_mul_half_f16(half %x) {
; GFX9-LABEL: v_mul_half_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0.5, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_half_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0.5, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_half_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0.5, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_half_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0.5, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_half_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0.5, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_half_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0.5, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 0.5
  ret half %mul
}

define half @v_mul_1_f16(half %x) {
; GCN-LABEL: v_mul_1_f16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 1.0
  ret half %mul
}

define half @v_mul_2_f16(half %x) {
; GFX9-SDAG-LABEL: v_mul_2_f16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_f16_e32 v0, v0, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_2_f16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mul_f16_e32 v0, 2.0, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_2_f16:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_f16_e32 v0, v0, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_2_f16:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f16_e32 v0, 2.0, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_2_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_add_f16_e32 v0.l, v0.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_2_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_add_f16_e32 v0, v0, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_2_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 2.0, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_2_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 2.0, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 2.0
  ret half %mul
}

define half @v_mul_4_f16(half %x) {
; GFX9-LABEL: v_mul_4_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 4.0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_4_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 4.0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_4_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 4.0, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_4_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 4.0, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_4_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 4.0, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_4_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 4.0, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 4.0
  ret half %mul
}

define half @v_mul_8_f16(half %x) {
; GFX9-LABEL: v_mul_8_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0x4800, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_8_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0x4800, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_8_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x4800, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_8_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x4800, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_8_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x4800, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_8_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x4800, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 8.0
  ret half %mul
}

define half @v_mul_16_f16(half %x) {
; GFX9-LABEL: v_mul_16_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0x4c00, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_16_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0x4c00, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_16_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x4c00, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_16_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x4c00, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_16_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x4c00, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_16_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x4c00, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 16.0
  ret half %mul
}

define half @v_mul_32_f16(half %x) {
; GFX9-LABEL: v_mul_32_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0x5000, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_32_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0x5000, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_32_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x5000, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_32_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x5000, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_32_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x5000, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_32_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x5000, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 32.0
  ret half %mul
}

define half @v_mul_64_f16(half %x) {
; GFX9-LABEL: v_mul_64_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0x5400, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_64_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0x5400, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_64_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x5400, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_64_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x5400, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_64_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x5400, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_64_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x5400, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 64.0
  ret half %mul
}

define half @v_mul_128_f16(half %x) {
; GFX9-LABEL: v_mul_128_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0x5800, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_128_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0x5800, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_128_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x5800, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_128_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x5800, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_128_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x5800, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_128_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x5800, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 128.0
  ret half %mul
}

define half @v_mul_256_f16(half %x) {
; GFX9-LABEL: v_mul_256_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0x5c00, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_256_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0x5c00, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_256_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x5c00, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_256_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x5c00, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_256_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x5c00, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_256_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x5c00, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 256.0
  ret half %mul
}

; 0x1p+15
define half @v_mul_0x1p15_f16(half %x) {
; GFX9-LABEL: v_mul_0x1p15_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0x7800, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_0x1p15_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0x7800, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_0x1p15_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x7800, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_0x1p15_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x7800, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_0x1p15_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x7800, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_0x1p15_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x7800, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 32768.0
  ret half %mul
}

; 0x1p+14
define half @v_mul_0x1p14_f16(half %x) {
; GFX9-LABEL: v_mul_0x1p14_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0x7400, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_0x1p14_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0x7400, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_0x1p14_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x7400, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_0x1p14_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x7400, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_0x1p14_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x7400, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_0x1p14_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x7400, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul half %x, 16384.0
  ret half %mul
}

; Check that this doesn't interfer with fma formation
define half @v_fma_mul_add_32_f16(half %x, half %y) {
; GFX9-SDAG-LABEL: v_fma_mul_add_32_f16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0x5000
; GFX9-SDAG-NEXT:    v_fma_f16 v0, v0, s4, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_fma_mul_add_32_f16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0x5000
; GFX9-GISEL-NEXT:    v_fma_f16 v0, v0, v2, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fma_mul_add_32_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_fmamk_f16 v0, v0, 0x5000, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_fma_mul_add_32_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_fmamk_f16 v0.l, v0.l, 0x5000, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_fma_mul_add_32_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_fmamk_f16 v0, v0, 0x5000, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_fma_mul_add_32_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_fmac_f16_e32 v1.l, 0x5000, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_mov_b32_e32 v0, v1
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_fma_mul_add_32_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_fmamk_f16 v0, v0, 0x5000, v1
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract half %x, 32.0
  %fma = fadd contract half %mul, %y
  ret half %fma
}

define half @v_fma_mul_sub_32_f16(half %x, half %y) {
; GFX9-SDAG-LABEL: v_fma_mul_sub_32_f16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0x5000
; GFX9-SDAG-NEXT:    v_fma_f16 v0, v0, s4, -v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_fma_mul_sub_32_f16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0x5000
; GFX9-GISEL-NEXT:    v_fma_f16 v0, v0, v2, -v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fma_mul_sub_32_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_fma_f16 v0, v0, 0x5000, -v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_fma_mul_sub_32_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_fma_f16 v0.l, v0.l, 0x5000, -v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_fma_mul_sub_32_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_fma_f16 v0, v0, 0x5000, -v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_fma_mul_sub_32_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_fma_f16 v0.l, v0.l, 0x5000, -v1.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_fma_mul_sub_32_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_fma_f16 v0, v0, 0x5000, -v1
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract half %x, 32.0
  %fma = fsub contract half %mul, %y
  ret half %fma
}

define half @v_fma_mul_add_neg32_f16(half %x, half %y) {
; GFX9-SDAG-LABEL: v_fma_mul_add_neg32_f16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0xd000
; GFX9-SDAG-NEXT:    v_fma_f16 v0, v0, s4, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_fma_mul_add_neg32_f16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0xd000
; GFX9-GISEL-NEXT:    v_fma_f16 v0, v0, v2, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fma_mul_add_neg32_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_fmamk_f16 v0, v0, 0xd000, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_fma_mul_add_neg32_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_fmamk_f16 v0.l, v0.l, 0xd000, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_fma_mul_add_neg32_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_fmamk_f16 v0, v0, 0xd000, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_fma_mul_add_neg32_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_fmac_f16_e32 v1.l, 0xd000, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_mov_b32_e32 v0, v1
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_fma_mul_add_neg32_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_fmamk_f16 v0, v0, 0xd000, v1
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract half %x, -32.0
  %fma = fadd contract half %mul, %y
  ret half %fma
}

define half @v_mul_fabs_32_f16(half %x) {
; GFX9-SDAG-LABEL: v_mul_fabs_32_f16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0x5000
; GFX9-SDAG-NEXT:    v_mul_f16_e64 v0, |v0|, s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_fabs_32_f16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0x5000
; GFX9-GISEL-NEXT:    v_mul_f16_e64 v0, |v0|, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_fabs_32_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e64 v0, 0x5000, |v0|
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_fabs_32_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e64 v0.l, 0x5000, |v0.l|
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_fabs_32_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e64 v0, 0x5000, |v0|
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_fabs_32_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e64 v0.l, 0x5000, |v0.l|
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_fabs_32_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e64 v0, 0x5000, |v0|
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %x.fabs = call half @llvm.fabs.f16(half %x)
  %mul = fmul half %x.fabs, 32.0
  ret half %mul
}

define half @v_mul_add_fma_fabs_32_f16(half %x, half %y) {
; GFX9-SDAG-LABEL: v_mul_add_fma_fabs_32_f16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0x5000
; GFX9-SDAG-NEXT:    v_fma_f16 v0, |v0|, s4, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_add_fma_fabs_32_f16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0x5000
; GFX9-GISEL-NEXT:    v_fma_f16 v0, |v0|, v2, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_add_fma_fabs_32_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_fma_f16 v0, |v0|, 0x5000, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_add_fma_fabs_32_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_fma_f16 v0.l, |v0.l|, 0x5000, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_add_fma_fabs_32_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_fma_f16 v0, |v0|, 0x5000, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_add_fma_fabs_32_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_fma_f16 v0.l, |v0.l|, 0x5000, v1.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_add_fma_fabs_32_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_fma_f16 v0, |v0|, 0x5000, v1
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %x.fabs = call half @llvm.fabs.f16(half %x)
  %mul = fmul contract half %x.fabs, 32.0
  %fma = fadd contract half %mul, %y
  ret half %fma
}

define <2 x half> @v_mul_16_v2f16(<2 x half> %x) {
; GFX9-SDAG-LABEL: v_mul_16_v2f16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0x4c00
; GFX9-SDAG-NEXT:    v_pk_mul_f16 v0, v0, s4 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_16_v2f16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0x4c004c00
; GFX9-GISEL-NEXT:    v_pk_mul_f16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_16_v2f16:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_mul_f16 v0, 0x4c00, v0 op_sel_hi:[0,1]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_16_v2f16:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_mul_f16 v0, 0x4c004c00, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_16_v2f16:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_pk_mul_f16 v0, 0x4c00, v0 op_sel_hi:[0,1]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_16_v2f16:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_mul_f16 v0, 0x4c004c00, v0
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul <2 x half> %x, <half 16.0, half 16.0>
  ret <2 x half> %mul
}

define <2 x half> @v_mul_neg16_v2f16(<2 x half> %x) {
; GFX9-SDAG-LABEL: v_mul_neg16_v2f16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0xcc00
; GFX9-SDAG-NEXT:    v_pk_mul_f16 v0, v0, s4 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_neg16_v2f16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0xcc00cc00
; GFX9-GISEL-NEXT:    v_pk_mul_f16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_neg16_v2f16:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_mul_f16 v0, 0xcc00, v0 op_sel_hi:[0,1]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_neg16_v2f16:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_mul_f16 v0, 0xcc00cc00, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_neg16_v2f16:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_pk_mul_f16 v0, 0xcc00, v0 op_sel_hi:[0,1]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_neg16_v2f16:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_mul_f16 v0, 0xcc00cc00, v0
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul <2 x half> %x, <half -16.0, half -16.0>
  ret <2 x half> %mul
}

define <2 x half> @v_mul_fabs_16_v2f16(<2 x half> %x) {
; GFX9-SDAG-LABEL: v_mul_fabs_16_v2f16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0x4c00
; GFX9-SDAG-NEXT:    v_pk_mul_f16 v0, v0, s4 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_fabs_16_v2f16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0x4c004c00
; GFX9-GISEL-NEXT:    v_pk_mul_f16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_fabs_16_v2f16:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX10-SDAG-NEXT:    v_pk_mul_f16 v0, 0x4c00, v0 op_sel_hi:[0,1]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_fabs_16_v2f16:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX10-GISEL-NEXT:    v_pk_mul_f16 v0, 0x4c004c00, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_fabs_16_v2f16:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX11-SDAG-NEXT:    v_pk_mul_f16 v0, 0x4c00, v0 op_sel_hi:[0,1]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_fabs_16_v2f16:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX11-GISEL-NEXT:    v_pk_mul_f16 v0, 0x4c004c00, v0
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %x.fabs = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %mul = fmul <2 x half> %x.fabs, <half 16.0, half 16.0>
  ret <2 x half> %mul
}

define <2 x half> @v_fma_mul_add_32_v2f16(<2 x half> %x, <2 x half> %y) {
; GFX9-SDAG-LABEL: v_fma_mul_add_32_v2f16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0x5000
; GFX9-SDAG-NEXT:    v_pk_fma_f16 v0, v0, s4, v1 op_sel_hi:[1,0,1]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_fma_mul_add_32_v2f16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0x50005000
; GFX9-GISEL-NEXT:    v_pk_fma_f16 v0, v0, v2, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_fma_mul_add_32_v2f16:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_fma_f16 v0, 0x5000, v0, v1 op_sel_hi:[0,1,1]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_fma_mul_add_32_v2f16:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_fma_f16 v0, 0x50005000, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_fma_mul_add_32_v2f16:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_pk_fma_f16 v0, 0x5000, v0, v1 op_sel_hi:[0,1,1]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_fma_mul_add_32_v2f16:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_fma_f16 v0, 0x50005000, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul contract <2 x half> %x, <half 32.0, half 32.0>
  %fma = fadd contract <2 x half> %mul, %y
  ret <2 x half> %fma
}

define amdgpu_ps i32 @s_mul_32_f16(half inreg %x, half inreg %y) {
; GFX9-LABEL: s_mul_32_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5000
; GFX9-NEXT:    v_mul_f16_e32 v0, s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_mul_32_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mul_f16_e64 v0, 0x5000, s0
; GFX10-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-SDAG-TRUE16-LABEL: s_mul_32_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e64 v0.l, 0x5000, s0
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-SDAG-TRUE16-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-SDAG-TRUE16-NEXT:    ; return to shader part epilog
;
; GFX11-SDAG-FAKE16-LABEL: s_mul_32_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e64 v0, 0x5000, s0
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-SDAG-FAKE16-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-SDAG-FAKE16-NEXT:    ; return to shader part epilog
;
; GFX11-GISEL-TRUE16-LABEL: s_mul_32_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e64 v0.l, 0x5000, s0
; GFX11-GISEL-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-TRUE16-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-GISEL-TRUE16-NEXT:    ; return to shader part epilog
;
; GFX11-GISEL-FAKE16-LABEL: s_mul_32_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e64 v0, 0x5000, s0
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-GISEL-FAKE16-NEXT:    ; return to shader part epilog
  %mul = fmul contract half %x, 32.0
  %cast = bitcast half %mul to i16
  %zext = zext i16 %cast to i32
  %readlane = call i32 @llvm.amdgcn.readfirstlane(i32 %zext)
  ret i32 %readlane
}

; --------------------------------------------------------------------
; fmul by select of power of 2
; --------------------------------------------------------------------

define float @v_mul_f32_select_64_1(i32 %arg, float %x) {
; GFX9-LABEL: v_mul_f32_select_64_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_mul_f32_select_64_1:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1011-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX1011-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, float 64.0, float 1.0
  %mul = fmul float %x, %select.pow2
  ret float %mul
}

define float @v_mul_f32_select_1_64(i32 %arg, float %x) {
; GFX9-LABEL: v_mul_f32_select_1_64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_mul_f32_select_1_64:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1011-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX1011-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, float 1.0, float 64.0
  %mul = fmul float %x, %select.pow2
  ret float %mul
}

define float @v_mul_f32_select_n1_n64(i32 %arg, float %x) {
; GFX9-LABEL: v_mul_f32_select_n1_n64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_mul_f32_select_n1_n64:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1011-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX1011-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, float -1.0, float -64.0
  %mul = fmul float %x, %select.pow2
  ret float %mul
}

define float @v_mul_f32_select_n64_n1(i32 %arg, float %x) {
; GFX9-LABEL: v_mul_f32_select_n64_n1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_mul_f32_select_n64_n1:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1011-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX1011-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, float -64.0, float -1.0
  %mul = fmul float %x, %select.pow2
  ret float %mul
}

define float @v_mul_f32_select_128_64(i32 %arg, float %x) {
; GFX9-SDAG-LABEL: v_mul_f32_select_128_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc
; GFX9-SDAG-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_f32_select_128_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 6, v0
; GFX9-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_f32_select_128_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc_lo
; GFX10-SDAG-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_f32_select_128_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX10-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_f32_select_128_64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc_lo
; GFX11-SDAG-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_f32_select_128_64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, float 128.0, float 64.0
  %mul = fmul float %x, %select.pow2
  ret float %mul
}

define float @v_mul_f32_select_n128_n64(i32 %arg, float %x) {
; GFX9-SDAG-LABEL: v_mul_f32_select_n128_n64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc
; GFX9-SDAG-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_f32_select_n128_n64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 6, v0
; GFX9-GISEL-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_f32_select_n128_n64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc_lo
; GFX10-SDAG-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_f32_select_n128_n64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX10-GISEL-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_f32_select_n128_n64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc_lo
; GFX11-SDAG-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_f32_select_n128_n64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, float -128.0, float -64.0
  %mul = fmul float %x, %select.pow2
  ret float %mul
}

define float @v_mul_f32_select_n128_n16(i32 %arg, float %x) {
; GFX9-LABEL: v_mul_f32_select_n128_n16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 4, 7, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_mul_f32_select_n128_n16:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1011-NEXT:    v_cndmask_b32_e64 v0, 4, 7, vcc_lo
; GFX1011-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, float -128.0, float -16.0
  %mul = fmul float %x, %select.pow2
  ret float %mul
}

define float @v_contract_mul_add_f32_select_64_1(i32 %arg, float %x, float %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f32_select_64_1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x42800000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, 1.0, v3, vcc
; GFX9-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f32_select_64_1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX9-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f32_select_64_1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, 1.0, 0x42800000, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f32_select_64_1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX10-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f32_select_64_1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, 1.0, 0x42800000, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f32_select_64_1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX11-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select contract i1 %cond, float 64.0, float 1.0
  %mul = fmul contract float %x, %select.pow2
  %fma = fadd contract float %mul, %y
  ret float %fma
}

define float @v_contract_mul_add_f32_select_1_64(i32 %arg, float %x, float %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f32_select_1_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x42800000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v0, v3, 1.0, vcc
; GFX9-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f32_select_1_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX9-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f32_select_1_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0x42800000, 1.0, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f32_select_1_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX10-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f32_select_1_64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0x42800000, 1.0, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f32_select_1_64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX11-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select contract i1 %cond, float 1.0, float 64.0
  %mul = fmul contract float %x, %select.pow2
  %fma = fadd contract float %mul, %y
  ret float %fma
}

define float @v_contract_mul_add_f32_select_n64_n1(i32 %arg, float %x, float %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f32_select_n64_n1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0xc2800000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, -1.0, v3, vcc
; GFX9-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f32_select_n64_n1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX9-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f32_select_n64_n1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, -1.0, 0xc2800000, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f32_select_n64_n1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX10-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f32_select_n64_n1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, -1.0, 0xc2800000, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f32_select_n64_n1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX11-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select contract i1 %cond, float -64.0, float -1.0
  %mul = fmul contract float %x, %select.pow2
  %fma = fadd contract float %mul, %y
  ret float %fma
}

define float @v_contract_mul_add_f32_select_n1_n64(i32 %arg, float %x, float %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f32_select_n1_n64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0xc2800000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v0, v3, -1.0, vcc
; GFX9-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f32_select_n1_n64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX9-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f32_select_n1_n64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0xc2800000, -1.0, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f32_select_n1_n64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX10-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f32_select_n1_n64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0xc2800000, -1.0, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f32_select_n1_n64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-NEXT:    v_ldexp_f32 v0, -v1, v0
; GFX11-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select contract i1 %cond, float -1.0, float -64.0
  %mul = fmul contract float %x, %select.pow2
  %fma = fadd contract float %mul, %y
  ret float %fma
}

define float @v_contract_mul_add_f32_select_128_64(i32 %arg, float %x, float %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f32_select_128_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x42800000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x43000000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f32_select_128_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 6, v0
; GFX9-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX9-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f32_select_128_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0x43000000
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x42800000, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f32_select_128_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX10-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX10-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f32_select_128_64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v3, 0x43000000
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x42800000, v3, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f32_select_128_64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX11-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, float 128.0, float 64.0
  %mul = fmul contract float %x, %select.pow2
  %fma = fadd contract float %mul, %y
  ret float %fma
}

define float @v_contract_mul_add_f32_select_128_4(i32 %arg, float %x, float %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f32_select_128_4:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x43000000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, 4.0, v3, vcc
; GFX9-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f32_select_128_4:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 2, 7, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX9-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f32_select_128_4:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, 4.0, 0x43000000, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f32_select_128_4:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 2, 7, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX10-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f32_select_128_4:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, 4.0, 0x43000000, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f32_select_128_4:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 2, 7, vcc_lo
; GFX11-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX11-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, float 128.0, float 4.0
  %mul = fmul contract float %x, %select.pow2
  %fma = fadd contract float %mul, %y
  ret float %fma
}

define float @v_contract_mul_add_f32_select_2_4(i32 %arg, float %x, float %y) {
; GFX9-LABEL: v_contract_mul_add_f32_select_2_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 4.0, 2.0, vcc
; GFX9-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_contract_mul_add_f32_select_2_4:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1011-NEXT:    v_cndmask_b32_e64 v0, 4.0, 2.0, vcc_lo
; GFX1011-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, float 2.0, float 4.0
  %mul = fmul contract float %x, %select.pow2
  %fma = fadd contract float %mul, %y
  ret float %fma
}

define float @v_contract_mul_add_f32_select_4_128(i32 %arg, float %x, float %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f32_select_4_128:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x43000000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v0, v3, 4.0, vcc
; GFX9-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f32_select_4_128:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 7, 2, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX9-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f32_select_4_128:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0x43000000, 4.0, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f32_select_4_128:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 7, 2, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX10-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f32_select_4_128:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0x43000000, 4.0, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f32 v0, v1, v0, v2
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f32_select_4_128:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 7, 2, vcc_lo
; GFX11-GISEL-NEXT:    v_ldexp_f32 v0, v1, v0
; GFX11-GISEL-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, float 4.0, float 128.0
  %mul = fmul contract float %x, %select.pow2
  %fma = fadd contract float %mul, %y
  ret float %fma
}

define double @v_mul_f64_select_64_1(i32 %arg, double %x) {
; GFX9-LABEL: v_mul_f64_select_64_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc
; GFX9-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_mul_f64_select_64_1:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1011-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX1011-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, double 64.0, double 1.0
  %mul = fmul double %x, %select.pow2
  ret double %mul
}

define double @v_mul_f64_select_1_64(i32 %arg, double %x) {
; GFX9-LABEL: v_mul_f64_select_1_64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_mul_f64_select_1_64:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1011-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX1011-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, double 1.0, double 64.0
  %mul = fmul double %x, %select.pow2
  ret double %mul
}

define double @v_mul_f64_select_n1_n64(i32 %arg, double %x) {
; GFX9-LABEL: v_mul_f64_select_n1_n64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_mul_f64_select_n1_n64:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1011-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX1011-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, double -1.0, double -64.0
  %mul = fmul double %x, %select.pow2
  ret double %mul
}

define double @v_mul_f64_select_128_64(i32 %arg, double %x) {
; GFX9-SDAG-LABEL: v_mul_f64_select_128_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_f64_select_128_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 6, v0
; GFX9-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_f64_select_128_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc_lo
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_f64_select_128_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX10-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_f64_select_128_64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc_lo
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_f64_select_128_64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, double 128.0, double 64.0
  %mul = fmul double %x, %select.pow2
  ret double %mul
}

define double @v_mul_f64_select_n128_n64(i32 %arg, double %x) {
; GFX9-SDAG-LABEL: v_mul_f64_select_n128_n64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_f64_select_n128_n64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 6, v0
; GFX9-GISEL-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_f64_select_n128_n64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc_lo
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_f64_select_n128_n64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX10-GISEL-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_f64_select_n128_n64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc_lo
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_f64_select_n128_n64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, double -128.0, double -64.0
  %mul = fmul double %x, %select.pow2
  ret double %mul
}

define double @v_mul_f64_select_n128_n16(i32 %arg, double %x) {
; GFX9-LABEL: v_mul_f64_select_n128_n16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 4, 7, vcc
; GFX9-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1011-LABEL: v_mul_f64_select_n128_n16:
; GFX1011:       ; %bb.0:
; GFX1011-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1011-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1011-NEXT:    v_cndmask_b32_e64 v0, 4, 7, vcc_lo
; GFX1011-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX1011-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, double -128.0, double -16.0
  %mul = fmul double %x, %select.pow2
  ret double %mul
}

define double @v_contract_mul_add_f64_select_64_1(i32 %arg, double %x, double %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f64_select_64_1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0x3ff00000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v6, 0x40500000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v6, v5, v6, vcc
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f64_select_64_1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX9-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f64_select_64_1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v6, 0x40500000
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0x3ff00000, v6, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f64_select_64_1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX10-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f64_select_64_1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v6, 0x40500000 :: v_dual_mov_b32 v5, 0
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0x3ff00000, v6, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f64_select_64_1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX11-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select contract i1 %cond, double 64.0, double 1.0
  %mul = fmul contract double %x, %select.pow2
  %fma = fadd contract double %mul, %y
  ret double %fma
}

define double @v_contract_mul_add_f64_select_1_64(i32 %arg, double %x, double %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f64_select_1_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0x40500000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v6, 0x3ff00000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v6, v5, v6, vcc
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f64_select_1_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX9-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f64_select_1_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v6, 0x3ff00000
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0x40500000, v6, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f64_select_1_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX10-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f64_select_1_64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v6, 0x3ff00000 :: v_dual_mov_b32 v5, 0
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0x40500000, v6, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f64_select_1_64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX11-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select contract i1 %cond, double 1.0, double 64.0
  %mul = fmul contract double %x, %select.pow2
  %fma = fadd contract double %mul, %y
  ret double %fma
}

define double @v_contract_mul_add_f64_select_n64_n1(i32 %arg, double %x, double %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f64_select_n64_n1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0xbff00000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v6, 0xc0500000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v6, v5, v6, vcc
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f64_select_n64_n1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX9-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f64_select_n64_n1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v6, 0xc0500000
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0xbff00000, v6, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f64_select_n64_n1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX10-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f64_select_n64_n1:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v6, 0xc0500000 :: v_dual_mov_b32 v5, 0
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0xbff00000, v6, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f64_select_n64_n1:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX11-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select contract i1 %cond, double -64.0, double -1.0
  %mul = fmul contract double %x, %select.pow2
  %fma = fadd contract double %mul, %y
  ret double %fma
}

define double @v_contract_mul_add_f64_select_n1_n64(i32 %arg, double %x, double %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f64_select_n1_n64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0xc0500000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v6, 0xbff00000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v6, v5, v6, vcc
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f64_select_n1_n64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX9-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f64_select_n1_n64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v6, 0xbff00000
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0xc0500000, v6, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f64_select_n1_n64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX10-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f64_select_n1_n64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v6, 0xbff00000 :: v_dual_mov_b32 v5, 0
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0xc0500000, v6, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f64_select_n1_n64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-NEXT:    v_ldexp_f64 v[0:1], -v[1:2], v0
; GFX11-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select contract i1 %cond, double -1.0, double -64.0
  %mul = fmul contract double %x, %select.pow2
  %fma = fadd contract double %mul, %y
  ret double %fma
}

define double @v_contract_mul_add_f64_select_128_64(i32 %arg, double %x, double %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f64_select_128_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0x40500000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v6, 0x40600000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v6, v5, v6, vcc
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f64_select_128_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 6, v0
; GFX9-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX9-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f64_select_128_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v6, 0x40600000
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0x40500000, v6, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f64_select_128_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX10-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX10-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f64_select_128_64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v6, 0x40600000 :: v_dual_mov_b32 v5, 0
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0x40500000, v6, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f64_select_128_64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX11-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, double 128.0, double 64.0
  %mul = fmul contract double %x, %select.pow2
  %fma = fadd contract double %mul, %y
  ret double %fma
}

define double @v_contract_mul_add_f64_select_128_4(i32 %arg, double %x, double %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f64_select_128_4:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0x40100000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v6, 0x40600000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v6, v5, v6, vcc
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f64_select_128_4:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 2, 7, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX9-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f64_select_128_4:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v6, 0x40600000
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0x40100000, v6, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f64_select_128_4:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 2, 7, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX10-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f64_select_128_4:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v6, 0x40600000 :: v_dual_mov_b32 v5, 0
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0x40100000, v6, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f64_select_128_4:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 2, 7, vcc_lo
; GFX11-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX11-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, double 128.0, double 4.0
  %mul = fmul contract double %x, %select.pow2
  %fma = fadd contract double %mul, %y
  ret double %fma
}

define double @v_contract_mul_add_f64_select_2_4(i32 %arg, double %x, double %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f64_select_2_4:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0x40100000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v6, v5, 2.0, vcc
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f64_select_2_4:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX9-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f64_select_2_4:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v6, 0x40100000, 2.0, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f64_select_2_4:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc_lo
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX10-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f64_select_2_4:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e64 v6, 0x40100000, 2.0, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f64_select_2_4:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc_lo
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX11-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, double 2.0, double 4.0
  %mul = fmul contract double %x, %select.pow2
  %fma = fadd contract double %mul, %y
  ret double %fma
}

define double @v_contract_mul_add_f64_select_4_128(i32 %arg, double %x, double %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f64_select_4_128:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0x40600000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v6, 0x40100000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v6, v5, v6, vcc
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f64_select_4_128:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 7, 2, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX9-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f64_select_4_128:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v6, 0x40100000
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0x40600000, v6, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f64_select_4_128:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 7, 2, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX10-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_contract_mul_add_f64_select_4_128:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v6, 0x40100000 :: v_dual_mov_b32 v5, 0
; GFX11-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0x40600000, v6, vcc_lo
; GFX11-SDAG-NEXT:    v_fma_f64 v[0:1], v[1:2], v[5:6], v[3:4]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_contract_mul_add_f64_select_4_128:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-NEXT:    v_cndmask_b32_e64 v0, 7, 2, vcc_lo
; GFX11-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[1:2], v0
; GFX11-GISEL-NEXT:    v_add_f64 v[0:1], v[0:1], v[3:4]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, double 4.0, double 128.0
  %mul = fmul contract double %x, %select.pow2
  %fma = fadd contract double %mul, %y
  ret double %fma
}

define half @v_mul_f16_select_64_1(i32 %arg, half %x) {
; GFX9-LABEL: v_mul_f16_select_64_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc
; GFX9-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_f16_select_64_1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX10-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_f16_select_64_1:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v1.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_f16_select_64_1:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_f16_select_64_1:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v1.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_f16_select_64_1:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, half 64.0, half 1.0
  %mul = fmul half %x, %select.pow2
  ret half %mul
}

define half @v_mul_f16_select_1_64(i32 %arg, half %x) {
; GFX9-LABEL: v_mul_f16_select_1_64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_f16_select_1_64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX10-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_f16_select_1_64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v1.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_f16_select_1_64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_f16_select_1_64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v1.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_f16_select_1_64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, half 1.0, half 64.0
  %mul = fmul half %x, %select.pow2
  ret half %mul
}

define half @v_mul_f16_select_n1_n64(i32 %arg, half %x) {
; GFX9-LABEL: v_mul_f16_select_n1_n64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_f16_select_n1_n64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX10-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_f16_select_n1_n64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_ldexp_f16_e64 v0.l, -v1.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_f16_select_n1_n64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_f16_select_n1_n64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e64 v0.l, -v1.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_f16_select_n1_n64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, half -1.0, half -64.0
  %mul = fmul half %x, %select.pow2
  ret half %mul
}

define half @v_mul_f16_select_128_64(i32 %arg, half %x) {
; GFX9-SDAG-LABEL: v_mul_f16_select_128_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc
; GFX9-SDAG-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_f16_select_128_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 6, v0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0xffff8000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX9-GISEL-NEXT:    v_med3_i32 v0, v0, v2, v3
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_f16_select_128_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc_lo
; GFX10-SDAG-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_f16_select_128_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, 0x7fff
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX10-GISEL-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v2
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_f16_select_128_64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v1.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_f16_select_128_64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_f16_select_128_64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_mov_b32_e32 v2, 0x7fff
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-TRUE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v2
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v1.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_f16_select_128_64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_mov_b32_e32 v2, 0x7fff
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-FAKE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v2
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, half 128.0, half 64.0
  %mul = fmul half %x, %select.pow2
  ret half %mul
}

define half @v_mul_f16_select_n128_n64(i32 %arg, half %x) {
; GFX9-SDAG-LABEL: v_mul_f16_select_n128_n64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc
; GFX9-SDAG-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_f16_select_n128_n64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 6, v0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0xffff8000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX9-GISEL-NEXT:    v_med3_i32 v0, v0, v2, v3
; GFX9-GISEL-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_f16_select_n128_n64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc_lo
; GFX10-SDAG-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_f16_select_n128_n64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, 0x7fff
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX10-GISEL-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v2
; GFX10-GISEL-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_f16_select_n128_n64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_ldexp_f16_e64 v0.l, -v1.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_f16_select_n128_n64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 6, 7, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_f16_select_n128_n64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_mov_b32_e32 v2, 0x7fff
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-TRUE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v2
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e64 v0.l, -v1.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_f16_select_n128_n64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_mov_b32_e32 v2, 0x7fff
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-FAKE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v2
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, half -128.0, half -64.0
  %mul = fmul half %x, %select.pow2
  ret half %mul
}

define half @v_mul_f16_select_n128_n16(i32 %arg, half %x) {
; GFX9-LABEL: v_mul_f16_select_n128_n16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 4, 7, vcc
; GFX9-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_mul_f16_select_n128_n16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 4, 7, vcc_lo
; GFX10-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_f16_select_n128_n16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 4, 7, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_ldexp_f16_e64 v0.l, -v1.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_f16_select_n128_n16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 4, 7, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_f16_select_n128_n16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 4, 7, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e64 v0.l, -v1.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_f16_select_n128_n16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 4, 7, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, half -128.0, half -16.0
  %mul = fmul half %x, %select.pow2
  ret half %mul
}

define half @v_contract_mul_add_f16_select_64_1(i32 %arg, half %x, half %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f16_select_64_1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x3c00
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x5400
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f16_select_64_1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX9-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f16_select_64_1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0x5400
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f16_select_64_1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX10-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_f16_select_64_1:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0x3c00
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, 0x5400, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_fma_f16 v0.l, v1.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_f16_select_64_1:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v3, 0x5400
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_f16_select_64_1:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v1.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_add_f16_e32 v0.l, v0.l, v2.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_f16_select_64_1:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX11-GISEL-FAKE16-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select contract i1 %cond, half 64.0, half 1.0
  %mul = fmul contract half %x, %select.pow2
  %fma = fadd contract half %mul, %y
  ret half %fma
}

define half @v_contract_mul_add_f16_select_1_64(i32 %arg, half %x, half %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f16_select_1_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x5400
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x3c00
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f16_select_1_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX9-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f16_select_1_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0x3c00
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x5400, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f16_select_1_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX10-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_f16_select_1_64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0x5400
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, 0x3c00, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_fma_f16 v0.l, v1.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_f16_select_1_64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v3, 0x3c00
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x5400, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_f16_select_1_64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v1.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_add_f16_e32 v0.l, v0.l, v2.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_f16_select_1_64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX11-GISEL-FAKE16-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select contract i1 %cond, half 1.0, half 64.0
  %mul = fmul contract half %x, %select.pow2
  %fma = fadd contract half %mul, %y
  ret half %fma
}

define half @v_contract_mul_add_f16_select_n64_n1(i32 %arg, half %x, half %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f16_select_n64_n1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0xbc00
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0xd400
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f16_select_n64_n1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX9-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f16_select_n64_n1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0xd400
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f16_select_n64_n1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX10-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_f16_select_n64_n1:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0xbc00
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, 0xd400, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_fma_f16 v0.l, v1.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_f16_select_n64_n1:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v3, 0xd400
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_f16_select_n64_n1:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e64 v0.l, -v1.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_add_f16_e32 v0.l, v0.l, v2.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_f16_select_n64_n1:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX11-GISEL-FAKE16-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select contract i1 %cond, half -64.0, half -1.0
  %mul = fmul contract half %x, %select.pow2
  %fma = fadd contract half %mul, %y
  ret half %fma
}

define half @v_contract_mul_add_f16_select_n1_n64(i32 %arg, half %x, half %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f16_select_n1_n64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0xd400
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0xbc00
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f16_select_n1_n64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX9-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f16_select_n1_n64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0xbc00
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0xd400, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f16_select_n1_n64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX10-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_f16_select_n1_n64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0xd400
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, 0xbc00, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_fma_f16 v0.l, v1.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_f16_select_n1_n64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v3, 0xbc00
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0xd400, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_f16_select_n1_n64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e64 v0.l, -v1.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_add_f16_e32 v0.l, v0.l, v2.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_f16_select_n1_n64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e64 v0, -v1, v0
; GFX11-GISEL-FAKE16-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select contract i1 %cond, half -1.0, half -64.0
  %mul = fmul contract half %x, %select.pow2
  %fma = fadd contract half %mul, %y
  ret half %fma
}

define half @v_contract_mul_add_f16_select_128_64(i32 %arg, half %x, half %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f16_select_128_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x5400
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x5800
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f16_select_128_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 6, v0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xffff8000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0x7fff
; GFX9-GISEL-NEXT:    v_med3_i32 v0, v0, v3, v4
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX9-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f16_select_128_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0x5800
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x5400, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f16_select_128_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX10-GISEL-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v3
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX10-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_f16_select_128_64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0x5400
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, 0x5800, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_fma_f16 v0.l, v1.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_f16_select_128_64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v3, 0x5800
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x5400, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_f16_select_128_64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-TRUE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v3
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v1.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_add_f16_e32 v0.l, v0.l, v2.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_f16_select_128_64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-FAKE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX11-GISEL-FAKE16-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, half 128.0, half 64.0
  %mul = fmul contract half %x, %select.pow2
  %fma = fadd contract half %mul, %y
  ret half %fma
}

define half @v_contract_mul_add_f16_select_128_4(i32 %arg, half %x, half %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f16_select_128_4:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x4400
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x5800
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f16_select_128_4:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 2, 7, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX9-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f16_select_128_4:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0x5800
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x4400, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f16_select_128_4:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 2, 7, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX10-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_f16_select_128_4:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0x4400
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, 0x5800, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_fma_f16 v0.l, v1.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_f16_select_128_4:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v3, 0x5800
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x4400, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_f16_select_128_4:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 2, 7, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v1.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_add_f16_e32 v0.l, v0.l, v2.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_f16_select_128_4:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 2, 7, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX11-GISEL-FAKE16-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, half 128.0, half 4.0
  %mul = fmul contract half %x, %select.pow2
  %fma = fadd contract half %mul, %y
  ret half %fma
}

define half @v_contract_mul_add_f16_select_2_4(i32 %arg, half %x, half %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f16_select_2_4:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x4400
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x4000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f16_select_2_4:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xffff8000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0x7fff
; GFX9-GISEL-NEXT:    v_med3_i32 v0, v0, v3, v4
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX9-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f16_select_2_4:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0x4000
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x4400, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f16_select_2_4:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc_lo
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v3
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX10-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_f16_select_2_4:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0x4400
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, 0x4000, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_fma_f16 v0.l, v1.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_f16_select_2_4:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v3, 0x4000
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x4400, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_f16_select_2_4:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 2, v0
; GFX11-GISEL-TRUE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v3
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v1.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_add_f16_e32 v0.l, v0.l, v2.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_f16_select_2_4:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX11-GISEL-FAKE16-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, half 2.0, half 4.0
  %mul = fmul contract half %x, %select.pow2
  %fma = fadd contract half %mul, %y
  ret half %fma
}

define half @v_contract_mul_add_f16_select_4_128(i32 %arg, half %x, half %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_f16_select_4_128:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x5800
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x4400
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_f16_select_4_128:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 7, 2, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX9-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_f16_select_4_128:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0x4400
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x5800, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_f16_select_4_128:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 7, 2, vcc_lo
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX10-GISEL-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_f16_select_4_128:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0x5800
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, 0x4400, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_fma_f16 v0.l, v1.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_f16_select_4_128:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v3, 0x4400
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x5800, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_fma_f16 v0, v1, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_f16_select_4_128:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 7, 2, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v1.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_add_f16_e32 v0.l, v0.l, v2.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_f16_select_4_128:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 7, 2, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v1, v0
; GFX11-GISEL-FAKE16-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq i32 %arg, 0
  %select.pow2 = select i1 %cond, half 4.0, half 128.0
  %mul = fmul contract half %x, %select.pow2
  %fma = fadd contract half %mul, %y
  ret half %fma
}

define <2 x half> @v_mul_v2f16_select_64_1(<2 x i32> %arg, <2 x half> %x) {
; GFX9-SDAG-LABEL: v_mul_v2f16_select_64_1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x3c00
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x5400
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_v2f16_select_64_1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v1, 0, 6, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_v2f16_select_64_1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0x5400
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0x3c00, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_v2f16_select_64_1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, 0, 6, vcc_lo
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_v2f16_select_64_1:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0x3c00
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, 0x5400, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.l, 0x5400, s0
; GFX11-SDAG-TRUE16-NEXT:    v_pack_b32_f16 v0, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_v2f16_select_64_1:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v3, 0x5400
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x3c00, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_v2f16_select_64_1:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v2.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v1, 0, 6, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.h, v2.h, v1.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_v2f16_select_64_1:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v1, 0, 6, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v1, v3, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq <2 x i32> %arg, zeroinitializer
  %select.pow2 = select <2 x i1> %cond, <2 x half> <half 64.0, half 64.0>, <2 x half> <half 1.0, half 1.0>
  %mul = fmul <2 x half> %x, %select.pow2
  ret <2 x half> %mul
}

define <2 x half> @v_mul_v2f16_select_1_64(<2 x i32> %arg, <2 x half> %x) {
; GFX9-SDAG-LABEL: v_mul_v2f16_select_1_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x5400
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x3c00
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_v2f16_select_1_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_v2f16_select_1_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0x3c00
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0x5400, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x5400, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_v2f16_select_1_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc_lo
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_v2f16_select_1_64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0x5400
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, 0x3c00, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.l, 0x3c00, s0
; GFX11-SDAG-TRUE16-NEXT:    v_pack_b32_f16 v0, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_v2f16_select_1_64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v3, 0x3c00
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x5400, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x5400, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_v2f16_select_1_64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v2.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.h, v2.h, v1.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_v2f16_select_1_64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v1, v3, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq <2 x i32> %arg, zeroinitializer
  %select.pow2 = select <2 x i1> %cond, <2 x half> <half 1.0, half 1.0>, <2 x half> <half 64.0, half 64.0>
  %mul = fmul <2 x half> %x, %select.pow2
  ret <2 x half> %mul
}

define <2 x half> @v_mul_v2f16_select_n1_n64(<2 x i32> %arg, <2 x half> %x) {
; GFX9-SDAG-LABEL: v_mul_v2f16_select_n1_n64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0xd400
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0xbc00
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_v2f16_select_n1_n64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_v2f16_select_n1_n64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0xbc00
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0xd400, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0xd400, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_v2f16_select_n1_n64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc_lo
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_v2f16_select_n1_n64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0xd400
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, 0xbc00, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.l, 0xbc00, s0
; GFX11-SDAG-TRUE16-NEXT:    v_pack_b32_f16 v0, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_v2f16_select_n1_n64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v3, 0xbc00
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0xd400, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0xd400, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_v2f16_select_n1_n64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v2.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.h, v2.h, v1.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_v2f16_select_n1_n64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v1, v3, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq <2 x i32> %arg, zeroinitializer
  %select.pow2 = select <2 x i1> %cond, <2 x half> <half -1.0, half -1.0>, <2 x half> <half -64.0, half -64.0>
  %mul = fmul <2 x half> %x, %select.pow2
  ret <2 x half> %mul
}

define <2 x half> @v_mul_v2f16_select_128_64(<2 x i32> %arg, <2 x half> %x) {
; GFX9-SDAG-LABEL: v_mul_v2f16_select_128_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x5400
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x5800
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_v2f16_select_128_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 6, v0
; GFX9-GISEL-NEXT:    v_add_u32_e32 v1, 6, v1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xffff8000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0x7fff
; GFX9-GISEL-NEXT:    v_med3_i32 v0, v0, v3, v4
; GFX9-GISEL-NEXT:    v_med3_i32 v1, v1, v3, v4
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_v2f16_select_128_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0x5800
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0x5400, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x5400, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_v2f16_select_128_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v3
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 6, v1
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v3
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_v2f16_select_128_64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0x5400
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, 0x5800, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.l, 0x5800, s0
; GFX11-SDAG-TRUE16-NEXT:    v_pack_b32_f16 v0, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_v2f16_select_128_64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v3, 0x5800
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x5400, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x5400, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_v2f16_select_128_64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-TRUE16-NEXT:    v_dual_mov_b32 v3, 0x7fff :: v_dual_add_nc_u32 v0, 6, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v3
; GFX11-GISEL-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 6, v1
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v2.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v3
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.h, v2.h, v1.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_v2f16_select_128_64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    v_add_nc_u32_e32 v1, 6, v1
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v3
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v1, v4, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq <2 x i32> %arg, zeroinitializer
  %select.pow2 = select <2 x i1> %cond, <2 x half> <half 128.0, half 128.0>, <2 x half> <half 64.0, half 64.0>
  %mul = fmul <2 x half> %x, %select.pow2
  ret <2 x half> %mul
}

define <2 x half> @v_mul_v2f16_select_n128_n64(<2 x i32> %arg, <2 x half> %x) {
; GFX9-SDAG-LABEL: v_mul_v2f16_select_n128_n64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0xd400
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0xd800
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_v2f16_select_n128_n64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 6, v0
; GFX9-GISEL-NEXT:    v_add_u32_e32 v1, 6, v1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xffff8000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0x7fff
; GFX9-GISEL-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX9-GISEL-NEXT:    v_med3_i32 v0, v0, v3, v4
; GFX9-GISEL-NEXT:    v_med3_i32 v1, v1, v3, v4
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_v2f16_select_n128_n64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0xd800
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0xd400, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0xd400, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_v2f16_select_n128_n64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX10-GISEL-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v3
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 6, v1
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v3
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_v2f16_select_n128_n64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0xd400
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, 0xd800, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.l, 0xd800, s0
; GFX11-SDAG-TRUE16-NEXT:    v_pack_b32_f16 v0, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_v2f16_select_n128_n64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v3, 0xd800
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0xd400, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0xd400, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_v2f16_select_n128_n64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-TRUE16-NEXT:    v_dual_mov_b32 v3, 0x7fff :: v_dual_add_nc_u32 v0, 6, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v3
; GFX11-GISEL-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 6, v1
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v2.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v3
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.h, v2.h, v1.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_v2f16_select_n128_n64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-GISEL-FAKE16-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    v_add_nc_u32_e32 v1, 6, v1
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v3
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v1, v4, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq <2 x i32> %arg, zeroinitializer
  %select.pow2 = select <2 x i1> %cond, <2 x half> <half -128.0, half -128.0>, <2 x half> <half -64.0, half -64.0>
  %mul = fmul <2 x half> %x, %select.pow2
  ret <2 x half> %mul
}

define <2 x half> @v_mul_v2f16_select_n128_n16(<2 x i32> %arg, <2 x half> %x) {
; GFX9-SDAG-LABEL: v_mul_v2f16_select_n128_n16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0xcc00
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0xd800
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_v2f16_select_n128_n16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 4, 7, vcc
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v1, 4, 7, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_v2f16_select_n128_n16:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v3, 0xd800
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0xcc00, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0xcc00, v3, vcc_lo
; GFX10-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_v2f16_select_n128_n16:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 4, 7, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, 4, 7, vcc_lo
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_mul_v2f16_select_n128_n16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0xcc00
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, 0xd800, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.l, 0xd800, s0
; GFX11-SDAG-TRUE16-NEXT:    v_pack_b32_f16 v0, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_mul_v2f16_select_n128_n16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v3, 0xd800
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0xcc00, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0xcc00, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_pk_mul_f16 v0, v2, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_mul_v2f16_select_n128_n16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 4, 7, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v2.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v1, 4, 7, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.h, v2.h, v1.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_mul_v2f16_select_n128_n16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 4, 7, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v1, 4, 7, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v1, v3, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq <2 x i32> %arg, zeroinitializer
  %select.pow2 = select <2 x i1> %cond, <2 x half> <half -128.0, half -128.0>, <2 x half> <half -16.0, half -16.0>
  %mul = fmul <2 x half> %x, %select.pow2
  ret <2 x half> %mul
}

define <2 x half> @v_contract_mul_add_v2f16_select_64_1(<2 x i32> %arg, <2 x half> %x, <2 x half> %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_v2f16_select_64_1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x3c00
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0x5400
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_v2f16_select_64_1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v1, 0, 6, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_v2f16_select_64_1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v4, 0x5400
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0x3c00, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_v2f16_select_64_1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, 0, 6, vcc_lo
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_v2f16_select_64_1:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, 0x3c00
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v4.l, 0x5400, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, 0x5400, s0
; GFX11-SDAG-TRUE16-NEXT:    v_pack_b32_f16 v0, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_v2f16_select_64_1:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v4, 0x5400
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x3c00, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_v2f16_select_64_1:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v2.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v1, 0, 6, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.h, v2.h, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_v2f16_select_64_1:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v1, 0, 6, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v1, v4, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-FAKE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq <2 x i32> %arg, zeroinitializer
  %select.pow2 = select <2 x i1> %cond, <2 x half> <half 64.0, half 64.0>, <2 x half> <half 1.0, half 1.0>
  %mul = fmul contract <2 x half> %x, %select.pow2
  %fma = fadd contract <2 x half> %mul, %y
  ret <2 x half> %fma
}

define <2 x half> @v_contract_mul_add_v2f16_select_1_64(<2 x i32> %arg, <2 x half> %x, <2 x half> %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_v2f16_select_1_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x5400
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0x3c00
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_v2f16_select_1_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_v2f16_select_1_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v4, 0x3c00
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0x5400, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x5400, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_v2f16_select_1_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc_lo
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_v2f16_select_1_64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, 0x5400
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v4.l, 0x3c00, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, 0x3c00, s0
; GFX11-SDAG-TRUE16-NEXT:    v_pack_b32_f16 v0, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_v2f16_select_1_64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v4, 0x3c00
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x5400, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x5400, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_v2f16_select_1_64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v2.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.h, v2.h, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_v2f16_select_1_64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v1, v4, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-FAKE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq <2 x i32> %arg, zeroinitializer
  %select.pow2 = select <2 x i1> %cond, <2 x half> <half 1.0, half 1.0>, <2 x half> <half 64.0, half 64.0>
  %mul = fmul contract <2 x half> %x, %select.pow2
  %fma = fadd contract <2 x half> %mul, %y
  ret <2 x half> %fma
}

define <2 x half> @v_contract_mul_add_v2f16_select_n64_n1(<2 x i32> %arg, <2 x half> %x, <2 x half> %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_v2f16_select_n64_n1:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0xbc00
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0xd400
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_v2f16_select_n64_n1:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v1, 0, 6, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_v2f16_select_n64_n1:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v4, 0xd400
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0xbc00, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_v2f16_select_n64_n1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, 0, 6, vcc_lo
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_v2f16_select_n64_n1:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, 0xbc00
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v4.l, 0xd400, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, 0xd400, s0
; GFX11-SDAG-TRUE16-NEXT:    v_pack_b32_f16 v0, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_v2f16_select_n64_n1:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v4, 0xd400
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0xbc00, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_v2f16_select_n64_n1:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v2.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v1, 0, 6, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.h, v2.h, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_v2f16_select_n64_n1:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, 6, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v1, 0, 6, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v1, v4, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-FAKE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq <2 x i32> %arg, zeroinitializer
  %select.pow2 = select <2 x i1> %cond, <2 x half> <half -64.0, half -64.0>, <2 x half> <half -1.0, half -1.0>
  %mul = fmul contract <2 x half> %x, %select.pow2
  %fma = fadd contract <2 x half> %mul, %y
  ret <2 x half> %fma
}

define <2 x half> @v_contract_mul_add_v2f16_select_n1_n64(<2 x i32> %arg, <2 x half> %x, <2 x half> %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_v2f16_select_n1_n64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0xd400
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0xbc00
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_v2f16_select_n1_n64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_v2f16_select_n1_n64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v4, 0xbc00
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0xd400, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0xd400, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_v2f16_select_n1_n64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc_lo
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_v2f16_select_n1_n64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, 0xd400
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v4.l, 0xbc00, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, 0xbc00, s0
; GFX11-SDAG-TRUE16-NEXT:    v_pack_b32_f16 v0, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_v2f16_select_n1_n64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v4, 0xbc00
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0xd400, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0xd400, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_v2f16_select_n1_n64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v2.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.h, v2.h, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_v2f16_select_n1_n64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 6, 0, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v1, 6, 0, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v1, v4, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-FAKE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq <2 x i32> %arg, zeroinitializer
  %select.pow2 = select <2 x i1> %cond, <2 x half> <half -1.0, half -1.0>, <2 x half> <half -64.0, half -64.0>
  %mul = fmul contract <2 x half> %x, %select.pow2
  %fma = fadd contract <2 x half> %mul, %y
  ret <2 x half> %fma
}

define <2 x half> @v_contract_mul_add_v2f16_select_128_64(<2 x i32> %arg, <2 x half> %x, <2 x half> %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_v2f16_select_128_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x5400
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0x5800
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_v2f16_select_128_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 6, v0
; GFX9-GISEL-NEXT:    v_add_u32_e32 v1, 6, v1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffff8000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v5, 0x7fff
; GFX9-GISEL-NEXT:    v_med3_i32 v0, v0, v4, v5
; GFX9-GISEL-NEXT:    v_med3_i32 v1, v1, v4, v5
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_v2f16_select_128_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v4, 0x5800
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0x5400, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x5400, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_v2f16_select_128_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v4, 0x7fff
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX10-GISEL-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v4
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 6, v1
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v4
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_v2f16_select_128_64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, 0x5400
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v4.l, 0x5800, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, 0x5800, s0
; GFX11-SDAG-TRUE16-NEXT:    v_pack_b32_f16 v0, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_v2f16_select_128_64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v4, 0x5800
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x5400, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x5400, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_v2f16_select_128_64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_dual_mov_b32 v4, 0x7fff :: v_dual_add_nc_u32 v1, 6, v1
; GFX11-GISEL-TRUE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v4
; GFX11-GISEL-TRUE16-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v4
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v2.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.h, v2.h, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_v2f16_select_128_64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 6, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_dual_mov_b32 v4, 0x7fff :: v_dual_add_nc_u32 v1, 6, v1
; GFX11-GISEL-FAKE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v4
; GFX11-GISEL-FAKE16-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v4
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v1, v5, v1
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-FAKE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq <2 x i32> %arg, zeroinitializer
  %select.pow2 = select <2 x i1> %cond, <2 x half> <half 128.0, half 128.0>, <2 x half> <half 64.0, half 64.0>
  %mul = fmul contract <2 x half> %x, %select.pow2
  %fma = fadd contract <2 x half> %mul, %y
  ret <2 x half> %fma
}

define <2 x half> @v_contract_mul_add_v2f16_select_128_4(<2 x i32> %arg, <2 x half> %x, <2 x half> %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_v2f16_select_128_4:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x4400
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0x5800
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_v2f16_select_128_4:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 2, 7, vcc
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v1, 2, 7, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_v2f16_select_128_4:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v4, 0x5800
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0x4400, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x4400, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_v2f16_select_128_4:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 2, 7, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, 2, 7, vcc_lo
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_v2f16_select_128_4:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, 0x4400
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v4.l, 0x5800, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, 0x5800, s0
; GFX11-SDAG-TRUE16-NEXT:    v_pack_b32_f16 v0, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_v2f16_select_128_4:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v4, 0x5800
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x4400, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x4400, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_v2f16_select_128_4:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 2, 7, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v2.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v1, 2, 7, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.h, v2.h, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_v2f16_select_128_4:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 2, 7, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v1, 2, 7, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v1, v4, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-FAKE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq <2 x i32> %arg, zeroinitializer
  %select.pow2 = select <2 x i1> %cond, <2 x half> <half 128.0, half 128.0>, <2 x half> <half 4.0, half 4.0>
  %mul = fmul contract <2 x half> %x, %select.pow2
  %fma = fadd contract <2 x half> %mul, %y
  ret <2 x half> %fma
}

define <2 x half> @v_contract_mul_add_v2f16_select_2_4(<2 x i32> %arg, <2 x half> %x, <2 x half> %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_v2f16_select_2_4:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x4400
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0x4000
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_v2f16_select_2_4:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    v_add_u32_e32 v1, 2, v1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffff8000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v5, 0x7fff
; GFX9-GISEL-NEXT:    v_med3_i32 v0, v0, v4, v5
; GFX9-GISEL-NEXT:    v_med3_i32 v1, v1, v4, v5
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_v2f16_select_2_4:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v4, 0x4000
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0x4400, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x4400, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_v2f16_select_2_4:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v4, 0x7fff
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc_lo
; GFX10-GISEL-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v4
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 2, v1
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v4
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_v2f16_select_2_4:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, 0x4400
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v4.l, 0x4000, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, 0x4000, s0
; GFX11-SDAG-TRUE16-NEXT:    v_pack_b32_f16 v0, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_v2f16_select_2_4:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v4, 0x4000
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x4400, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x4400, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_v2f16_select_2_4:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 2, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_dual_mov_b32 v4, 0x7fff :: v_dual_add_nc_u32 v1, 2, v1
; GFX11-GISEL-TRUE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v4
; GFX11-GISEL-TRUE16-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v4
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v2.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.h, v2.h, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_v2f16_select_2_4:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_dual_mov_b32 v4, 0x7fff :: v_dual_add_nc_u32 v1, 2, v1
; GFX11-GISEL-FAKE16-NEXT:    v_med3_i32 v0, 0xffff8000, v0, v4
; GFX11-GISEL-FAKE16-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v4
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v1, v5, v1
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-FAKE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq <2 x i32> %arg, zeroinitializer
  %select.pow2 = select <2 x i1> %cond, <2 x half> <half 2.0, half 2.0>, <2 x half> <half 4.0, half 4.0>
  %mul = fmul contract <2 x half> %x, %select.pow2
  %fma = fadd contract <2 x half> %mul, %y
  ret <2 x half> %fma
}

define <2 x half> @v_contract_mul_add_v2f16_select_4_128(<2 x i32> %arg, <2 x half> %x, <2 x half> %y) {
; GFX9-SDAG-LABEL: v_contract_mul_add_v2f16_select_4_128:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v4, 0x5800
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v5, 0x4400
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_contract_mul_add_v2f16_select_4_128:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v0, 7, 2, vcc
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-GISEL-NEXT:    v_cndmask_b32_e64 v1, 7, 2, vcc
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_contract_mul_add_v2f16_select_4_128:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v4, 0x4400
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v1, 0x5800, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-SDAG-NEXT:    v_cndmask_b32_e32 v0, 0x5800, v4, vcc_lo
; GFX10-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_contract_mul_add_v2f16_select_4_128:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, 7, 2, vcc_lo
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, 7, 2, vcc_lo
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-GISEL-NEXT:    v_ldexp_f16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_contract_mul_add_v2f16_select_4_128:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, 0x5800
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v4.l, 0x4400, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, 0x4400, s0
; GFX11-SDAG-TRUE16-NEXT:    v_pack_b32_f16 v0, v0.h, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_contract_mul_add_v2f16_select_4_128:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v4, 0x4400
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x5800, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x5800, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_pk_fma_f16 v0, v2, v0, v3
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_contract_mul_add_v2f16_select_4_128:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v0, 7, 2, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.l, v2.l, v0.l
; GFX11-GISEL-TRUE16-NEXT:    v_cndmask_b32_e64 v1, 7, 2, vcc_lo
; GFX11-GISEL-TRUE16-NEXT:    v_ldexp_f16_e32 v0.h, v2.h, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_contract_mul_add_v2f16_select_4_128:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 7, 2, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v0, v2, v0
; GFX11-GISEL-FAKE16-NEXT:    v_cndmask_b32_e64 v1, 7, 2, vcc_lo
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-FAKE16-NEXT:    v_ldexp_f16_e32 v1, v4, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-FAKE16-NEXT:    v_pk_add_f16 v0, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cond = icmp eq <2 x i32> %arg, zeroinitializer
  %select.pow2 = select <2 x i1> %cond, <2 x half> <half 4.0, half 4.0>, <2 x half> <half 128.0, half 128.0>
  %mul = fmul contract <2 x half> %x, %select.pow2
  %fma = fadd contract <2 x half> %mul, %y
  ret <2 x half> %fma
}

;---------------------------------------------------------------------
; strictfp support
;---------------------------------------------------------------------

define float @v_constrained_fmul_32_f32(float %x, float %y) #0 {
; GCN-LABEL: v_constrained_fmul_32_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0x42000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %val = call float @llvm.experimental.constrained.fmul.f32(float %x, float 32.0, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret float %val
}

define double @v_constrained_fmul_32_f64(double %x, double %y) #0 {
; GFX9-SDAG-LABEL: v_constrained_fmul_32_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 5
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_constrained_fmul_32_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x40400000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_constrained_fmul_32_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 5
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_constrained_fmul_32_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], 0x40400000
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_constrained_fmul_32_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 5
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_constrained_fmul_32_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], 0x40400000
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %val = call double @llvm.experimental.constrained.fmul.f64(double %x, double 32.0, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret double %val
}

define double @v_constrained_fmul_0x1p64_f64(double %x, double %y) #0 {
; GFX9-SDAG-LABEL: v_constrained_fmul_0x1p64_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 64
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_constrained_fmul_0x1p64_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x43f00000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_constrained_fmul_0x1p64_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 64
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_constrained_fmul_0x1p64_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], 0x43f00000
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_constrained_fmul_0x1p64_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], 64
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_constrained_fmul_0x1p64_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], 0x43f00000
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %val = call double @llvm.experimental.constrained.fmul.f64(double %x, double 18446744073709551616.0, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret double %val
}

define half @v_constrained_fmul_32_f16(half %x, half %y) #0 {
; GFX9-LABEL: v_constrained_fmul_32_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, 0x5000, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_constrained_fmul_32_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, 0x5000, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_constrained_fmul_32_f16:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x5000, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_constrained_fmul_32_f16:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x5000, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: v_constrained_fmul_32_f16:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, 0x5000, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: v_constrained_fmul_32_f16:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, 0x5000, v0
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %val = call half @llvm.experimental.constrained.fmul.f16(half %x, half 32.0, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret half %val
}

define double @v_mul_fabs_0x1pn1031_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_fabs_0x1pn1031_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0xfbf9
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_fabs_0x1pn1031_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x800
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_fabs_0x1pn1031_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, 0xfffffbf9
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_fabs_0x1pn1031_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x800, |v[0:1]|
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_fabs_0x1pn1031_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, 0xfffffbf9
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_fabs_0x1pn1031_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x800, |v[0:1]|
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %fabs.x, 4.34584737989687770135e-311
  ret double %mul
}

define double @v_mul_fabs_neg256_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_fabs_neg256_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], -|v[0:1]|, 8
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_fabs_neg256_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xc0700000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_fabs_neg256_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], -|v[0:1]|, 8
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_fabs_neg256_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0700000, |v[0:1]|
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_fabs_neg256_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], -|v[0:1]|, 8
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_fabs_neg256_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0700000, |v[0:1]|
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %fabs.x, -256.0
  ret double %mul
}

define double @v_mul_fabs_neg8_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_fabs_neg8_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], -|v[0:1]|, 3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_fabs_neg8_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xc0200000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_fabs_neg8_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], -|v[0:1]|, 3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_fabs_neg8_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0200000, |v[0:1]|
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_fabs_neg8_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], -|v[0:1]|, 3
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_fabs_neg8_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0xc0200000, |v[0:1]|
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %fabs.x, -8.0
  ret double %mul
}

define double @v_mul_fabs_neg4_f64(double %x) {
; GCN-LABEL: v_mul_fabs_neg4_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, -4.0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %fabs.x, -4.0
  ret double %mul
}

define double @v_mul_fabs_neg2_f64(double %x) {
; GCN-LABEL: v_mul_fabs_neg2_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, -2.0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %fabs.x, -2.0
  ret double %mul
}

define double @v_mul_fabs_neg1_f64(double %x) {
; GCN-LABEL: v_mul_fabs_neg1_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_or_b32_e32 v1, 0x80000000, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %fabs.x, -1.0
  ret double %mul
}

define double @v_mul_fabs_neghalf_f64(double %x) {
; GCN-LABEL: v_mul_fabs_neghalf_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, -0.5
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %fabs.x, -0.5
  ret double %mul
}

define double @v_mul_fabs_negquarter_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_fabs_negquarter_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], -|v[0:1]|, -2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_fabs_negquarter_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xbfd00000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_fabs_negquarter_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], -|v[0:1]|, -2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_fabs_negquarter_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0xbfd00000, |v[0:1]|
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_fabs_negquarter_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], -|v[0:1]|, -2
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_fabs_negquarter_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0xbfd00000, |v[0:1]|
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %fabs.x, -0.25
  ret double %mul
}

define double @v_mul_fabs_quarter_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_fabs_quarter_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, -2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_fabs_quarter_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x3fd00000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_fabs_quarter_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, -2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_fabs_quarter_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x3fd00000, |v[0:1]|
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_fabs_quarter_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, -2
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_fabs_quarter_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x3fd00000, |v[0:1]|
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %fabs.x, 0.25
  ret double %mul
}

define double @v_mul_fabs_half_f64(double %x) {
; GCN-LABEL: v_mul_fabs_half_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, 0.5
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %fabs.x, 0.5
  ret double %mul
}

define double @v_mul_fabs_1_f64(double %x) {
; GCN-LABEL: v_mul_fabs_1_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 0x7fffffff, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %fabs.x, 1.0
  ret double %mul
}

define double @v_mul_fabs_2_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_fabs_2_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_f64 v[0:1], |v[0:1]|, |v[0:1]|
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_fabs_2_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, 2.0
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_fabs_2_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_f64 v[0:1], |v[0:1]|, |v[0:1]|
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_fabs_2_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, 2.0
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_fabs_2_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_f64 v[0:1], |v[0:1]|, |v[0:1]|
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_fabs_2_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, 2.0
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %fabs.x, 2.0
  ret double %mul
}

define double @v_mul_fabs_4_f64(double %x) {
; GCN-LABEL: v_mul_fabs_4_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, 4.0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %fabs.x, 4.0
  ret double %mul
}

define double @v_mul_fabs_8_f64(double %x) {
; GFX9-SDAG-LABEL: v_mul_fabs_8_f64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, 3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_mul_fabs_8_f64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x40200000
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], |v[0:1]|, v[2:3]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_mul_fabs_8_f64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, 3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_mul_fabs_8_f64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40200000, |v[0:1]|
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_mul_fabs_8_f64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, 3
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: v_mul_fabs_8_f64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], 0x40200000, |v[0:1]|
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %mul = fmul double %fabs.x, 8.0
  ret double %mul
}

declare half @llvm.experimental.constrained.fmul.f16(half, half, metadata, metadata)
declare float @llvm.experimental.constrained.fmul.f32(float, float, metadata, metadata)
declare double @llvm.experimental.constrained.fmul.f64(double, double, metadata, metadata)

attributes #0 = { strictfp }
