; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfbfmin,+zvfbfmin,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfbfmin,+zvfbfmin,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

define bfloat @vpreduce_fmin_nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpreduce_fmin_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.s.f v8, fa5
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfredmin.vs v8, v10, v8, v0.t
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call bfloat @llvm.vp.reduce.fmin.nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret bfloat %s
}

define bfloat @vpreduce_fmax_nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpreduce_fmax_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.s.f v8, fa5
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfredmax.vs v8, v10, v8, v0.t
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call bfloat @llvm.vp.reduce.fmax.nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret bfloat %s
}

define bfloat @vpreduce_fmin_nnan_nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpreduce_fmin_nnan_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.s.f v8, fa5
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfredmin.vs v8, v10, v8, v0.t
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call nnan bfloat @llvm.vp.reduce.fmin.nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret bfloat %s
}

define bfloat @vpreduce_fmax_nnan_nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpreduce_fmax_nnan_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.s.f v8, fa5
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfredmax.vs v8, v10, v8, v0.t
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call nnan bfloat @llvm.vp.reduce.fmax.nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret bfloat %s
}

define bfloat @vpreduce_fminimum_nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpreduce_fminimum_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfne.vv v8, v10, v10, v0.t
; CHECK-NEXT:    feq.s a1, fa5, fa5
; CHECK-NEXT:    vcpop.m a2, v8, v0.t
; CHECK-NEXT:    xori a1, a1, 1
; CHECK-NEXT:    or a1, a2, a1
; CHECK-NEXT:    beqz a1, .LBB4_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB4_2:
; CHECK-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.s.f v8, fa5
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfredmin.vs v8, v10, v8, v0.t
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call bfloat @llvm.vp.reduce.fminimum.nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret bfloat %s
}

define bfloat @vpreduce_fmaximum_nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpreduce_fmaximum_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfne.vv v8, v10, v10, v0.t
; CHECK-NEXT:    feq.s a1, fa5, fa5
; CHECK-NEXT:    vcpop.m a2, v8, v0.t
; CHECK-NEXT:    xori a1, a1, 1
; CHECK-NEXT:    or a1, a2, a1
; CHECK-NEXT:    beqz a1, .LBB5_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB5_2:
; CHECK-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.s.f v8, fa5
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfredmax.vs v8, v10, v8, v0.t
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call bfloat @llvm.vp.reduce.fmaximum.nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret bfloat %s
}

define bfloat @vpreduce_fminimum_nnan_nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpreduce_fminimum_nnan_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.s.f v8, fa5
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfredmin.vs v8, v10, v8, v0.t
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call nnan bfloat @llvm.vp.reduce.fminimum.nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret bfloat %s
}

define bfloat @vpreduce_fmaximum_nnan_nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpreduce_fmaximum_nnan_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.s.f v8, fa5
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfredmax.vs v8, v10, v8, v0.t
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %s = call nnan bfloat @llvm.vp.reduce.fmaximum.nxv4bf16(bfloat %start, <vscale x 4 x bfloat> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret bfloat %s
}
