#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Strike Suit Zero
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250311.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='strike-suit-zero'
GAME_NAME='Strike Suit Zero'

ARCHIVE_BASE_0_NAME='StrikeSuitZero_linux_1389211698.zip'
ARCHIVE_BASE_0_MD5='94b1c2907ae61deb27eb77fee3fb9c19'
ARCHIVE_BASE_0_SIZE='2400000'
ARCHIVE_BASE_0_VERSION='1.0-humble1'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/strike-suit-zero'

ARCHIVE_OPTIONAL_ICONS_NAME='strike-suit-zero_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_MD5='3fe8bbad7ecca5c0e3afdbbfedb8945d'
ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/strike-suit-zero/'
CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
16x16
32x32
48x48'

CONTENT_PATH_DEFAULT='.'
CONTENT_LIBS_BIN_RELATIVE_PATH='linux/main/binary'
CONTENT_LIBS_BIN_FILES='
libfmodevent.so
libfmodeventnet.so
libfmodex.so
libfmodex-4.44.12.so'
CONTENT_GAME_BIN_FILES='
linux/main/binary/StrikeSuitZero'
CONTENT_GAME_DATA_FILES='
linux/main/art
linux/main/audio
linux/main/fonts
linux/main/gui
linux/main/level
linux/main/levels
linux/main/localisation
linux/main/particles
linux/main/scripts
linux/main/shaders
linux/main/system
linux/main/textures
linux/main/video
linux/main/index.toc
linux/main/index.toc.txt'

USER_PERSISTENT_FILES='
*.sav'

APP_MAIN_EXE='linux/main/binary/StrikeSuitZero'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
libSDL2-2.0.so.0
libstdc++.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Run the game binary from its parent directory
game_exec_line() {
	cat <<- 'EOF'
	cd linux/main/binary
	./StrikeSuitZero "$@"
	EOF
}

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
