// Copyright (C) 2019-2026 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

// { dg-do compile { target c++20 } }

#include <algorithm>
#include <array>

constexpr bool
test()
{
  auto ok = true;

  std::array<int, 23>
  ah{{0,
      1, 2,
      3, 4, 5, 6,
      7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22}};

  std::make_heap(ah.begin(), ah.end());
  ok = ok && std::is_heap(ah.begin(), ah.end());

  std::pop_heap(ah.begin(), ah.end());
  std::pop_heap(ah.begin(), ah.end() - 1);
  std::pop_heap(ah.begin(), ah.end() - 2);
  ok = ok && std::is_heap(ah.begin(), ah.end() - 3)
	  && !std::is_heap(ah.begin(), ah.end());

  return ok;
}

static_assert(test());
