//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armapimanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementListApiProducts.json
func ExampleAPIProductClient_NewListByApisPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAPIProductClient().NewListByApisPager("rg1", "apimService1", "57d2ef278aa04f0888cba3f3", &armapimanagement.APIProductClientListByApisOptions{Filter: nil,
		Top:  nil,
		Skip: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProductCollection = armapimanagement.ProductCollection{
		// 	Count: to.Ptr[int64](1),
		// 	Value: []*armapimanagement.ProductContract{
		// 		{
		// 			Name: to.Ptr("5600b539c53f5b0062060002"),
		// 			Type: to.Ptr("Microsoft.ApiManagement/service/apis/products"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/products/5600b539c53f5b0062060002"),
		// 			Properties: &armapimanagement.ProductContractProperties{
		// 				Description: to.Ptr("Subscribers have completely unlimited access to the API. Administrator approval is required."),
		// 				ApprovalRequired: to.Ptr(true),
		// 				State: to.Ptr(armapimanagement.ProductStatePublished),
		// 				SubscriptionRequired: to.Ptr(true),
		// 				SubscriptionsLimit: to.Ptr[int32](1),
		// 				DisplayName: to.Ptr("Unlimited"),
		// 			},
		// 	}},
		// }
	}
}
