//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armconsumption_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/consumption/armconsumption"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ChargesForBillingPeriodByDepartment.json
func ExampleChargesClient_List_changesForBillingPeriodByDepartmentLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChargesClient().List(ctx, "providers/Microsoft.Billing/BillingAccounts/1234/departments/42425", &armconsumption.ChargesClientListOptions{StartDate: nil,
		EndDate: nil,
		Filter:  nil,
		Apply:   nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChargesListResult = armconsumption.ChargesListResult{
	// 	Value: []armconsumption.ChargeSummaryClassification{
	// 		&armconsumption.LegacyChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId1"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234/departments/42425/providers/Microsoft.Consumption/charges/chargeSummaryId1"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindLegacy),
	// 			Properties: &armconsumption.LegacyChargeSummaryProperties{
	// 				AzureCharges: to.Ptr[float64](5000),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234/providers/Microsoft.Billing/billingPeriods/201804"),
	// 				ChargesBilledSeparately: to.Ptr[float64](60.9),
	// 				Currency: to.Ptr("USD"),
	// 				MarketplaceCharges: to.Ptr[float64](100),
	// 				UsageEnd: to.Ptr("2018-04-30"),
	// 				UsageStart: to.Ptr("2018-04-01"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ChargesForBillingPeriodByEnrollmentAccount.json
func ExampleChargesClient_List_changesForBillingPeriodByEnrollmentAccountLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChargesClient().List(ctx, "providers/Microsoft.Billing/BillingAccounts/1234/enrollmentAccounts/42425", &armconsumption.ChargesClientListOptions{StartDate: nil,
		EndDate: nil,
		Filter:  nil,
		Apply:   nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChargesListResult = armconsumption.ChargesListResult{
	// 	Value: []armconsumption.ChargeSummaryClassification{
	// 		&armconsumption.LegacyChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId1"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234/enrollmentAccounts/42425/providers/Microsoft.Consumption/charges/chargeSummaryId1"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindLegacy),
	// 			Properties: &armconsumption.LegacyChargeSummaryProperties{
	// 				AzureCharges: to.Ptr[float64](5000),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234/providers/Microsoft.Billing/billingPeriods/201804"),
	// 				ChargesBilledSeparately: to.Ptr[float64](60.9),
	// 				Currency: to.Ptr("USD"),
	// 				MarketplaceCharges: to.Ptr[float64](100),
	// 				UsageEnd: to.Ptr("2018-04-30"),
	// 				UsageStart: to.Ptr("2018-04-01"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ChargesListByModernBillingAccount.json
func ExampleChargesClient_List_chargesListByBillingAccountModern() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChargesClient().List(ctx, "providers/Microsoft.Billing/billingAccounts/1234:56789", &armconsumption.ChargesClientListOptions{StartDate: to.Ptr("2019-09-01"),
		EndDate: to.Ptr("2019-10-31"),
		Filter:  nil,
		Apply:   nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChargesListResult = armconsumption.ChargesListResult{
	// 	Value: []armconsumption.ChargeSummaryClassification{
	// 		&armconsumption.ModernChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId1"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Consumption/charges/chargeSummaryId1"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindModern),
	// 			Properties: &armconsumption.ModernChargeSummaryProperties{
	// 				AzureCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](0),
	// 				},
	// 				BillingAccountID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789"),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Billing/billingPeriods/201910"),
	// 				ChargesBilledSeparately: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](265.09),
	// 				},
	// 				IsInvoiced: to.Ptr(false),
	// 				MarketplaceCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](0),
	// 				},
	// 				UsageEnd: to.Ptr("2019-10-31"),
	// 				UsageStart: to.Ptr("2021-10-01"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ChargesListByModernBillingAccountGroupByBillingProfileId.json
func ExampleChargesClient_List_chargesListByBillingAccountGroupByBillingProfileIdModern() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChargesClient().List(ctx, "providers/Microsoft.Billing/billingAccounts/1234:56789", &armconsumption.ChargesClientListOptions{StartDate: to.Ptr("2019-09-01"),
		EndDate: to.Ptr("2019-09-30"),
		Filter:  nil,
		Apply:   to.Ptr("groupby((properties/billingProfileId))"),
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChargesListResult = armconsumption.ChargesListResult{
	// 	Value: []armconsumption.ChargeSummaryClassification{
	// 		&armconsumption.ModernChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId1"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Consumption/charges/chargeSummaryId1"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindModern),
	// 			Properties: &armconsumption.ModernChargeSummaryProperties{
	// 				AzureCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](5000),
	// 				},
	// 				BillingAccountID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789"),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/123456/providers/Microsoft.Billing/billingPeriods/201909"),
	// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/123456"),
	// 				ChargesBilledSeparately: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](60.9),
	// 				},
	// 				IsInvoiced: to.Ptr(false),
	// 				MarketplaceCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](100),
	// 				},
	// 				UsageEnd: to.Ptr("2019-09-30"),
	// 				UsageStart: to.Ptr("2019-09-01"),
	// 			},
	// 		},
	// 		&armconsumption.ModernChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId2"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234:56789/billingProfiles/42425/providers/Microsoft.Consumption/charges/chargeSummaryId2"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindModern),
	// 			Properties: &armconsumption.ModernChargeSummaryProperties{
	// 				AzureCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](5000),
	// 				},
	// 				BillingAccountID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789"),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Billing/billingPeriods/201909"),
	// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425"),
	// 				ChargesBilledSeparately: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](60.9),
	// 				},
	// 				MarketplaceCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](100),
	// 				},
	// 				UsageEnd: to.Ptr("2019-09-30"),
	// 				UsageStart: to.Ptr("2019-09-01"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ChargesListByModernBillingAccountGroupByCustomerId.json
func ExampleChargesClient_List_chargesListByBillingAccountGroupByCustomerIdModern() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChargesClient().List(ctx, "providers/Microsoft.Billing/billingAccounts/1234:56789", &armconsumption.ChargesClientListOptions{StartDate: to.Ptr("2019-09-01"),
		EndDate: to.Ptr("2019-09-30"),
		Filter:  nil,
		Apply:   to.Ptr("groupby((properties/customerId))"),
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChargesListResult = armconsumption.ChargesListResult{
	// 	Value: []armconsumption.ChargeSummaryClassification{
	// 		&armconsumption.ModernChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId1"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/customers/67890/providers/Microsoft.Consumption/charges/chargeSummaryId1"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindModern),
	// 			Properties: &armconsumption.ModernChargeSummaryProperties{
	// 				AzureCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](5000),
	// 				},
	// 				BillingAccountID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789"),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Billing/billingPeriods/201909"),
	// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425"),
	// 				ChargesBilledSeparately: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](60.9),
	// 				},
	// 				CustomerID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/customers/67890"),
	// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/invoiceSections/67890"),
	// 				IsInvoiced: to.Ptr(false),
	// 				MarketplaceCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](100),
	// 				},
	// 				UsageEnd: to.Ptr("2019-09-30"),
	// 				UsageStart: to.Ptr("2019-09-01"),
	// 			},
	// 		},
	// 		&armconsumption.ModernChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId2"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234:56789/customers/123456/providers/Microsoft.Consumption/charges/chargeSummaryId2"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindModern),
	// 			Properties: &armconsumption.ModernChargeSummaryProperties{
	// 				AzureCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](5000),
	// 				},
	// 				BillingAccountID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789"),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Billing/billingPeriods/201909"),
	// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425"),
	// 				ChargesBilledSeparately: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](60.9),
	// 				},
	// 				CustomerID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/customers/123456"),
	// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/invoiceSections/67890"),
	// 				IsInvoiced: to.Ptr(false),
	// 				MarketplaceCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](100),
	// 				},
	// 				UsageEnd: to.Ptr("2019-09-30"),
	// 				UsageStart: to.Ptr("2019-09-01"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ChargesListByModernBillingAccountGroupByInvoiceSectionId.json
func ExampleChargesClient_List_chargesListByBillingAccountGroupByInvoiceSectionIdModern() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChargesClient().List(ctx, "providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425", &armconsumption.ChargesClientListOptions{StartDate: to.Ptr("2019-09-01"),
		EndDate: to.Ptr("2019-09-30"),
		Filter:  nil,
		Apply:   to.Ptr("groupby((properties/invoiceSectionId))"),
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChargesListResult = armconsumption.ChargesListResult{
	// 	Value: []armconsumption.ChargeSummaryClassification{
	// 		&armconsumption.ModernChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId1"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425/invoiceSections/4567/providers/Microsoft.Consumption/charges/chargeSummaryId1"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindModern),
	// 			Properties: &armconsumption.ModernChargeSummaryProperties{
	// 				AzureCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](5000),
	// 				},
	// 				BillingAccountID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789"),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Billing/billingPeriods/201909"),
	// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425"),
	// 				ChargesBilledSeparately: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](60.9),
	// 				},
	// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/invoiceSections/4567"),
	// 				IsInvoiced: to.Ptr(false),
	// 				MarketplaceCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](100),
	// 				},
	// 				UsageEnd: to.Ptr("2019-09-30"),
	// 				UsageStart: to.Ptr("2019-09-01"),
	// 			},
	// 		},
	// 		&armconsumption.ModernChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId2"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234:56789//billingProfiles/42425/invoiceSections/67890/providers/Microsoft.Consumption/charges/chargeSummaryId2"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindModern),
	// 			Properties: &armconsumption.ModernChargeSummaryProperties{
	// 				AzureCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](5000),
	// 				},
	// 				BillingAccountID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789"),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Billing/billingPeriods/201909"),
	// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425"),
	// 				ChargesBilledSeparately: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](60.9),
	// 				},
	// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/invoiceSections/67890"),
	// 				IsInvoiced: to.Ptr(false),
	// 				MarketplaceCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](100),
	// 				},
	// 				UsageEnd: to.Ptr("2019-09-30"),
	// 				UsageStart: to.Ptr("2019-09-01"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ChargesListByModernBillingProfile.json
func ExampleChargesClient_List_chargesListByBillingProfileModern() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChargesClient().List(ctx, "providers/Microsoft.Billing/BillingAccounts/1234:56789/billingProfiles/2460", &armconsumption.ChargesClientListOptions{StartDate: nil,
		EndDate: nil,
		Filter:  nil,
		Apply:   nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChargesListResult = armconsumption.ChargesListResult{
	// 	Value: []armconsumption.ChargeSummaryClassification{
	// 		&armconsumption.ModernChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId1"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/2460/providers/Microsoft.Consumption/charges/chargeSummaryId1"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindModern),
	// 			Properties: &armconsumption.ModernChargeSummaryProperties{
	// 				AzureCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](0),
	// 				},
	// 				BillingAccountID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789"),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Billing/billingPeriods/201910"),
	// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/2460"),
	// 				ChargesBilledSeparately: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](265.09),
	// 				},
	// 				IsInvoiced: to.Ptr(false),
	// 				MarketplaceCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](0),
	// 				},
	// 				UsageEnd: to.Ptr("2019-10-31"),
	// 				UsageStart: to.Ptr("2021-10-01"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ChargesListByModernBillingProfileGroupByInvoiceSectionId.json
func ExampleChargesClient_List_chargesListByBillingProfileGroupByInvoiceSectionIdModern() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChargesClient().List(ctx, "providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425", &armconsumption.ChargesClientListOptions{StartDate: to.Ptr("2019-09-01"),
		EndDate: to.Ptr("2019-09-30"),
		Filter:  nil,
		Apply:   to.Ptr("groupby((properties/invoiceSectionId))"),
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChargesListResult = armconsumption.ChargesListResult{
	// 	Value: []armconsumption.ChargeSummaryClassification{
	// 		&armconsumption.ModernChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId1"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425/invoiceSections/4567/providers/Microsoft.Consumption/charges/chargeSummaryId1"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindModern),
	// 			Properties: &armconsumption.ModernChargeSummaryProperties{
	// 				AzureCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](5000),
	// 				},
	// 				BillingAccountID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789"),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Billing/billingPeriods/201909"),
	// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425"),
	// 				ChargesBilledSeparately: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](60.9),
	// 				},
	// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/invoiceSections/4567"),
	// 				IsInvoiced: to.Ptr(false),
	// 				MarketplaceCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](100),
	// 				},
	// 				UsageEnd: to.Ptr("2019-09-30"),
	// 				UsageStart: to.Ptr("2019-09-01"),
	// 			},
	// 		},
	// 		&armconsumption.ModernChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId2"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234:56789//billingProfiles/42425/invoiceSections/67890/providers/Microsoft.Consumption/charges/chargeSummaryId2"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindModern),
	// 			Properties: &armconsumption.ModernChargeSummaryProperties{
	// 				AzureCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](5000),
	// 				},
	// 				BillingAccountID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789"),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Billing/billingPeriods/201909"),
	// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425"),
	// 				ChargesBilledSeparately: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](60.9),
	// 				},
	// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/invoiceSections/67890"),
	// 				IsInvoiced: to.Ptr(false),
	// 				MarketplaceCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](100),
	// 				},
	// 				UsageEnd: to.Ptr("2019-09-30"),
	// 				UsageStart: to.Ptr("2019-09-01"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ChargesListByModernBillingProfileInvoiceSection.json
func ExampleChargesClient_List_chargesListByBillingProfileInvoiceSectionModern() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChargesClient().List(ctx, "providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425/invoiceSections/67890", &armconsumption.ChargesClientListOptions{StartDate: to.Ptr("2019-09-01"),
		EndDate: to.Ptr("2019-10-31"),
		Filter:  nil,
		Apply:   nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChargesListResult = armconsumption.ChargesListResult{
	// 	Value: []armconsumption.ChargeSummaryClassification{
	// 		&armconsumption.ModernChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId1"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425/invoiceSections/67890/providers/Microsoft.Consumption/charges/chargeSummaryId1"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindModern),
	// 			Properties: &armconsumption.ModernChargeSummaryProperties{
	// 				AzureCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](5000),
	// 				},
	// 				BillingAccountID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789"),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Billing/billingPeriods/201909"),
	// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425"),
	// 				ChargesBilledSeparately: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](60.9),
	// 				},
	// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425/invoiceSections/4567"),
	// 				IsInvoiced: to.Ptr(false),
	// 				MarketplaceCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](100),
	// 				},
	// 				UsageEnd: to.Ptr("2019-09-30"),
	// 				UsageStart: to.Ptr("2019-09-01"),
	// 			},
	// 		},
	// 		&armconsumption.ModernChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId2"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425/invoiceSections/67890/providers/Microsoft.Consumption/charges/chargeSummaryId2"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindModern),
	// 			Properties: &armconsumption.ModernChargeSummaryProperties{
	// 				AzureCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](5000),
	// 				},
	// 				BillingAccountID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789"),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Billing/billingPeriods/201910"),
	// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425"),
	// 				ChargesBilledSeparately: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](60.9),
	// 				},
	// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/42425/invoiceSections/4567"),
	// 				IsInvoiced: to.Ptr(false),
	// 				MarketplaceCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](100),
	// 				},
	// 				UsageEnd: to.Ptr("2019-10-31"),
	// 				UsageStart: to.Ptr("2021-10-01"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ChargesListByModernCustomer.json
func ExampleChargesClient_List_chargesListByCustomerModern() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChargesClient().List(ctx, "providers/Microsoft.Billing/BillingAccounts/1234:56789/customers/67890", &armconsumption.ChargesClientListOptions{StartDate: nil,
		EndDate: nil,
		Filter:  nil,
		Apply:   nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChargesListResult = armconsumption.ChargesListResult{
	// 	Value: []armconsumption.ChargeSummaryClassification{
	// 		&armconsumption.ModernChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId1"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/customers/67890/providers/Microsoft.Consumption/charges/chargeSummaryId1"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindModern),
	// 			Properties: &armconsumption.ModernChargeSummaryProperties{
	// 				AzureCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](0),
	// 				},
	// 				BillingAccountID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789"),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Billing/billingPeriods/201910"),
	// 				ChargesBilledSeparately: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](265.09),
	// 				},
	// 				IsInvoiced: to.Ptr(false),
	// 				MarketplaceCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](0),
	// 				},
	// 				UsageEnd: to.Ptr("2019-10-31"),
	// 				UsageStart: to.Ptr("2021-10-01"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ChargesListForDepartmentFilterByStartEndDate.json
func ExampleChargesClient_List_chargesListByDepartmentLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChargesClient().List(ctx, "providers/Microsoft.Billing/BillingAccounts/1234/departments/42425", &armconsumption.ChargesClientListOptions{StartDate: nil,
		EndDate: nil,
		Filter:  to.Ptr("usageStart eq '2018-04-01' AND usageEnd eq '2018-05-30'"),
		Apply:   nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChargesListResult = armconsumption.ChargesListResult{
	// 	Value: []armconsumption.ChargeSummaryClassification{
	// 		&armconsumption.LegacyChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId1"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234/departments/42425/providers/Microsoft.Consumption/charges/chargeSummaryId1"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindLegacy),
	// 			Properties: &armconsumption.LegacyChargeSummaryProperties{
	// 				AzureCharges: to.Ptr[float64](5000),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234/providers/Microsoft.Billing/billingPeriods/201804"),
	// 				ChargesBilledSeparately: to.Ptr[float64](60.9),
	// 				Currency: to.Ptr("USD"),
	// 				MarketplaceCharges: to.Ptr[float64](100),
	// 				UsageEnd: to.Ptr("2018-04-30"),
	// 				UsageStart: to.Ptr("2018-04-01"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ChargesListByModernInvoiceSectionId.json
func ExampleChargesClient_List_chargesListByInvoiceSectionIdModern() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChargesClient().List(ctx, "providers/Microsoft.Billing/BillingAccounts/1234:56789/invoiceSections/97531", &armconsumption.ChargesClientListOptions{StartDate: nil,
		EndDate: nil,
		Filter:  nil,
		Apply:   nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChargesListResult = armconsumption.ChargesListResult{
	// 	Value: []armconsumption.ChargeSummaryClassification{
	// 		&armconsumption.ModernChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId1"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/2460/invoiceSections/97531/providers/Microsoft.Consumption/charges/chargeSummaryId1"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindModern),
	// 			Properties: &armconsumption.ModernChargeSummaryProperties{
	// 				AzureCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](12),
	// 				},
	// 				BillingAccountID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789"),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/providers/Microsoft.Billing/billingPeriods/201910"),
	// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/2460"),
	// 				ChargesBilledSeparately: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](0),
	// 				},
	// 				InvoiceSectionID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/1234:56789/billingProfiles/2460/invoiceSections/97531"),
	// 				IsInvoiced: to.Ptr(false),
	// 				MarketplaceCharges: &armconsumption.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float64](0),
	// 				},
	// 				UsageEnd: to.Ptr("2019-10-31"),
	// 				UsageStart: to.Ptr("2021-10-01"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/ChargesListForEnrollmentAccountFilterByStartEndDate.json
func ExampleChargesClient_List_chargesListForEnrollmentAccountLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChargesClient().List(ctx, "providers/Microsoft.Billing/BillingAccounts/1234/enrollmentAccounts/42425", &armconsumption.ChargesClientListOptions{StartDate: nil,
		EndDate: nil,
		Filter:  nil,
		Apply:   nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChargesListResult = armconsumption.ChargesListResult{
	// 	Value: []armconsumption.ChargeSummaryClassification{
	// 		&armconsumption.LegacyChargeSummary{
	// 			Name: to.Ptr("chargeSummaryId1"),
	// 			Type: to.Ptr("Microsoft.Consumption/charges"),
	// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234/enrollmentAccounts/42425/providers/Microsoft.Consumption/charges/chargeSummaryId1"),
	// 			Kind: to.Ptr(armconsumption.ChargeSummaryKindLegacy),
	// 			Properties: &armconsumption.LegacyChargeSummaryProperties{
	// 				AzureCharges: to.Ptr[float64](5000),
	// 				BillingPeriodID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234/providers/Microsoft.Billing/billingPeriods/201804"),
	// 				ChargesBilledSeparately: to.Ptr[float64](60.9),
	// 				Currency: to.Ptr("USD"),
	// 				MarketplaceCharges: to.Ptr[float64](100),
	// 				UsageEnd: to.Ptr("2018-04-30"),
	// 				UsageStart: to.Ptr("2018-04-01"),
	// 			},
	// 	}},
	// }
}
