//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armconsumption_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/consumption/armconsumption"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListByBillingAccount.json
func ExampleUsageDetailsClient_NewListPager_billingAccountUsageDetailsListLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("providers/Microsoft.Billing/BillingAccounts/1234", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("Account Name 1"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				Cost: to.Ptr[float64](0.000295194820065),
		// 				CostCenter: to.Ptr("DEV"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-30T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.000402776395232),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product Name 1"),
		// 				Quantity: to.Ptr[float64](0.7329),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceName: to.Ptr("Resource Name 1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				UnitPrice: to.Ptr[float64](4.38),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListByMCABillingAccount.json
func ExampleUsageDetailsClient_NewListPager_billingAccountUsageDetailsListModern() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("providers/Microsoft.Billing/BillingAccounts/1234:56789", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.ModernUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234:56789/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindModern),
		// 			Properties: &armconsumption.ModernUsageDetailProperties{
		// 				AdditionalInfo: to.Ptr("{  \"UsageType\": \"ComputeHR\",  \"ImageType\": \"Windows Client BYOL\",  \"ServiceType\": \"Standard_D1\",  \"VMName\": null,  \"VMProperties\": null,  \"VCPUs\": 1,  \"CPUs\": 0}"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("1234:56789"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrencyCode: to.Ptr("USD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-10-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("2468"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				CostCenter: to.Ptr("DEV"),
		// 				CostInBillingCurrency: to.Ptr[float64](1.84763819095477),
		// 				CostInPricingCurrency: to.Ptr[float64](1.84763819095477),
		// 				CostInUSD: to.Ptr[float64](1.84763819095477),
		// 				CustomerName: to.Ptr("Modern Azure Customer 1"),
		// 				CustomerTenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-30T00:00:00.000Z"); return t}()),
		// 				ExchangeRate: to.Ptr("1"),
		// 				ExchangeRateDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-10-01T00:00:00.000Z"); return t}()),
		// 				ExchangeRatePricingToBilling: to.Ptr[float64](0.077),
		// 				Frequency: to.Ptr("UsageBased"),
		// 				InstanceName: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				InvoiceID: to.Ptr(""),
		// 				InvoiceSectionID: to.Ptr("98765"),
		// 				InvoiceSectionName: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MarketPrice: to.Ptr[float64](0.077),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				PartnerEarnedCreditApplied: to.Ptr("0"),
		// 				PartnerEarnedCreditRate: to.Ptr[float64](0.077),
		// 				PartnerName: to.Ptr("Partner Name 1"),
		// 				PartnerTenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				PaygCostInBillingCurrency: to.Ptr[float64](1.848),
		// 				PaygCostInUSD: to.Ptr[float64](1.848),
		// 				PreviousInvoiceID: to.Ptr(""),
		// 				PricingCurrencyCode: to.Ptr("USD"),
		// 				Product: to.Ptr("Virtual Machines D Series - D1 - US East"),
		// 				ProductIdentifier: to.Ptr("DZH318Z0BQ4B00FV"),
		// 				ProductOrderID: to.Ptr("a3db7880-70eb-4b4c-6a79-1425a058df5a"),
		// 				ProductOrderName: to.Ptr("Azure plan"),
		// 				PublisherID: to.Ptr(""),
		// 				PublisherName: to.Ptr("Microsoft"),
		// 				PublisherType: to.Ptr("Microsoft"),
		// 				Quantity: to.Ptr[float64](0.7329),
		// 				ResellerMpnID: to.Ptr(""),
		// 				ResellerName: to.Ptr("Reseller Name 1"),
		// 				ReservationID: to.Ptr(""),
		// 				ReservationName: to.Ptr(""),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceLocationNormalized: to.Ptr("US East"),
		// 				ServiceInfo1: to.Ptr(""),
		// 				ServiceInfo2: to.Ptr("Windows Client BYOL"),
		// 				ServicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-01T00:00:00.000Z"); return t}()),
		// 				ServicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-10-01T00:00:00.000Z"); return t}()),
		// 				SubscriptionGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				Term: to.Ptr(""),
		// 				UnitPrice: to.Ptr[float64](4.38),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListForBillingPeriodByBillingAccount.json
func ExampleUsageDetailsClient_NewListPager_billingAccountUsageDetailsListForBillingPeriodLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("providers/Microsoft.Billing/BillingAccounts/1234", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("Account Name 1"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				Cost: to.Ptr[float64](0.000342194841184),
		// 				CostCenter: to.Ptr("DEV"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-30T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.010534556373432),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product Name 1"),
		// 				Quantity: to.Ptr[float64](0.8234),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceName: to.Ptr("Resource Name 1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				UnitPrice: to.Ptr[float64](3.74),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListByMCABillingProfile.json
func ExampleUsageDetailsClient_NewListPager_billingProfileUsageDetailsListModern() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("providers/Microsoft.Billing/BillingAccounts/1234:56789/billingProfiles/2468", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.ModernUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234:56789/billingProfiles/2468/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindModern),
		// 			Properties: &armconsumption.ModernUsageDetailProperties{
		// 				AdditionalInfo: to.Ptr("{  \"UsageType\": \"ComputeHR\",  \"ImageType\": \"Windows Client BYOL\",  \"ServiceType\": \"Standard_D1\",  \"VMName\": null,  \"VMProperties\": null,  \"VCPUs\": 1,  \"CPUs\": 0}"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("1234:56789"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrencyCode: to.Ptr("USD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-10-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("2468"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				CostCenter: to.Ptr("DEV"),
		// 				CostInBillingCurrency: to.Ptr[float64](1.84763819095477),
		// 				CostInPricingCurrency: to.Ptr[float64](1.84763819095477),
		// 				CostInUSD: to.Ptr[float64](1.84763819095477),
		// 				CustomerName: to.Ptr("Modern Azure Customer 1"),
		// 				CustomerTenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-30T00:00:00.000Z"); return t}()),
		// 				ExchangeRate: to.Ptr("1"),
		// 				ExchangeRateDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-10-01T00:00:00.000Z"); return t}()),
		// 				ExchangeRatePricingToBilling: to.Ptr[float64](0.077),
		// 				Frequency: to.Ptr("UsageBased"),
		// 				InstanceName: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				InvoiceID: to.Ptr(""),
		// 				InvoiceSectionID: to.Ptr("98765"),
		// 				InvoiceSectionName: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MarketPrice: to.Ptr[float64](0.077),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				PartnerEarnedCreditApplied: to.Ptr("0"),
		// 				PartnerEarnedCreditRate: to.Ptr[float64](0.077),
		// 				PartnerName: to.Ptr("Partner Name 1"),
		// 				PartnerTenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				PaygCostInBillingCurrency: to.Ptr[float64](1.848),
		// 				PaygCostInUSD: to.Ptr[float64](1.848),
		// 				PreviousInvoiceID: to.Ptr(""),
		// 				PricingCurrencyCode: to.Ptr("USD"),
		// 				Product: to.Ptr("Virtual Machines D Series - D1 - US East"),
		// 				ProductIdentifier: to.Ptr("DZH318Z0BQ4B00FV"),
		// 				ProductOrderID: to.Ptr("a3db7880-70eb-4b4c-6a79-1425a058df5a"),
		// 				ProductOrderName: to.Ptr("Azure plan"),
		// 				PublisherID: to.Ptr(""),
		// 				PublisherName: to.Ptr("Microsoft"),
		// 				PublisherType: to.Ptr("Microsoft"),
		// 				Quantity: to.Ptr[float64](0.7329),
		// 				ResellerMpnID: to.Ptr(""),
		// 				ResellerName: to.Ptr("Reseller Name 1"),
		// 				ReservationID: to.Ptr(""),
		// 				ReservationName: to.Ptr(""),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceLocationNormalized: to.Ptr("US East"),
		// 				ServiceInfo1: to.Ptr(""),
		// 				ServiceInfo2: to.Ptr("Windows Client BYOL"),
		// 				ServicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-01T00:00:00.000Z"); return t}()),
		// 				ServicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-10-01T00:00:00.000Z"); return t}()),
		// 				SubscriptionGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				Term: to.Ptr(""),
		// 				UnitPrice: to.Ptr[float64](4.38),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListByMCACustomer.json
func ExampleUsageDetailsClient_NewListPager_customerUsageDetailsListModern() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("providers/Microsoft.Billing/BillingAccounts/1234:56789/customers/00000000-0000-0000-0000-000000000000", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.ModernUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234:56789/customers/00000000-0000-0000-0000-000000000000/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindModern),
		// 			Properties: &armconsumption.ModernUsageDetailProperties{
		// 				AdditionalInfo: to.Ptr("{  \"UsageType\": \"ComputeHR\",  \"ImageType\": \"Windows Client BYOL\",  \"ServiceType\": \"Standard_D1\",  \"VMName\": null,  \"VMProperties\": null,  \"VCPUs\": 1,  \"CPUs\": 0}"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("1234:56789"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrencyCode: to.Ptr("USD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-10-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("2468"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				CostCenter: to.Ptr("DEV"),
		// 				CostInBillingCurrency: to.Ptr[float64](1.84763819095477),
		// 				CostInPricingCurrency: to.Ptr[float64](1.84763819095477),
		// 				CostInUSD: to.Ptr[float64](1.84763819095477),
		// 				CustomerName: to.Ptr("Modern Azure Customer 1"),
		// 				CustomerTenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-30T00:00:00.000Z"); return t}()),
		// 				ExchangeRate: to.Ptr("1"),
		// 				ExchangeRateDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-10-01T00:00:00.000Z"); return t}()),
		// 				ExchangeRatePricingToBilling: to.Ptr[float64](0.077),
		// 				Frequency: to.Ptr("UsageBased"),
		// 				InstanceName: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				InvoiceID: to.Ptr(""),
		// 				InvoiceSectionID: to.Ptr("98765"),
		// 				InvoiceSectionName: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MarketPrice: to.Ptr[float64](0.077),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				PartnerEarnedCreditApplied: to.Ptr("0"),
		// 				PartnerEarnedCreditRate: to.Ptr[float64](0.077),
		// 				PartnerName: to.Ptr("Partner Name 1"),
		// 				PartnerTenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				PaygCostInBillingCurrency: to.Ptr[float64](1.848),
		// 				PaygCostInUSD: to.Ptr[float64](1.848),
		// 				PreviousInvoiceID: to.Ptr(""),
		// 				PricingCurrencyCode: to.Ptr("USD"),
		// 				Product: to.Ptr("Virtual Machines D Series - D1 - US East"),
		// 				ProductIdentifier: to.Ptr("DZH318Z0BQ4B00FV"),
		// 				ProductOrderID: to.Ptr("a3db7880-70eb-4b4c-6a79-1425a058df5a"),
		// 				ProductOrderName: to.Ptr("Azure plan"),
		// 				PublisherID: to.Ptr(""),
		// 				PublisherName: to.Ptr("Microsoft"),
		// 				PublisherType: to.Ptr("Microsoft"),
		// 				Quantity: to.Ptr[float64](0.7329),
		// 				ResellerMpnID: to.Ptr(""),
		// 				ResellerName: to.Ptr("Reseller Name 1"),
		// 				ReservationID: to.Ptr(""),
		// 				ReservationName: to.Ptr(""),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceLocationNormalized: to.Ptr("US East"),
		// 				ServiceInfo1: to.Ptr(""),
		// 				ServiceInfo2: to.Ptr("Windows Client BYOL"),
		// 				ServicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-01T00:00:00.000Z"); return t}()),
		// 				ServicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-10-01T00:00:00.000Z"); return t}()),
		// 				SubscriptionGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				Term: to.Ptr(""),
		// 				UnitPrice: to.Ptr[float64](4.38),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListByDepartment.json
func ExampleUsageDetailsClient_NewListPager_departmentUsageDetailsListLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("providers/Microsoft.Billing/Departments/1234", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/Departments/1234/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("Account Name 1"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				Cost: to.Ptr[float64](0.000295194820065),
		// 				CostCenter: to.Ptr("DEV"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-30T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.000402776395232),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product Name 1"),
		// 				Quantity: to.Ptr[float64](0.7329),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceName: to.Ptr("Resource Name 1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				UnitPrice: to.Ptr[float64](4.38),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListForBillingPeriodByDepartment.json
func ExampleUsageDetailsClient_NewListPager_departmentUsageDetailsListForBillingPeriodLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("providers/Microsoft.Billing/Departments/1234", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/Departments/1234/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("Account Name 1"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				Cost: to.Ptr[float64](0.000342194841184),
		// 				CostCenter: to.Ptr("DEV"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-30T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.010534556373432),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product Name 1"),
		// 				Quantity: to.Ptr[float64](0.8234),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceName: to.Ptr("Resource Name 1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				UnitPrice: to.Ptr[float64](3.74),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListByEnrollmentAccount.json
func ExampleUsageDetailsClient_NewListPager_enrollmentAccountUsageDetailsListLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("providers/Microsoft.Billing/EnrollmentAccounts/1234", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/EnrollmentAccounts/1234/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("Account Name 1"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				Cost: to.Ptr[float64](0.000295194820065),
		// 				CostCenter: to.Ptr("DEV"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-30T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.000402776395232),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product Name 1"),
		// 				Quantity: to.Ptr[float64](0.7329),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceName: to.Ptr("Resource Name 1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				UnitPrice: to.Ptr[float64](4.38),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListForBillingPeriodByEnrollmentAccount.json
func ExampleUsageDetailsClient_NewListPager_enrollmentAccountUsageDetailsListForBillingPeriodLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("providers/Microsoft.Billing/EnrollmentAccounts/1234", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/EnrollmentAccounts/1234/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("Account Name 1"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				Cost: to.Ptr[float64](0.000342194841184),
		// 				CostCenter: to.Ptr("DEV"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-30T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.010534556373432),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product Name 1"),
		// 				Quantity: to.Ptr[float64](0.8234),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceName: to.Ptr("Resource Name 1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				UnitPrice: to.Ptr[float64](3.74),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListByMCAInvoiceSection.json
func ExampleUsageDetailsClient_NewListPager_invoiceSectionUsageDetailsListModern() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("providers/Microsoft.Billing/BillingAccounts/1234:56789/invoiceSections/98765", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.ModernUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/BillingAccounts/1234:56789/invoiceSections/98765/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindModern),
		// 			Properties: &armconsumption.ModernUsageDetailProperties{
		// 				AdditionalInfo: to.Ptr("{  \"UsageType\": \"ComputeHR\",  \"ImageType\": \"Windows Client BYOL\",  \"ServiceType\": \"Standard_D1\",  \"VMName\": null,  \"VMProperties\": null,  \"VCPUs\": 1,  \"CPUs\": 0}"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("1234:56789"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrencyCode: to.Ptr("USD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-10-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("2468"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				CostCenter: to.Ptr("DEV"),
		// 				CostInBillingCurrency: to.Ptr[float64](1.84763819095477),
		// 				CostInPricingCurrency: to.Ptr[float64](1.84763819095477),
		// 				CostInUSD: to.Ptr[float64](1.84763819095477),
		// 				CustomerName: to.Ptr("Modern Azure Customer 1"),
		// 				CustomerTenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-30T00:00:00.000Z"); return t}()),
		// 				ExchangeRate: to.Ptr("1"),
		// 				ExchangeRateDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-10-01T00:00:00.000Z"); return t}()),
		// 				ExchangeRatePricingToBilling: to.Ptr[float64](0.077),
		// 				Frequency: to.Ptr("UsageBased"),
		// 				InstanceName: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				InvoiceID: to.Ptr(""),
		// 				InvoiceSectionID: to.Ptr("98765"),
		// 				InvoiceSectionName: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MarketPrice: to.Ptr[float64](0.077),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				PartnerEarnedCreditApplied: to.Ptr("0"),
		// 				PartnerEarnedCreditRate: to.Ptr[float64](0.077),
		// 				PartnerName: to.Ptr("Partner Name 1"),
		// 				PartnerTenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				PaygCostInBillingCurrency: to.Ptr[float64](1.848),
		// 				PaygCostInUSD: to.Ptr[float64](1.848),
		// 				PreviousInvoiceID: to.Ptr(""),
		// 				PricingCurrencyCode: to.Ptr("USD"),
		// 				Product: to.Ptr("Virtual Machines D Series - D1 - US East"),
		// 				ProductIdentifier: to.Ptr("DZH318Z0BQ4B00FV"),
		// 				ProductOrderID: to.Ptr("a3db7880-70eb-4b4c-6a79-1425a058df5a"),
		// 				ProductOrderName: to.Ptr("Azure plan"),
		// 				PublisherID: to.Ptr(""),
		// 				PublisherName: to.Ptr("Microsoft"),
		// 				PublisherType: to.Ptr("Microsoft"),
		// 				Quantity: to.Ptr[float64](0.7329),
		// 				ResellerMpnID: to.Ptr(""),
		// 				ResellerName: to.Ptr("Reseller Name 1"),
		// 				ReservationID: to.Ptr(""),
		// 				ReservationName: to.Ptr(""),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceLocationNormalized: to.Ptr("US East"),
		// 				ServiceInfo1: to.Ptr(""),
		// 				ServiceInfo2: to.Ptr("Windows Client BYOL"),
		// 				ServicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-01T00:00:00.000Z"); return t}()),
		// 				ServicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-10-01T00:00:00.000Z"); return t}()),
		// 				SubscriptionGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				Term: to.Ptr(""),
		// 				UnitPrice: to.Ptr[float64](4.38),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListByManagementGroup.json
func ExampleUsageDetailsClient_NewListPager_managementGroupUsageDetailsListLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("Account Name 1"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				Cost: to.Ptr[float64](0.000342194841184),
		// 				CostCenter: to.Ptr("DEV"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-30T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.010534556373432),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product Name 1"),
		// 				Quantity: to.Ptr[float64](0.8234),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceName: to.Ptr("Resource Name 1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				UnitPrice: to.Ptr[float64](3.74),
		// 			},
		// 		},
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id2"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/scope/providers/Microsoft.Billing/billingPeriods/20180801/providers/Microsoft.Consumption/usageDetails/usageDetails_Id2"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("Account Name 1"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Account Name 2"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Account Name 2"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				Cost: to.Ptr[float64](0.000295194820065),
		// 				CostCenter: to.Ptr("DEV"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-30T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.000402776395232),
		// 				InvoiceSection: to.Ptr("Invoice Section 2"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("11111111-1111-1111-1111-111111111111"),
		// 				OfferID: to.Ptr("Offer Id 2"),
		// 				PartNumber: to.Ptr("Part Number 2"),
		// 				Product: to.Ptr("Product Name 2"),
		// 				Quantity: to.Ptr[float64](0.7329),
		// 				ResourceGroup: to.Ptr("Resource Group 2"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 2/providers/Microsoft.Storage/storageAccounts/Resource Name 2"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceName: to.Ptr("Resource Name 2"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				UnitPrice: to.Ptr[float64](4.38),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListForBillingPeriodByManagementGroup.json
func ExampleUsageDetailsClient_NewListPager_managementGroupUsageDetailsListForBillingPeriodLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("Account Name 1"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				Cost: to.Ptr[float64](0.000342194841184),
		// 				CostCenter: to.Ptr("DEV"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-30T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.010534556373432),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product Name 1"),
		// 				Quantity: to.Ptr[float64](0.8234),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceName: to.Ptr("Resource Name 1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				UnitPrice: to.Ptr[float64](3.74),
		// 			},
		// 		},
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id2"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/scope/providers/Microsoft.Billing/billingPeriods/billingPeriodName/providers/Microsoft.Consumption/usageDetails/usageDetails_Id2"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("Account Name 2"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Account Name 2"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Account Name 2"),
		// 				ChargeType: to.Ptr("UnusedReservation"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				Cost: to.Ptr[float64](0.000821821271948),
		// 				CostCenter: to.Ptr("DEV"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-30T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.073488920944598),
		// 				InvoiceSection: to.Ptr("Invoice Section 2"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("11111111-1111-1111-1111-111111111111"),
		// 				OfferID: to.Ptr("Offer Id 2"),
		// 				PartNumber: to.Ptr("Part Number 2"),
		// 				Product: to.Ptr("Product Name 2"),
		// 				Quantity: to.Ptr[float64](0.4759),
		// 				ResourceGroup: to.Ptr("Resource Group 2"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 2/providers/Microsoft.Storage/storageAccounts/Resource Name 2"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceName: to.Ptr("Resource Name 2"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 2"),
		// 				UnitPrice: to.Ptr[float64](5.74),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsExpand.json
func ExampleUsageDetailsClient_NewListPager_usageDetailsExpandLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000", &armconsumption.UsageDetailsClientListOptions{Expand: to.Ptr("meterDetails,additionalInfo"),
		Filter:    to.Ptr("tags eq 'dev:tools'"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](1),
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("Account Name 1"),
		// 				AdditionalInfo: to.Ptr("{\"MyType\":\"\",\"ServiceType\":\"\",\"VMName\":\"\",\"UsageType\":\"MyUsage\"}"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				Cost: to.Ptr[float64](0.000342194841184),
		// 				CostCenter: to.Ptr("DEV"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-30T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.010464556322455),
		// 				Frequency: to.Ptr("UsageBased"),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterDetails: &armconsumption.MeterDetailsResponse{
		// 					MeterCategory: to.Ptr("Networking"),
		// 					MeterName: to.Ptr("Data Transfer Out (GB)"),
		// 					MeterSubCategory: to.Ptr("ExpressRoute"),
		// 					ServiceFamily: to.Ptr("Compute"),
		// 					UnitOfMeasure: to.Ptr("GB"),
		// 				},
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product Name 1"),
		// 				Quantity: to.Ptr[float64](0.8234),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceName: to.Ptr("Resource Name 1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				UnitPrice: to.Ptr[float64](3.54),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsList.json
func ExampleUsageDetailsClient_NewListPager_usageDetailsListLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("AccountName"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Customer Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-30T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Customer Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.ClassicStorage"),
		// 				Cost: to.Ptr[float64](0.000001980949998),
		// 				CostCenter: to.Ptr("BAS"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-09T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.054693034210767),
		// 				Frequency: to.Ptr("UsageBased"),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product1"),
		// 				Quantity: to.Ptr[float64](0.000036),
		// 				ResourceGroup: to.Ptr("Resource-Group-westus"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource-Group-westus/providers/Microsoft.ClassicStorage/storageAccounts/ResourceName1"),
		// 				ResourceLocation: to.Ptr("uswest"),
		// 				ResourceName: to.Ptr("ResourceName1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("SubscriptionName 1"),
		// 				UnitPrice: to.Ptr[float64](5.47),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListByMetricActualCost.json
func ExampleUsageDetailsClient_NewListPager_usageDetailsListByMetricActualCostLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    to.Ptr(armconsumption.MetrictypeActualCostMetricType),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("AccountName"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Customer Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-30T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Customer Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.ClassicStorage"),
		// 				Cost: to.Ptr[float64](0.000001968949998),
		// 				CostCenter: to.Ptr("BAS"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-09T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.054693055510767),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product1"),
		// 				Quantity: to.Ptr[float64](0.000036),
		// 				ResourceGroup: to.Ptr("Resource-Group-westus"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource-Group-westus/providers/Microsoft.ClassicStorage/storageAccounts/ResourceName1"),
		// 				ResourceLocation: to.Ptr("uswest"),
		// 				ResourceName: to.Ptr("ResourceName1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("SubscriptionName 1"),
		// 				UnitPrice: to.Ptr[float64](5.47),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListByMetricAmortizedCost.json
func ExampleUsageDetailsClient_NewListPager_usageDetailsListByMetricAmortizedCostLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    to.Ptr(armconsumption.MetrictypeAmortizedCostMetricType),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("AccountName"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Customer Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-30T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Customer Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.ClassicStorage"),
		// 				Cost: to.Ptr[float64](0.000001968949998),
		// 				CostCenter: to.Ptr("BAS"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-09T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.054693055510767),
		// 				Frequency: to.Ptr("UsageBased"),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product1"),
		// 				Quantity: to.Ptr[float64](0.000036),
		// 				ResourceGroup: to.Ptr("Resource-Group-westus"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource-Group-westus/providers/Microsoft.ClassicStorage/storageAccounts/ResourceName1"),
		// 				ResourceLocation: to.Ptr("uswest"),
		// 				ResourceName: to.Ptr("ResourceName1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("SubscriptionName 1"),
		// 				UnitPrice: to.Ptr[float64](5.47),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListByMetricUsage.json
func ExampleUsageDetailsClient_NewListPager_usageDetailsListByMetricUsageLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    to.Ptr(armconsumption.MetrictypeUsageMetricType),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("AccountName"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Customer Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-30T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Customer Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.ClassicStorage"),
		// 				Cost: to.Ptr[float64](0.000001968949998),
		// 				CostCenter: to.Ptr("BAS"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-09T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.054693055510767),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product1"),
		// 				Quantity: to.Ptr[float64](0.000036),
		// 				ResourceGroup: to.Ptr("Resource-Group-westus"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource-Group-westus/providers/Microsoft.ClassicStorage/storageAccounts/ResourceName1"),
		// 				ResourceLocation: to.Ptr("uswest"),
		// 				ResourceName: to.Ptr("ResourceName1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("SubscriptionName 1"),
		// 				UnitPrice: to.Ptr[float64](5.47),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListFilterByTag.json
func ExampleUsageDetailsClient_NewListPager_usageDetailsListFilterByTagLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    to.Ptr("tags eq 'dev:tools'"),
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("Account Name 1"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				Cost: to.Ptr[float64](0.000342194841184),
		// 				CostCenter: to.Ptr("DEV"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-30T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.010534556373432),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product Name 1"),
		// 				Quantity: to.Ptr[float64](0.8234),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceName: to.Ptr("Resource Name 1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				UnitPrice: to.Ptr[float64](3.74),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/consumption/resource-manager/Microsoft.Consumption/stable/2021-10-01/examples/UsageDetailsListForBillingPeriod.json
func ExampleUsageDetailsClient_NewListPager_usageDetailsListForBillingPeriodLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armconsumption.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsageDetailsClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000", &armconsumption.UsageDetailsClientListOptions{Expand: nil,
		Filter:    nil,
		Skiptoken: nil,
		Top:       nil,
		Metric:    nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageDetailsListResult = armconsumption.UsageDetailsListResult{
		// 	Value: []armconsumption.UsageDetailClassification{
		// 		&armconsumption.LegacyUsageDetail{
		// 			Name: to.Ptr("usageDetails_Id1"),
		// 			Type: to.Ptr("Microsoft.Consumption/usageDetails"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Billing/billingPeriods/201903/providers/Microsoft.Consumption/usageDetails/usageDetails_Id1"),
		// 			Tags: map[string]*string{
		// 				"dev": to.Ptr("tools"),
		// 				"env": to.Ptr("newcrp"),
		// 			},
		// 			Kind: to.Ptr(armconsumption.UsageDetailsKindLegacy),
		// 			Properties: &armconsumption.LegacyUsageDetailProperties{
		// 				AccountName: to.Ptr("Account Name 1"),
		// 				BenefitID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				BenefitName: to.Ptr("Reservation_purchase_03-09-2018_10-59"),
		// 				BillingAccountID: to.Ptr("xxxxxxxx"),
		// 				BillingAccountName: to.Ptr("Account Name 1"),
		// 				BillingCurrency: to.Ptr("CAD"),
		// 				BillingPeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-31T00:00:00.000Z"); return t}()),
		// 				BillingPeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
		// 				BillingProfileID: to.Ptr("xxxxxxxx"),
		// 				BillingProfileName: to.Ptr("Account Name 1"),
		// 				ChargeType: to.Ptr("Usage"),
		// 				ConsumedService: to.Ptr("Microsoft.Storage"),
		// 				Cost: to.Ptr[float64](0.000342194841184),
		// 				CostCenter: to.Ptr("DEV"),
		// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-30T00:00:00.000Z"); return t}()),
		// 				EffectivePrice: to.Ptr[float64](0.010534556373432),
		// 				InvoiceSection: to.Ptr("Invoice Section 1"),
		// 				IsAzureCreditEligible: to.Ptr(false),
		// 				MeterID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				OfferID: to.Ptr("Offer Id 1"),
		// 				PartNumber: to.Ptr("Part Number 1"),
		// 				Product: to.Ptr("Product Name 1"),
		// 				Quantity: to.Ptr[float64](0.8234),
		// 				ResourceGroup: to.Ptr("Resource Group 1"),
		// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/Resource Group 1/providers/Microsoft.Storage/storageAccounts/Resource Name 1"),
		// 				ResourceLocation: to.Ptr("USEast"),
		// 				ResourceName: to.Ptr("Resource Name 1"),
		// 				SubscriptionID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				SubscriptionName: to.Ptr("Subscription Name 1"),
		// 				UnitPrice: to.Ptr[float64](3.74),
		// 			},
		// 	}},
		// }
	}
}
