//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armfrontdoor

import "time"

// AzureAsyncOperationResult - The response body contains the status of the specified asynchronous operation, indicating whether
// it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP
// status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response
// body includes the HTTP status code for the successful request. If the
// asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information
// regarding the failure.
type AzureAsyncOperationResult struct {
	Error *Error

	// Status of the Azure async operation.
	Status *NetworkOperationStatus
}

// Backend address of a frontDoor load balancer.
type Backend struct {
	// Location of the backend (IP address or FQDN)
	Address *string

	// The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
	BackendHostHeader *string

	// Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *BackendEnabledState

	// The HTTP TCP port number. Must be between 1 and 65535.
	HTTPPort *int32

	// The HTTPS TCP port number. Must be between 1 and 65535.
	HTTPSPort *int32

	// Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend
	// is healthy.
	Priority *int32

	// The Alias of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
	PrivateLinkAlias *string

	// A custom message to be included in the approval request to connect to the Private Link
	PrivateLinkApprovalMessage *string

	// The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
	PrivateLinkLocation *string

	// The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
	PrivateLinkResourceID *string

	// Weight of this endpoint for load balancing purposes.
	Weight *int32

	// READ-ONLY; The Approval status for the connection to the Private Link
	PrivateEndpointStatus *PrivateEndpointStatus
}

// BackendPool - A backend pool is a collection of backends that can be routed to.
type BackendPool struct {
	// Resource ID.
	ID *string

	// Resource name.
	Name *string

	// Properties of the Front Door Backend Pool
	Properties *BackendPoolProperties

	// READ-ONLY; Resource type.
	Type *string
}

// BackendPoolListResult - Result of the request to list Backend Pools. It contains a list of Backend Pools objects and a
// URL link to get the next set of results.
type BackendPoolListResult struct {
	// URL to get the next set of BackendPool objects if there are any.
	NextLink *string

	// READ-ONLY; List of Backend Pools within a Front Door.
	Value []*BackendPool
}

// BackendPoolProperties - The JSON object that contains the properties required to create a Backend Pool.
type BackendPoolProperties struct {
	// The set of backends for this pool
	Backends []*Backend

	// L7 health probe settings for a backend pool
	HealthProbeSettings *SubResource

	// Load balancing settings for a backend pool
	LoadBalancingSettings *SubResource

	// READ-ONLY; Resource status.
	ResourceState *FrontDoorResourceState
}

// BackendPoolUpdateParameters - A collection of backends that can be routed to.
type BackendPoolUpdateParameters struct {
	// The set of backends for this pool
	Backends []*Backend

	// L7 health probe settings for a backend pool
	HealthProbeSettings *SubResource

	// Load balancing settings for a backend pool
	LoadBalancingSettings *SubResource
}

// BackendPoolsSettings - Settings that apply to all backend pools.
type BackendPoolsSettings struct {
	// Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
	EnforceCertificateNameCheck *EnforceCertificateNameCheckEnabledState

	// Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
	SendRecvTimeoutSeconds *int32
}

// CacheConfiguration - Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration
// object.
type CacheConfiguration struct {
	// The duration for which the content needs to be cached. Allowed format is in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).
	// HTTP requires the value to be no more than a year
	CacheDuration *string

	// Whether to use dynamic compression for cached content
	DynamicCompression *DynamicCompressionEnabled

	// Treatment of URL query terms when forming the cache key.
	QueryParameterStripDirective *FrontDoorQuery

	// query parameters to include or exclude (comma separated).
	QueryParameters *string
}

// CertificateSourceParameters - Parameters required for enabling SSL with Front Door-managed certificates
type CertificateSourceParameters struct {
	// Defines the type of the certificate used for secure connections to a frontendEndpoint
	CertificateType *FrontDoorCertificateType
}

// CheckNameAvailabilityInput - Input of CheckNameAvailability API.
type CheckNameAvailabilityInput struct {
	// REQUIRED; The resource name to validate.
	Name *string

	// REQUIRED; The type of the resource whose name is to be validated.
	Type *ResourceType
}

// CheckNameAvailabilityOutput - Output of check name availability API.
type CheckNameAvailabilityOutput struct {
	// READ-ONLY; The detailed error message describing why the name is not available.
	Message *string

	// READ-ONLY; Indicates whether the name is available.
	NameAvailability *Availability

	// READ-ONLY; The reason why the name is not available.
	Reason *string
}

// CustomHTTPSConfiguration - Https settings for a domain
type CustomHTTPSConfiguration struct {
	// REQUIRED; Defines the source of the SSL certificate
	CertificateSource *FrontDoorCertificateSource

	// REQUIRED; The minimum TLS version required from the clients to establish an SSL handshake with Front Door.
	MinimumTLSVersion *MinimumTLSVersion

	// REQUIRED; Defines the TLS extension protocol that is used for secure delivery
	ProtocolType *FrontDoorTLSProtocolType

	// Parameters required for enabling SSL with Front Door-managed certificates (if certificateSource=FrontDoor)
	FrontDoorCertificateSourceParameters *CertificateSourceParameters

	// KeyVault certificate source parameters (if certificateSource=AzureKeyVault)
	KeyVaultCertificateSourceParameters *KeyVaultCertificateSourceParameters
}

// CustomRule - Defines contents of a web application rule
type CustomRule struct {
	// REQUIRED; Describes what action to be applied when rule matches.
	Action *ActionType

	// REQUIRED; List of match conditions.
	MatchConditions []*MatchCondition

	// REQUIRED; Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
	Priority *int32

	// REQUIRED; Describes type of rule.
	RuleType *RuleType

	// Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
	EnabledState *CustomRuleEnabledState

	// Describes the name of the rule.
	Name *string

	// Time window for resetting the rate limit count. Default is 1 minute.
	RateLimitDurationInMinutes *int32

	// Number of allowed requests per client within the time window.
	RateLimitThreshold *int32
}

// CustomRuleList - Defines contents of custom rules
type CustomRuleList struct {
	// List of rules
	Rules []*CustomRule
}

// DefaultErrorResponse - Error response indicates Front Door service is not able to process the incoming request. The reason
// is provided in the error message.
type DefaultErrorResponse struct {
	// Error model.
	Error *DefaultErrorResponseError
}

// DefaultErrorResponseError - Error model.
type DefaultErrorResponseError struct {
	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string
}

// Endpoint - Defines the endpoint properties
type Endpoint struct {
	// The endpoint URL
	Endpoint *string

	// The name of the endpoint
	Name *string
}

type Error struct {
	Code       *string
	Details    []*ErrorDetails
	InnerError *string
	Message    *string
	Target     *string
}

type ErrorDetails struct {
	Code    *string
	Message *string
	Target  *string
}

// ErrorResponse - Error response indicates Front Door service is not able to process the incoming request. The reason is
// provided in the error message.
type ErrorResponse struct {
	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string
}

// Experiment - Defines the properties of an Experiment
type Experiment struct {
	// Resource location.
	Location *string

	// The properties of an Experiment
	Properties *ExperimentProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ExperimentList - Defines a list of Experiments. It contains a list of Experiment objects and a URL link to get the next
// set of results.
type ExperimentList struct {
	// URL to get the next set of Experiment objects if there are any.
	NextLink *string

	// READ-ONLY; List of Experiments within a resource group.
	Value []*Experiment
}

// ExperimentProperties - Defines the properties of an experiment
type ExperimentProperties struct {
	// The description of the details or intents of the Experiment
	Description *string

	// The state of the Experiment
	EnabledState *State

	// The endpoint A of an experiment
	EndpointA *Endpoint

	// The endpoint B of an experiment
	EndpointB *Endpoint

	// READ-ONLY; Resource status.
	ResourceState *NetworkExperimentResourceState

	// READ-ONLY; The uri to the Script used in the Experiment
	ScriptFileURI *string

	// READ-ONLY; The description of Experiment status from the server side
	Status *string
}

// ExperimentUpdateModel - Defines modifiable attributes of an Experiment
type ExperimentUpdateModel struct {
	// The properties of a Profile
	Properties *ExperimentUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// ExperimentUpdateProperties - Defines the properties of an experiment
type ExperimentUpdateProperties struct {
	// The description of the intent or details of the Experiment
	Description *string

	// The state of the Experiment
	EnabledState *State
}

// ForwardingConfiguration - Describes Forwarding Route.
type ForwardingConfiguration struct {
	// REQUIRED
	ODataType *string

	// A reference to the BackendPool which this rule routes to.
	BackendPool *SubResource

	// The caching configuration associated with this rule.
	CacheConfiguration *CacheConfiguration

	// A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
	CustomForwardingPath *string

	// Protocol this rule will use when forwarding traffic to backends.
	ForwardingProtocol *FrontDoorForwardingProtocol
}

// GetRouteConfiguration implements the RouteConfigurationClassification interface for type ForwardingConfiguration.
func (f *ForwardingConfiguration) GetRouteConfiguration() *RouteConfiguration {
	return &RouteConfiguration{
		ODataType: f.ODataType,
	}
}

// FrontDoor - Front Door represents a collection of backend endpoints to route traffic to along with rules that specify how
// traffic is sent there.
type FrontDoor struct {
	// Resource location.
	Location *string

	// Properties of the Front Door Load Balancer
	Properties *Properties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// FrontendEndpoint - A frontend endpoint used for routing.
type FrontendEndpoint struct {
	// Resource ID.
	ID *string

	// Resource name.
	Name *string

	// Properties of the Frontend endpoint
	Properties *FrontendEndpointProperties

	// READ-ONLY; Resource type.
	Type *string
}

// FrontendEndpointLink - Defines the Resource ID for a Frontend Endpoint.
type FrontendEndpointLink struct {
	// Resource ID.
	ID *string
}

// FrontendEndpointProperties - The JSON object that contains the properties required to create a frontend endpoint.
type FrontendEndpointProperties struct {
	// The host name of the frontendEndpoint. Must be a domain name.
	HostName *string

	// Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
	SessionAffinityEnabledState *SessionAffinityEnabledState

	// UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
	SessionAffinityTTLSeconds *int32

	// Defines the Web Application Firewall policy for each host (if applicable)
	WebApplicationFirewallPolicyLink *FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink

	// READ-ONLY; The configuration specifying how to enable HTTPS
	CustomHTTPSConfiguration *CustomHTTPSConfiguration

	// READ-ONLY; Provisioning status of Custom Https of the frontendEndpoint.
	CustomHTTPSProvisioningState *CustomHTTPSProvisioningState

	// READ-ONLY; Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step.
	CustomHTTPSProvisioningSubstate *CustomHTTPSProvisioningSubstate

	// READ-ONLY; Resource status.
	ResourceState *FrontDoorResourceState
}

// FrontendEndpointUpdateParameters - Frontend endpoint used in routing rule
type FrontendEndpointUpdateParameters struct {
	// The host name of the frontendEndpoint. Must be a domain name.
	HostName *string

	// Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
	SessionAffinityEnabledState *SessionAffinityEnabledState

	// UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
	SessionAffinityTTLSeconds *int32

	// Defines the Web Application Firewall policy for each host (if applicable)
	WebApplicationFirewallPolicyLink *FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink
}

// FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink - Defines the Web Application Firewall policy for each
// host (if applicable)
type FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink struct {
	// Resource ID.
	ID *string
}

// FrontendEndpointsListResult - Result of the request to list frontend endpoints. It contains a list of Frontend endpoint
// objects and a URL link to get the next set of results.
type FrontendEndpointsListResult struct {
	// URL to get the next set of frontend endpoints if there are any.
	NextLink *string

	// READ-ONLY; List of Frontend endpoints within a Front Door.
	Value []*FrontendEndpoint
}

// HeaderAction - An action that can manipulate an http header.
type HeaderAction struct {
	// REQUIRED; Which type of manipulation to apply to the header.
	HeaderActionType *HeaderActionType

	// REQUIRED; The name of the header this action will apply to.
	HeaderName *string

	// The value to update the given header name with. This value is not used if the actionType is Delete.
	Value *string
}

// HealthProbeSettingsListResult - Result of the request to list HealthProbeSettings. It contains a list of HealthProbeSettings
// objects and a URL link to get the next set of results.
type HealthProbeSettingsListResult struct {
	// URL to get the next set of HealthProbeSettings objects if there are any.
	NextLink *string

	// READ-ONLY; List of HealthProbeSettings within a Front Door.
	Value []*HealthProbeSettingsModel
}

// HealthProbeSettingsModel - Load balancing settings for a backend pool
type HealthProbeSettingsModel struct {
	// Resource ID.
	ID *string

	// Resource name.
	Name *string

	// Properties of the health probe settings
	Properties *HealthProbeSettingsProperties

	// READ-ONLY; Resource type.
	Type *string
}

// HealthProbeSettingsProperties - The JSON object that contains the properties required to create a health probe settings.
type HealthProbeSettingsProperties struct {
	// Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled
	// if there is a single enabled backend in single enabled backend pool.
	EnabledState *HealthProbeEnabled

	// Configures which HTTP method to use to probe the backends defined under backendPools.
	HealthProbeMethod *FrontDoorHealthProbeMethod

	// The number of seconds between health probes.
	IntervalInSeconds *int32

	// The path to use for the health probe. Default is /
	Path *string

	// Protocol scheme to use for this probe
	Protocol *FrontDoorProtocol

	// READ-ONLY; Resource status.
	ResourceState *FrontDoorResourceState
}

// HealthProbeSettingsUpdateParameters - L7 health probe settings for a backend pool
type HealthProbeSettingsUpdateParameters struct {
	// Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled
	// if there is a single enabled backend in single enabled backend pool.
	EnabledState *HealthProbeEnabled

	// Configures which HTTP method to use to probe the backends defined under backendPools.
	HealthProbeMethod *FrontDoorHealthProbeMethod

	// The number of seconds between health probes.
	IntervalInSeconds *int32

	// The path to use for the health probe. Default is /
	Path *string

	// Protocol scheme to use for this probe
	Protocol *FrontDoorProtocol
}

// KeyVaultCertificateSourceParameters - Parameters required for bring-your-own-certification via Key Vault
type KeyVaultCertificateSourceParameters struct {
	// The name of the Key Vault secret representing the full certificate PFX
	SecretName *string

	// The version of the Key Vault secret representing the full certificate PFX
	SecretVersion *string

	// The Key Vault containing the SSL certificate
	Vault *KeyVaultCertificateSourceParametersVault
}

// KeyVaultCertificateSourceParametersVault - The Key Vault containing the SSL certificate
type KeyVaultCertificateSourceParametersVault struct {
	// Resource ID.
	ID *string
}

// LatencyMetric - Defines the properties of a latency metric used in the latency scorecard
type LatencyMetric struct {
	// READ-ONLY; The lower end of the 95% confidence interval for endpoint A
	ACLower95CI *float32

	// READ-ONLY; The upper end of the 95% confidence interval for endpoint A
	AHUpper95CI *float32

	// READ-ONLY; The metric value of the A endpoint
	AValue *float32

	// READ-ONLY; The lower end of the 95% confidence interval for endpoint B
	BCLower95CI *float32

	// READ-ONLY; The upper end of the 95% confidence interval for endpoint B
	BUpper95CI *float32

	// READ-ONLY; The metric value of the B endpoint
	BValue *float32

	// READ-ONLY; The difference in value between endpoint A and B
	Delta *float32

	// READ-ONLY; The percent difference between endpoint A and B
	DeltaPercent *float32

	// READ-ONLY; The end time of the Latency Scorecard in UTC
	EndDateTimeUTC *string

	// READ-ONLY; The name of the Latency Metric
	Name *string
}

// LatencyScorecard - Defines the LatencyScorecard
type LatencyScorecard struct {
	// Resource location.
	Location *string

	// The properties of a latency scorecard
	Properties *LatencyScorecardProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// LatencyScorecardProperties - Defines a the properties of a Latency Scorecard
type LatencyScorecardProperties struct {
	// The latency metrics of the Latency Scorecard
	LatencyMetrics []*LatencyMetric

	// READ-ONLY; The country associated with the Latency Scorecard. Values are country ISO codes as specified here- https://www.iso.org/iso-3166-country-codes.html
	Country *string

	// READ-ONLY; The description of the Latency Scorecard
	Description *string

	// READ-ONLY; The end time of the Latency Scorecard in UTC
	EndDateTimeUTC *time.Time

	// READ-ONLY; The A endpoint in the scorecard
	EndpointA *string

	// READ-ONLY; The B endpoint in the scorecard
	EndpointB *string

	// READ-ONLY; The unique identifier of the Latency Scorecard
	ID *string

	// READ-ONLY; The name of the Latency Scorecard
	Name *string

	// READ-ONLY; The start time of the Latency Scorecard in UTC
	StartDateTimeUTC *time.Time
}

// ListResult - Result of the request to list Front Doors. It contains a list of Front Door objects and a URL link to get
// the next set of results.
type ListResult struct {
	// URL to get the next set of Front Door objects if there are any.
	NextLink *string

	// READ-ONLY; List of Front Doors within a resource group.
	Value []*FrontDoor
}

// LoadBalancingSettingsListResult - Result of the request to list load balancing settings. It contains a list of load balancing
// settings objects and a URL link to get the next set of results.
type LoadBalancingSettingsListResult struct {
	// URL to get the next set of LoadBalancingSettings objects if there are any.
	NextLink *string

	// READ-ONLY; List of Backend Pools within a Front Door.
	Value []*LoadBalancingSettingsModel
}

// LoadBalancingSettingsModel - Load balancing settings for a backend pool
type LoadBalancingSettingsModel struct {
	// Resource ID.
	ID *string

	// Resource name.
	Name *string

	// Properties of the load balancing settings
	Properties *LoadBalancingSettingsProperties

	// READ-ONLY; Resource type.
	Type *string
}

// LoadBalancingSettingsProperties - The JSON object that contains the properties required to create load balancing settings
type LoadBalancingSettingsProperties struct {
	// The additional latency in milliseconds for probes to fall into the lowest latency bucket
	AdditionalLatencyMilliseconds *int32

	// The number of samples to consider for load balancing decisions
	SampleSize *int32

	// The number of samples within the sample period that must succeed
	SuccessfulSamplesRequired *int32

	// READ-ONLY; Resource status.
	ResourceState *FrontDoorResourceState
}

// LoadBalancingSettingsUpdateParameters - Round-Robin load balancing settings for a backend pool
type LoadBalancingSettingsUpdateParameters struct {
	// The additional latency in milliseconds for probes to fall into the lowest latency bucket
	AdditionalLatencyMilliseconds *int32

	// The number of samples to consider for load balancing decisions
	SampleSize *int32

	// The number of samples within the sample period that must succeed
	SuccessfulSamplesRequired *int32
}

// ManagedRuleDefinition - Describes a managed rule definition.
type ManagedRuleDefinition struct {
	// READ-ONLY; Describes the default action to be applied when the managed rule matches.
	DefaultAction *ActionType

	// READ-ONLY; Describes the default state for the managed rule.
	DefaultState *ManagedRuleEnabledState

	// READ-ONLY; Describes the functionality of the managed rule.
	Description *string

	// READ-ONLY; Identifier for the managed rule.
	RuleID *string
}

// ManagedRuleExclusion - Exclude variables from managed rule evaluation.
type ManagedRuleExclusion struct {
	// REQUIRED; The variable type to be excluded.
	MatchVariable *ManagedRuleExclusionMatchVariable

	// REQUIRED; Selector value for which elements in the collection this exclusion applies to.
	Selector *string

	// REQUIRED; Comparison operator to apply to the selector when specifying which elements in the collection this exclusion
	// applies to.
	SelectorMatchOperator *ManagedRuleExclusionSelectorMatchOperator
}

// ManagedRuleGroupDefinition - Describes a managed rule group.
type ManagedRuleGroupDefinition struct {
	// READ-ONLY; Description of the managed rule group.
	Description *string

	// READ-ONLY; Name of the managed rule group.
	RuleGroupName *string

	// READ-ONLY; List of rules within the managed rule group.
	Rules []*ManagedRuleDefinition
}

// ManagedRuleGroupOverride - Defines a managed rule group override setting.
type ManagedRuleGroupOverride struct {
	// REQUIRED; Describes the managed rule group to override.
	RuleGroupName *string

	// Describes the exclusions that are applied to all rules in the group.
	Exclusions []*ManagedRuleExclusion

	// List of rules that will be disabled. If none specified, all rules in the group will be disabled.
	Rules []*ManagedRuleOverride
}

// ManagedRuleOverride - Defines a managed rule group override setting.
type ManagedRuleOverride struct {
	// REQUIRED; Identifier for the managed rule.
	RuleID *string

	// Describes the override action to be applied when rule matches.
	Action *ActionType

	// Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
	EnabledState *ManagedRuleEnabledState

	// Describes the exclusions that are applied to this specific rule.
	Exclusions []*ManagedRuleExclusion
}

// ManagedRuleSet - Defines a managed rule set.
type ManagedRuleSet struct {
	// REQUIRED; Defines the rule set type to use.
	RuleSetType *string

	// REQUIRED; Defines the version of the rule set to use.
	RuleSetVersion *string

	// Describes the exclusions that are applied to all rules in the set.
	Exclusions []*ManagedRuleExclusion

	// Defines the rule group overrides to apply to the rule set.
	RuleGroupOverrides []*ManagedRuleGroupOverride

	// Defines the rule set action.
	RuleSetAction *ManagedRuleSetActionType
}

// ManagedRuleSetDefinition - Describes the a managed rule set definition.
type ManagedRuleSetDefinition struct {
	// Resource location.
	Location *string

	// Properties for a managed rule set definition.
	Properties *ManagedRuleSetDefinitionProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ManagedRuleSetDefinitionList - List of managed rule set definitions available for use in a policy.
type ManagedRuleSetDefinitionList struct {
	// URL to retrieve next set of managed rule set definitions.
	NextLink *string

	// READ-ONLY; List of managed rule set definitions.
	Value []*ManagedRuleSetDefinition
}

// ManagedRuleSetDefinitionProperties - Properties for a managed rule set definition.
type ManagedRuleSetDefinitionProperties struct {
	// READ-ONLY; Provisioning state of the managed rule set.
	ProvisioningState *string

	// READ-ONLY; Rule groups of the managed rule set.
	RuleGroups []*ManagedRuleGroupDefinition

	// READ-ONLY; Id of the managed rule set.
	RuleSetID *string

	// READ-ONLY; Type of the managed rule set.
	RuleSetType *string

	// READ-ONLY; Version of the managed rule set type.
	RuleSetVersion *string
}

// ManagedRuleSetList - Defines the list of managed rule sets for the policy.
type ManagedRuleSetList struct {
	// List of rule sets.
	ManagedRuleSets []*ManagedRuleSet
}

// MatchCondition - Define a match condition.
type MatchCondition struct {
	// REQUIRED; List of possible match values.
	MatchValue []*string

	// REQUIRED; Request variable to compare with.
	MatchVariable *MatchVariable

	// REQUIRED; Comparison type to use for matching with the variable value.
	Operator *Operator

	// Describes if the result of this condition should be negated.
	NegateCondition *bool

	// Match against a specific key from the QueryString, PostArgs, RequestHeader or Cookies variables. Default is null.
	Selector *string

	// List of transforms.
	Transforms []*TransformType
}

// PolicySettings - Defines top-level WebApplicationFirewallPolicy configuration settings.
type PolicySettings struct {
	// If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
	CustomBlockResponseBody *string

	// If the action type is block, customer can override the response status code.
	CustomBlockResponseStatusCode *int32

	// Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
	EnabledState *PolicyEnabledState

	// Describes if it is in detection mode or prevention mode at policy level.
	Mode *PolicyMode

	// If action type is redirect, this field represents redirect URL for the client.
	RedirectURL *string

	// Describes if policy managed rules will inspect the request body content.
	RequestBodyCheck *PolicyRequestBodyCheck
}

// PreconfiguredEndpoint - Defines the properties of a preconfigured endpoint
type PreconfiguredEndpoint struct {
	// Resource location.
	Location *string

	// The properties of a preconfiguredEndpoint
	Properties *PreconfiguredEndpointProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PreconfiguredEndpointList - Defines a list of preconfigured endpoints.
type PreconfiguredEndpointList struct {
	// URL to get the next set of PreconfiguredEndpoints if there are any.
	NextLink *string

	// READ-ONLY; List of PreconfiguredEndpoints supported by NetworkExperiment.
	Value []*PreconfiguredEndpoint
}

// PreconfiguredEndpointProperties - Defines the properties of a preconfigured endpoint
type PreconfiguredEndpointProperties struct {
	// The preconfigured endpoint backend
	Backend *string

	// The description of the endpoint
	Description *string

	// The endpoint that is preconfigured
	Endpoint *string

	// The type of endpoint
	EndpointType *EndpointType
}

// Profile - Defines an Network Experiment Profile and lists of Experiments
type Profile struct {
	// Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string

	// Resource location.
	Location *string

	// The properties of a Profile
	Properties *ProfileProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ProfileList - Defines a list of Profiles. It contains a list of Profile objects and a URL link to get the next set of results.
type ProfileList struct {
	// URL to get the next set of Profile objects if there are any.
	NextLink *string

	// READ-ONLY; List of Profiles within a resource group.
	Value []*Profile
}

// ProfileProperties - Defines the properties of an experiment
type ProfileProperties struct {
	// The state of the Experiment
	EnabledState *State

	// READ-ONLY; Resource status.
	ResourceState *NetworkExperimentResourceState
}

// ProfileUpdateModel - Defines modifiable attributes of a Profile
type ProfileUpdateModel struct {
	// The properties of a Profile
	Properties *ProfileUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// ProfileUpdateProperties - Defines the properties of an experiment
type ProfileUpdateProperties struct {
	// The enabled state of the Profile
	EnabledState *State
}

// Properties - The JSON object that contains the properties required to create an endpoint.
type Properties struct {
	// Backend pools available to routing rules.
	BackendPools []*BackendPool

	// Settings for all backendPools
	BackendPoolsSettings *BackendPoolsSettings

	// Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *FrontDoorEnabledState

	// A friendly name for the frontDoor
	FriendlyName *string

	// Frontend endpoints available to routing rules.
	FrontendEndpoints []*FrontendEndpoint

	// Health probe settings associated with this Front Door instance.
	HealthProbeSettings []*HealthProbeSettingsModel

	// Load balancing settings associated with this Front Door instance.
	LoadBalancingSettings []*LoadBalancingSettingsModel

	// Routing rules associated with this Front Door.
	RoutingRules []*RoutingRule

	// READ-ONLY; The host that each frontendEndpoint must CNAME to.
	Cname *string

	// READ-ONLY; Key-Value pair representing additional properties for frontdoor.
	ExtendedProperties map[string]*string

	// READ-ONLY; The Id of the frontdoor.
	FrontdoorID *string

	// READ-ONLY; Provisioning state of the Front Door.
	ProvisioningState *string

	// READ-ONLY; Resource status of the Front Door.
	ResourceState *FrontDoorResourceState

	// READ-ONLY; Rules Engine Configurations available to routing rules.
	RulesEngines []*RulesEngine
}

// PurgeParameters - Parameters required for content purge.
type PurgeParameters struct {
	// REQUIRED; The path to the content to be purged. Can describe a file path or a wild card directory.
	ContentPaths []*string
}

// RedirectConfiguration - Describes Redirect Route.
type RedirectConfiguration struct {
	// REQUIRED
	ODataType *string

	// Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
	CustomFragment *string

	// Host to redirect. Leave empty to use the incoming host as the destination host.
	CustomHost *string

	// The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination
	// path.
	CustomPath *string

	// The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string;
	// leave empty to preserve the incoming query string. Query string must be in =
	// format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query
	// strings with &.
	CustomQueryString *string

	// The protocol of the destination to where the traffic is redirected
	RedirectProtocol *FrontDoorRedirectProtocol

	// The redirect type the rule will use when redirecting traffic.
	RedirectType *FrontDoorRedirectType
}

// GetRouteConfiguration implements the RouteConfigurationClassification interface for type RedirectConfiguration.
func (r *RedirectConfiguration) GetRouteConfiguration() *RouteConfiguration {
	return &RouteConfiguration{
		ODataType: r.ODataType,
	}
}

// Resource - Common resource representation.
type Resource struct {
	// Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RouteConfiguration - Base class for all types of Route.
type RouteConfiguration struct {
	// REQUIRED
	ODataType *string
}

// GetRouteConfiguration implements the RouteConfigurationClassification interface for type RouteConfiguration.
func (r *RouteConfiguration) GetRouteConfiguration() *RouteConfiguration { return r }

// RoutingRule - A routing rule represents a specification for traffic to treat and where to send it, along with health probe
// information.
type RoutingRule struct {
	// Resource ID.
	ID *string

	// Resource name.
	Name *string

	// Properties of the Front Door Routing Rule
	Properties *RoutingRuleProperties

	// READ-ONLY; Resource type.
	Type *string
}

// RoutingRuleLink - Defines the Resource ID for a Routing Rule.
type RoutingRuleLink struct {
	// Resource ID.
	ID *string
}

// RoutingRuleListResult - Result of the request to list Routing Rules. It contains a list of Routing Rule objects and a URL
// link to get the next set of results.
type RoutingRuleListResult struct {
	// URL to get the next set of RoutingRule objects if there are any.
	NextLink *string

	// READ-ONLY; List of Routing Rules within a Front Door.
	Value []*RoutingRule
}

// RoutingRuleProperties - The JSON object that contains the properties required to create a routing rule.
type RoutingRuleProperties struct {
	// Protocol schemes to match for this rule
	AcceptedProtocols []*FrontDoorProtocol

	// Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *RoutingRuleEnabledState

	// Frontend endpoints associated with this rule
	FrontendEndpoints []*SubResource

	// The route patterns of the rule.
	PatternsToMatch []*string

	// A reference to the routing configuration.
	RouteConfiguration RouteConfigurationClassification

	// A reference to a specific Rules Engine Configuration to apply to this route.
	RulesEngine *SubResource

	// Defines the Web Application Firewall policy for each routing rule (if applicable)
	WebApplicationFirewallPolicyLink *RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink

	// READ-ONLY; Resource status.
	ResourceState *FrontDoorResourceState
}

// RoutingRuleUpdateParameters - Routing rules to apply to an endpoint
type RoutingRuleUpdateParameters struct {
	// Protocol schemes to match for this rule
	AcceptedProtocols []*FrontDoorProtocol

	// Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *RoutingRuleEnabledState

	// Frontend endpoints associated with this rule
	FrontendEndpoints []*SubResource

	// The route patterns of the rule.
	PatternsToMatch []*string

	// A reference to the routing configuration.
	RouteConfiguration RouteConfigurationClassification

	// A reference to a specific Rules Engine Configuration to apply to this route.
	RulesEngine *SubResource

	// Defines the Web Application Firewall policy for each routing rule (if applicable)
	WebApplicationFirewallPolicyLink *RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink
}

// RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink - Defines the Web Application Firewall policy for each routing
// rule (if applicable)
type RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink struct {
	// Resource ID.
	ID *string
}

// RulesEngine - A rules engine configuration containing a list of rules that will run to modify the runtime behavior of the
// request and response.
type RulesEngine struct {
	// Properties of the Rules Engine Configuration.
	Properties *RulesEngineProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RulesEngineAction - One or more actions that will execute, modifying the request and/or response.
type RulesEngineAction struct {
	// A list of header actions to apply from the request from AFD to the origin.
	RequestHeaderActions []*HeaderAction

	// A list of header actions to apply from the response from AFD to the client.
	ResponseHeaderActions []*HeaderAction

	// Override the route configuration.
	RouteConfigurationOverride RouteConfigurationClassification
}

// RulesEngineListResult - Result of the request to list Rules Engine Configurations. It contains a list of RulesEngine objects
// and a URL link to get the next set of results.
type RulesEngineListResult struct {
	// URL to get the next set of RulesEngine objects if there are any.
	NextLink *string

	// READ-ONLY; List of rulesEngines within a Front Door.
	Value []*RulesEngine
}

// RulesEngineMatchCondition - Define a match condition
type RulesEngineMatchCondition struct {
	// REQUIRED; Match values to match against. The operator will apply to each value in here with OR semantics. If any of them
	// match the variable with the given operator this match condition is considered a match.
	RulesEngineMatchValue []*string

	// REQUIRED; Match Variable
	RulesEngineMatchVariable *RulesEngineMatchVariable

	// REQUIRED; Describes operator to apply to the match condition.
	RulesEngineOperator *RulesEngineOperator

	// Describes if this is negate condition or not
	NegateCondition *bool

	// Name of selector in RequestHeader or RequestBody to be matched
	Selector *string

	// List of transforms
	Transforms []*Transform
}

// RulesEngineProperties - The JSON object that contains the properties required to create a Rules Engine Configuration.
type RulesEngineProperties struct {
	// A list of rules that define a particular Rules Engine Configuration.
	Rules []*RulesEngineRule

	// READ-ONLY; Resource status.
	ResourceState *FrontDoorResourceState
}

// RulesEngineRule - Contains a list of match conditions, and an action on how to modify the request/response. If multiple
// rules match, the actions from one rule that conflict with a previous rule overwrite for a singular
// action, or append in the case of headers manipulation.
type RulesEngineRule struct {
	// REQUIRED; Actions to perform on the request and response if all of the match conditions are met.
	Action *RulesEngineAction

	// REQUIRED; A name to refer to this specific rule.
	Name *string

	// REQUIRED; A priority assigned to this rule.
	Priority *int32

	// A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means
	// the actions will always run.
	MatchConditions []*RulesEngineMatchCondition

	// If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults
	// to Continue.
	MatchProcessingBehavior *MatchProcessingBehavior
}

// RulesEngineUpdateParameters - Rules Engine Configuration to apply to a Routing Rule.
type RulesEngineUpdateParameters struct {
	// A list of rules that define a particular Rules Engine Configuration.
	Rules []*RulesEngineRule
}

// SKU - The pricing tier of the web application firewall policy.
type SKU struct {
	// Name of the pricing tier.
	Name *SKUName
}

// SecurityPolicyLink - Defines the Resource ID for a Security Policy.
type SecurityPolicyLink struct {
	// Resource ID.
	ID *string
}

// SubResource - Reference to another subresource.
type SubResource struct {
	// Resource ID.
	ID *string
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string
}

// Timeseries - Defines the Timeseries
type Timeseries struct {
	// Resource location.
	Location *string

	// The properties of a Timeseries
	Properties *TimeseriesProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// TimeseriesDataPoint - Defines a timeseries datapoint used in a timeseries
type TimeseriesDataPoint struct {
	// The DateTime of the Timeseries data point in UTC
	DateTimeUTC *string

	// The Value of the Timeseries data point
	Value *float32
}

// TimeseriesProperties - Defines the properties of a timeseries
type TimeseriesProperties struct {
	// The aggregation interval of the Timeseries
	AggregationInterval *AggregationInterval

	// The country associated with the Timeseries. Values are country ISO codes as specified here- https://www.iso.org/iso-3166-country-codes.html
	Country *string

	// The end DateTime of the Timeseries in UTC
	EndDateTimeUTC *string

	// The endpoint associated with the Timeseries data point
	Endpoint *string

	// The start DateTime of the Timeseries in UTC
	StartDateTimeUTC *string

	// The set of data points for the timeseries
	TimeseriesData []*TimeseriesDataPoint

	// The type of Timeseries
	TimeseriesType *TimeseriesType
}

// UpdateParameters - The properties needed to update a Front Door
type UpdateParameters struct {
	// Backend pools available to routing rules.
	BackendPools []*BackendPool

	// Settings for all backendPools
	BackendPoolsSettings *BackendPoolsSettings

	// Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *FrontDoorEnabledState

	// A friendly name for the frontDoor
	FriendlyName *string

	// Frontend endpoints available to routing rules.
	FrontendEndpoints []*FrontendEndpoint

	// Health probe settings associated with this Front Door instance.
	HealthProbeSettings []*HealthProbeSettingsModel

	// Load balancing settings associated with this Front Door instance.
	LoadBalancingSettings []*LoadBalancingSettingsModel

	// Routing rules associated with this Front Door.
	RoutingRules []*RoutingRule
}

// ValidateCustomDomainInput - Input of the custom domain to be validated for DNS mapping.
type ValidateCustomDomainInput struct {
	// REQUIRED; The host name of the custom domain. Must be a domain name.
	HostName *string
}

// ValidateCustomDomainOutput - Output of custom domain validation.
type ValidateCustomDomainOutput struct {
	// READ-ONLY; Indicates whether the custom domain is valid or not.
	CustomDomainValidated *bool

	// READ-ONLY; Error message describing why the custom domain is not valid.
	Message *string

	// READ-ONLY; The reason why the custom domain is not valid.
	Reason *string
}

// WebApplicationFirewallPolicy - Defines web application firewall policy.
type WebApplicationFirewallPolicy struct {
	// Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string

	// Resource location.
	Location *string

	// Properties of the web application firewall policy.
	Properties *WebApplicationFirewallPolicyProperties

	// The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if not specified.
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WebApplicationFirewallPolicyList - Defines a list of WebApplicationFirewallPolicies. It contains a list of WebApplicationFirewallPolicy
// objects and a URL link to get the next set of results.
type WebApplicationFirewallPolicyList struct {
	// URL to get the next set of WebApplicationFirewallPolicy objects if there are any.
	NextLink *string

	// READ-ONLY; List of WebApplicationFirewallPolicies within a resource group.
	Value []*WebApplicationFirewallPolicy
}

// WebApplicationFirewallPolicyProperties - Defines web application firewall policy properties.
type WebApplicationFirewallPolicyProperties struct {
	// Describes custom rules inside the policy.
	CustomRules *CustomRuleList

	// Describes managed rules inside the policy.
	ManagedRules *ManagedRuleSetList

	// Describes settings for the policy.
	PolicySettings *PolicySettings

	// READ-ONLY; Describes Frontend Endpoints associated with this Web Application Firewall policy.
	FrontendEndpointLinks []*FrontendEndpointLink

	// READ-ONLY; Provisioning state of the policy.
	ProvisioningState *string

	// READ-ONLY; Resource status of the policy.
	ResourceState *PolicyResourceState

	// READ-ONLY; Describes Routing Rules associated with this Web Application Firewall policy.
	RoutingRuleLinks []*RoutingRuleLink

	// READ-ONLY; Describes Security Policy associated with this Web Application Firewall policy.
	SecurityPolicyLinks []*SecurityPolicyLink
}
