//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybriddatamanager/armhybriddatamanager"
	"net/http"
	"net/url"
	"regexp"
)

// PublicKeysServer is a fake server for instances of the armhybriddatamanager.PublicKeysClient type.
type PublicKeysServer struct {
	// Get is the fake for method PublicKeysClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, publicKeyName string, resourceGroupName string, dataManagerName string, options *armhybriddatamanager.PublicKeysClientGetOptions) (resp azfake.Responder[armhybriddatamanager.PublicKeysClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDataManagerPager is the fake for method PublicKeysClient.NewListByDataManagerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDataManagerPager func(resourceGroupName string, dataManagerName string, options *armhybriddatamanager.PublicKeysClientListByDataManagerOptions) (resp azfake.PagerResponder[armhybriddatamanager.PublicKeysClientListByDataManagerResponse])
}

// NewPublicKeysServerTransport creates a new instance of PublicKeysServerTransport with the provided implementation.
// The returned PublicKeysServerTransport instance is connected to an instance of armhybriddatamanager.PublicKeysClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPublicKeysServerTransport(srv *PublicKeysServer) *PublicKeysServerTransport {
	return &PublicKeysServerTransport{
		srv:                       srv,
		newListByDataManagerPager: newTracker[azfake.PagerResponder[armhybriddatamanager.PublicKeysClientListByDataManagerResponse]](),
	}
}

// PublicKeysServerTransport connects instances of armhybriddatamanager.PublicKeysClient to instances of PublicKeysServer.
// Don't use this type directly, use NewPublicKeysServerTransport instead.
type PublicKeysServerTransport struct {
	srv                       *PublicKeysServer
	newListByDataManagerPager *tracker[azfake.PagerResponder[armhybriddatamanager.PublicKeysClientListByDataManagerResponse]]
}

// Do implements the policy.Transporter interface for PublicKeysServerTransport.
func (p *PublicKeysServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PublicKeysClient.Get":
		resp, err = p.dispatchGet(req)
	case "PublicKeysClient.NewListByDataManagerPager":
		resp, err = p.dispatchNewListByDataManagerPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PublicKeysServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicKeys/(?P<publicKeyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	publicKeyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicKeyName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), publicKeyNameParam, resourceGroupNameParam, dataManagerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PublicKey, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PublicKeysServerTransport) dispatchNewListByDataManagerPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByDataManagerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDataManagerPager not implemented")}
	}
	newListByDataManagerPager := p.newListByDataManagerPager.get(req)
	if newListByDataManagerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicKeys`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByDataManagerPager(resourceGroupNameParam, dataManagerNameParam, nil)
		newListByDataManagerPager = &resp
		p.newListByDataManagerPager.add(req, newListByDataManagerPager)
		server.PagerResponderInjectNextLinks(newListByDataManagerPager, req, func(page *armhybriddatamanager.PublicKeysClientListByDataManagerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDataManagerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByDataManagerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDataManagerPager) {
		p.newListByDataManagerPager.remove(req)
	}
	return resp, nil
}
