//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/paloaltonetworksngfw/armpanngfw"
	"net/http"
	"net/url"
	"regexp"
)

// FqdnListGlobalRulestackServer is a fake server for instances of the armpanngfw.FqdnListGlobalRulestackClient type.
type FqdnListGlobalRulestackServer struct {
	// BeginCreateOrUpdate is the fake for method FqdnListGlobalRulestackClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, globalRulestackName string, name string, resource armpanngfw.FqdnListGlobalRulestackResource, options *armpanngfw.FqdnListGlobalRulestackClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armpanngfw.FqdnListGlobalRulestackClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method FqdnListGlobalRulestackClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, globalRulestackName string, name string, options *armpanngfw.FqdnListGlobalRulestackClientBeginDeleteOptions) (resp azfake.PollerResponder[armpanngfw.FqdnListGlobalRulestackClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method FqdnListGlobalRulestackClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, globalRulestackName string, name string, options *armpanngfw.FqdnListGlobalRulestackClientGetOptions) (resp azfake.Responder[armpanngfw.FqdnListGlobalRulestackClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method FqdnListGlobalRulestackClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(globalRulestackName string, options *armpanngfw.FqdnListGlobalRulestackClientListOptions) (resp azfake.PagerResponder[armpanngfw.FqdnListGlobalRulestackClientListResponse])
}

// NewFqdnListGlobalRulestackServerTransport creates a new instance of FqdnListGlobalRulestackServerTransport with the provided implementation.
// The returned FqdnListGlobalRulestackServerTransport instance is connected to an instance of armpanngfw.FqdnListGlobalRulestackClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewFqdnListGlobalRulestackServerTransport(srv *FqdnListGlobalRulestackServer) *FqdnListGlobalRulestackServerTransport {
	return &FqdnListGlobalRulestackServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armpanngfw.FqdnListGlobalRulestackClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armpanngfw.FqdnListGlobalRulestackClientDeleteResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armpanngfw.FqdnListGlobalRulestackClientListResponse]](),
	}
}

// FqdnListGlobalRulestackServerTransport connects instances of armpanngfw.FqdnListGlobalRulestackClient to instances of FqdnListGlobalRulestackServer.
// Don't use this type directly, use NewFqdnListGlobalRulestackServerTransport instead.
type FqdnListGlobalRulestackServerTransport struct {
	srv                 *FqdnListGlobalRulestackServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armpanngfw.FqdnListGlobalRulestackClientCreateOrUpdateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armpanngfw.FqdnListGlobalRulestackClientDeleteResponse]]
	newListPager        *tracker[azfake.PagerResponder[armpanngfw.FqdnListGlobalRulestackClientListResponse]]
}

// Do implements the policy.Transporter interface for FqdnListGlobalRulestackServerTransport.
func (f *FqdnListGlobalRulestackServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "FqdnListGlobalRulestackClient.BeginCreateOrUpdate":
		resp, err = f.dispatchBeginCreateOrUpdate(req)
	case "FqdnListGlobalRulestackClient.BeginDelete":
		resp, err = f.dispatchBeginDelete(req)
	case "FqdnListGlobalRulestackClient.Get":
		resp, err = f.dispatchGet(req)
	case "FqdnListGlobalRulestackClient.NewListPager":
		resp, err = f.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (f *FqdnListGlobalRulestackServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if f.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := f.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fqdnlists/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armpanngfw.FqdnListGlobalRulestackResource](req)
		if err != nil {
			return nil, err
		}
		globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := f.srv.BeginCreateOrUpdate(req.Context(), globalRulestackNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		f.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		f.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		f.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (f *FqdnListGlobalRulestackServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if f.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := f.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fqdnlists/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := f.srv.BeginDelete(req.Context(), globalRulestackNameParam, nameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		f.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		f.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		f.beginDelete.remove(req)
	}

	return resp, nil
}

func (f *FqdnListGlobalRulestackServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if f.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fqdnlists/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Get(req.Context(), globalRulestackNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FqdnListGlobalRulestackResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FqdnListGlobalRulestackServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := f.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fqdnlists`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListPager(globalRulestackNameParam, nil)
		newListPager = &resp
		f.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armpanngfw.FqdnListGlobalRulestackClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		f.newListPager.remove(req)
	}
	return resp, nil
}
