//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpostgresqlflexibleservers

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// PostgreSQLManagementClient contains the methods for the PostgreSQLManagementClient group.
// Don't use this type directly, use NewPostgreSQLManagementClient() instead.
type PostgreSQLManagementClient struct {
	internal *arm.Client
}

// NewPostgreSQLManagementClient creates a new instance of PostgreSQLManagementClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewPostgreSQLManagementClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*PostgreSQLManagementClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &PostgreSQLManagementClient{
		internal: cl,
	}
	return client, nil
}

// CheckMigrationNameAvailability - This method checks whether a proposed migration name is valid and available.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - subscriptionID - The subscription ID of the target database server.
//   - resourceGroupName - The resource group name of the target database server.
//   - targetDbServerName - The name of the target database server.
//   - parameters - The required parameters for checking if a migration name is available.
//   - options - PostgreSQLManagementClientCheckMigrationNameAvailabilityOptions contains the optional parameters for the PostgreSQLManagementClient.CheckMigrationNameAvailability
//     method.
func (client *PostgreSQLManagementClient) CheckMigrationNameAvailability(ctx context.Context, subscriptionID string, resourceGroupName string, targetDbServerName string, parameters MigrationNameAvailabilityResource, options *PostgreSQLManagementClientCheckMigrationNameAvailabilityOptions) (PostgreSQLManagementClientCheckMigrationNameAvailabilityResponse, error) {
	var err error
	const operationName = "PostgreSQLManagementClient.CheckMigrationNameAvailability"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.checkMigrationNameAvailabilityCreateRequest(ctx, subscriptionID, resourceGroupName, targetDbServerName, parameters, options)
	if err != nil {
		return PostgreSQLManagementClientCheckMigrationNameAvailabilityResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PostgreSQLManagementClientCheckMigrationNameAvailabilityResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PostgreSQLManagementClientCheckMigrationNameAvailabilityResponse{}, err
	}
	resp, err := client.checkMigrationNameAvailabilityHandleResponse(httpResp)
	return resp, err
}

// checkMigrationNameAvailabilityCreateRequest creates the CheckMigrationNameAvailability request.
func (client *PostgreSQLManagementClient) checkMigrationNameAvailabilityCreateRequest(ctx context.Context, subscriptionID string, resourceGroupName string, targetDbServerName string, parameters MigrationNameAvailabilityResource, options *PostgreSQLManagementClientCheckMigrationNameAvailabilityOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/checkMigrationNameAvailability"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if targetDbServerName == "" {
		return nil, errors.New("parameter targetDbServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{targetDbServerName}", url.PathEscape(targetDbServerName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// checkMigrationNameAvailabilityHandleResponse handles the CheckMigrationNameAvailability response.
func (client *PostgreSQLManagementClient) checkMigrationNameAvailabilityHandleResponse(resp *http.Response) (PostgreSQLManagementClientCheckMigrationNameAvailabilityResponse, error) {
	result := PostgreSQLManagementClientCheckMigrationNameAvailabilityResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MigrationNameAvailabilityResource); err != nil {
		return PostgreSQLManagementClientCheckMigrationNameAvailabilityResponse{}, err
	}
	return result, nil
}
