//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armdeploymentstacks"
	"net/http"
	"net/url"
	"regexp"
)

// Server is a fake server for instances of the armdeploymentstacks.Client type.
type Server struct {
	// BeginCreateOrUpdateAtManagementGroup is the fake for method Client.BeginCreateOrUpdateAtManagementGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdateAtManagementGroup func(ctx context.Context, managementGroupID string, deploymentStackName string, deploymentStack armdeploymentstacks.DeploymentStack, options *armdeploymentstacks.ClientBeginCreateOrUpdateAtManagementGroupOptions) (resp azfake.PollerResponder[armdeploymentstacks.ClientCreateOrUpdateAtManagementGroupResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateAtResourceGroup is the fake for method Client.BeginCreateOrUpdateAtResourceGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdateAtResourceGroup func(ctx context.Context, resourceGroupName string, deploymentStackName string, deploymentStack armdeploymentstacks.DeploymentStack, options *armdeploymentstacks.ClientBeginCreateOrUpdateAtResourceGroupOptions) (resp azfake.PollerResponder[armdeploymentstacks.ClientCreateOrUpdateAtResourceGroupResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateAtSubscription is the fake for method Client.BeginCreateOrUpdateAtSubscription
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdateAtSubscription func(ctx context.Context, deploymentStackName string, deploymentStack armdeploymentstacks.DeploymentStack, options *armdeploymentstacks.ClientBeginCreateOrUpdateAtSubscriptionOptions) (resp azfake.PollerResponder[armdeploymentstacks.ClientCreateOrUpdateAtSubscriptionResponse], errResp azfake.ErrorResponder)

	// BeginDeleteAtManagementGroup is the fake for method Client.BeginDeleteAtManagementGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteAtManagementGroup func(ctx context.Context, managementGroupID string, deploymentStackName string, options *armdeploymentstacks.ClientBeginDeleteAtManagementGroupOptions) (resp azfake.PollerResponder[armdeploymentstacks.ClientDeleteAtManagementGroupResponse], errResp azfake.ErrorResponder)

	// BeginDeleteAtResourceGroup is the fake for method Client.BeginDeleteAtResourceGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteAtResourceGroup func(ctx context.Context, resourceGroupName string, deploymentStackName string, options *armdeploymentstacks.ClientBeginDeleteAtResourceGroupOptions) (resp azfake.PollerResponder[armdeploymentstacks.ClientDeleteAtResourceGroupResponse], errResp azfake.ErrorResponder)

	// BeginDeleteAtSubscription is the fake for method Client.BeginDeleteAtSubscription
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteAtSubscription func(ctx context.Context, deploymentStackName string, options *armdeploymentstacks.ClientBeginDeleteAtSubscriptionOptions) (resp azfake.PollerResponder[armdeploymentstacks.ClientDeleteAtSubscriptionResponse], errResp azfake.ErrorResponder)

	// ExportTemplateAtManagementGroup is the fake for method Client.ExportTemplateAtManagementGroup
	// HTTP status codes to indicate success: http.StatusOK
	ExportTemplateAtManagementGroup func(ctx context.Context, managementGroupID string, deploymentStackName string, options *armdeploymentstacks.ClientExportTemplateAtManagementGroupOptions) (resp azfake.Responder[armdeploymentstacks.ClientExportTemplateAtManagementGroupResponse], errResp azfake.ErrorResponder)

	// ExportTemplateAtResourceGroup is the fake for method Client.ExportTemplateAtResourceGroup
	// HTTP status codes to indicate success: http.StatusOK
	ExportTemplateAtResourceGroup func(ctx context.Context, resourceGroupName string, deploymentStackName string, options *armdeploymentstacks.ClientExportTemplateAtResourceGroupOptions) (resp azfake.Responder[armdeploymentstacks.ClientExportTemplateAtResourceGroupResponse], errResp azfake.ErrorResponder)

	// ExportTemplateAtSubscription is the fake for method Client.ExportTemplateAtSubscription
	// HTTP status codes to indicate success: http.StatusOK
	ExportTemplateAtSubscription func(ctx context.Context, deploymentStackName string, options *armdeploymentstacks.ClientExportTemplateAtSubscriptionOptions) (resp azfake.Responder[armdeploymentstacks.ClientExportTemplateAtSubscriptionResponse], errResp azfake.ErrorResponder)

	// GetAtManagementGroup is the fake for method Client.GetAtManagementGroup
	// HTTP status codes to indicate success: http.StatusOK
	GetAtManagementGroup func(ctx context.Context, managementGroupID string, deploymentStackName string, options *armdeploymentstacks.ClientGetAtManagementGroupOptions) (resp azfake.Responder[armdeploymentstacks.ClientGetAtManagementGroupResponse], errResp azfake.ErrorResponder)

	// GetAtResourceGroup is the fake for method Client.GetAtResourceGroup
	// HTTP status codes to indicate success: http.StatusOK
	GetAtResourceGroup func(ctx context.Context, resourceGroupName string, deploymentStackName string, options *armdeploymentstacks.ClientGetAtResourceGroupOptions) (resp azfake.Responder[armdeploymentstacks.ClientGetAtResourceGroupResponse], errResp azfake.ErrorResponder)

	// GetAtSubscription is the fake for method Client.GetAtSubscription
	// HTTP status codes to indicate success: http.StatusOK
	GetAtSubscription func(ctx context.Context, deploymentStackName string, options *armdeploymentstacks.ClientGetAtSubscriptionOptions) (resp azfake.Responder[armdeploymentstacks.ClientGetAtSubscriptionResponse], errResp azfake.ErrorResponder)

	// NewListAtManagementGroupPager is the fake for method Client.NewListAtManagementGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAtManagementGroupPager func(managementGroupID string, options *armdeploymentstacks.ClientListAtManagementGroupOptions) (resp azfake.PagerResponder[armdeploymentstacks.ClientListAtManagementGroupResponse])

	// NewListAtResourceGroupPager is the fake for method Client.NewListAtResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAtResourceGroupPager func(resourceGroupName string, options *armdeploymentstacks.ClientListAtResourceGroupOptions) (resp azfake.PagerResponder[armdeploymentstacks.ClientListAtResourceGroupResponse])

	// NewListAtSubscriptionPager is the fake for method Client.NewListAtSubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAtSubscriptionPager func(options *armdeploymentstacks.ClientListAtSubscriptionOptions) (resp azfake.PagerResponder[armdeploymentstacks.ClientListAtSubscriptionResponse])
}

// NewServerTransport creates a new instance of ServerTransport with the provided implementation.
// The returned ServerTransport instance is connected to an instance of armdeploymentstacks.Client via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerTransport(srv *Server) *ServerTransport {
	return &ServerTransport{
		srv:                                  srv,
		beginCreateOrUpdateAtManagementGroup: newTracker[azfake.PollerResponder[armdeploymentstacks.ClientCreateOrUpdateAtManagementGroupResponse]](),
		beginCreateOrUpdateAtResourceGroup:   newTracker[azfake.PollerResponder[armdeploymentstacks.ClientCreateOrUpdateAtResourceGroupResponse]](),
		beginCreateOrUpdateAtSubscription:    newTracker[azfake.PollerResponder[armdeploymentstacks.ClientCreateOrUpdateAtSubscriptionResponse]](),
		beginDeleteAtManagementGroup:         newTracker[azfake.PollerResponder[armdeploymentstacks.ClientDeleteAtManagementGroupResponse]](),
		beginDeleteAtResourceGroup:           newTracker[azfake.PollerResponder[armdeploymentstacks.ClientDeleteAtResourceGroupResponse]](),
		beginDeleteAtSubscription:            newTracker[azfake.PollerResponder[armdeploymentstacks.ClientDeleteAtSubscriptionResponse]](),
		newListAtManagementGroupPager:        newTracker[azfake.PagerResponder[armdeploymentstacks.ClientListAtManagementGroupResponse]](),
		newListAtResourceGroupPager:          newTracker[azfake.PagerResponder[armdeploymentstacks.ClientListAtResourceGroupResponse]](),
		newListAtSubscriptionPager:           newTracker[azfake.PagerResponder[armdeploymentstacks.ClientListAtSubscriptionResponse]](),
	}
}

// ServerTransport connects instances of armdeploymentstacks.Client to instances of Server.
// Don't use this type directly, use NewServerTransport instead.
type ServerTransport struct {
	srv                                  *Server
	beginCreateOrUpdateAtManagementGroup *tracker[azfake.PollerResponder[armdeploymentstacks.ClientCreateOrUpdateAtManagementGroupResponse]]
	beginCreateOrUpdateAtResourceGroup   *tracker[azfake.PollerResponder[armdeploymentstacks.ClientCreateOrUpdateAtResourceGroupResponse]]
	beginCreateOrUpdateAtSubscription    *tracker[azfake.PollerResponder[armdeploymentstacks.ClientCreateOrUpdateAtSubscriptionResponse]]
	beginDeleteAtManagementGroup         *tracker[azfake.PollerResponder[armdeploymentstacks.ClientDeleteAtManagementGroupResponse]]
	beginDeleteAtResourceGroup           *tracker[azfake.PollerResponder[armdeploymentstacks.ClientDeleteAtResourceGroupResponse]]
	beginDeleteAtSubscription            *tracker[azfake.PollerResponder[armdeploymentstacks.ClientDeleteAtSubscriptionResponse]]
	newListAtManagementGroupPager        *tracker[azfake.PagerResponder[armdeploymentstacks.ClientListAtManagementGroupResponse]]
	newListAtResourceGroupPager          *tracker[azfake.PagerResponder[armdeploymentstacks.ClientListAtResourceGroupResponse]]
	newListAtSubscriptionPager           *tracker[azfake.PagerResponder[armdeploymentstacks.ClientListAtSubscriptionResponse]]
}

// Do implements the policy.Transporter interface for ServerTransport.
func (s *ServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "Client.BeginCreateOrUpdateAtManagementGroup":
		resp, err = s.dispatchBeginCreateOrUpdateAtManagementGroup(req)
	case "Client.BeginCreateOrUpdateAtResourceGroup":
		resp, err = s.dispatchBeginCreateOrUpdateAtResourceGroup(req)
	case "Client.BeginCreateOrUpdateAtSubscription":
		resp, err = s.dispatchBeginCreateOrUpdateAtSubscription(req)
	case "Client.BeginDeleteAtManagementGroup":
		resp, err = s.dispatchBeginDeleteAtManagementGroup(req)
	case "Client.BeginDeleteAtResourceGroup":
		resp, err = s.dispatchBeginDeleteAtResourceGroup(req)
	case "Client.BeginDeleteAtSubscription":
		resp, err = s.dispatchBeginDeleteAtSubscription(req)
	case "Client.ExportTemplateAtManagementGroup":
		resp, err = s.dispatchExportTemplateAtManagementGroup(req)
	case "Client.ExportTemplateAtResourceGroup":
		resp, err = s.dispatchExportTemplateAtResourceGroup(req)
	case "Client.ExportTemplateAtSubscription":
		resp, err = s.dispatchExportTemplateAtSubscription(req)
	case "Client.GetAtManagementGroup":
		resp, err = s.dispatchGetAtManagementGroup(req)
	case "Client.GetAtResourceGroup":
		resp, err = s.dispatchGetAtResourceGroup(req)
	case "Client.GetAtSubscription":
		resp, err = s.dispatchGetAtSubscription(req)
	case "Client.NewListAtManagementGroupPager":
		resp, err = s.dispatchNewListAtManagementGroupPager(req)
	case "Client.NewListAtResourceGroupPager":
		resp, err = s.dispatchNewListAtResourceGroupPager(req)
	case "Client.NewListAtSubscriptionPager":
		resp, err = s.dispatchNewListAtSubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ServerTransport) dispatchBeginCreateOrUpdateAtManagementGroup(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateOrUpdateAtManagementGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateAtManagementGroup not implemented")}
	}
	beginCreateOrUpdateAtManagementGroup := s.beginCreateOrUpdateAtManagementGroup.get(req)
	if beginCreateOrUpdateAtManagementGroup == nil {
		const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks/(?P<deploymentStackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdeploymentstacks.DeploymentStack](req)
		if err != nil {
			return nil, err
		}
		managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
		if err != nil {
			return nil, err
		}
		deploymentStackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentStackName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateOrUpdateAtManagementGroup(req.Context(), managementGroupIDParam, deploymentStackNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateAtManagementGroup = &respr
		s.beginCreateOrUpdateAtManagementGroup.add(req, beginCreateOrUpdateAtManagementGroup)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateAtManagementGroup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginCreateOrUpdateAtManagementGroup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateAtManagementGroup) {
		s.beginCreateOrUpdateAtManagementGroup.remove(req)
	}

	return resp, nil
}

func (s *ServerTransport) dispatchBeginCreateOrUpdateAtResourceGroup(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateOrUpdateAtResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateAtResourceGroup not implemented")}
	}
	beginCreateOrUpdateAtResourceGroup := s.beginCreateOrUpdateAtResourceGroup.get(req)
	if beginCreateOrUpdateAtResourceGroup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks/(?P<deploymentStackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdeploymentstacks.DeploymentStack](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		deploymentStackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentStackName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateOrUpdateAtResourceGroup(req.Context(), resourceGroupNameParam, deploymentStackNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateAtResourceGroup = &respr
		s.beginCreateOrUpdateAtResourceGroup.add(req, beginCreateOrUpdateAtResourceGroup)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateAtResourceGroup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginCreateOrUpdateAtResourceGroup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateAtResourceGroup) {
		s.beginCreateOrUpdateAtResourceGroup.remove(req)
	}

	return resp, nil
}

func (s *ServerTransport) dispatchBeginCreateOrUpdateAtSubscription(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateOrUpdateAtSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateAtSubscription not implemented")}
	}
	beginCreateOrUpdateAtSubscription := s.beginCreateOrUpdateAtSubscription.get(req)
	if beginCreateOrUpdateAtSubscription == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks/(?P<deploymentStackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdeploymentstacks.DeploymentStack](req)
		if err != nil {
			return nil, err
		}
		deploymentStackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentStackName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateOrUpdateAtSubscription(req.Context(), deploymentStackNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateAtSubscription = &respr
		s.beginCreateOrUpdateAtSubscription.add(req, beginCreateOrUpdateAtSubscription)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateAtSubscription, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginCreateOrUpdateAtSubscription.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateAtSubscription) {
		s.beginCreateOrUpdateAtSubscription.remove(req)
	}

	return resp, nil
}

func (s *ServerTransport) dispatchBeginDeleteAtManagementGroup(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDeleteAtManagementGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteAtManagementGroup not implemented")}
	}
	beginDeleteAtManagementGroup := s.beginDeleteAtManagementGroup.get(req)
	if beginDeleteAtManagementGroup == nil {
		const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks/(?P<deploymentStackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
		if err != nil {
			return nil, err
		}
		deploymentStackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentStackName")])
		if err != nil {
			return nil, err
		}
		unmanageActionResourcesUnescaped, err := url.QueryUnescape(qp.Get("unmanageAction.Resources"))
		if err != nil {
			return nil, err
		}
		unmanageActionResourcesParam := getOptional(armdeploymentstacks.UnmanageActionResourceMode(unmanageActionResourcesUnescaped))
		unmanageActionResourceGroupsUnescaped, err := url.QueryUnescape(qp.Get("unmanageAction.ResourceGroups"))
		if err != nil {
			return nil, err
		}
		unmanageActionResourceGroupsParam := getOptional(armdeploymentstacks.UnmanageActionResourceGroupMode(unmanageActionResourceGroupsUnescaped))
		unmanageActionManagementGroupsUnescaped, err := url.QueryUnescape(qp.Get("unmanageAction.ManagementGroups"))
		if err != nil {
			return nil, err
		}
		unmanageActionManagementGroupsParam := getOptional(armdeploymentstacks.UnmanageActionManagementGroupMode(unmanageActionManagementGroupsUnescaped))
		var options *armdeploymentstacks.ClientBeginDeleteAtManagementGroupOptions
		if unmanageActionResourcesParam != nil || unmanageActionResourceGroupsParam != nil || unmanageActionManagementGroupsParam != nil {
			options = &armdeploymentstacks.ClientBeginDeleteAtManagementGroupOptions{
				UnmanageActionResources:        unmanageActionResourcesParam,
				UnmanageActionResourceGroups:   unmanageActionResourceGroupsParam,
				UnmanageActionManagementGroups: unmanageActionManagementGroupsParam,
			}
		}
		respr, errRespr := s.srv.BeginDeleteAtManagementGroup(req.Context(), managementGroupIDParam, deploymentStackNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteAtManagementGroup = &respr
		s.beginDeleteAtManagementGroup.add(req, beginDeleteAtManagementGroup)
	}

	resp, err := server.PollerResponderNext(beginDeleteAtManagementGroup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDeleteAtManagementGroup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteAtManagementGroup) {
		s.beginDeleteAtManagementGroup.remove(req)
	}

	return resp, nil
}

func (s *ServerTransport) dispatchBeginDeleteAtResourceGroup(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDeleteAtResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteAtResourceGroup not implemented")}
	}
	beginDeleteAtResourceGroup := s.beginDeleteAtResourceGroup.get(req)
	if beginDeleteAtResourceGroup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks/(?P<deploymentStackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		deploymentStackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentStackName")])
		if err != nil {
			return nil, err
		}
		unmanageActionResourcesUnescaped, err := url.QueryUnescape(qp.Get("unmanageAction.Resources"))
		if err != nil {
			return nil, err
		}
		unmanageActionResourcesParam := getOptional(armdeploymentstacks.UnmanageActionResourceMode(unmanageActionResourcesUnescaped))
		unmanageActionResourceGroupsUnescaped, err := url.QueryUnescape(qp.Get("unmanageAction.ResourceGroups"))
		if err != nil {
			return nil, err
		}
		unmanageActionResourceGroupsParam := getOptional(armdeploymentstacks.UnmanageActionResourceGroupMode(unmanageActionResourceGroupsUnescaped))
		var options *armdeploymentstacks.ClientBeginDeleteAtResourceGroupOptions
		if unmanageActionResourcesParam != nil || unmanageActionResourceGroupsParam != nil {
			options = &armdeploymentstacks.ClientBeginDeleteAtResourceGroupOptions{
				UnmanageActionResources:      unmanageActionResourcesParam,
				UnmanageActionResourceGroups: unmanageActionResourceGroupsParam,
			}
		}
		respr, errRespr := s.srv.BeginDeleteAtResourceGroup(req.Context(), resourceGroupNameParam, deploymentStackNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteAtResourceGroup = &respr
		s.beginDeleteAtResourceGroup.add(req, beginDeleteAtResourceGroup)
	}

	resp, err := server.PollerResponderNext(beginDeleteAtResourceGroup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDeleteAtResourceGroup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteAtResourceGroup) {
		s.beginDeleteAtResourceGroup.remove(req)
	}

	return resp, nil
}

func (s *ServerTransport) dispatchBeginDeleteAtSubscription(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDeleteAtSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteAtSubscription not implemented")}
	}
	beginDeleteAtSubscription := s.beginDeleteAtSubscription.get(req)
	if beginDeleteAtSubscription == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks/(?P<deploymentStackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		deploymentStackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentStackName")])
		if err != nil {
			return nil, err
		}
		unmanageActionResourcesUnescaped, err := url.QueryUnescape(qp.Get("unmanageAction.Resources"))
		if err != nil {
			return nil, err
		}
		unmanageActionResourcesParam := getOptional(armdeploymentstacks.UnmanageActionResourceMode(unmanageActionResourcesUnescaped))
		unmanageActionResourceGroupsUnescaped, err := url.QueryUnescape(qp.Get("unmanageAction.ResourceGroups"))
		if err != nil {
			return nil, err
		}
		unmanageActionResourceGroupsParam := getOptional(armdeploymentstacks.UnmanageActionResourceGroupMode(unmanageActionResourceGroupsUnescaped))
		var options *armdeploymentstacks.ClientBeginDeleteAtSubscriptionOptions
		if unmanageActionResourcesParam != nil || unmanageActionResourceGroupsParam != nil {
			options = &armdeploymentstacks.ClientBeginDeleteAtSubscriptionOptions{
				UnmanageActionResources:      unmanageActionResourcesParam,
				UnmanageActionResourceGroups: unmanageActionResourceGroupsParam,
			}
		}
		respr, errRespr := s.srv.BeginDeleteAtSubscription(req.Context(), deploymentStackNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteAtSubscription = &respr
		s.beginDeleteAtSubscription.add(req, beginDeleteAtSubscription)
	}

	resp, err := server.PollerResponderNext(beginDeleteAtSubscription, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDeleteAtSubscription.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteAtSubscription) {
		s.beginDeleteAtSubscription.remove(req)
	}

	return resp, nil
}

func (s *ServerTransport) dispatchExportTemplateAtManagementGroup(req *http.Request) (*http.Response, error) {
	if s.srv.ExportTemplateAtManagementGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExportTemplateAtManagementGroup not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks/(?P<deploymentStackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/exportTemplate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
	if err != nil {
		return nil, err
	}
	deploymentStackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentStackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ExportTemplateAtManagementGroup(req.Context(), managementGroupIDParam, deploymentStackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentStackTemplateDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchExportTemplateAtResourceGroup(req *http.Request) (*http.Response, error) {
	if s.srv.ExportTemplateAtResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExportTemplateAtResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks/(?P<deploymentStackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/exportTemplate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	deploymentStackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentStackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ExportTemplateAtResourceGroup(req.Context(), resourceGroupNameParam, deploymentStackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentStackTemplateDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchExportTemplateAtSubscription(req *http.Request) (*http.Response, error) {
	if s.srv.ExportTemplateAtSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExportTemplateAtSubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks/(?P<deploymentStackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/exportTemplate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deploymentStackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentStackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ExportTemplateAtSubscription(req.Context(), deploymentStackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentStackTemplateDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchGetAtManagementGroup(req *http.Request) (*http.Response, error) {
	if s.srv.GetAtManagementGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtManagementGroup not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks/(?P<deploymentStackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
	if err != nil {
		return nil, err
	}
	deploymentStackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentStackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetAtManagementGroup(req.Context(), managementGroupIDParam, deploymentStackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentStack, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchGetAtResourceGroup(req *http.Request) (*http.Response, error) {
	if s.srv.GetAtResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks/(?P<deploymentStackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	deploymentStackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentStackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetAtResourceGroup(req.Context(), resourceGroupNameParam, deploymentStackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentStack, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchGetAtSubscription(req *http.Request) (*http.Response, error) {
	if s.srv.GetAtSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtSubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks/(?P<deploymentStackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deploymentStackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentStackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetAtSubscription(req.Context(), deploymentStackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentStack, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchNewListAtManagementGroupPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListAtManagementGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAtManagementGroupPager not implemented")}
	}
	newListAtManagementGroupPager := s.newListAtManagementGroupPager.get(req)
	if newListAtManagementGroupPager == nil {
		const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListAtManagementGroupPager(managementGroupIDParam, nil)
		newListAtManagementGroupPager = &resp
		s.newListAtManagementGroupPager.add(req, newListAtManagementGroupPager)
		server.PagerResponderInjectNextLinks(newListAtManagementGroupPager, req, func(page *armdeploymentstacks.ClientListAtManagementGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAtManagementGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListAtManagementGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAtManagementGroupPager) {
		s.newListAtManagementGroupPager.remove(req)
	}
	return resp, nil
}

func (s *ServerTransport) dispatchNewListAtResourceGroupPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListAtResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAtResourceGroupPager not implemented")}
	}
	newListAtResourceGroupPager := s.newListAtResourceGroupPager.get(req)
	if newListAtResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListAtResourceGroupPager(resourceGroupNameParam, nil)
		newListAtResourceGroupPager = &resp
		s.newListAtResourceGroupPager.add(req, newListAtResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListAtResourceGroupPager, req, func(page *armdeploymentstacks.ClientListAtResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAtResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListAtResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAtResourceGroupPager) {
		s.newListAtResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (s *ServerTransport) dispatchNewListAtSubscriptionPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListAtSubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAtSubscriptionPager not implemented")}
	}
	newListAtSubscriptionPager := s.newListAtSubscriptionPager.get(req)
	if newListAtSubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deploymentStacks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := s.srv.NewListAtSubscriptionPager(nil)
		newListAtSubscriptionPager = &resp
		s.newListAtSubscriptionPager.add(req, newListAtSubscriptionPager)
		server.PagerResponderInjectNextLinks(newListAtSubscriptionPager, req, func(page *armdeploymentstacks.ClientListAtSubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAtSubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListAtSubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAtSubscriptionPager) {
		s.newListAtSubscriptionPager.remove(req)
	}
	return resp, nil
}
