//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsaas_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/saas/armsaas"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/saas/resource-manager/Microsoft.SaaS/preview/2018-03-01-beta/examples/saasSubscriptionLevel/SaasGetAllInAzureSubscription.json
func ExampleSubscriptionLevelClient_NewListByAzureSubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsaas.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSubscriptionLevelClient().NewListByAzureSubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ResourceResponseWithContinuation = armsaas.ResourceResponseWithContinuation{
		// 	Value: []*armsaas.Resource{
		// 		{
		// 			Name: to.Ptr("MyContosoSubscription"),
		// 			Type: to.Ptr("Microsoft.SaaS/resources"),
		// 			ID: to.Ptr("/subscriptions/c825645b-e31b-9cf4-1cee-2aba9e58bc7c/resourceGroups/my-saas-rg/providers/Microsoft.SaaS/resources/MyContosoSubscription"),
		// 			Properties: &armsaas.ResourceProperties{
		// 				AutoRenew: to.Ptr(true),
		// 				OfferID: to.Ptr("contosoOffer"),
		// 				PaymentChannelMetadata: map[string]*string{
		// 					"azureSubscriptionId": to.Ptr("c825645b-e31b-9cf4-1cee-2aba9e58bc7c"),
		// 					"resourceId": to.Ptr("263ebe8c-3621-4ac0-a6ba-f1419bfb9166"),
		// 				},
		// 				PaymentChannelType: to.Ptr(armsaas.PaymentChannelTypeSubscriptionDelegated),
		// 				PublisherID: to.Ptr("microsoft-contoso"),
		// 				SaasResourceName: to.Ptr("MyContosoSubscription"),
		// 				SKUID: to.Ptr("free"),
		// 				Created: to.Ptr("2021-01-01T08:30:10.1234567Z"),
		// 				IsFreeTrial: to.Ptr(false),
		// 				LastModified: to.Ptr("2020-01-01T08:35:05.7654321Z"),
		// 				Status: to.Ptr(armsaas.SaasResourceStatusSubscribed),
		// 				Term: &armsaas.PropertiesTerm{
		// 					EndDate: to.Ptr("2021-02-31T00:00:00Z"),
		// 					StartDate: to.Ptr("2021-01-01T00:00:00Z"),
		// 					TermUnit: to.Ptr("P1M"),
		// 				},
		// 			},
		// 			Tags: map[string]*string{
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/saas/resource-manager/Microsoft.SaaS/preview/2018-03-01-beta/examples/saasSubscriptionLevel/SaasGetAllInResourceGroup.json
func ExampleSubscriptionLevelClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsaas.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSubscriptionLevelClient().NewListByResourceGroupPager("my-saas-rg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ResourceResponseWithContinuation = armsaas.ResourceResponseWithContinuation{
		// 	Value: []*armsaas.Resource{
		// 		{
		// 			Name: to.Ptr("MyContosoSubscription"),
		// 			Type: to.Ptr("Microsoft.SaaS/resources"),
		// 			ID: to.Ptr("/subscriptions/c825645b-e31b-9cf4-1cee-2aba9e58bc7c/resourceGroups/my-saas-rg/providers/Microsoft.SaaS/resources/MyContosoSubscription"),
		// 			Properties: &armsaas.ResourceProperties{
		// 				AutoRenew: to.Ptr(true),
		// 				OfferID: to.Ptr("contosoOffer"),
		// 				PaymentChannelMetadata: map[string]*string{
		// 					"azureSubscriptionId": to.Ptr("c825645b-e31b-9cf4-1cee-2aba9e58bc7c"),
		// 					"resourceId": to.Ptr("263ebe8c-3621-4ac0-a6ba-f1419bfb9166"),
		// 				},
		// 				PaymentChannelType: to.Ptr(armsaas.PaymentChannelTypeSubscriptionDelegated),
		// 				PublisherID: to.Ptr("microsoft-contoso"),
		// 				SaasResourceName: to.Ptr("MyContosoSubscription"),
		// 				SKUID: to.Ptr("free"),
		// 				Created: to.Ptr("2021-01-01T08:30:10.1234567Z"),
		// 				IsFreeTrial: to.Ptr(false),
		// 				LastModified: to.Ptr("2020-01-01T08:35:05.7654321Z"),
		// 				Status: to.Ptr(armsaas.SaasResourceStatusSubscribed),
		// 				Term: &armsaas.PropertiesTerm{
		// 					EndDate: to.Ptr("2021-02-31T00:00:00Z"),
		// 					StartDate: to.Ptr("2021-01-01T00:00:00Z"),
		// 					TermUnit: to.Ptr("P1M"),
		// 				},
		// 			},
		// 			Tags: map[string]*string{
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/saas/resource-manager/Microsoft.SaaS/preview/2018-03-01-beta/examples/saasSubscriptionLevel/SaasGet.json
func ExampleSubscriptionLevelClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsaas.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSubscriptionLevelClient().Get(ctx, "my-saas-rg", "MyContosoSubscription", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Resource = armsaas.Resource{
	// 	Name: to.Ptr("MyContosoSubscription"),
	// 	Type: to.Ptr("Microsoft.SaaS/resources"),
	// 	ID: to.Ptr("/subscriptions/c825645b-e31b-9cf4-1cee-2aba9e58bc7c/resourceGroups/my-saas-rg/providers/Microsoft.SaaS/resources/MyContosoSubscription"),
	// 	Properties: &armsaas.ResourceProperties{
	// 		AutoRenew: to.Ptr(true),
	// 		OfferID: to.Ptr("contosoOffer"),
	// 		PaymentChannelMetadata: map[string]*string{
	// 			"azureSubscriptionId": to.Ptr("c825645b-e31b-9cf4-1cee-2aba9e58bc7c"),
	// 			"resourceId": to.Ptr("263ebe8c-3621-4ac0-a6ba-f1419bfb9166"),
	// 		},
	// 		PaymentChannelType: to.Ptr(armsaas.PaymentChannelTypeSubscriptionDelegated),
	// 		PublisherID: to.Ptr("microsoft-contoso"),
	// 		SaasResourceName: to.Ptr("MyContosoSubscription"),
	// 		SKUID: to.Ptr("free"),
	// 		Created: to.Ptr("2021-01-01T08:30:10.1234567Z"),
	// 		IsFreeTrial: to.Ptr(false),
	// 		LastModified: to.Ptr("2020-01-01T08:35:05.7654321Z"),
	// 		Status: to.Ptr(armsaas.SaasResourceStatusSubscribed),
	// 		Term: &armsaas.PropertiesTerm{
	// 			EndDate: to.Ptr("2021-02-31T00:00:00Z"),
	// 			StartDate: to.Ptr("2021-01-01T00:00:00Z"),
	// 			TermUnit: to.Ptr("P1M"),
	// 		},
	// 	},
	// 	Tags: map[string]*string{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/saas/resource-manager/Microsoft.SaaS/preview/2018-03-01-beta/examples/saasSubscriptionLevel/SaasPut.json
func ExampleSubscriptionLevelClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsaas.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSubscriptionLevelClient().BeginCreateOrUpdate(ctx, "my-saas-rg", "MyContosoSubscription", armsaas.ResourceCreation{
		Name:     to.Ptr("MyContosoSubscription"),
		Location: to.Ptr("global"),
		Properties: &armsaas.CreationProperties{
			OfferID: to.Ptr("contosoOffer"),
			PaymentChannelMetadata: map[string]*string{
				"AzureSubscriptionId": to.Ptr("155af98a-3205-47e7-883b-a2ab9db9f88d"),
			},
			PaymentChannelType: to.Ptr(armsaas.PaymentChannelTypeSubscriptionDelegated),
			PublisherID:        to.Ptr("microsoft-contoso"),
			SaasResourceName:   to.Ptr("MyContosoSubscription"),
			SKUID:              to.Ptr("free"),
			TermID:             to.Ptr("hjdtn7tfnxcy"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Resource = armsaas.Resource{
	// 	Name: to.Ptr("MyContosoSubscription"),
	// 	Type: to.Ptr("Microsoft.SaaS/resources"),
	// 	ID: to.Ptr("/subscriptions/c825645b-e31b-9cf4-1cee-2aba9e58bc7c/resourceGroups/my-saas-rg/providers/Microsoft.SaaS/resources/MyContosoSubscription"),
	// 	Properties: &armsaas.ResourceProperties{
	// 		AutoRenew: to.Ptr(true),
	// 		OfferID: to.Ptr("contosoOffer"),
	// 		PaymentChannelMetadata: map[string]*string{
	// 			"azureSubscriptionId": to.Ptr("c825645b-e31b-9cf4-1cee-2aba9e58bc7c"),
	// 			"resourceId": to.Ptr("263ebe8c-3621-4ac0-a6ba-f1419bfb9166"),
	// 		},
	// 		PaymentChannelType: to.Ptr(armsaas.PaymentChannelTypeSubscriptionDelegated),
	// 		PublisherID: to.Ptr("microsoft-contoso"),
	// 		SaasResourceName: to.Ptr("MyContosoSubscription"),
	// 		SKUID: to.Ptr("free"),
	// 		Created: to.Ptr("2021-01-01T08:30:10.1234567Z"),
	// 		IsFreeTrial: to.Ptr(false),
	// 		LastModified: to.Ptr("2020-01-01T08:35:05.7654321Z"),
	// 		Status: to.Ptr(armsaas.SaasResourceStatusSubscribed),
	// 		Term: &armsaas.PropertiesTerm{
	// 			EndDate: to.Ptr("2021-02-31T00:00:00Z"),
	// 			StartDate: to.Ptr("2021-01-01T00:00:00Z"),
	// 			TermUnit: to.Ptr("P1M"),
	// 		},
	// 	},
	// 	Tags: map[string]*string{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/saas/resource-manager/Microsoft.SaaS/preview/2018-03-01-beta/examples/saasSubscriptionLevel/SaasPatch.json
func ExampleSubscriptionLevelClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsaas.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSubscriptionLevelClient().BeginUpdate(ctx, "my-saas-rg", "MyContosoSubscription", armsaas.ResourceCreation{
		Properties: &armsaas.CreationProperties{
			SKUID: to.Ptr("premium"),
		},
		Tags: map[string]*string{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Resource = armsaas.Resource{
	// 	Name: to.Ptr("MyContosoSubscription"),
	// 	Type: to.Ptr("Microsoft.SaaS/resources"),
	// 	ID: to.Ptr("/subscriptions/c825645b-e31b-9cf4-1cee-2aba9e58bc7c/resourceGroups/my-saas-rg/providers/Microsoft.SaaS/resources/MyContosoSubscription"),
	// 	Properties: &armsaas.ResourceProperties{
	// 		AutoRenew: to.Ptr(true),
	// 		OfferID: to.Ptr("contosoOffer"),
	// 		PaymentChannelMetadata: map[string]*string{
	// 			"azureSubscriptionId": to.Ptr("c825645b-e31b-9cf4-1cee-2aba9e58bc7c"),
	// 			"resourceId": to.Ptr("263ebe8c-3621-4ac0-a6ba-f1419bfb9166"),
	// 		},
	// 		PaymentChannelType: to.Ptr(armsaas.PaymentChannelTypeSubscriptionDelegated),
	// 		PublisherID: to.Ptr("microsoft-contoso"),
	// 		SaasResourceName: to.Ptr("MyContosoSubscription"),
	// 		SKUID: to.Ptr("free"),
	// 		Created: to.Ptr("2021-01-01T08:30:10.1234567Z"),
	// 		IsFreeTrial: to.Ptr(false),
	// 		LastModified: to.Ptr("2020-01-01T08:35:05.7654321Z"),
	// 		Status: to.Ptr(armsaas.SaasResourceStatusSubscribed),
	// 		Term: &armsaas.PropertiesTerm{
	// 			EndDate: to.Ptr("2021-02-31T00:00:00Z"),
	// 			StartDate: to.Ptr("2021-01-01T00:00:00Z"),
	// 			TermUnit: to.Ptr("P1M"),
	// 		},
	// 	},
	// 	Tags: map[string]*string{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/saas/resource-manager/Microsoft.SaaS/preview/2018-03-01-beta/examples/saasSubscriptionLevel/SaasDelete.json
func ExampleSubscriptionLevelClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsaas.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSubscriptionLevelClient().BeginDelete(ctx, "my-saas-rg", "MyContosoSubscription", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/saas/resource-manager/Microsoft.SaaS/preview/2018-03-01-beta/examples/saasSubscriptionLevel/SaasUnsubscribe.json
func ExampleSubscriptionLevelClient_BeginUpdateToUnsubscribed() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsaas.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSubscriptionLevelClient().BeginUpdateToUnsubscribed(ctx, "my-saas-rg", "MyContosoSubscription", armsaas.DeleteOptions{
		Feedback:        to.Ptr("No longer need this SaaS"),
		ReasonCode:      to.Ptr[float32](0),
		UnsubscribeOnly: to.Ptr(true),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/saas/resource-manager/Microsoft.SaaS/preview/2018-03-01-beta/examples/saasSubscriptionLevel/ListAccessTokenPost.json
func ExampleSubscriptionLevelClient_ListAccessToken() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsaas.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSubscriptionLevelClient().ListAccessToken(ctx, "my-saas-rg", "MyContosoSubscription", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccessTokenResult = armsaas.AccessTokenResult{
	// 	PublisherOfferBaseURI: to.Ptr("https://contoso.website.com/api/v1/marketplace/azure/common/auth"),
	// 	Token: to.Ptr("jyhAtr3AiFTXO0QsEkYizsNzqIAUJ+E0M1SXhl4E5hwAl7+GJT6t+dEwuWpSizgR0Vn6dMhzpS94JRzkUh2Xuq5L1QDgmDkDUeIikTFNviwtwxtF8CwipcB49rq5d8whmVp0CmWEjd/FzU0vvlikBRuy+asxC1UhXv6XxBkSxkZKj29AAFiGgsgRvXIld47C"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/saas/resource-manager/Microsoft.SaaS/preview/2018-03-01-beta/examples/saasSubscriptionLevel/ValidateResourceMove.json
func ExampleSubscriptionLevelClient_ValidateMoveResources() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsaas.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewSubscriptionLevelClient().ValidateMoveResources(ctx, "my-saas-rg", armsaas.MoveResource{
		Resources: []*string{
			to.Ptr("/subscriptions/c825645b-e31b-9cf4-1cee-2aba9e58bc7c/resourceGroups/my-saas-rg/providers/Microsoft.SaaS/resources/saas1"),
			to.Ptr("/subscriptions/c825645b-e31b-9cf4-1cee-2aba9e58bc7c/resourceGroups/my-saas-rg/providers/Microsoft.SaaS/resources/saas2"),
			to.Ptr("/subscriptions/c825645b-e31b-9cf4-1cee-2aba9e58bc7c/resourceGroups/my-saas-rg/providers/Microsoft.SaaS/resources/saas3")},
		TargetResourceGroup: to.Ptr("/subscriptions/5122d0a3-1e10-4baf-bdc5-c2a452489525/resourceGroups/new-saas-rg"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/saas/resource-manager/Microsoft.SaaS/preview/2018-03-01-beta/examples/saasSubscriptionLevel/ResourceMove.json
func ExampleSubscriptionLevelClient_BeginMoveResources() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsaas.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSubscriptionLevelClient().BeginMoveResources(ctx, "my-saas-rg", armsaas.MoveResource{
		Resources: []*string{
			to.Ptr("/subscriptions/c825645b-e31b-9cf4-1cee-2aba9e58bc7c/resourceGroups/my-saas-rg/providers/Microsoft.SaaS/resources/saas1"),
			to.Ptr("/subscriptions/c825645b-e31b-9cf4-1cee-2aba9e58bc7c/resourceGroups/my-saas-rg/providers/Microsoft.SaaS/resources/saas2"),
			to.Ptr("/subscriptions/c825645b-e31b-9cf4-1cee-2aba9e58bc7c/resourceGroups/my-saas-rg/providers/Microsoft.SaaS/resources/saas3")},
		TargetResourceGroup: to.Ptr("/subscriptions/5122d0a3-1e10-4baf-bdc5-c2a452489525/resourceGroups/new-saas-rg"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
