//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// LedgerDigestUploadsServer is a fake server for instances of the armsql.LedgerDigestUploadsClient type.
type LedgerDigestUploadsServer struct {
	// BeginCreateOrUpdate is the fake for method LedgerDigestUploadsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ledgerDigestUploads armsql.LedgerDigestUploadsName, parameters armsql.LedgerDigestUploads, options *armsql.LedgerDigestUploadsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsql.LedgerDigestUploadsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDisable is the fake for method LedgerDigestUploadsClient.BeginDisable
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDisable func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ledgerDigestUploads armsql.LedgerDigestUploadsName, options *armsql.LedgerDigestUploadsClientBeginDisableOptions) (resp azfake.PollerResponder[armsql.LedgerDigestUploadsClientDisableResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method LedgerDigestUploadsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ledgerDigestUploads armsql.LedgerDigestUploadsName, options *armsql.LedgerDigestUploadsClientGetOptions) (resp azfake.Responder[armsql.LedgerDigestUploadsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDatabasePager is the fake for method LedgerDigestUploadsClient.NewListByDatabasePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDatabasePager func(resourceGroupName string, serverName string, databaseName string, options *armsql.LedgerDigestUploadsClientListByDatabaseOptions) (resp azfake.PagerResponder[armsql.LedgerDigestUploadsClientListByDatabaseResponse])
}

// NewLedgerDigestUploadsServerTransport creates a new instance of LedgerDigestUploadsServerTransport with the provided implementation.
// The returned LedgerDigestUploadsServerTransport instance is connected to an instance of armsql.LedgerDigestUploadsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLedgerDigestUploadsServerTransport(srv *LedgerDigestUploadsServer) *LedgerDigestUploadsServerTransport {
	return &LedgerDigestUploadsServerTransport{
		srv:                    srv,
		beginCreateOrUpdate:    newTracker[azfake.PollerResponder[armsql.LedgerDigestUploadsClientCreateOrUpdateResponse]](),
		beginDisable:           newTracker[azfake.PollerResponder[armsql.LedgerDigestUploadsClientDisableResponse]](),
		newListByDatabasePager: newTracker[azfake.PagerResponder[armsql.LedgerDigestUploadsClientListByDatabaseResponse]](),
	}
}

// LedgerDigestUploadsServerTransport connects instances of armsql.LedgerDigestUploadsClient to instances of LedgerDigestUploadsServer.
// Don't use this type directly, use NewLedgerDigestUploadsServerTransport instead.
type LedgerDigestUploadsServerTransport struct {
	srv                    *LedgerDigestUploadsServer
	beginCreateOrUpdate    *tracker[azfake.PollerResponder[armsql.LedgerDigestUploadsClientCreateOrUpdateResponse]]
	beginDisable           *tracker[azfake.PollerResponder[armsql.LedgerDigestUploadsClientDisableResponse]]
	newListByDatabasePager *tracker[azfake.PagerResponder[armsql.LedgerDigestUploadsClientListByDatabaseResponse]]
}

// Do implements the policy.Transporter interface for LedgerDigestUploadsServerTransport.
func (l *LedgerDigestUploadsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LedgerDigestUploadsClient.BeginCreateOrUpdate":
		resp, err = l.dispatchBeginCreateOrUpdate(req)
	case "LedgerDigestUploadsClient.BeginDisable":
		resp, err = l.dispatchBeginDisable(req)
	case "LedgerDigestUploadsClient.Get":
		resp, err = l.dispatchGet(req)
	case "LedgerDigestUploadsClient.NewListByDatabasePager":
		resp, err = l.dispatchNewListByDatabasePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LedgerDigestUploadsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if l.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := l.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ledgerDigestUploads/(?P<ledgerDigestUploads>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.LedgerDigestUploads](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		ledgerDigestUploadsParam, err := parseWithCast(matches[regex.SubexpIndex("ledgerDigestUploads")], func(v string) (armsql.LedgerDigestUploadsName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.LedgerDigestUploadsName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, ledgerDigestUploadsParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		l.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		l.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (l *LedgerDigestUploadsServerTransport) dispatchBeginDisable(req *http.Request) (*http.Response, error) {
	if l.srv.BeginDisable == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDisable not implemented")}
	}
	beginDisable := l.beginDisable.get(req)
	if beginDisable == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ledgerDigestUploads/(?P<ledgerDigestUploads>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disable`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		ledgerDigestUploadsParam, err := parseWithCast(matches[regex.SubexpIndex("ledgerDigestUploads")], func(v string) (armsql.LedgerDigestUploadsName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.LedgerDigestUploadsName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginDisable(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, ledgerDigestUploadsParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDisable = &respr
		l.beginDisable.add(req, beginDisable)
	}

	resp, err := server.PollerResponderNext(beginDisable, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginDisable.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDisable) {
		l.beginDisable.remove(req)
	}

	return resp, nil
}

func (l *LedgerDigestUploadsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if l.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ledgerDigestUploads/(?P<ledgerDigestUploads>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	ledgerDigestUploadsParam, err := parseWithCast(matches[regex.SubexpIndex("ledgerDigestUploads")], func(v string) (armsql.LedgerDigestUploadsName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.LedgerDigestUploadsName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, ledgerDigestUploadsParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LedgerDigestUploads, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LedgerDigestUploadsServerTransport) dispatchNewListByDatabasePager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByDatabasePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDatabasePager not implemented")}
	}
	newListByDatabasePager := l.newListByDatabasePager.get(req)
	if newListByDatabasePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ledgerDigestUploads`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListByDatabasePager(resourceGroupNameParam, serverNameParam, databaseNameParam, nil)
		newListByDatabasePager = &resp
		l.newListByDatabasePager.add(req, newListByDatabasePager)
		server.PagerResponderInjectNextLinks(newListByDatabasePager, req, func(page *armsql.LedgerDigestUploadsClientListByDatabaseResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDatabasePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByDatabasePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDatabasePager) {
		l.newListByDatabasePager.remove(req)
	}
	return resp, nil
}
