//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple1200series/armstorsimple1200series"
	"net/http"
	"net/url"
	"regexp"
)

// DevicesServer is a fake server for instances of the armstorsimple1200series.DevicesClient type.
type DevicesServer struct {
	// BeginCreateOrUpdateAlertSettings is the fake for method DevicesClient.BeginCreateOrUpdateAlertSettings
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdateAlertSettings func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, alertSettings armstorsimple1200series.AlertSettings, options *armstorsimple1200series.DevicesClientBeginCreateOrUpdateAlertSettingsOptions) (resp azfake.PollerResponder[armstorsimple1200series.DevicesClientCreateOrUpdateAlertSettingsResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateSecuritySettings is the fake for method DevicesClient.BeginCreateOrUpdateSecuritySettings
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginCreateOrUpdateSecuritySettings func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, securitySettings armstorsimple1200series.SecuritySettings, options *armstorsimple1200series.DevicesClientBeginCreateOrUpdateSecuritySettingsOptions) (resp azfake.PollerResponder[armstorsimple1200series.DevicesClientCreateOrUpdateSecuritySettingsResponse], errResp azfake.ErrorResponder)

	// BeginDeactivate is the fake for method DevicesClient.BeginDeactivate
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeactivate func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple1200series.DevicesClientBeginDeactivateOptions) (resp azfake.PollerResponder[armstorsimple1200series.DevicesClientDeactivateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method DevicesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple1200series.DevicesClientBeginDeleteOptions) (resp azfake.PollerResponder[armstorsimple1200series.DevicesClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDownloadUpdates is the fake for method DevicesClient.BeginDownloadUpdates
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDownloadUpdates func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple1200series.DevicesClientBeginDownloadUpdatesOptions) (resp azfake.PollerResponder[armstorsimple1200series.DevicesClientDownloadUpdatesResponse], errResp azfake.ErrorResponder)

	// BeginFailover is the fake for method DevicesClient.BeginFailover
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginFailover func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, failoverRequest armstorsimple1200series.FailoverRequest, options *armstorsimple1200series.DevicesClientBeginFailoverOptions) (resp azfake.PollerResponder[armstorsimple1200series.DevicesClientFailoverResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DevicesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple1200series.DevicesClientGetOptions) (resp azfake.Responder[armstorsimple1200series.DevicesClientGetResponse], errResp azfake.ErrorResponder)

	// GetAlertSettings is the fake for method DevicesClient.GetAlertSettings
	// HTTP status codes to indicate success: http.StatusOK
	GetAlertSettings func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple1200series.DevicesClientGetAlertSettingsOptions) (resp azfake.Responder[armstorsimple1200series.DevicesClientGetAlertSettingsResponse], errResp azfake.ErrorResponder)

	// GetNetworkSettings is the fake for method DevicesClient.GetNetworkSettings
	// HTTP status codes to indicate success: http.StatusOK
	GetNetworkSettings func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple1200series.DevicesClientGetNetworkSettingsOptions) (resp azfake.Responder[armstorsimple1200series.DevicesClientGetNetworkSettingsResponse], errResp azfake.ErrorResponder)

	// GetTimeSettings is the fake for method DevicesClient.GetTimeSettings
	// HTTP status codes to indicate success: http.StatusOK
	GetTimeSettings func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple1200series.DevicesClientGetTimeSettingsOptions) (resp azfake.Responder[armstorsimple1200series.DevicesClientGetTimeSettingsResponse], errResp azfake.ErrorResponder)

	// GetUpdateSummary is the fake for method DevicesClient.GetUpdateSummary
	// HTTP status codes to indicate success: http.StatusOK
	GetUpdateSummary func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple1200series.DevicesClientGetUpdateSummaryOptions) (resp azfake.Responder[armstorsimple1200series.DevicesClientGetUpdateSummaryResponse], errResp azfake.ErrorResponder)

	// BeginInstallUpdates is the fake for method DevicesClient.BeginInstallUpdates
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginInstallUpdates func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple1200series.DevicesClientBeginInstallUpdatesOptions) (resp azfake.PollerResponder[armstorsimple1200series.DevicesClientInstallUpdatesResponse], errResp azfake.ErrorResponder)

	// NewListByManagerPager is the fake for method DevicesClient.NewListByManagerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByManagerPager func(resourceGroupName string, managerName string, options *armstorsimple1200series.DevicesClientListByManagerOptions) (resp azfake.PagerResponder[armstorsimple1200series.DevicesClientListByManagerResponse])

	// NewListFailoverTargetPager is the fake for method DevicesClient.NewListFailoverTargetPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListFailoverTargetPager func(deviceName string, resourceGroupName string, managerName string, options *armstorsimple1200series.DevicesClientListFailoverTargetOptions) (resp azfake.PagerResponder[armstorsimple1200series.DevicesClientListFailoverTargetResponse])

	// NewListMetricDefinitionPager is the fake for method DevicesClient.NewListMetricDefinitionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricDefinitionPager func(deviceName string, resourceGroupName string, managerName string, options *armstorsimple1200series.DevicesClientListMetricDefinitionOptions) (resp azfake.PagerResponder[armstorsimple1200series.DevicesClientListMetricDefinitionResponse])

	// NewListMetricsPager is the fake for method DevicesClient.NewListMetricsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricsPager func(deviceName string, resourceGroupName string, managerName string, options *armstorsimple1200series.DevicesClientListMetricsOptions) (resp azfake.PagerResponder[armstorsimple1200series.DevicesClientListMetricsResponse])

	// BeginPatch is the fake for method DevicesClient.BeginPatch
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPatch func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, devicePatch armstorsimple1200series.DevicePatch, options *armstorsimple1200series.DevicesClientBeginPatchOptions) (resp azfake.PollerResponder[armstorsimple1200series.DevicesClientPatchResponse], errResp azfake.ErrorResponder)

	// BeginScanForUpdates is the fake for method DevicesClient.BeginScanForUpdates
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginScanForUpdates func(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *armstorsimple1200series.DevicesClientBeginScanForUpdatesOptions) (resp azfake.PollerResponder[armstorsimple1200series.DevicesClientScanForUpdatesResponse], errResp azfake.ErrorResponder)
}

// NewDevicesServerTransport creates a new instance of DevicesServerTransport with the provided implementation.
// The returned DevicesServerTransport instance is connected to an instance of armstorsimple1200series.DevicesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDevicesServerTransport(srv *DevicesServer) *DevicesServerTransport {
	return &DevicesServerTransport{
		srv:                                 srv,
		beginCreateOrUpdateAlertSettings:    newTracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientCreateOrUpdateAlertSettingsResponse]](),
		beginCreateOrUpdateSecuritySettings: newTracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientCreateOrUpdateSecuritySettingsResponse]](),
		beginDeactivate:                     newTracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientDeactivateResponse]](),
		beginDelete:                         newTracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientDeleteResponse]](),
		beginDownloadUpdates:                newTracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientDownloadUpdatesResponse]](),
		beginFailover:                       newTracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientFailoverResponse]](),
		beginInstallUpdates:                 newTracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientInstallUpdatesResponse]](),
		newListByManagerPager:               newTracker[azfake.PagerResponder[armstorsimple1200series.DevicesClientListByManagerResponse]](),
		newListFailoverTargetPager:          newTracker[azfake.PagerResponder[armstorsimple1200series.DevicesClientListFailoverTargetResponse]](),
		newListMetricDefinitionPager:        newTracker[azfake.PagerResponder[armstorsimple1200series.DevicesClientListMetricDefinitionResponse]](),
		newListMetricsPager:                 newTracker[azfake.PagerResponder[armstorsimple1200series.DevicesClientListMetricsResponse]](),
		beginPatch:                          newTracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientPatchResponse]](),
		beginScanForUpdates:                 newTracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientScanForUpdatesResponse]](),
	}
}

// DevicesServerTransport connects instances of armstorsimple1200series.DevicesClient to instances of DevicesServer.
// Don't use this type directly, use NewDevicesServerTransport instead.
type DevicesServerTransport struct {
	srv                                 *DevicesServer
	beginCreateOrUpdateAlertSettings    *tracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientCreateOrUpdateAlertSettingsResponse]]
	beginCreateOrUpdateSecuritySettings *tracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientCreateOrUpdateSecuritySettingsResponse]]
	beginDeactivate                     *tracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientDeactivateResponse]]
	beginDelete                         *tracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientDeleteResponse]]
	beginDownloadUpdates                *tracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientDownloadUpdatesResponse]]
	beginFailover                       *tracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientFailoverResponse]]
	beginInstallUpdates                 *tracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientInstallUpdatesResponse]]
	newListByManagerPager               *tracker[azfake.PagerResponder[armstorsimple1200series.DevicesClientListByManagerResponse]]
	newListFailoverTargetPager          *tracker[azfake.PagerResponder[armstorsimple1200series.DevicesClientListFailoverTargetResponse]]
	newListMetricDefinitionPager        *tracker[azfake.PagerResponder[armstorsimple1200series.DevicesClientListMetricDefinitionResponse]]
	newListMetricsPager                 *tracker[azfake.PagerResponder[armstorsimple1200series.DevicesClientListMetricsResponse]]
	beginPatch                          *tracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientPatchResponse]]
	beginScanForUpdates                 *tracker[azfake.PollerResponder[armstorsimple1200series.DevicesClientScanForUpdatesResponse]]
}

// Do implements the policy.Transporter interface for DevicesServerTransport.
func (d *DevicesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DevicesClient.BeginCreateOrUpdateAlertSettings":
		resp, err = d.dispatchBeginCreateOrUpdateAlertSettings(req)
	case "DevicesClient.BeginCreateOrUpdateSecuritySettings":
		resp, err = d.dispatchBeginCreateOrUpdateSecuritySettings(req)
	case "DevicesClient.BeginDeactivate":
		resp, err = d.dispatchBeginDeactivate(req)
	case "DevicesClient.BeginDelete":
		resp, err = d.dispatchBeginDelete(req)
	case "DevicesClient.BeginDownloadUpdates":
		resp, err = d.dispatchBeginDownloadUpdates(req)
	case "DevicesClient.BeginFailover":
		resp, err = d.dispatchBeginFailover(req)
	case "DevicesClient.Get":
		resp, err = d.dispatchGet(req)
	case "DevicesClient.GetAlertSettings":
		resp, err = d.dispatchGetAlertSettings(req)
	case "DevicesClient.GetNetworkSettings":
		resp, err = d.dispatchGetNetworkSettings(req)
	case "DevicesClient.GetTimeSettings":
		resp, err = d.dispatchGetTimeSettings(req)
	case "DevicesClient.GetUpdateSummary":
		resp, err = d.dispatchGetUpdateSummary(req)
	case "DevicesClient.BeginInstallUpdates":
		resp, err = d.dispatchBeginInstallUpdates(req)
	case "DevicesClient.NewListByManagerPager":
		resp, err = d.dispatchNewListByManagerPager(req)
	case "DevicesClient.NewListFailoverTargetPager":
		resp, err = d.dispatchNewListFailoverTargetPager(req)
	case "DevicesClient.NewListMetricDefinitionPager":
		resp, err = d.dispatchNewListMetricDefinitionPager(req)
	case "DevicesClient.NewListMetricsPager":
		resp, err = d.dispatchNewListMetricsPager(req)
	case "DevicesClient.BeginPatch":
		resp, err = d.dispatchBeginPatch(req)
	case "DevicesClient.BeginScanForUpdates":
		resp, err = d.dispatchBeginScanForUpdates(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginCreateOrUpdateAlertSettings(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdateAlertSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateAlertSettings not implemented")}
	}
	beginCreateOrUpdateAlertSettings := d.beginCreateOrUpdateAlertSettings.get(req)
	if beginCreateOrUpdateAlertSettings == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alertSettings/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorsimple1200series.AlertSettings](req)
		if err != nil {
			return nil, err
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdateAlertSettings(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateAlertSettings = &respr
		d.beginCreateOrUpdateAlertSettings.add(req, beginCreateOrUpdateAlertSettings)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateAlertSettings, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginCreateOrUpdateAlertSettings.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateAlertSettings) {
		d.beginCreateOrUpdateAlertSettings.remove(req)
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginCreateOrUpdateSecuritySettings(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdateSecuritySettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateSecuritySettings not implemented")}
	}
	beginCreateOrUpdateSecuritySettings := d.beginCreateOrUpdateSecuritySettings.get(req)
	if beginCreateOrUpdateSecuritySettings == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/securitySettings/default/update`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorsimple1200series.SecuritySettings](req)
		if err != nil {
			return nil, err
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdateSecuritySettings(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateSecuritySettings = &respr
		d.beginCreateOrUpdateSecuritySettings.add(req, beginCreateOrUpdateSecuritySettings)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateSecuritySettings, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginCreateOrUpdateSecuritySettings.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateSecuritySettings) {
		d.beginCreateOrUpdateSecuritySettings.remove(req)
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginDeactivate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDeactivate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeactivate not implemented")}
	}
	beginDeactivate := d.beginDeactivate.get(req)
	if beginDeactivate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deactivate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDeactivate(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeactivate = &respr
		d.beginDeactivate.add(req, beginDeactivate)
	}

	resp, err := server.PollerResponderNext(beginDeactivate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDeactivate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeactivate) {
		d.beginDeactivate.remove(req)
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := d.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDelete(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		d.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		d.beginDelete.remove(req)
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginDownloadUpdates(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDownloadUpdates == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDownloadUpdates not implemented")}
	}
	beginDownloadUpdates := d.beginDownloadUpdates.get(req)
	if beginDownloadUpdates == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/download`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDownloadUpdates(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDownloadUpdates = &respr
		d.beginDownloadUpdates.add(req, beginDownloadUpdates)
	}

	resp, err := server.PollerResponderNext(beginDownloadUpdates, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDownloadUpdates.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDownloadUpdates) {
		d.beginDownloadUpdates.remove(req)
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginFailover(req *http.Request) (*http.Response, error) {
	if d.srv.BeginFailover == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginFailover not implemented")}
	}
	beginFailover := d.beginFailover.get(req)
	if beginFailover == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failover`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorsimple1200series.FailoverRequest](req)
		if err != nil {
			return nil, err
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginFailover(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginFailover = &respr
		d.beginFailover.add(req, beginFailover)
	}

	resp, err := server.PollerResponderNext(beginFailover, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginFailover.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginFailover) {
		d.beginFailover.remove(req)
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armstorsimple1200series.DevicesClientGetOptions
	if expandParam != nil {
		options = &armstorsimple1200series.DevicesClientGetOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := d.srv.Get(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Device, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchGetAlertSettings(req *http.Request) (*http.Response, error) {
	if d.srv.GetAlertSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAlertSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alertSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetAlertSettings(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AlertSettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchGetNetworkSettings(req *http.Request) (*http.Response, error) {
	if d.srv.GetNetworkSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetNetworkSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetNetworkSettings(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkSettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchGetTimeSettings(req *http.Request) (*http.Response, error) {
	if d.srv.GetTimeSettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetTimeSettings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/timeSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetTimeSettings(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TimeSettings, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchGetUpdateSummary(req *http.Request) (*http.Response, error) {
	if d.srv.GetUpdateSummary == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetUpdateSummary not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateSummary/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetUpdateSummary(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Updates, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginInstallUpdates(req *http.Request) (*http.Response, error) {
	if d.srv.BeginInstallUpdates == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginInstallUpdates not implemented")}
	}
	beginInstallUpdates := d.beginInstallUpdates.get(req)
	if beginInstallUpdates == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/install`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginInstallUpdates(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginInstallUpdates = &respr
		d.beginInstallUpdates.add(req, beginInstallUpdates)
	}

	resp, err := server.PollerResponderNext(beginInstallUpdates, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginInstallUpdates.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginInstallUpdates) {
		d.beginInstallUpdates.remove(req)
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchNewListByManagerPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByManagerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByManagerPager not implemented")}
	}
	newListByManagerPager := d.newListByManagerPager.get(req)
	if newListByManagerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		var options *armstorsimple1200series.DevicesClientListByManagerOptions
		if expandParam != nil {
			options = &armstorsimple1200series.DevicesClientListByManagerOptions{
				Expand: expandParam,
			}
		}
		resp := d.srv.NewListByManagerPager(resourceGroupNameParam, managerNameParam, options)
		newListByManagerPager = &resp
		d.newListByManagerPager.add(req, newListByManagerPager)
	}
	resp, err := server.PagerResponderNext(newListByManagerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByManagerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByManagerPager) {
		d.newListByManagerPager.remove(req)
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchNewListFailoverTargetPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListFailoverTargetPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListFailoverTargetPager not implemented")}
	}
	newListFailoverTargetPager := d.newListFailoverTargetPager.get(req)
	if newListFailoverTargetPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failoverTargets`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		var options *armstorsimple1200series.DevicesClientListFailoverTargetOptions
		if expandParam != nil {
			options = &armstorsimple1200series.DevicesClientListFailoverTargetOptions{
				Expand: expandParam,
			}
		}
		resp := d.srv.NewListFailoverTargetPager(deviceNameParam, resourceGroupNameParam, managerNameParam, options)
		newListFailoverTargetPager = &resp
		d.newListFailoverTargetPager.add(req, newListFailoverTargetPager)
	}
	resp, err := server.PagerResponderNext(newListFailoverTargetPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListFailoverTargetPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListFailoverTargetPager) {
		d.newListFailoverTargetPager.remove(req)
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchNewListMetricDefinitionPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListMetricDefinitionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricDefinitionPager not implemented")}
	}
	newListMetricDefinitionPager := d.newListMetricDefinitionPager.get(req)
	if newListMetricDefinitionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metricsDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListMetricDefinitionPager(deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
		newListMetricDefinitionPager = &resp
		d.newListMetricDefinitionPager.add(req, newListMetricDefinitionPager)
	}
	resp, err := server.PagerResponderNext(newListMetricDefinitionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListMetricDefinitionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricDefinitionPager) {
		d.newListMetricDefinitionPager.remove(req)
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchNewListMetricsPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListMetricsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricsPager not implemented")}
	}
	newListMetricsPager := d.newListMetricsPager.get(req)
	if newListMetricsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metrics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armstorsimple1200series.DevicesClientListMetricsOptions
		if filterParam != nil {
			options = &armstorsimple1200series.DevicesClientListMetricsOptions{
				Filter: filterParam,
			}
		}
		resp := d.srv.NewListMetricsPager(deviceNameParam, resourceGroupNameParam, managerNameParam, options)
		newListMetricsPager = &resp
		d.newListMetricsPager.add(req, newListMetricsPager)
	}
	resp, err := server.PagerResponderNext(newListMetricsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListMetricsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricsPager) {
		d.newListMetricsPager.remove(req)
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginPatch(req *http.Request) (*http.Response, error) {
	if d.srv.BeginPatch == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPatch not implemented")}
	}
	beginPatch := d.beginPatch.get(req)
	if beginPatch == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorsimple1200series.DevicePatch](req)
		if err != nil {
			return nil, err
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginPatch(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPatch = &respr
		d.beginPatch.add(req, beginPatch)
	}

	resp, err := server.PollerResponderNext(beginPatch, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginPatch.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPatch) {
		d.beginPatch.remove(req)
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchBeginScanForUpdates(req *http.Request) (*http.Response, error) {
	if d.srv.BeginScanForUpdates == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginScanForUpdates not implemented")}
	}
	beginScanForUpdates := d.beginScanForUpdates.get(req)
	if beginScanForUpdates == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scanForUpdates`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginScanForUpdates(req.Context(), deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginScanForUpdates = &respr
		d.beginScanForUpdates.add(req, beginScanForUpdates)
	}

	resp, err := server.PollerResponderNext(beginScanForUpdates, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginScanForUpdates.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginScanForUpdates) {
		d.beginScanForUpdates.remove(req)
	}

	return resp, nil
}
