//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsynapse

import "encoding/json"

func unmarshalCustomSetupBaseClassification(rawMsg json.RawMessage) (CustomSetupBaseClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b CustomSetupBaseClassification
	switch m["type"] {
	case "CmdkeySetup":
		b = &CmdkeySetup{}
	case "ComponentSetup":
		b = &ComponentSetup{}
	case "EnvironmentVariableSetup":
		b = &EnvironmentVariableSetup{}
	default:
		b = &CustomSetupBase{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalCustomSetupBaseClassificationArray(rawMsg json.RawMessage) ([]CustomSetupBaseClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]CustomSetupBaseClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalCustomSetupBaseClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalDataConnectionClassification(rawMsg json.RawMessage) (DataConnectionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b DataConnectionClassification
	switch m["kind"] {
	case string(DataConnectionKindEventGrid):
		b = &EventGridDataConnection{}
	case string(DataConnectionKindEventHub):
		b = &EventHubDataConnection{}
	case string(DataConnectionKindIotHub):
		b = &IotHubDataConnection{}
	default:
		b = &DataConnection{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalDataConnectionClassificationArray(rawMsg json.RawMessage) ([]DataConnectionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]DataConnectionClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalDataConnectionClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalDatabaseClassification(rawMsg json.RawMessage) (DatabaseClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b DatabaseClassification
	switch m["kind"] {
	case string(KindReadOnlyFollowing):
		b = &ReadOnlyFollowingDatabase{}
	case string(KindReadWrite):
		b = &ReadWriteDatabase{}
	default:
		b = &Database{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalDatabaseClassificationArray(rawMsg json.RawMessage) ([]DatabaseClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]DatabaseClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalDatabaseClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalIntegrationRuntimeClassification(rawMsg json.RawMessage) (IntegrationRuntimeClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b IntegrationRuntimeClassification
	switch m["type"] {
	case string(IntegrationRuntimeTypeManaged):
		b = &ManagedIntegrationRuntime{}
	case string(IntegrationRuntimeTypeSelfHosted):
		b = &SelfHostedIntegrationRuntime{}
	default:
		b = &IntegrationRuntime{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalIntegrationRuntimeStatusClassification(rawMsg json.RawMessage) (IntegrationRuntimeStatusClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b IntegrationRuntimeStatusClassification
	switch m["type"] {
	case string(IntegrationRuntimeTypeManaged):
		b = &ManagedIntegrationRuntimeStatus{}
	case string(IntegrationRuntimeTypeSelfHosted):
		b = &SelfHostedIntegrationRuntimeStatus{}
	default:
		b = &IntegrationRuntimeStatus{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalLinkedIntegrationRuntimeTypeClassification(rawMsg json.RawMessage) (LinkedIntegrationRuntimeTypeClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b LinkedIntegrationRuntimeTypeClassification
	switch m["authorizationType"] {
	case "Key":
		b = &LinkedIntegrationRuntimeKeyAuthorization{}
	case "RBAC":
		b = &LinkedIntegrationRuntimeRbacAuthorization{}
	default:
		b = &LinkedIntegrationRuntimeType{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalSecretBaseClassification(rawMsg json.RawMessage) (SecretBaseClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b SecretBaseClassification
	switch m["type"] {
	case "SecureString":
		b = &SecureString{}
	default:
		b = &SecretBase{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalSsisObjectMetadataClassification(rawMsg json.RawMessage) (SsisObjectMetadataClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b SsisObjectMetadataClassification
	switch m["type"] {
	case string(SsisObjectMetadataTypeEnvironment):
		b = &SsisEnvironment{}
	case string(SsisObjectMetadataTypeFolder):
		b = &SsisFolder{}
	case string(SsisObjectMetadataTypePackage):
		b = &SsisPackage{}
	case string(SsisObjectMetadataTypeProject):
		b = &SsisProject{}
	default:
		b = &SsisObjectMetadata{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalSsisObjectMetadataClassificationArray(rawMsg json.RawMessage) ([]SsisObjectMetadataClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]SsisObjectMetadataClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalSsisObjectMetadataClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}
