//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armvoiceservices_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/voiceservices/armvoiceservices"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aa85f59e259c4b12197b57b221067c40fa2fe3f1/specification/voiceservices/resource-manager/Microsoft.VoiceServices/stable/2023-01-31/examples/CommunicationsGateways_ListBySubscription.json
func ExampleCommunicationsGatewaysClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvoiceservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCommunicationsGatewaysClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CommunicationsGatewayListResult = armvoiceservices.CommunicationsGatewayListResult{
		// 	Value: []*armvoiceservices.CommunicationsGateway{
		// 		{
		// 			Name: to.Ptr("myname"),
		// 			Type: to.Ptr("Microsoft.VoiceService/communicationsGateways"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.VoiceService/communicationsGateways/myname"),
		// 			Location: to.Ptr("useast"),
		// 			Properties: &armvoiceservices.CommunicationsGatewayProperties{
		// 				AutoGeneratedDomainNameLabel: to.Ptr("somelabel"),
		// 				AutoGeneratedDomainNameLabelScope: to.Ptr(armvoiceservices.AutoGeneratedDomainNameLabelScopeNoReuse),
		// 				Codecs: []*armvoiceservices.TeamsCodecs{
		// 					to.Ptr(armvoiceservices.TeamsCodecsPCMA)},
		// 					Connectivity: to.Ptr(armvoiceservices.ConnectivityPublicAddress),
		// 					E911Type: to.Ptr(armvoiceservices.E911TypeStandard),
		// 					Platforms: []*armvoiceservices.CommunicationsPlatform{
		// 						to.Ptr(armvoiceservices.CommunicationsPlatformOperatorConnect)},
		// 						ServiceLocations: []*armvoiceservices.ServiceRegionProperties{
		// 							{
		// 								Name: to.Ptr("useast"),
		// 								PrimaryRegionProperties: &armvoiceservices.PrimaryRegionProperties{
		// 									AllowedMediaSourceAddressPrefixes: []*string{
		// 										to.Ptr("10.1.2.0/24")},
		// 										AllowedSignalingSourceAddressPrefixes: []*string{
		// 											to.Ptr("10.1.1.0/24")},
		// 											OperatorAddresses: []*string{
		// 												to.Ptr("198.51.100.1")},
		// 											},
		// 										},
		// 										{
		// 											Name: to.Ptr("useast2"),
		// 											PrimaryRegionProperties: &armvoiceservices.PrimaryRegionProperties{
		// 												AllowedMediaSourceAddressPrefixes: []*string{
		// 													to.Ptr("10.2.2.0/24")},
		// 													AllowedSignalingSourceAddressPrefixes: []*string{
		// 														to.Ptr("10.2.1.0/24")},
		// 														OperatorAddresses: []*string{
		// 															to.Ptr("198.51.100.2")},
		// 														},
		// 												}},
		// 												Status: to.Ptr(armvoiceservices.StatusChangePending),
		// 												TeamsVoicemailPilotNumber: to.Ptr("1234567890"),
		// 											},
		// 									}},
		// 								}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aa85f59e259c4b12197b57b221067c40fa2fe3f1/specification/voiceservices/resource-manager/Microsoft.VoiceServices/stable/2023-01-31/examples/CommunicationsGateways_ListByResourceGroup.json
func ExampleCommunicationsGatewaysClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvoiceservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCommunicationsGatewaysClient().NewListByResourceGroupPager("testrg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CommunicationsGatewayListResult = armvoiceservices.CommunicationsGatewayListResult{
		// 	Value: []*armvoiceservices.CommunicationsGateway{
		// 		{
		// 			Name: to.Ptr("myname"),
		// 			Type: to.Ptr("Microsoft.VoiceService/communicationsGateways"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.VoiceService/communicationsGateways/myname"),
		// 			Location: to.Ptr("useast"),
		// 			Properties: &armvoiceservices.CommunicationsGatewayProperties{
		// 				AutoGeneratedDomainNameLabel: to.Ptr("somelabel"),
		// 				AutoGeneratedDomainNameLabelScope: to.Ptr(armvoiceservices.AutoGeneratedDomainNameLabelScopeNoReuse),
		// 				Codecs: []*armvoiceservices.TeamsCodecs{
		// 					to.Ptr(armvoiceservices.TeamsCodecsPCMA)},
		// 					Connectivity: to.Ptr(armvoiceservices.ConnectivityPublicAddress),
		// 					E911Type: to.Ptr(armvoiceservices.E911TypeStandard),
		// 					Platforms: []*armvoiceservices.CommunicationsPlatform{
		// 						to.Ptr(armvoiceservices.CommunicationsPlatformOperatorConnect)},
		// 						ServiceLocations: []*armvoiceservices.ServiceRegionProperties{
		// 							{
		// 								Name: to.Ptr("useast"),
		// 								PrimaryRegionProperties: &armvoiceservices.PrimaryRegionProperties{
		// 									AllowedMediaSourceAddressPrefixes: []*string{
		// 										to.Ptr("10.1.2.0/24")},
		// 										AllowedSignalingSourceAddressPrefixes: []*string{
		// 											to.Ptr("10.1.1.0/24")},
		// 											OperatorAddresses: []*string{
		// 												to.Ptr("198.51.100.1")},
		// 											},
		// 										},
		// 										{
		// 											Name: to.Ptr("useast2"),
		// 											PrimaryRegionProperties: &armvoiceservices.PrimaryRegionProperties{
		// 												AllowedMediaSourceAddressPrefixes: []*string{
		// 													to.Ptr("10.2.2.0/24")},
		// 													AllowedSignalingSourceAddressPrefixes: []*string{
		// 														to.Ptr("10.2.1.0/24")},
		// 														OperatorAddresses: []*string{
		// 															to.Ptr("198.51.100.2")},
		// 														},
		// 												}},
		// 												Status: to.Ptr(armvoiceservices.StatusChangePending),
		// 												TeamsVoicemailPilotNumber: to.Ptr("1234567890"),
		// 											},
		// 									}},
		// 								}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aa85f59e259c4b12197b57b221067c40fa2fe3f1/specification/voiceservices/resource-manager/Microsoft.VoiceServices/stable/2023-01-31/examples/CommunicationsGateways_Get.json
func ExampleCommunicationsGatewaysClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvoiceservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCommunicationsGatewaysClient().Get(ctx, "testrg", "myname", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CommunicationsGateway = armvoiceservices.CommunicationsGateway{
	// 	Name: to.Ptr("myname"),
	// 	Type: to.Ptr("Microsoft.VoiceService/communicationsGateways"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.VoiceService/communicationsGateways/myname"),
	// 	Location: to.Ptr("useast"),
	// 	Properties: &armvoiceservices.CommunicationsGatewayProperties{
	// 		AutoGeneratedDomainNameLabel: to.Ptr("somelabel"),
	// 		AutoGeneratedDomainNameLabelScope: to.Ptr(armvoiceservices.AutoGeneratedDomainNameLabelScopeNoReuse),
	// 		Codecs: []*armvoiceservices.TeamsCodecs{
	// 			to.Ptr(armvoiceservices.TeamsCodecsPCMA)},
	// 			Connectivity: to.Ptr(armvoiceservices.ConnectivityPublicAddress),
	// 			E911Type: to.Ptr(armvoiceservices.E911TypeStandard),
	// 			Platforms: []*armvoiceservices.CommunicationsPlatform{
	// 				to.Ptr(armvoiceservices.CommunicationsPlatformOperatorConnect)},
	// 				ServiceLocations: []*armvoiceservices.ServiceRegionProperties{
	// 					{
	// 						Name: to.Ptr("useast"),
	// 						PrimaryRegionProperties: &armvoiceservices.PrimaryRegionProperties{
	// 							AllowedMediaSourceAddressPrefixes: []*string{
	// 								to.Ptr("10.1.2.0/24")},
	// 								AllowedSignalingSourceAddressPrefixes: []*string{
	// 									to.Ptr("10.1.1.0/24")},
	// 									OperatorAddresses: []*string{
	// 										to.Ptr("198.51.100.1")},
	// 									},
	// 								},
	// 								{
	// 									Name: to.Ptr("useast2"),
	// 									PrimaryRegionProperties: &armvoiceservices.PrimaryRegionProperties{
	// 										AllowedMediaSourceAddressPrefixes: []*string{
	// 											to.Ptr("10.2.2.0/24")},
	// 											AllowedSignalingSourceAddressPrefixes: []*string{
	// 												to.Ptr("10.2.1.0/24")},
	// 												OperatorAddresses: []*string{
	// 													to.Ptr("198.51.100.2")},
	// 												},
	// 										}},
	// 										Status: to.Ptr(armvoiceservices.StatusChangePending),
	// 										TeamsVoicemailPilotNumber: to.Ptr("1234567890"),
	// 									},
	// 								}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aa85f59e259c4b12197b57b221067c40fa2fe3f1/specification/voiceservices/resource-manager/Microsoft.VoiceServices/stable/2023-01-31/examples/CommunicationsGateways_CreateOrUpdate.json
func ExampleCommunicationsGatewaysClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvoiceservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCommunicationsGatewaysClient().BeginCreateOrUpdate(ctx, "testrg", "myname", armvoiceservices.CommunicationsGateway{
		Location: to.Ptr("useast"),
		Properties: &armvoiceservices.CommunicationsGatewayProperties{
			AutoGeneratedDomainNameLabelScope: to.Ptr(armvoiceservices.AutoGeneratedDomainNameLabelScopeNoReuse),
			Codecs: []*armvoiceservices.TeamsCodecs{
				to.Ptr(armvoiceservices.TeamsCodecsPCMA)},
			Connectivity: to.Ptr(armvoiceservices.ConnectivityPublicAddress),
			E911Type:     to.Ptr(armvoiceservices.E911TypeStandard),
			Platforms: []*armvoiceservices.CommunicationsPlatform{
				to.Ptr(armvoiceservices.CommunicationsPlatformOperatorConnect)},
			ServiceLocations: []*armvoiceservices.ServiceRegionProperties{
				{
					Name: to.Ptr("useast"),
					PrimaryRegionProperties: &armvoiceservices.PrimaryRegionProperties{
						AllowedMediaSourceAddressPrefixes: []*string{
							to.Ptr("10.1.2.0/24")},
						AllowedSignalingSourceAddressPrefixes: []*string{
							to.Ptr("10.1.1.0/24")},
						OperatorAddresses: []*string{
							to.Ptr("198.51.100.1")},
					},
				},
				{
					Name: to.Ptr("useast2"),
					PrimaryRegionProperties: &armvoiceservices.PrimaryRegionProperties{
						AllowedMediaSourceAddressPrefixes: []*string{
							to.Ptr("10.2.2.0/24")},
						AllowedSignalingSourceAddressPrefixes: []*string{
							to.Ptr("10.2.1.0/24")},
						OperatorAddresses: []*string{
							to.Ptr("198.51.100.2")},
					},
				}},
			TeamsVoicemailPilotNumber: to.Ptr("1234567890"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CommunicationsGateway = armvoiceservices.CommunicationsGateway{
	// 	Name: to.Ptr("myname"),
	// 	Type: to.Ptr("Microsoft.Voiceservice/communicationsGateways"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.VoiceService/communicationsGateway/myname"),
	// 	Location: to.Ptr("useast"),
	// 	Properties: &armvoiceservices.CommunicationsGatewayProperties{
	// 		AutoGeneratedDomainNameLabel: to.Ptr("somelabel"),
	// 		AutoGeneratedDomainNameLabelScope: to.Ptr(armvoiceservices.AutoGeneratedDomainNameLabelScopeNoReuse),
	// 		Codecs: []*armvoiceservices.TeamsCodecs{
	// 			to.Ptr(armvoiceservices.TeamsCodecsPCMA)},
	// 			Connectivity: to.Ptr(armvoiceservices.ConnectivityPublicAddress),
	// 			E911Type: to.Ptr(armvoiceservices.E911TypeStandard),
	// 			Platforms: []*armvoiceservices.CommunicationsPlatform{
	// 				to.Ptr(armvoiceservices.CommunicationsPlatformOperatorConnect)},
	// 				ServiceLocations: []*armvoiceservices.ServiceRegionProperties{
	// 					{
	// 						Name: to.Ptr("useast"),
	// 						PrimaryRegionProperties: &armvoiceservices.PrimaryRegionProperties{
	// 							AllowedMediaSourceAddressPrefixes: []*string{
	// 								to.Ptr("10.1.2.0/24")},
	// 								AllowedSignalingSourceAddressPrefixes: []*string{
	// 									to.Ptr("10.1.1.0/24")},
	// 									OperatorAddresses: []*string{
	// 										to.Ptr("198.51.100.1")},
	// 									},
	// 								},
	// 								{
	// 									Name: to.Ptr("useast2"),
	// 									PrimaryRegionProperties: &armvoiceservices.PrimaryRegionProperties{
	// 										AllowedMediaSourceAddressPrefixes: []*string{
	// 											to.Ptr("10.2.2.0/24")},
	// 											AllowedSignalingSourceAddressPrefixes: []*string{
	// 												to.Ptr("10.2.1.0/24")},
	// 												OperatorAddresses: []*string{
	// 													to.Ptr("198.51.100.2")},
	// 												},
	// 										}},
	// 										Status: to.Ptr(armvoiceservices.StatusChangePending),
	// 										TeamsVoicemailPilotNumber: to.Ptr("1234567890"),
	// 									},
	// 								}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aa85f59e259c4b12197b57b221067c40fa2fe3f1/specification/voiceservices/resource-manager/Microsoft.VoiceServices/stable/2023-01-31/examples/CommunicationsGateways_Delete.json
func ExampleCommunicationsGatewaysClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvoiceservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCommunicationsGatewaysClient().BeginDelete(ctx, "testrg", "myname", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aa85f59e259c4b12197b57b221067c40fa2fe3f1/specification/voiceservices/resource-manager/Microsoft.VoiceServices/stable/2023-01-31/examples/CommunicationsGateways_Update.json
func ExampleCommunicationsGatewaysClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvoiceservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCommunicationsGatewaysClient().Update(ctx, "testrg", "myname", armvoiceservices.CommunicationsGatewayUpdate{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CommunicationsGateway = armvoiceservices.CommunicationsGateway{
	// 	Name: to.Ptr("myname"),
	// 	Type: to.Ptr("Microsoft.Voiceservice/communicationsGateways"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.VoiceService/communicationsGateway/myname"),
	// 	Location: to.Ptr("useast"),
	// 	Properties: &armvoiceservices.CommunicationsGatewayProperties{
	// 		AutoGeneratedDomainNameLabel: to.Ptr("somelabel"),
	// 		AutoGeneratedDomainNameLabelScope: to.Ptr(armvoiceservices.AutoGeneratedDomainNameLabelScopeNoReuse),
	// 		Codecs: []*armvoiceservices.TeamsCodecs{
	// 			to.Ptr(armvoiceservices.TeamsCodecsPCMA)},
	// 			Connectivity: to.Ptr(armvoiceservices.ConnectivityPublicAddress),
	// 			E911Type: to.Ptr(armvoiceservices.E911TypeStandard),
	// 			Platforms: []*armvoiceservices.CommunicationsPlatform{
	// 				to.Ptr(armvoiceservices.CommunicationsPlatformOperatorConnect)},
	// 				ServiceLocations: []*armvoiceservices.ServiceRegionProperties{
	// 					{
	// 						Name: to.Ptr("useast"),
	// 						PrimaryRegionProperties: &armvoiceservices.PrimaryRegionProperties{
	// 							AllowedMediaSourceAddressPrefixes: []*string{
	// 								to.Ptr("10.1.2.0/24")},
	// 								AllowedSignalingSourceAddressPrefixes: []*string{
	// 									to.Ptr("10.1.1.0/24")},
	// 									OperatorAddresses: []*string{
	// 										to.Ptr("198.51.100.1")},
	// 									},
	// 								},
	// 								{
	// 									Name: to.Ptr("useast2"),
	// 									PrimaryRegionProperties: &armvoiceservices.PrimaryRegionProperties{
	// 										AllowedMediaSourceAddressPrefixes: []*string{
	// 											to.Ptr("10.2.2.0/24")},
	// 											AllowedSignalingSourceAddressPrefixes: []*string{
	// 												to.Ptr("10.2.1.0/24")},
	// 												OperatorAddresses: []*string{
	// 													to.Ptr("198.51.100.2")},
	// 												},
	// 										}},
	// 										Status: to.Ptr(armvoiceservices.StatusChangePending),
	// 										TeamsVoicemailPilotNumber: to.Ptr("1234567890"),
	// 									},
	// 								}
}
