; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-unknown-unknown | FileCheck %s
; RUN: llc < %s -mtriple=aarch64-unknown-unknown -global-isel | FileCheck %s

; These tests can be optimised
;       fold (bitreverse(srl (bitreverse c), x)) -> (shl c, x)
;       fold (bitreverse(shl (bitreverse c), x)) -> (srl c, x)

declare i8 @llvm.bitreverse.i8(i8)
declare i16 @llvm.bitreverse.i16(i16)
declare i32 @llvm.bitreverse.i32(i32)
declare i64 @llvm.bitreverse.i64(i64)

define i8 @test_bitreverse_srli_bitreverse_i8(i8 %a) nounwind {
; CHECK-LABEL: test_bitreverse_srli_bitreverse_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w0, w0, #3
; CHECK-NEXT:    ret
  %1 = call i8 @llvm.bitreverse.i8(i8 %a)
  %2 = lshr i8 %1, 3
  %3 = call i8 @llvm.bitreverse.i8(i8 %2)
  ret i8 %3
}

define i16 @test_bitreverse_srli_bitreverse_i16(i16 %a) nounwind {
; CHECK-LABEL: test_bitreverse_srli_bitreverse_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w0, w0, #7
; CHECK-NEXT:    ret
  %1 = call i16 @llvm.bitreverse.i16(i16 %a)
  %2 = lshr i16 %1, 7
  %3 = call i16 @llvm.bitreverse.i16(i16 %2)
  ret i16 %3
}

define i32 @test_bitreverse_srli_bitreverse_i32(i32 %a) nounwind {
; CHECK-LABEL: test_bitreverse_srli_bitreverse_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w0, w0, #15
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.bitreverse.i32(i32 %a)
  %2 = lshr i32 %1, 15
  %3 = call i32 @llvm.bitreverse.i32(i32 %2)
  ret i32 %3
}

define i64 @test_bitreverse_srli_bitreverse_i64(i64 %a) nounwind {
; CHECK-LABEL: test_bitreverse_srli_bitreverse_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl x0, x0, #33
; CHECK-NEXT:    ret
  %1 = call i64 @llvm.bitreverse.i64(i64 %a)
  %2 = lshr i64 %1, 33
  %3 = call i64 @llvm.bitreverse.i64(i64 %2)
  ret i64 %3
}

define i8 @test_bitreverse_shli_bitreverse_i8(i8 %a) nounwind {
; CHECK-LABEL: test_bitreverse_shli_bitreverse_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #3, #5
; CHECK-NEXT:    ret
  %1 = call i8 @llvm.bitreverse.i8(i8 %a)
  %2 = shl i8 %1, 3
  %3 = call i8 @llvm.bitreverse.i8(i8 %2)
  ret i8 %3
}

define i16 @test_bitreverse_shli_bitreverse_i16(i16 %a) nounwind {
; CHECK-LABEL: test_bitreverse_shli_bitreverse_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w0, w0, #7, #9
; CHECK-NEXT:    ret
  %1 = call i16 @llvm.bitreverse.i16(i16 %a)
  %2 = shl i16 %1, 7
  %3 = call i16 @llvm.bitreverse.i16(i16 %2)
  ret i16 %3
}

define i32 @test_bitreverse_shli_bitreverse_i32(i32 %a) nounwind {
; CHECK-LABEL: test_bitreverse_shli_bitreverse_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr w0, w0, #15
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.bitreverse.i32(i32 %a)
  %2 = shl i32 %1, 15
  %3 = call i32 @llvm.bitreverse.i32(i32 %2)
  ret i32 %3
}

define i64 @test_bitreverse_shli_bitreverse_i64(i64 %a) nounwind {
; CHECK-LABEL: test_bitreverse_shli_bitreverse_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr x0, x0, #33
; CHECK-NEXT:    ret
  %1 = call i64 @llvm.bitreverse.i64(i64 %a)
  %2 = shl i64 %1, 33
  %3 = call i64 @llvm.bitreverse.i64(i64 %2)
  ret i64 %3
}
