; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=CHECK,X64

define <8 x i32> @v8i32_cmpgt(<8 x i32> %i, <8 x i32> %j) nounwind readnone {
; CHECK-LABEL: v8i32_cmpgt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %bincmp = icmp slt <8 x i32> %i, %j
  %x = sext <8 x i1> %bincmp to <8 x i32>
  ret <8 x i32> %x
}

define <4 x i64> @v4i64_cmpgt(<4 x i64> %i, <4 x i64> %j) nounwind readnone {
; CHECK-LABEL: v4i64_cmpgt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %bincmp = icmp slt <4 x i64> %i, %j
  %x = sext <4 x i1> %bincmp to <4 x i64>
  ret <4 x i64> %x
}

define <16 x i16> @v16i16_cmpgt(<16 x i16> %i, <16 x i16> %j) nounwind readnone {
; CHECK-LABEL: v16i16_cmpgt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %bincmp = icmp slt <16 x i16> %i, %j
  %x = sext <16 x i1> %bincmp to <16 x i16>
  ret <16 x i16> %x
}

define <32 x i8> @v32i8_cmpgt(<32 x i8> %i, <32 x i8> %j) nounwind readnone {
; CHECK-LABEL: v32i8_cmpgt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %bincmp = icmp slt <32 x i8> %i, %j
  %x = sext <32 x i1> %bincmp to <32 x i8>
  ret <32 x i8> %x
}

define <8 x i32> @int256_cmpeq(<8 x i32> %i, <8 x i32> %j) nounwind readnone {
; CHECK-LABEL: int256_cmpeq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %bincmp = icmp eq <8 x i32> %i, %j
  %x = sext <8 x i1> %bincmp to <8 x i32>
  ret <8 x i32> %x
}

define <4 x i64> @v4i64_cmpeq(<4 x i64> %i, <4 x i64> %j) nounwind readnone {
; CHECK-LABEL: v4i64_cmpeq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmpeqq %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %bincmp = icmp eq <4 x i64> %i, %j
  %x = sext <4 x i1> %bincmp to <4 x i64>
  ret <4 x i64> %x
}

define <16 x i16> @v16i16_cmpeq(<16 x i16> %i, <16 x i16> %j) nounwind readnone {
; CHECK-LABEL: v16i16_cmpeq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %bincmp = icmp eq <16 x i16> %i, %j
  %x = sext <16 x i1> %bincmp to <16 x i16>
  ret <16 x i16> %x
}

define <32 x i8> @v32i8_cmpeq(<32 x i8> %i, <32 x i8> %j) nounwind readnone {
; CHECK-LABEL: v32i8_cmpeq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %bincmp = icmp eq <32 x i8> %i, %j
  %x = sext <32 x i1> %bincmp to <32 x i8>
  ret <32 x i8> %x
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; X64: {{.*}}
; X86: {{.*}}
