; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefix=X64

define <2 x i256> @test_shl(<2 x i256> %In) nounwind {
; X86-LABEL: test_shl:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    shldl $2, %ecx, %edx
; X86-NEXT:    movl %edx, 60(%eax)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    shldl $2, %edx, %ecx
; X86-NEXT:    movl %ecx, 56(%eax)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    shldl $2, %ecx, %edx
; X86-NEXT:    movl %edx, 52(%eax)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    shldl $2, %edx, %ecx
; X86-NEXT:    movl %ecx, 48(%eax)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    shldl $2, %ecx, %edx
; X86-NEXT:    movl %edx, 44(%eax)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    shldl $2, %edx, %ecx
; X86-NEXT:    movl %ecx, 40(%eax)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    shldl $2, %ecx, %edx
; X86-NEXT:    movl %edx, 36(%eax)
; X86-NEXT:    shll $2, %ecx
; X86-NEXT:    movl %ecx, 32(%eax)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    shll $31, %ecx
; X86-NEXT:    movl %ecx, 28(%eax)
; X86-NEXT:    movl $0, 24(%eax)
; X86-NEXT:    movl $0, 20(%eax)
; X86-NEXT:    movl $0, 16(%eax)
; X86-NEXT:    movl $0, 12(%eax)
; X86-NEXT:    movl $0, 8(%eax)
; X86-NEXT:    movl $0, 4(%eax)
; X86-NEXT:    movl $0, (%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: test_shl:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    shldq $2, %rdx, %rcx
; X64-NEXT:    shldq $2, %rdi, %rdx
; X64-NEXT:    shldq $2, %r9, %rdi
; X64-NEXT:    shlq $63, %rsi
; X64-NEXT:    shlq $2, %r9
; X64-NEXT:    movq %rcx, 56(%rax)
; X64-NEXT:    movq %rdx, 48(%rax)
; X64-NEXT:    movq %rdi, 40(%rax)
; X64-NEXT:    movq %r9, 32(%rax)
; X64-NEXT:    movq %rsi, 24(%rax)
; X64-NEXT:    xorps %xmm0, %xmm0
; X64-NEXT:    movaps %xmm0, (%rax)
; X64-NEXT:    movq $0, 16(%rax)
; X64-NEXT:    retq
  %Amt = insertelement <2 x i256> <i256 1, i256 2>, i256 255, i32 0
  %Out = shl <2 x i256> %In, %Amt
  ret <2 x i256> %Out
}

define <2 x i256> @test_srl(<2 x i256> %In) nounwind {
; X86-LABEL: test_srl:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %ebp, %esi
; X86-NEXT:    shldl $28, %edx, %esi
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    shldl $28, %ebx, %edx
; X86-NEXT:    movl %edx, (%esp) # 4-byte Spill
; X86-NEXT:    shldl $28, %ecx, %ebx
; X86-NEXT:    movl %ecx, %esi
; X86-NEXT:    shldl $28, %edi, %esi
; X86-NEXT:    shldl $28, %eax, %edi
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shldl $28, %eax, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    shrdl $4, %eax, %ecx
; X86-NEXT:    shrl $4, %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %ebp, 60(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    movl %ebp, 56(%eax)
; X86-NEXT:    movl (%esp), %ebp # 4-byte Reload
; X86-NEXT:    movl %ebp, 52(%eax)
; X86-NEXT:    movl %ebx, 48(%eax)
; X86-NEXT:    movl %esi, 44(%eax)
; X86-NEXT:    movl %edi, 40(%eax)
; X86-NEXT:    movl %edx, 36(%eax)
; X86-NEXT:    movl %ecx, 32(%eax)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    shrl $31, %ecx
; X86-NEXT:    movl %ecx, (%eax)
; X86-NEXT:    movl $0, 28(%eax)
; X86-NEXT:    movl $0, 24(%eax)
; X86-NEXT:    movl $0, 20(%eax)
; X86-NEXT:    movl $0, 16(%eax)
; X86-NEXT:    movl $0, 12(%eax)
; X86-NEXT:    movl $0, 8(%eax)
; X86-NEXT:    movl $0, 4(%eax)
; X86-NEXT:    addl $8, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; X64-LABEL: test_srl:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; X64-NEXT:    shrdq $4, %rsi, %r9
; X64-NEXT:    shrdq $4, %rdx, %rsi
; X64-NEXT:    shrdq $4, %rcx, %rdx
; X64-NEXT:    shrq $63, %r8
; X64-NEXT:    shrq $4, %rcx
; X64-NEXT:    movq %rcx, 56(%rdi)
; X64-NEXT:    movq %rdx, 48(%rdi)
; X64-NEXT:    movq %rsi, 40(%rdi)
; X64-NEXT:    movq %r9, 32(%rdi)
; X64-NEXT:    movq %r8, (%rdi)
; X64-NEXT:    xorps %xmm0, %xmm0
; X64-NEXT:    movaps %xmm0, 16(%rdi)
; X64-NEXT:    movq $0, 8(%rdi)
; X64-NEXT:    retq
  %Amt = insertelement <2 x i256> <i256 3, i256 4>, i256 255, i32 0
  %Out = lshr <2 x i256> %In, %Amt
  ret <2 x i256> %Out
}

define <2 x i256> @test_sra(<2 x i256> %In) nounwind {
; X86-LABEL: test_sra:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %ebp, %esi
; X86-NEXT:    shldl $26, %edx, %esi
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    shldl $26, %ebx, %edx
; X86-NEXT:    movl %edx, (%esp) # 4-byte Spill
; X86-NEXT:    shldl $26, %ecx, %ebx
; X86-NEXT:    movl %ecx, %esi
; X86-NEXT:    shldl $26, %edi, %esi
; X86-NEXT:    shldl $26, %eax, %edi
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shldl $26, %eax, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    shrdl $6, %eax, %ecx
; X86-NEXT:    sarl $6, %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %ebp, 60(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    movl %ebp, 56(%eax)
; X86-NEXT:    movl (%esp), %ebp # 4-byte Reload
; X86-NEXT:    movl %ebp, 52(%eax)
; X86-NEXT:    movl %ebx, 48(%eax)
; X86-NEXT:    movl %esi, 44(%eax)
; X86-NEXT:    movl %edi, 40(%eax)
; X86-NEXT:    movl %edx, 36(%eax)
; X86-NEXT:    movl %ecx, 32(%eax)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    sarl $31, %ecx
; X86-NEXT:    movl %ecx, 28(%eax)
; X86-NEXT:    movl %ecx, 24(%eax)
; X86-NEXT:    movl %ecx, 20(%eax)
; X86-NEXT:    movl %ecx, 16(%eax)
; X86-NEXT:    movl %ecx, 12(%eax)
; X86-NEXT:    movl %ecx, 8(%eax)
; X86-NEXT:    movl %ecx, 4(%eax)
; X86-NEXT:    movl %ecx, (%eax)
; X86-NEXT:    addl $8, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; X64-LABEL: test_sra:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; X64-NEXT:    shrdq $6, %rsi, %r9
; X64-NEXT:    shrdq $6, %rdx, %rsi
; X64-NEXT:    shrdq $6, %rcx, %rdx
; X64-NEXT:    sarq $63, %r8
; X64-NEXT:    sarq $6, %rcx
; X64-NEXT:    movq %rcx, 56(%rdi)
; X64-NEXT:    movq %rdx, 48(%rdi)
; X64-NEXT:    movq %rsi, 40(%rdi)
; X64-NEXT:    movq %r9, 32(%rdi)
; X64-NEXT:    movq %r8, 24(%rdi)
; X64-NEXT:    movq %r8, 16(%rdi)
; X64-NEXT:    movq %r8, 8(%rdi)
; X64-NEXT:    movq %r8, (%rdi)
; X64-NEXT:    retq
  %Amt = insertelement <2 x i256> <i256 5, i256 6>, i256 255, i32 0
  %Out = ashr <2 x i256> %In, %Amt
  ret <2 x i256> %Out
}
