; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc --relocation-model=pic -code-model=small < %s | FileCheck %s
; RUN: llc --relocation-model=pic -code-model=medium < %s | FileCheck %s
; RUN: llc --relocation-model=pic -code-model=large < %s | FileCheck %s --check-prefix=LARGE

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

@global = external global i32
declare void @func()

define ptr @global_addr() #0 {
; CHECK-LABEL: global_addr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq global@GOTPCREL_NORELAX(%rip), %rax
; CHECK-NEXT:    retq
;
; LARGE-LABEL: global_addr:
; LARGE:       # %bb.0:
; LARGE-NEXT:  .L0$pb:
; LARGE-NEXT:    leaq .L0$pb(%rip), %rax
; LARGE-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L0$pb, %rcx
; LARGE-NEXT:    addq %rax, %rcx
; LARGE-NEXT:    movabsq $global@GOT, %rax
; LARGE-NEXT:    movq (%rcx,%rax), %rax
; LARGE-NEXT:    retq
  ret ptr @global
}

define i32 @global_load() #0 {
; CHECK-LABEL: global_load:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq global@GOTPCREL_NORELAX(%rip), %rax
; CHECK-NEXT:    movl (%rax), %eax
; CHECK-NEXT:    retq
;
; LARGE-LABEL: global_load:
; LARGE:       # %bb.0:
; LARGE-NEXT:  .L1$pb:
; LARGE-NEXT:    leaq .L1$pb(%rip), %rax
; LARGE-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L1$pb, %rcx
; LARGE-NEXT:    addq %rax, %rcx
; LARGE-NEXT:    movabsq $global@GOT, %rax
; LARGE-NEXT:    movq (%rcx,%rax), %rax
; LARGE-NEXT:    movl (%rax), %eax
; LARGE-NEXT:    retq
  %load = load i32, ptr @global
  ret i32 %load
}

define void @global_store() #0 {
; CHECK-LABEL: global_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq global@GOTPCREL_NORELAX(%rip), %rax
; CHECK-NEXT:    movl $0, (%rax)
; CHECK-NEXT:    retq
;
; LARGE-LABEL: global_store:
; LARGE:       # %bb.0:
; LARGE-NEXT:  .L2$pb:
; LARGE-NEXT:    leaq .L2$pb(%rip), %rax
; LARGE-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L2$pb, %rcx
; LARGE-NEXT:    addq %rax, %rcx
; LARGE-NEXT:    movabsq $global@GOT, %rax
; LARGE-NEXT:    movq (%rcx,%rax), %rax
; LARGE-NEXT:    movl $0, (%rax)
; LARGE-NEXT:    retq
  store i32 0, ptr @global
  ret void
}

define ptr @func_addr() #0 {
; CHECK-LABEL: func_addr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq func@GOTPCREL(%rip), %rax
; CHECK-NEXT:    retq
;
; LARGE-LABEL: func_addr:
; LARGE:       # %bb.0:
; LARGE-NEXT:  .L3$pb:
; LARGE-NEXT:    leaq .L3$pb(%rip), %rax
; LARGE-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L3$pb, %rcx
; LARGE-NEXT:    addq %rax, %rcx
; LARGE-NEXT:    movabsq $func@GOT, %rax
; LARGE-NEXT:    movq (%rcx,%rax), %rax
; LARGE-NEXT:    retq
  ret ptr @func
}

attributes #0 = { "target-features"="+tagged-globals" }
