// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Todhri`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [
    0x000301,
    0x000304,
    0x000307,
    0x000311,
    0x000313,
    0x00035E
  ],
  ranges: [
    [0x0105C0, 0x0105F3]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Todhri}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Todhri}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Todr}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Todr}"
);
testPropertyEscapes(
  /^\p{scx=Todhri}+$/u,
  matchSymbols,
  "\\p{scx=Todhri}"
);
testPropertyEscapes(
  /^\p{scx=Todr}+$/u,
  matchSymbols,
  "\\p{scx=Todr}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [
    0x000312
  ],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x000300],
    [0x000302, 0x000303],
    [0x000305, 0x000306],
    [0x000308, 0x000310],
    [0x000314, 0x00035D],
    [0x00035F, 0x00DBFF],
    [0x00E000, 0x0105BF],
    [0x0105F4, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Todhri}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Todhri}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Todr}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Todr}"
);
testPropertyEscapes(
  /^\P{scx=Todhri}+$/u,
  nonMatchSymbols,
  "\\P{scx=Todhri}"
);
testPropertyEscapes(
  /^\P{scx=Todr}+$/u,
  nonMatchSymbols,
  "\\P{scx=Todr}"
);

reportCompare(0, 0);
