# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerservice.aio import ContainerServiceClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerServiceOperationStatusResultOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerServiceClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_operation_status_result_list(self, resource_group):
        response = self.client.operation_status_result.list(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2025-08-02-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_operation_status_result_get(self, resource_group):
        response = await self.client.operation_status_result.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            operation_id="str",
            api_version="2025-08-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_operation_status_result_get_by_agent_pool(self, resource_group):
        response = await self.client.operation_status_result.get_by_agent_pool(
            resource_group_name=resource_group.name,
            resource_name="str",
            agent_pool_name="str",
            operation_id="str",
            api_version="2025-08-02-preview",
        )

        # please add some check logic here by yourself
        # ...
