% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreg.R
\name{predict.phreg}
\alias{predict.phreg}
\alias{headstrata}
\alias{tailstrata}
\alias{revcumsumstrata}
\alias{revcumsumstratasum}
\alias{cumsumstrata}
\alias{sumstrata}
\alias{covfr}
\alias{covfridstrata}
\alias{covfridstrataCov}
\alias{cumsumidstratasum}
\alias{cumsumidstratasumCov}
\alias{cumsumstratasum}
\alias{revcumsum}
\alias{revcumsumidstratasum}
\alias{revcumsumidstratasumCov}
\alias{robust.basehaz.phreg}
\alias{matdoubleindex}
\alias{mdi}
\alias{cumsum2strata}
\alias{revcumsum2strata}
\alias{revcumsum2stratafdN}
\title{Predictions from proportional hazards model}
\usage{
\method{predict}{phreg}(
  object,
  newdata,
  times = NULL,
  individual.time = FALSE,
  tminus = FALSE,
  se = TRUE,
  robust = FALSE,
  conf.type = "log",
  conf.int = 0.95,
  km = FALSE,
  ...
)
}
\arguments{
\item{object}{phreg object}

\item{newdata}{data.frame}

\item{times}{Time where to predict variable, default is all time-points from the object sorted}

\item{individual.time}{to use one (individual) time per subject, and then newdata and times have same length and makes only predictions for these individual times.}

\item{tminus}{to make predictions in T- that is strictly before given times, useful for IPCW techniques}

\item{se}{with standard errors and upper and lower confidence intervals.}

\item{robust}{to get robust se's also default for most functions (uses robse.cumhaz otherwise se.cumhaz).}

\item{conf.type}{transformation for suvival estimates, default is log}

\item{conf.int}{significance level}

\item{km}{to use Kaplan-Meier product-limit for baseline \deqn{S_{s0}(t)= (1 - dA_{s0}(t))}, otherwise take exp of cumulative baseline.}

\item{...}{Additional arguments to plot functions}
}
\description{
Predictions from proportional hazards model
}
