% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_orm.r
\name{adapt_orm}
\alias{adapt_orm}
\title{Adaptive orm Fit For a Single Continuous Predictor}
\usage{
adapt_orm(x, y, maxk = 6, ...)
}
\arguments{
\item{x}{a numeric vector}

\item{y}{a numeric or factor variable representing an ordinal dependent variable, or an \code{Ocens} object}

\item{maxk}{maximum number of knots to try}

\item{...}{arguments to orm other than \code{family}, \code{x}, \code{y}}
}
\value{
the best \code{orm} fit object
}
\description{
Finds the best fitting \code{orm} model for a single continuous predictor \code{x}, starting by finding the link function with the smallest deviance when the predictor is modeled with 4 knots in a restricted cubic spline function.  Then the function finds the number of knots minimizing AIC when this link function is used.  Candidate number of knots are 0 (linear fit), 3, 4, 5, \code{maxk}.
}
\examples{
\dontrun{
f <- adapt_orm(age, blood_pressure)
f$stats['d.f.']   # print no. of parameters for age
f$family          # print optimum link found
}
}
\author{
Frank Harrell
}
