% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay.R
\docType{class}
\name{Assay-class}
\alias{Assay-class}
\alias{Assay}
\title{The Assay Class}
\description{
The Assay object is the basic unit of Seurat; each Assay stores raw,
normalized, and scaled data as well as cluster information, variable
features, and any other assay-specific metadata. Assays should contain single
cell expression data such as RNA-seq, protein, or imputed expression data.
}
\section{Slots}{

\describe{
\item{\code{counts}}{Unnormalized data such as raw counts or TPMs}

\item{\code{data}}{Normalized expression data}

\item{\code{scale.data}}{Scaled expression data}

\item{\code{assay.orig}}{Original assay that this assay is based off of. Used to
track assay provenance}

\item{\code{var.features}}{Vector of features exhibiting high variance across
single cells}

\item{\code{meta.features}}{Feature-level metadata}

\item{\code{misc}}{A named list of unstructured miscellaneous data}

\item{\code{key}}{A one-length character vector with the object's key; keys must
be one or more alphanumeric characters followed by an underscore
\dQuote{\code{_}} (regex pattern
\dQuote{\code{\Sexpr[stage=build]{SeuratObject:::.KeyPattern()}}})}
}}

\seealso{
v3 Assay object, validity, and interaction methods:
\code{\link{$.Assay}()},
\code{\link{Assay-validity}},
\code{\link{CreateAssayObject}()},
\code{\link{[.Assay}()},
\code{\link{[[.Assay}()},
\code{\link{dim.Assay}()},
\code{\link{dimnames.Assay}()},
\code{\link{merge.Assay}()},
\code{\link{split.Assay}()},
\code{\link{subset.Assay}()}
}
\concept{assay}
