% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_outline.R
\name{glyph_raster_grob}
\alias{glyph_raster_grob}
\title{Convert an extracted glyph raster to a grob}
\usage{
glyph_raster_grob(glyph, x, y, ..., default.units = "bigpts")
}
\arguments{
\item{glyph}{The nativeRaster object returned as one of the elements by
\code{\link[=glyph_raster]{glyph_raster()}}}

\item{x, y}{The baseline location of the glyph}

\item{...}{
  Arguments passed on to \code{\link[grid:grid.raster]{grid::rasterGrob}}
  \describe{
    \item{\code{image}}{
    Any R object that can be coerced to a raster object.
  }
    \item{\code{width}}{A numeric vector or unit object specifying width.}
    \item{\code{height}}{A numeric vector or unit object specifying height.}
    \item{\code{just}}{The justification of the rectangle
    relative to its (x, y) location.  If there are two values, the first
    value specifies horizontal justification and the second value specifies
    vertical justification.  Possible string values are: \code{"left"},
    \code{"right"}, \code{"centre"}, \code{"center"}, \code{"bottom"},
    and \code{"top"}.  For numeric values, 0 means left alignment
    and 1 means right alignment.
  }
    \item{\code{hjust}}{A numeric vector specifying horizontal justification.
    If specified, overrides the \code{just} setting.}
    \item{\code{vjust}}{A numeric vector specifying vertical justification.
    If specified, overrides the \code{just} setting.}
    \item{\code{name}}{ A character identifier. }
    \item{\code{gp}}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}
    \item{\code{vp}}{A Grid viewport object (or NULL).}
    \item{\code{interpolate}}{
    A logical value indicating whether to linearly interpolate the
    image (the alternative is to use nearest-neighbour interpolation,
    which gives a more blocky result).
  }
  }}

\item{default.units}{A string indicating the default units to use
    if \code{x}, \code{y}, \code{width}, or \code{height}
    are only given as numeric vectors.}
}
\value{
A rasterGrob object
}
\description{
This is a convenience function that helps in creating \link{rasterGrob} with the
correct settings for the glyph. It takes inot account the sizing and offset
returned by \code{\link[=glyph_raster]{glyph_raster()}} and allows you to only consider the baseline
position of the glyph.
}
\examples{
font <- font_info()
glyph <- glyph_info("R", path = font$path, index = font$index)

R <- glyph_raster(glyph$index, font$path, font$index, size = 150)

grob <- glyph_raster_grob(R[[1]], 50, 50)

grid::grid.newpage()
# Mark the baseline location
grid::grid.points(50, 50, default.units = "bigpts")
# Draw the glyph
grid::grid.draw(grob)

}
