# General

- [Overview](./overview.md)
- [Installation](./general/installation.md)
- [Getting started](./general/getting-started.md)
- [Configuration](./general/configuration.md)

# `rudof` commands

`rudof` supports the following commands:

- [node](./cli_usage/node.md)
- [data](./cli_usage/data.md)
- [query](./cli_usage/sparql.md)
- [shex](./cli_usage/shex.md)
- [shacl](./cli_usage/shacl.md)
- [pgschema](./cli_usage/pgschema.md)
- [shapemap](./cli_usage/shapemap.md)
- [dctap](./cli_usage/dctap.md)
- [service](./cli_usage/service.md)
- [shex-validate](./cli_usage/shex_validate.md)
- [shacl-validate](./cli_usage/shacl_validate.md)
- [validate](./cli_usage/validate.md)
- [convert](./cli_usage/convert.md)
- [compare](./cli_usage/compare.md)
- [rdf-config](./cli_usage/rdf-config.md)
- [generate](./cli_usage/generate.md)
- [mcp](./cli_usage/mcp.md)

# `rudof` as a library

- [Docs](./library/docs.md)
- [Processing RDF](./library/rdf_processing.md)
- [Parsing RDF](./library/parsing_processing.md)
- [Python-bindings](./library/python.md)

# `rudof` internals

- [Scope of the project](./internals/scope.md)
- [Architecture](./internals/architecture.md)
  - [`iri_s`](./internals/crates/iri_s.md)
  - [`prefixmap`](./internals/crates/prefixmap.md)
- [ADRs](./internals/ADRs.md)

# More information

- [Benchmarks](./references/benchmarks.md)
- [FAQ](./references/faq.md)
