from typing import Any, List, Mapping

from .listener import Listener
from .topicobj import Topic

class INotificationHandler:
    def notifySubscribe(
        self, pubListener: Listener, topicObj: Topic, newSub: bool
    ) -> bool: ...
    def notifyUnsubscribe(self, pubListener: Listener, topicObj: Topic) -> None: ...
    def notifyDeadListener(self, pubListener: Listener, topicObj: Topic) -> None: ...
    def notifySend(
        self, stage: str, topicObj: Topic, pubListener: Listener = ...
    ) -> None: ...
    def notifyNewTopic(
        self,
        topicObj: Topic,
        description: str,
        required: List[str],
        argsDocs: Mapping[str, str],
    ) -> None: ...
    def notifyDelTopic(self, topicName: str) -> None: ...

class NotificationMgr:
    def __init__(self, notificationHandler: INotificationHandler = ...) -> None: ...
    def addHandler(self, handler: INotificationHandler) -> None: ...
    def getHandlers(self) -> List[INotificationHandler]: ...
    def clearHandlers(self) -> None: ...
    def notifySubscribe(self, *args: Any, **kwargs: Any) -> None: ...
    def notifyUnsubscribe(self, *args: Any, **kwargs: Any) -> None: ...
    def notifySend(self, *args: Any, **kwargs: Any) -> None: ...
    def notifyNewTopic(self, *args: Any, **kwargs: Any) -> None: ...
    def notifyDelTopic(self, *args: Any, **kwargs: Any) -> None: ...
    def notifyDeadListener(self, *args: Any, **kwargs: Any) -> None: ...
    def getFlagStates(self) -> Mapping[str, bool]: ...
    def setFlagStates(
        self,
        subscribe: bool = ...,
        unsubscribe: bool = ...,
        deadListener: bool = ...,
        sendMessage: bool = ...,
        newTopic: bool = ...,
        delTopic: bool = ...,
        all: bool = ...,
    ) -> None: ...
