//
// Created by uos on 2022/6/9.
//

#include "LogDialog.h"
#include "common/BaseItemDelegate.h"
#include <DTitlebar>
#include <DLabel>
#include <QVBoxLayout>
#include <DFontSizeManager>
#include <DBackgroundGroup>
#include <QHeaderView>
#include <QScreen>
#include <QDateTime>
#include <QAbstractItemView>


const int TABLE_COL_NO = 0;             //table表：序号
const int TABLE_COL_TYPE = 1;           //table表：类型
const int TABLE_COL_USER = 2;           //table表：用户名
const int TABLE_COL_TIME = 3;           //table表：时间
const int TABLE_COL_REMARK = 4;         //table表：备注

LogDialog::LogDialog(QWidget *parent) : DMainWindow(parent)
{
    this->setAccessibleName("LogDialog");
    initUI();
}

void LogDialog::initUI()
{
    auto titleBar = titlebar();
    setWindowFlags(windowFlags());// & ~Qt::WindowMinimizeButtonHint);
    titleBar->setMenuVisible(false);
    titleBar->setIcon(QIcon::fromTheme("uos-recovery"));
    titleBar->setAccessibleName("LogDialog_titleBar");
    auto contentLayout = new QVBoxLayout;
    contentLayout->setSpacing(10);
    contentLayout->setContentsMargins(10, 20, 10, 50);

    DLabel *label = new DLabel;
    label->setText(tr("Logs"));
    label->setAccessibleName("LogDialog_LogsLabel");
    DFontSizeManager::instance()->bind(label, DFontSizeManager::T5);
    QFont font = label->font();
    font.setWeight(QFont::DemiBold);
    label->setFont(font);
    label->setAlignment(Qt::AlignLeft);
    QPalette titlePalette;
    titlePalette.setColor(QPalette::BrightText, QColor(qRgba(0,0,0,0.85)));
    label->setPalette(titlePalette);
    contentLayout->addWidget(label);
    contentLayout->addSpacing(3);

    QWidget *contentWidget = new QWidget;
    contentWidget->setObjectName("contentWidget");
    contentWidget->setAccessibleName("LogDialog_contentWidget");
    contentWidget->setLayout(contentLayout);

    auto mainLayout = new QHBoxLayout;
    auto mainWidget = new DBackgroundGroup();
    mainWidget->setAccessibleName("LogDialog_DBackgroundGroup");
    mainWidget->setObjectName("mainWidget");
    mainLayout->addWidget(contentWidget);
    setCentralWidget(mainWidget);
    centralWidget()->setLayout(mainLayout);

    m_tableView = new BaseTableView;
    m_tableView->setAccessibleName("LogDialog_tableView");
    m_model = new QStandardItemModel;
    m_tableView->setModel(m_model);
    m_tableView->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    auto itemDelegate = new BaseItemDelegate(this);
    m_tableView->setItemDelegate(itemDelegate);
    initTableView();
    contentLayout->addWidget(m_tableView);
}

void LogDialog::initTableView()
{
    m_tableView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    m_tableView->setSortingEnabled(false);
    m_tableView->setFocusPolicy(Qt::NoFocus);
    m_tableView->setRowBackgroundDelta(10);

    //序号
    auto noItem = new QStandardItem(tr("No."));
    noItem->setTextAlignment(Qt::AlignVCenter);
    noItem->setAccessibleText("LogDialog_HeaderNo");

    // 类型
    auto typeItem = new QStandardItem(tr("Type"));
    typeItem->setTextAlignment(Qt::AlignVCenter);
    typeItem->setAccessibleText("LogDialog_HeaderType");

    //用户名
    auto nameItem = new QStandardItem(tr("User"));
    nameItem->setTextAlignment(Qt::AlignVCenter);
    nameItem->setAccessibleText("LogDialog_HeaderUser");

    // 时间
    auto timeItem = new QStandardItem(tr("Time"));
    timeItem->setTextAlignment(Qt::AlignVCenter);
    timeItem->setAccessibleText("LogDialog_HeaderTime");

    //备注
    auto remarkItem = new QStandardItem(tr("Note"));
    remarkItem->setTextAlignment(Qt::AlignVCenter);
    remarkItem->setAccessibleText("LogDialog_HeaderNote");


    m_model->setHorizontalHeaderItem(TABLE_COL_NO, noItem);
    m_model->setHorizontalHeaderItem(TABLE_COL_TYPE, typeItem);
    m_model->setHorizontalHeaderItem(TABLE_COL_USER, nameItem);
    m_model->setHorizontalHeaderItem(TABLE_COL_TIME, timeItem);
    m_model->setHorizontalHeaderItem(TABLE_COL_REMARK, remarkItem);

//    m_tableView->header()->setSectionResizeMode(QHeaderView::Stretch);
    m_tableView->setColumnWidth(TABLE_COL_NO, 55);
    m_tableView->setColumnWidth(TABLE_COL_TYPE, 120);
    m_tableView->setColumnWidth(TABLE_COL_USER, 150);
    m_tableView->setColumnWidth(TABLE_COL_TIME, 150);
    m_tableView->setColumnWidth(TABLE_COL_REMARK, 130);

    // 禁止拖动列宽
    QHeaderView * headerView = m_tableView->header();
    headerView->setSectionResizeMode(TABLE_COL_NO, QHeaderView::ResizeMode::Fixed);
    headerView->setSectionResizeMode(TABLE_COL_TYPE, QHeaderView::ResizeMode::Fixed);
    headerView->setSectionResizeMode(TABLE_COL_USER, QHeaderView::ResizeMode::Fixed);
    headerView->setSectionResizeMode(TABLE_COL_TIME, QHeaderView::ResizeMode::Fixed);
    headerView->setSectionResizeMode(TABLE_COL_REMARK, QHeaderView::ResizeMode::Fixed);
}

void LogDialog::setData(const OperateLogList operateLogList)
{
    m_model->removeRows(0, m_model->rowCount());
    auto iter = operateLogList.begin();
    int seqNo = 1;
    for (; iter != operateLogList.end(); ++iter) {
        int currentRow = m_model->rowCount();
        auto seqItem = new QStandardItem(QString("%1").arg(seqNo++));
        m_model->setItem(currentRow, TABLE_COL_NO, seqItem);

        QString type;
        switch (iter->operateType) {
            case OperateType::SystemBackup:
            case OperateType::ManualBackupV20:
            case OperateType::SystemBackupV20:
                type = tr("System backup");
                break;
            case OperateType::SystemRestore:
            case OperateType::SystemRestoreV20:
            case OperateType::ManualRestoreV20:
                type = tr("System restore");
                break;
            case OperateType::UserDataBackup:
                type = tr("Data backup");
                break;
            case OperateType::UserDataRestore:
                type = tr("Data restore");
                break;
            case OperateType::removeBackup:
                type = tr("Delete backup");
                break;
            case OperateType::FactoryRestore:
            case OperateType::InitRestoreV20: {
                type = tr("Reset to factory settings");
                break;
            }
            default:
                break;
        }
        auto typeItem = new QStandardItem(type);
        m_model->setItem(currentRow, TABLE_COL_TYPE, typeItem);

        auto nameItem = new QStandardItem(iter->username);
        m_model->setItem(currentRow, TABLE_COL_USER, nameItem);

        auto time = QDateTime::fromMSecsSinceEpoch(iter->time);
        auto timeItem = new QStandardItem(time.toString("yyyy-MM-dd HH:mm:ss"));
        m_model->setItem(currentRow, TABLE_COL_TIME, timeItem);

        auto remarkItem = new QStandardItem(iter->remark);
        m_model->setItem(currentRow, TABLE_COL_REMARK, remarkItem);
    }
}

void LogDialog::showToCenter()
{
    auto screen = QGuiApplication::primaryScreen();
    auto rect = screen->geometry();
    if (rect.width() < MAIN_WINDOW_WIDTH || rect.height() < MAIN_WINDOW_HEIGHT) {
        QWidget::showMaximized();
    } else {
        setFixedSize(QSize(MAIN_WINDOW_WIDTH - 80, MAIN_WINDOW_HEIGHT - 80));
        move((rect.width() - width()) / 2, (rect.height() - height()) / 2);
        QWidget::show();
    }
}

// void LogDialog::closeEvent(QCloseEvent *event)
// {
//     DMainWindow::closeEvent(event);
// //    this->close();
//     Q_EMIT closeMainWindow();
// }
