// Code generated by "./generator system/org.deepin.passkey1"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package passkey1

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus/v5"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type Passkey interface {
	passkey // interface org.deepin.Passkey1
	proxy.Object
}

type objectPasskey struct {
	interfacePasskey // interface org.deepin.Passkey1
	proxy.ImplObject
}

func NewPasskey(conn *dbus.Conn, serviceName string, path dbus.ObjectPath) (Passkey, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectPasskey)
	obj.ImplObject.Init_(conn, serviceName, path)
	return obj, nil
}

type passkey interface {
	SetInterfaceName_(name string)
	GoClaim(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Claim(flags dbus.Flags) error
	GoUnClaim(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	UnClaim(flags dbus.Flags) error
	GoGetPinStatus(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetPinStatus(flags dbus.Flags) (int32, int32, error)
	GoSetPin(flags dbus.Flags, ch chan *dbus.Call, oldPin string, newPin string) *dbus.Call
	SetPin(flags dbus.Flags, oldPin string, newPin string) error
	GoReset(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Reset(flags dbus.Flags) (string, error)
	GoMakeCredential(flags dbus.Flags, ch chan *dbus.Call, user string, credName string, pin string) *dbus.Call
	MakeCredential(flags dbus.Flags, user string, credName string, pin string) (string, error)
	GoGetAssertion(flags dbus.Flags, ch chan *dbus.Call, user string, credName string, pin string) *dbus.Call
	GetAssertion(flags dbus.Flags, user string, credName string, pin string) (string, error)
	GoGetValidCredCount(flags dbus.Flags, ch chan *dbus.Call, user string) *dbus.Call
	GetValidCredCount(flags dbus.Flags, user string) (int32, error)
	GoGetCreds(flags dbus.Flags, ch chan *dbus.Call, user string) *dbus.Call
	GetCreds(flags dbus.Flags, user string) ([]string, error)
	GoGetDeviceCount(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetDeviceCount(flags dbus.Flags) (int32, error)
	GoDeviceDetect(flags dbus.Flags, ch chan *dbus.Call, timeout int32) *dbus.Call
	DeviceDetect(flags dbus.Flags, timeout int32) (string, error)
	GoDeviceSelect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	DeviceSelect(flags dbus.Flags) (string, error)
	GoDeviceSelectClose(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	DeviceSelectClose(flags dbus.Flags) error
	GoDeviceClose(flags dbus.Flags, ch chan *dbus.Call, id string) *dbus.Call
	DeviceClose(flags dbus.Flags, id string) error
	GoEncryptKey(flags dbus.Flags, ch chan *dbus.Call, keyType int32) *dbus.Call
	EncryptKey(flags dbus.Flags, keyType int32) (string, error)
	GoSetSymmetricKey(flags dbus.Flags, ch chan *dbus.Call, encryptType int32, keyType int32, key string) *dbus.Call
	SetSymmetricKey(flags dbus.Flags, encryptType int32, keyType int32, key string) error
	ConnectResetStatus(cb func(id string, finish int32, result string)) (dbusutil.SignalHandlerId, error)
	ConnectMakeCredStatus(cb func(id string, user string, finish int32, result string)) (dbusutil.SignalHandlerId, error)
	ConnectGetAssertStatus(cb func(id string, user string, finish int32, result string)) (dbusutil.SignalHandlerId, error)
	ConnectDeviceDetectStatus(cb func(id string, finish int32, result string)) (dbusutil.SignalHandlerId, error)
	ConnectDeviceSelectStatus(cb func(id string, finish int32, result string)) (dbusutil.SignalHandlerId, error)
}

type interfacePasskey struct{}

func (v *interfacePasskey) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (v *interfacePasskey) SetInterfaceName_(name string) {
	v.GetObject_().SetExtra("customIfc", name)
}

func (v *interfacePasskey) GetInterfaceName_() string {
	ifcName, _ := v.GetObject_().GetExtra("customIfc")
	ifcNameStr, _ := ifcName.(string)
	return ifcNameStr
}

// method Claim

func (v *interfacePasskey) GoClaim(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Claim", flags, ch)
}

func (v *interfacePasskey) Claim(flags dbus.Flags) error {
	return (<-v.GoClaim(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method UnClaim

func (v *interfacePasskey) GoUnClaim(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnClaim", flags, ch)
}

func (v *interfacePasskey) UnClaim(flags dbus.Flags) error {
	return (<-v.GoUnClaim(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method GetPinStatus

func (v *interfacePasskey) GoGetPinStatus(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetPinStatus", flags, ch)
}

func (*interfacePasskey) StoreGetPinStatus(call *dbus.Call) (support int32, exist int32, err error) {
	err = call.Store(&support, &exist)
	return
}

func (v *interfacePasskey) GetPinStatus(flags dbus.Flags) (int32, int32, error) {
	return v.StoreGetPinStatus(
		<-v.GoGetPinStatus(flags, make(chan *dbus.Call, 1)).Done)
}

// method SetPin

func (v *interfacePasskey) GoSetPin(flags dbus.Flags, ch chan *dbus.Call, oldPin string, newPin string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetPin", flags, ch, oldPin, newPin)
}

func (v *interfacePasskey) SetPin(flags dbus.Flags, oldPin string, newPin string) error {
	return (<-v.GoSetPin(flags, make(chan *dbus.Call, 1), oldPin, newPin).Done).Err
}

// method Reset

func (v *interfacePasskey) GoReset(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Reset", flags, ch)
}

func (*interfacePasskey) StoreReset(call *dbus.Call) (id string, err error) {
	err = call.Store(&id)
	return
}

func (v *interfacePasskey) Reset(flags dbus.Flags) (string, error) {
	return v.StoreReset(
		<-v.GoReset(flags, make(chan *dbus.Call, 1)).Done)
}

// method MakeCredential

func (v *interfacePasskey) GoMakeCredential(flags dbus.Flags, ch chan *dbus.Call, user string, credName string, pin string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".MakeCredential", flags, ch, user, credName, pin)
}

func (*interfacePasskey) StoreMakeCredential(call *dbus.Call) (id string, err error) {
	err = call.Store(&id)
	return
}

func (v *interfacePasskey) MakeCredential(flags dbus.Flags, user string, credName string, pin string) (string, error) {
	return v.StoreMakeCredential(
		<-v.GoMakeCredential(flags, make(chan *dbus.Call, 1), user, credName, pin).Done)
}

// method GetAssertion

func (v *interfacePasskey) GoGetAssertion(flags dbus.Flags, ch chan *dbus.Call, user string, credName string, pin string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetAssertion", flags, ch, user, credName, pin)
}

func (*interfacePasskey) StoreGetAssertion(call *dbus.Call) (id string, err error) {
	err = call.Store(&id)
	return
}

func (v *interfacePasskey) GetAssertion(flags dbus.Flags, user string, credName string, pin string) (string, error) {
	return v.StoreGetAssertion(
		<-v.GoGetAssertion(flags, make(chan *dbus.Call, 1), user, credName, pin).Done)
}

// method GetValidCredCount

func (v *interfacePasskey) GoGetValidCredCount(flags dbus.Flags, ch chan *dbus.Call, user string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetValidCredCount", flags, ch, user)
}

func (*interfacePasskey) StoreGetValidCredCount(call *dbus.Call) (count int32, err error) {
	err = call.Store(&count)
	return
}

func (v *interfacePasskey) GetValidCredCount(flags dbus.Flags, user string) (int32, error) {
	return v.StoreGetValidCredCount(
		<-v.GoGetValidCredCount(flags, make(chan *dbus.Call, 1), user).Done)
}

// method GetCreds

func (v *interfacePasskey) GoGetCreds(flags dbus.Flags, ch chan *dbus.Call, user string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetCreds", flags, ch, user)
}

func (*interfacePasskey) StoreGetCreds(call *dbus.Call) (creds []string, err error) {
	err = call.Store(&creds)
	return
}

func (v *interfacePasskey) GetCreds(flags dbus.Flags, user string) ([]string, error) {
	return v.StoreGetCreds(
		<-v.GoGetCreds(flags, make(chan *dbus.Call, 1), user).Done)
}

// method GetDeviceCount

func (v *interfacePasskey) GoGetDeviceCount(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetDeviceCount", flags, ch)
}

func (*interfacePasskey) StoreGetDeviceCount(call *dbus.Call) (count int32, err error) {
	err = call.Store(&count)
	return
}

func (v *interfacePasskey) GetDeviceCount(flags dbus.Flags) (int32, error) {
	return v.StoreGetDeviceCount(
		<-v.GoGetDeviceCount(flags, make(chan *dbus.Call, 1)).Done)
}

// method DeviceDetect

func (v *interfacePasskey) GoDeviceDetect(flags dbus.Flags, ch chan *dbus.Call, timeout int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DeviceDetect", flags, ch, timeout)
}

func (*interfacePasskey) StoreDeviceDetect(call *dbus.Call) (id string, err error) {
	err = call.Store(&id)
	return
}

func (v *interfacePasskey) DeviceDetect(flags dbus.Flags, timeout int32) (string, error) {
	return v.StoreDeviceDetect(
		<-v.GoDeviceDetect(flags, make(chan *dbus.Call, 1), timeout).Done)
}

// method DeviceSelect

func (v *interfacePasskey) GoDeviceSelect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DeviceSelect", flags, ch)
}

func (*interfacePasskey) StoreDeviceSelect(call *dbus.Call) (id string, err error) {
	err = call.Store(&id)
	return
}

func (v *interfacePasskey) DeviceSelect(flags dbus.Flags) (string, error) {
	return v.StoreDeviceSelect(
		<-v.GoDeviceSelect(flags, make(chan *dbus.Call, 1)).Done)
}

// method DeviceSelectClose

func (v *interfacePasskey) GoDeviceSelectClose(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DeviceSelectClose", flags, ch)
}

func (v *interfacePasskey) DeviceSelectClose(flags dbus.Flags) error {
	return (<-v.GoDeviceSelectClose(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method DeviceClose

func (v *interfacePasskey) GoDeviceClose(flags dbus.Flags, ch chan *dbus.Call, id string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DeviceClose", flags, ch, id)
}

func (v *interfacePasskey) DeviceClose(flags dbus.Flags, id string) error {
	return (<-v.GoDeviceClose(flags, make(chan *dbus.Call, 1), id).Done).Err
}

// method EncryptKey

func (v *interfacePasskey) GoEncryptKey(flags dbus.Flags, ch chan *dbus.Call, keyType int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".EncryptKey", flags, ch, keyType)
}

func (*interfacePasskey) StoreEncryptKey(call *dbus.Call) (publicKey string, err error) {
	err = call.Store(&publicKey)
	return
}

func (v *interfacePasskey) EncryptKey(flags dbus.Flags, keyType int32) (string, error) {
	return v.StoreEncryptKey(
		<-v.GoEncryptKey(flags, make(chan *dbus.Call, 1), keyType).Done)
}

// method SetSymmetricKey

func (v *interfacePasskey) GoSetSymmetricKey(flags dbus.Flags, ch chan *dbus.Call, encryptType int32, keyType int32, key string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetSymmetricKey", flags, ch, encryptType, keyType, key)
}

func (v *interfacePasskey) SetSymmetricKey(flags dbus.Flags, encryptType int32, keyType int32, key string) error {
	return (<-v.GoSetSymmetricKey(flags, make(chan *dbus.Call, 1), encryptType, keyType, key).Done).Err
}

// signal ResetStatus

func (v *interfacePasskey) ConnectResetStatus(cb func(id string, finish int32, result string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ResetStatus", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ResetStatus",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var id string
		var finish int32
		var result string
		err := dbus.Store(sig.Body, &id, &finish, &result)
		if err == nil {
			cb(id, finish, result)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal MakeCredStatus

func (v *interfacePasskey) ConnectMakeCredStatus(cb func(id string, user string, finish int32, result string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "MakeCredStatus", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".MakeCredStatus",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var id string
		var user string
		var finish int32
		var result string
		err := dbus.Store(sig.Body, &id, &user, &finish, &result)
		if err == nil {
			cb(id, user, finish, result)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal GetAssertStatus

func (v *interfacePasskey) ConnectGetAssertStatus(cb func(id string, user string, finish int32, result string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "GetAssertStatus", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".GetAssertStatus",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var id string
		var user string
		var finish int32
		var result string
		err := dbus.Store(sig.Body, &id, &user, &finish, &result)
		if err == nil {
			cb(id, user, finish, result)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal DeviceDetectStatus

func (v *interfacePasskey) ConnectDeviceDetectStatus(cb func(id string, finish int32, result string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "DeviceDetectStatus", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".DeviceDetectStatus",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var id string
		var finish int32
		var result string
		err := dbus.Store(sig.Body, &id, &finish, &result)
		if err == nil {
			cb(id, finish, result)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal DeviceSelectStatus

func (v *interfacePasskey) ConnectDeviceSelectStatus(cb func(id string, finish int32, result string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "DeviceSelectStatus", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".DeviceSelectStatus",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var id string
		var finish int32
		var result string
		err := dbus.Store(sig.Body, &id, &finish, &result)
		if err == nil {
			cb(id, finish, result)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}
