/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.handlers;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.model.edit.providers.ResultListLabelProvider;
import org.eclipse.fordiac.ide.model.edit.providers.TypeImageProvider;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class OpenTypeHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        TypeSearchDialog dialog = new TypeSearchDialog(shell);
        dialog.open();
        Object result = dialog.getFirstResult();
        if (result instanceof TypeEntry) {
            TypeEntry typeEntry = (TypeEntry)result;
            OpenTypeHandler.openEditor(typeEntry.getFile());
        }
        return null;
    }

    private static void openEditor(IFile file) {
        IWorkbenchWindow activeWorkbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            try {
                activePage.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
            }
            catch (PartInitException e1) {
                FordiacLogHelper.logError((String)e1.getMessage(), (Throwable)e1);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)Messages.OpenTypeHandler_OPEN_TYPE_ERROR_TITLE, (String)Messages.OpenTypeHandler_EDITOR_OPEN_ERROR_MESSAGE);
            }
        }
    }

    private static class TypeSearchDialog
    extends FilteredItemsSelectionDialog {
        private final List<IProject> projects;
        private final ResultListLabelProvider listLabelProvider = new ResultListLabelProvider(true);
        private String selectedProject = null;

        public TypeSearchDialog(Shell shell) {
            super(shell);
            this.setTitle(Messages.OpenTypeHandler_OPEN_TYPE_TITLE);
            this.setMessage(Messages.OpenTypeHandler_DialogMessage);
            this.setSelectionHistory(this.getSelectionHistory());
            this.setListLabelProvider((ILabelProvider)this.listLabelProvider);
            this.setDetailsLabelProvider((ILabelProvider)new TypeSearchDetailsLabelProvider());
            this.projects = Arrays.stream(ResourcesPlugin.getWorkspace().getRoot().getProjects()).filter(TypeSearchDialog::isOpen4diacIDEProject).toList();
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            Combo combo = new Combo(container, 12);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)combo);
            combo.addListener(13, e -> {
                int selectionIndex = combo.getSelectionIndex();
                this.selectedProject = selectionIndex == 0 ? null : combo.getItem(selectionIndex);
                this.applyFilter();
            });
            combo.setItems(this.getProjectComboEntries());
            combo.select(0);
            return container;
        }

        private String[] getProjectComboEntries() {
            return (String[])Stream.concat(Stream.of(Messages.OpenTypeHandler_SearchInAllProjects), this.projects.stream().map(IResource::getName).sorted(Comparator.naturalOrder())).toArray(String[]::new);
        }

        protected Control createExtendedContentArea(Composite parent) {
            return null;
        }

        protected IDialogSettings getDialogSettings() {
            IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(TypeSearchDialog.class)).getDialogSettings();
            return DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)((Object)((Object)this)).getClass().getSimpleName());
        }

        protected IStatus validateItem(Object item) {
            return Status.OK_STATUS;
        }

        protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
            return new TypeEntryFilter(this.selectedProject);
        }

        protected Comparator getItemsComparator() {
            return Comparator.comparing(this::getElementName);
        }

        protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
            this.listLabelProvider.setSearchString(itemsFilter.getPattern());
            if (itemsFilter.getPattern().isBlank()) {
                return;
            }
            if (this.selectedProject == null) {
                for (IProject proj : this.projects) {
                    if (progressMonitor.isCanceled()) {
                        return;
                    }
                    TypeSearchDialog.fillForProject(contentProvider, itemsFilter, progressMonitor, proj);
                }
            } else {
                TypeSearchDialog.fillForProject(contentProvider, itemsFilter, progressMonitor, this.getSelectedProject());
            }
        }

        private IProject getSelectedProject() {
            return this.projects.stream().filter(proj -> proj.getName().equals(this.selectedProject)).findAny().orElse(null);
        }

        private static void fillForProject(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor, IProject proj) {
            for (TypeEntry entry : TypeLibraryManager.INSTANCE.getTypeLibrary(proj).getAllTypes()) {
                if (progressMonitor.isCanceled()) {
                    return;
                }
                if (entry instanceof SystemEntry || !itemsFilter.matchItem((Object)entry)) continue;
                contentProvider.add((Object)entry, itemsFilter);
            }
        }

        public String getElementName(Object item) {
            if (item instanceof TypeEntry) {
                TypeEntry typeEntry = (TypeEntry)item;
                return typeEntry.getFullTypeName();
            }
            return null;
        }

        private static boolean isOpen4diacIDEProject(IProject proj) {
            try {
                return proj.isOpen() && proj.hasNature("org.eclipse.fordiac.ide.systemmanagement.FordiacNature");
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)"Could not read project nature", (Throwable)e);
                return false;
            }
        }

        private final class TypeEntryFilter
        extends FilteredItemsSelectionDialog.ItemsFilter {
            final String selectedProject;

            public TypeEntryFilter(String selectedProject) {
                super((FilteredItemsSelectionDialog)TypeSearchDialog.this);
                this.selectedProject = selectedProject;
            }

            public boolean matchItem(Object item) {
                if (item instanceof TypeEntry) {
                    TypeEntry typeEntry = (TypeEntry)item;
                    return this.matches(typeEntry.getTypeName()) || this.matches(typeEntry.getPackageName()) || this.matches(typeEntry.getComment());
                }
                return false;
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
                if (filter instanceof TypeEntryFilter) {
                    TypeEntryFilter typeEntryFilter = (TypeEntryFilter)filter;
                    if (typeEntryFilter.selectedProject != null && !typeEntryFilter.selectedProject.equals(this.selectedProject)) {
                        return false;
                    }
                }
                return super.equalsFilter(filter);
            }

            public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
                if (filter instanceof TypeEntryFilter) {
                    TypeEntryFilter typeEntryFilter = (TypeEntryFilter)filter;
                    if (typeEntryFilter.selectedProject != null && !typeEntryFilter.selectedProject.equals(this.selectedProject)) {
                        return false;
                    }
                }
                return super.isSubFilter(filter);
            }
        }

        private static class TypeSearchDetailsLabelProvider
        extends LabelProvider
        implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
            private TypeSearchDetailsLabelProvider() {
            }

            public StyledString getStyledText(Object element) {
                if (element instanceof TypeEntry) {
                    TypeEntry entry = (TypeEntry)element;
                    return ResultListLabelProvider.getTypeEntryStyledText((TypeEntry)entry, (boolean)true);
                }
                if (element != null) {
                    return new StyledString(element.toString());
                }
                return new StyledString();
            }

            public String getText(Object element) {
                return this.getStyledText(element).getString();
            }

            public Image getImage(Object element) {
                if (element instanceof TypeEntry) {
                    TypeEntry entry = (TypeEntry)element;
                    return TypeImageProvider.getImageForTypeEntry((TypeEntry)entry);
                }
                return null;
            }
        }
    }
}

