/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.contentoutline;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.fordiac.ide.ui.contentoutline.MultiPageSite;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class MultiPageEditorContentOutlinePage
extends Page
implements IContentOutlinePage,
IPostSelectionProvider,
IAdaptable {
    private final MultiPageEditorPart editorPart;
    private final IContentOutlinePage defaultOutlinePage;
    private final CopyOnWriteArrayList<ISelectionChangedListener> selectionChangedListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ISelectionChangedListener> postSelectionChangedListeners = new CopyOnWriteArrayList();
    private final Map<IEditorPart, PageRecord> pages = new HashMap<IEditorPart, PageRecord>();
    private final Set<MultiPageEditorPart> multiPageChildren = new HashSet<MultiPageEditorPart>();
    private final ISelectionChangedListener selectionChangedListener = this::selectionChanged;
    private final ISelectionChangedListener postSelectionChangedListener = this::postSelectionChanged;
    private final IPageChangedListener pageChangedListener = this::pageChanged;
    private PageBook book;
    private PageRecord defaultPage;
    private PageRecord currentPage;

    public MultiPageEditorContentOutlinePage(MultiPageEditorPart editorPart, IContentOutlinePage defaultOutlinePage) {
        this.editorPart = editorPart;
        this.defaultOutlinePage = defaultOutlinePage;
    }

    public void createControl(Composite parent) {
        this.book = new PageBook(parent, 0);
        this.defaultPage = this.createPage((IEditorPart)this.editorPart, this.defaultOutlinePage);
        Object object = this.editorPart.getSelectedPage();
        if (object instanceof IEditorPart) {
            IEditorPart activeEditor = (IEditorPart)object;
            this.showPage(this.getOrCreatePage(activeEditor));
        } else {
            this.showPage(this.getOrCreatePage((IEditorPart)this.editorPart));
        }
        this.editorPart.addPageChangedListener(this.pageChangedListener);
    }

    private PageRecord getOrCreatePage(IEditorPart editorPart) {
        return this.pages.computeIfAbsent(editorPart, this::createPage);
    }

    private PageRecord createPage(IEditorPart editorPart) {
        IContentOutlinePage page;
        if (editorPart != this.editorPart && (page = (IContentOutlinePage)Adapters.adapt((Object)editorPart, IContentOutlinePage.class)) != null) {
            return this.createPage(editorPart, page);
        }
        return this.defaultPage;
    }

    private PageRecord createPage(IEditorPart editorPart, IContentOutlinePage page) {
        MultiPageSite site;
        if (page instanceof IPageBookViewPage) {
            IPageBookViewPage pageBookViewPage = (IPageBookViewPage)page;
            if (pageBookViewPage.getSite() == null) {
                site = new MultiPageSite(this.getSite());
                SafeRunner.run(() -> pageBookViewPage.init(site));
            } else {
                site = pageBookViewPage.getSite();
            }
        } else {
            site = new MultiPageSite(this.getSite());
        }
        if (page.getControl() == null || page.getControl().isDisposed()) {
            page.createControl((Composite)this.book);
            page.setActionBars(site.getActionBars());
        } else if (!MultiPageEditorContentOutlinePage.isAncestor((Control)page.getControl().getParent(), (Composite)this.book)) {
            throw new IllegalStateException("The page " + String.valueOf(page) + " is currently used in a different page book");
        }
        return new PageRecord(editorPart, page, site);
    }

    private static boolean isAncestor(Control control, Composite ancestor) {
        while ((control = control.getParent()) != null) {
            if (control != ancestor) continue;
            return true;
        }
        return false;
    }

    protected void showPage(PageRecord page) {
        IPostSelectionProvider postSelectionProvider;
        IContentOutlinePage iContentOutlinePage;
        MultiPageSite multiPageSite;
        IPageSite iPageSite;
        if (page == this.currentPage) {
            return;
        }
        if (this.currentPage != null && page != null && this.currentPage.page() == page.page()) {
            this.currentPage = page;
            return;
        }
        if (this.currentPage != null) {
            iPageSite = this.currentPage.site();
            if (iPageSite instanceof MultiPageSite) {
                multiPageSite = (MultiPageSite)iPageSite;
                multiPageSite.getActionBars().deactivate();
                multiPageSite.deactivate();
            }
            this.currentPage.page().removeSelectionChangedListener(this.selectionChangedListener);
            iContentOutlinePage = this.currentPage.page();
            if (iContentOutlinePage instanceof IPostSelectionProvider) {
                postSelectionProvider = (IPostSelectionProvider)iContentOutlinePage;
                postSelectionProvider.removePostSelectionChangedListener(this.postSelectionChangedListener);
            }
        }
        this.currentPage = page;
        if (this.currentPage != null && !this.currentPage.page().getControl().isDisposed()) {
            IActionBars iActionBars;
            this.book.showPage(this.currentPage.page().getControl());
            iPageSite = this.currentPage.site();
            if (iPageSite instanceof MultiPageSite) {
                multiPageSite = (MultiPageSite)iPageSite;
                multiPageSite.getActionBars().activate();
                multiPageSite.activate();
            }
            this.currentPage.page().addSelectionChangedListener(this.selectionChangedListener);
            iContentOutlinePage = this.currentPage.page();
            if (iContentOutlinePage instanceof IPostSelectionProvider) {
                postSelectionProvider = (IPostSelectionProvider)iContentOutlinePage;
                postSelectionProvider.addPostSelectionChangedListener(this.postSelectionChangedListener);
            }
            if ((iActionBars = this.getSite().getActionBars()) instanceof SubActionBars) {
                SubActionBars parentSubActionBars = (SubActionBars)iActionBars;
                parentSubActionBars.activate();
            }
            this.getSite().getActionBars().updateActionBars();
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        this.firePostSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    protected void pageChanged(PageChangedEvent event) {
        Object object;
        MultiPageEditorPart multiPageEditor;
        Object object2 = event.getSelectedPage();
        if (object2 instanceof MultiPageEditorPart && this.multiPageChildren.add(multiPageEditor = (MultiPageEditorPart)object2)) {
            multiPageEditor.addPageChangedListener(this.pageChangedListener);
        }
        if ((object = event.getSelectedPage()) instanceof IEditorPart) {
            IEditorPart activeEditor = (IEditorPart)object;
            this.showPage(this.getOrCreatePage(activeEditor));
        } else {
            this.showPage(this.getOrCreatePage((IEditorPart)this.editorPart));
        }
    }

    public ISelection getSelection() {
        ISelection selection;
        if (this.currentPage != null && (selection = this.currentPage.page().getSelection()) != null) {
            return selection;
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (this.currentPage != null) {
            this.currentPage.page().setSelection(selection);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionChangedListeners.add(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionChangedListeners.remove(listener);
    }

    protected void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, event.getSelection()));
    }

    protected void postSelectionChanged(SelectionChangedEvent event) {
        this.firePostSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, event.getSelection()));
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        this.selectionChangedListeners.forEach(listener -> SafeRunner.run(() -> listener.selectionChanged(event)));
    }

    protected void firePostSelectionChanged(SelectionChangedEvent event) {
        this.postSelectionChangedListeners.forEach(listener -> SafeRunner.run(() -> listener.selectionChanged(event)));
    }

    public Control getControl() {
        return this.book;
    }

    public void setFocus() {
        if (this.book != null && !this.book.isDisposed()) {
            this.book.setFocus();
        }
        if (this.currentPage != null && this.currentPage.page().getControl() != null && !this.currentPage.page().getControl().isDisposed()) {
            this.currentPage.page().setFocus();
        }
    }

    public <T> T getAdapter(Class<T> key) {
        if (this.currentPage != null) {
            return (T)Adapters.adapt((Object)this.currentPage.page(), key);
        }
        return null;
    }

    public void dispose() {
        this.editorPart.removePageChangedListener(this.pageChangedListener);
        this.multiPageChildren.forEach(child -> child.removePageChangedListener(this.pageChangedListener));
        this.multiPageChildren.clear();
        this.showPage(null);
        this.pages.values().forEach(PageRecord::dispose);
        this.pages.clear();
        if (this.defaultPage != null) {
            this.defaultPage.dispose();
            this.defaultPage = null;
        }
        if (this.book != null) {
            this.book.dispose();
            this.book = null;
        }
        super.dispose();
    }

    protected record PageRecord(IEditorPart editorPart, IContentOutlinePage page, IPageSite site) {
        protected void dispose() {
            this.page.dispose();
        }
    }
}

