/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.commands.PasteCommand;
import org.eclipse.fordiac.ide.gef.utilities.ElementSelector;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.change.AddElementsToGroup;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.gef.commands.Command;

public class CopyElementsToGroupCommand
extends Command
implements ScopedCommand {
    private final Group targetGroup;
    private final PasteCommand pasteCommand;
    private AddElementsToGroup addElements;
    private final List<FBNetworkElement> elementsToAdd = new ArrayList<FBNetworkElement>();
    private final Point offset;

    public CopyElementsToGroupCommand(Group targetGroup, PasteCommand pasteCommand, Point offset) {
        this.targetGroup = Objects.requireNonNull(targetGroup);
        this.pasteCommand = Objects.requireNonNull(pasteCommand);
        this.offset = Objects.requireNonNull(offset);
    }

    public void execute() {
        this.pasteCommand.execute();
        this.elementsToAdd.addAll(this.pasteCommand.getCopiedFBs());
        this.addElements = new AddElementsToGroup(this.targetGroup, this.elementsToAdd, this.offset);
        if (this.addElements.canExecute()) {
            this.addElements.execute();
        } else {
            this.addElements = null;
        }
        ElementSelector.selectViewObjects(this.elementsToAdd);
    }

    public void undo() {
        if (this.addElements != null) {
            this.addElements.undo();
        }
        this.pasteCommand.undo();
    }

    public void redo() {
        this.pasteCommand.redo();
        if (this.addElements != null) {
            this.addElements.redo();
        }
    }

    public Point getOffset() {
        return this.offset;
    }

    public Set<EObject> getAffectedObjects() {
        return Set.of(this.targetGroup);
    }
}

