/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.actions.CopyPasteData;
import org.eclipse.fordiac.ide.application.commands.ConnectionReference;
import org.eclipse.fordiac.ide.gef.utilities.ElementSelector;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AddNewImportCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.graphics.Point;

public class PasteCommand
extends Command
implements ScopedCommand {
    private static final double DEFAULT_DELTA = 111.11111111111111;
    private final CopyPasteData copyPasteData;
    private final FBNetwork dstFBNetwork;
    private final Map<FBNetworkElement, FBNetworkElement> copiedElements = new HashMap<FBNetworkElement, FBNetworkElement>();
    private final CompoundCommand connCreateCmds = new CompoundCommand();
    private final CompoundCommand updateTypeCmds = new CompoundCommand();
    private final CompoundCommand importCmds = new CompoundCommand();
    private double xDelta;
    private double yDelta;
    private boolean calculateDelta = false;
    private Position pasteRefPos;
    private final TypeLibrary dstTypeLib;

    public PasteCommand(CopyPasteData copyPasteData, FBNetwork destination, Point pasteRefPos) {
        this.copyPasteData = copyPasteData;
        this.dstFBNetwork = destination;
        this.pasteRefPos = CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(pasteRefPos.x, pasteRefPos.y);
        this.calculateDelta = true;
        this.dstTypeLib = PasteCommand.checkTypeLib(copyPasteData.srcNetwork(), destination);
    }

    public PasteCommand(CopyPasteData copyPasteData, FBNetwork destination, int copyDeltaX, int copyDeltaY) {
        this.copyPasteData = copyPasteData;
        this.dstFBNetwork = destination;
        this.xDelta = CoordinateConverter.INSTANCE.screenToIEC61499(copyDeltaX);
        this.yDelta = CoordinateConverter.INSTANCE.screenToIEC61499(copyDeltaY);
        this.dstTypeLib = PasteCommand.checkTypeLib(copyPasteData.srcNetwork(), destination);
    }

    public boolean canExecute() {
        return this.copyPasteData != null && !this.copyPasteData.isEmpty() && this.dstFBNetwork != null;
    }

    public void execute() {
        if (this.dstFBNetwork != null) {
            ErrorMessenger.pauseMessages();
            this.updateDelta();
            this.removeDuplicateElements();
            this.copyPasteData.elements().forEach(this::copyAndCreateFB);
            this.copyConnections();
            ElementSelector.selectViewObjects(this.copiedElements.values());
            if (this.dstTypeLib != null) {
                this.createUpdateTypeCommands();
            }
            this.updateTypeCmds.execute();
            this.checkAndAddMissingImports();
            if (!ErrorMessenger.unpauseMessages().isEmpty()) {
                ErrorMessenger.popUpErrorMessage((String)Messages.PasteRecreateNotPossible, (int)-1);
            }
        }
    }

    public void undo() {
        this.updateTypeCmds.undo();
        this.connCreateCmds.undo();
        this.dstFBNetwork.getNetworkElements().removeAll(this.copiedElements.values());
        this.importCmds.undo();
    }

    public void redo() {
        this.dstFBNetwork.getNetworkElements().addAll(this.copiedElements.values());
        this.connCreateCmds.redo();
        this.updateTypeCmds.redo();
        ElementSelector.selectViewObjects(this.copiedElements.values());
        this.importCmds.redo();
    }

    private void checkAndAddMissingImports() {
        ArrayList neededImports = new ArrayList();
        for (FBNetworkElement elem : this.copiedElements.keySet()) {
            LibraryElement srcLE;
            EObject srcObj = EcoreUtil.getRootContainer((EObject)elem);
            if (!(srcObj instanceof LibraryElement) || (srcLE = (LibraryElement)srcObj).getCompilerInfo() == null) continue;
            srcLE.getCompilerInfo().getImports().stream().map(Import::getImportedNamespace).forEach(neededImports::add);
        }
        EObject destContainer = EcoreUtil.getRootContainer((EObject)this.dstFBNetwork);
        if (destContainer instanceof LibraryElement) {
            LibraryElement le = (LibraryElement)destContainer;
            if (le.getCompilerInfo() == null) {
                le.setCompilerInfo(LibraryElementFactory.eINSTANCE.createCompilerInfo());
            }
            List<String> importNames = le.getCompilerInfo().getImports().stream().map(Import::getImportedNamespace).toList();
            for (String importName : neededImports) {
                if (importNames.contains(importName)) continue;
                AddNewImportCommand importCmd = new AddNewImportCommand(le, importName);
                if (importCmd.canExecute()) {
                    importCmd.execute();
                }
                this.importCmds.add((Command)importCmd);
            }
        }
    }

    private void removeDuplicateElements() {
        this.copyPasteData.elements().removeIf(element -> this.copyPasteData.elements().stream().filter(SubApp.class::isInstance).map(SubApp.class::cast).filter(subapp -> !subapp.isTyped()).anyMatch(subapp -> subapp.getSubAppNetwork().getNetworkElements().contains(element)));
        this.copyPasteData.elements().removeIf(element -> this.copyPasteData.elements().stream().filter(Group.class::isInstance).map(Group.class::cast).anyMatch(group -> group.getGroupElements().contains(element)));
    }

    private void updateDelta() {
        if (this.calculateDelta) {
            if (this.pasteRefPos != null) {
                double x = Double.MAX_VALUE;
                double y = Double.MAX_VALUE;
                for (FBNetworkElement element : this.copyPasteData.elements()) {
                    Position pos = element.getPosition();
                    x = Math.min(x, pos.getX());
                    y = Math.min(y, pos.getY());
                }
                this.xDelta = this.pasteRefPos.getX() - x;
                this.yDelta = this.pasteRefPos.getY() - y;
            } else {
                this.xDelta = 111.11111111111111;
                this.yDelta = 111.11111111111111;
            }
        }
    }

    private FBNetworkElement copyAndCreateFB(FBNetworkElement element) {
        return this.copyAndCreateFB(element, false);
    }

    private FBNetworkElement copyAndCreateFB(FBNetworkElement element, boolean isNested) {
        FBNetworkElement copiedElement = this.createElementCopyFB(element, isNested);
        this.copiedElements.put(element, copiedElement);
        this.dstFBNetwork.getNetworkElements().add((Object)copiedElement);
        copiedElement.setName(NameRepository.createUniqueName((INamedElement)copiedElement, (String)element.getName()));
        return copiedElement;
    }

    private FBNetworkElement createElementCopyFB(FBNetworkElement element, boolean isNested) {
        FBNetworkElement copiedElement = this.createCopiedElement(element);
        if (!isNested) {
            copiedElement.setPosition(this.calculatePastePos(element));
        }
        copiedElement.setMapping(null);
        if (copiedElement instanceof StructManipulator) {
            StructManipulator copiedStructMan = (StructManipulator)copiedElement;
            PasteCommand.checkDataValues((StructManipulator)element, copiedStructMan);
        }
        if (element instanceof Group) {
            Group group = (Group)element;
            for (FBNetworkElement groupElement : group.getGroupElements()) {
                ((Group)copiedElement).getGroupElements().add((Object)this.copyAndCreateFB(groupElement, true));
            }
        }
        return copiedElement;
    }

    private FBNetworkElement createCopiedElement(FBNetworkElement element) {
        FBNetworkElement copiedElement;
        block5: {
            block3: {
                block4: {
                    copiedElement = (FBNetworkElement)EcoreUtil.copy((EObject)element);
                    if (this.dstTypeLib == null || element.getTypeEntry() == null) break block3;
                    TypeEntry dstTypeEntry = this.dstTypeLib.getFBOrSubAppType(element.getFullTypeName());
                    if (dstTypeEntry == null) break block4;
                    copiedElement.setTypeEntry(dstTypeEntry);
                    break block5;
                }
                copiedElement.setTypeEntry(this.dstTypeLib.createErrorTypeEntry(element.getFullTypeName(), element.getTypeEntry().getTypeEClass()));
                if (!(element instanceof BlockFBNetworkElement)) break block5;
                BlockFBNetworkElement bfbElement = (BlockFBNetworkElement)element;
                ((BlockFBNetworkElement)copiedElement).setInterface(bfbElement.getInterface().copy());
                break block5;
            }
            if (copiedElement instanceof BlockFBNetworkElement) {
                BlockFBNetworkElement copiedBlockElement = (BlockFBNetworkElement)copiedElement;
                for (IInterfaceElement ie : copiedBlockElement.getInterface().getAllInterfaceElements()) {
                    if (ie.isIsInput()) {
                        ie.getInputConnections().clear();
                        continue;
                    }
                    ie.getOutputConnections().clear();
                }
            }
        }
        return copiedElement;
    }

    private static void checkDataValues(StructManipulator src, StructManipulator copy) {
        EList srcList = src.getInterface().getInputVars();
        EList copyList = copy.getInterface().getInputVars();
        int i = 0;
        while (i < srcList.size()) {
            VarDeclaration srcVar = (VarDeclaration)srcList.get(i);
            VarDeclaration copyVar = (VarDeclaration)copyList.get(i);
            if (copyVar.getValue() == null) {
                copyVar.setValue(LibraryElementFactory.eINSTANCE.createValue());
            }
            if (srcVar.getValue() != null) {
                copyVar.getValue().setValue(srcVar.getValue().getValue());
            }
            ++i;
        }
    }

    private void copyConnections() {
        for (ConnectionReference connRef : this.copyPasteData.conns()) {
            AbstractConnectionCreateCommand cmd;
            BlockFBNetworkElement copiedSrc = (BlockFBNetworkElement)this.copiedElements.get(connRef.sourceElement());
            BlockFBNetworkElement copiedDest = (BlockFBNetworkElement)this.copiedElements.get(connRef.destinationElement());
            if (copiedSrc == null && copiedDest == null || (cmd = this.getConnectionCreateCmd(connRef.source())) == null) continue;
            this.copyConnection(connRef, copiedSrc, copiedDest, cmd);
            if (!cmd.canExecute()) continue;
            this.connCreateCmds.add((Command)cmd);
        }
        this.connCreateCmds.execute();
    }

    private AbstractConnectionCreateCommand getConnectionCreateCmd(IInterfaceElement source) {
        EventConnectionCreateCommand cmd = null;
        if (source instanceof Event) {
            cmd = new EventConnectionCreateCommand(this.dstFBNetwork);
        } else if (source instanceof AdapterDeclaration) {
            cmd = new AdapterConnectionCreateCommand(this.dstFBNetwork);
        } else if (source instanceof VarDeclaration) {
            cmd = new DataConnectionCreateCommand(this.dstFBNetwork);
        }
        return cmd;
    }

    private void copyConnection(ConnectionReference connRef, BlockFBNetworkElement copiedSrc, BlockFBNetworkElement copiedDest, AbstractConnectionCreateCommand cmd) {
        IInterfaceElement source = this.getInterfaceElement(connRef.source(), copiedSrc);
        IInterfaceElement destination = this.getInterfaceElement(connRef.destination(), copiedDest);
        cmd.setSource(source);
        cmd.setDestination(destination);
        cmd.setArrangementConstraints(connRef.routingData());
        cmd.setVisible(connRef.visible());
    }

    private IInterfaceElement getInterfaceElement(IInterfaceElement orig, BlockFBNetworkElement copiedElement) {
        if (copiedElement != null) {
            return copiedElement.getInterfaceElement(orig.getName());
        }
        if (this.dstFBNetwork.equals(this.copyPasteData.srcNetwork()) || this.dstFBNetwork.isSubApplicationNetwork() || this.copyPasteData.srcNetwork().isSubApplicationNetwork()) {
            return orig;
        }
        return null;
    }

    private Position calculatePastePos(FBNetworkElement element) {
        Position pastePos = LibraryElementFactory.eINSTANCE.createPosition();
        Position outermostPos = element.getPosition();
        pastePos.setX(outermostPos.getX() + this.xDelta);
        pastePos.setY(outermostPos.getY() + this.yDelta);
        return pastePos;
    }

    public Collection<FBNetworkElement> getCopiedFBs() {
        return this.copiedElements.values();
    }

    private static TypeLibrary checkTypeLib(FBNetwork srcNetwork, FBNetwork destNetwork) {
        EObject srcRoot = EcoreUtil.getRootContainer((EObject)srcNetwork);
        EObject dstRoot = EcoreUtil.getRootContainer((EObject)destNetwork);
        if (srcRoot instanceof LibraryElement) {
            LibraryElement srcLibEl = (LibraryElement)srcRoot;
            if (dstRoot instanceof LibraryElement) {
                LibraryElement dstLibEl = (LibraryElement)dstRoot;
                if (!srcLibEl.getTypeLibrary().getProject().equals((Object)dstLibEl.getTypeLibrary().getProject())) {
                    return dstLibEl.getTypeLibrary();
                }
            }
        }
        return null;
    }

    private void createUpdateTypeCommands() {
        FBNetworkHelper.getBlockFBNetworkElementsFromList(this.copiedElements.values()).forEach(fbnEl -> {
            if (fbnEl.getTypeEntry() != null && !(fbnEl instanceof ErrorMarkerFBNElement)) {
                this.updateTypeCmds.add((Command)new UpdateFBTypeCommand(fbnEl));
            }
        });
    }

    public Set<EObject> getAffectedObjects() {
        if (this.dstFBNetwork != null) {
            return Set.of(this.dstFBNetwork);
        }
        return Set.of();
    }
}

