/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.utilities;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.application.utilities.FBTypeTemplateCreationFactory;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.InterfaceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.requests.CreationFactory;

public class FbTypeTemplateTransferDropTargetListener
extends TemplateTransferDropTargetListener {
    private final IProject targetProject;

    public FbTypeTemplateTransferDropTargetListener(EditPartViewer viewer, IProject targetProject) {
        super(viewer);
        this.targetProject = targetProject;
    }

    protected void handleDragOver() {
        Object object;
        super.handleDragOver();
        this.getCurrentEvent().feedback = 24;
        this.getCurrentEvent().detail = 0;
        this.getCurrentEvent().operations = 0;
        Object object2 = TemplateTransfer.getInstance().getTemplate();
        Objects.requireNonNull(object2);
        Object object3 = object = object2;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AdapterTypeEntry.class, InterfaceTypeEntry.class, FBTypeEntry.class, SubAppTypeEntry.class, DataTypeEntry.class}, (Object)object3, n)) {
                case 0: {
                    AdapterTypeEntry adpTypeEntry = (AdapterTypeEntry)object;
                    break block7;
                }
                case 1: {
                    InterfaceTypeEntry ifTypeEntry = (InterfaceTypeEntry)object;
                    if (!(ifTypeEntry instanceof FBTypeEntry) && !(ifTypeEntry instanceof SubAppTypeEntry)) {
                        object3 = object;
                        n = 2;
                        continue block7;
                    }
                    this.handleFBDragOver((TypeEntry)ifTypeEntry);
                    break block7;
                }
                case 2: {
                    FBTypeEntry fbEntry = (FBTypeEntry)object;
                    this.handleFBDragOver((TypeEntry)fbEntry);
                    break block7;
                }
                case 3: {
                    SubAppTypeEntry fbEntry = (SubAppTypeEntry)object;
                    this.handleFBDragOver((TypeEntry)fbEntry);
                    break block7;
                }
                case 4: {
                    DataTypeEntry dataTypeEntry = (DataTypeEntry)object;
                    this.handleDataTypeDragOver(dataTypeEntry);
                    break block7;
                }
            }
            break;
        }
    }

    protected void handleDrop() {
        DataTypeEntry dataTypeEntry;
        Object object;
        if (!(this.getCurrentEvent().data instanceof FBTypeEntry || this.getCurrentEvent().data instanceof SubAppTypeEntry || (object = this.getCurrentEvent().data) instanceof DataTypeEntry && (dataTypeEntry = (DataTypeEntry)object).getType() instanceof StructuredType)) {
            return;
        }
        super.handleDrop();
        TemplateTransfer.getInstance().setTemplate(null);
    }

    private void handleFBDragOver(TypeEntry fbEntry) {
        if (this.isFromSameProject(fbEntry)) {
            this.getCurrentEvent().detail = 1;
        }
    }

    private void handleDataTypeDragOver(DataTypeEntry dataTypeEntry) {
        if (!this.isFromSameProject((TypeEntry)dataTypeEntry)) {
            return;
        }
        if (dataTypeEntry.getType() instanceof StructuredType && this.getTargetEditPart() != null && this.getTargetEditPart().getModel() instanceof ConfigurableFB) {
            this.getCurrentEvent().detail = 1;
        }
    }

    protected CreationFactory getFactory(Object template) {
        DataTypeEntry dataTypeEntry;
        this.getCurrentEvent().detail = 1;
        if (template instanceof FBType || template instanceof FBTypeEntry || template instanceof SubAppTypeEntry || template instanceof DataTypeEntry && (dataTypeEntry = (DataTypeEntry)template).getType() instanceof StructuredType) {
            return new FBTypeTemplateCreationFactory(template);
        }
        return null;
    }

    private boolean isFromSameProject(TypeEntry entry) {
        IProject srcProject = entry.getFile().getProject();
        return this.targetProject != null && this.targetProject.equals((Object)srcProject);
    }
}

