/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.elk;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;

public class FordiacLayoutData {
    private final Map<FBNetworkElement, Position> positions = new HashMap<FBNetworkElement, Position>();
    private final List<ConnectionLayoutData> connData = new ArrayList<ConnectionLayoutData>();
    private final Map<IInterfaceElement, Integer> pins = new HashMap<IInterfaceElement, Integer>();
    private final Map<Group, Map.Entry<Double, Double>> groups = new HashMap<Group, Map.Entry<Double, Double>>();

    public Map<FBNetworkElement, Position> getPositions() {
        return this.positions;
    }

    public List<ConnectionLayoutData> getConnectionPoints() {
        return this.connData;
    }

    public Map<IInterfaceElement, Integer> getPins() {
        return this.pins;
    }

    public Map<Group, Map.Entry<Double, Double>> getGroups() {
        return this.groups;
    }

    public void addPosition(FBNetworkElement element, Position position) {
        this.positions.put(element, position);
    }

    public void addConnectionPoints(Connection connection, PointList pointList) {
        this.connData.add(new ConnectionLayoutData(connection, FordiacLayoutData.createRoutingData(pointList)));
    }

    public void addPin(IInterfaceElement pin, Integer padding) {
        this.pins.put(pin, padding);
    }

    public void addGroup(Group group, int height, int width) {
        this.groups.put(group, new AbstractMap.SimpleEntry<Double, Double>(CoordinateConverter.INSTANCE.screenToIEC61499(height), CoordinateConverter.INSTANCE.screenToIEC61499(width)));
    }

    private static ConnectionRoutingData createRoutingData(PointList pointList) {
        ConnectionRoutingData routingData = LibraryElementFactory.eINSTANCE.createConnectionRoutingData();
        if (pointList.size() > 2) {
            routingData.setDx1(FordiacLayoutData.fromScreen(pointList.getPoint(1).x() - pointList.getFirstPoint().x()));
            if (pointList.size() > 4) {
                routingData.setDy(FordiacLayoutData.fromScreen(pointList.getPoint(2).y() - pointList.getFirstPoint().y()));
                routingData.setDx2(FordiacLayoutData.fromScreen(pointList.getLastPoint().x() - pointList.getPoint(pointList.size() - 2).x()));
            }
        }
        return routingData;
    }

    private static double fromScreen(int val) {
        return CoordinateConverter.INSTANCE.screenToIEC61499(val);
    }

    public record ConnectionLayoutData(Connection con, ConnectionRoutingData routingData) {
    }
}

