/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.dataexport.FBNetworkExporter;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.DeviceType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceTypeName;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class DEVExporter
extends AbstractTypeExporter {
    public DEVExporter(DeviceType type) {
        super(type);
    }

    @Override
    public DeviceType getType() {
        return (DeviceType)super.getType();
    }

    @Override
    protected String getRootTag() {
        return "DeviceType";
    }

    @Override
    protected void createTypeSpecificXMLEntries() throws XMLStreamException {
        this.addCompilerInfo(this.getType().getCompilerInfo());
        for (VarDeclaration varDecl : this.getType().getVarDeclaration()) {
            this.addVarDeclaration(varDecl);
        }
        for (ResourceTypeName rName : this.getType().getResourceTypeName()) {
            this.addStartElement("ResourceTypeName");
            this.addNameAttribute(rName.getName());
            this.addEndElement();
        }
        this.addResources(this.getType().getResource());
        FBNetwork network = this.getType().getFBNetwork();
        if (network != null && !network.getNetworkElements().isEmpty()) {
            new FBNetworkExporter(this).createFBNetworkElement(network);
        }
        this.addAttributes((EList<Attribute>)this.getType().getAttributes());
    }

    private void addResources(EList<Resource> resourceList) throws XMLStreamException {
        for (Resource resource : resourceList) {
            this.addStartElement("Resource");
            this.addNameTypeCommentAttribute(resource, resource.getType());
            this.addParamsConfig((EList<? extends VarDeclaration>)resource.getVarDeclarations());
            new FBNetworkExporter(this).createFBNetworkElement(resource.getFBNetwork());
            this.addAttributes((EList<Attribute>)this.getType().getAttributes());
            this.addEndElement();
        }
    }
}

