/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.collections.api.factory.primitive.IntIntMaps;
import org.eclipse.collections.api.map.primitive.IntIntMap;
import org.eclipse.collections.api.map.primitive.MutableIntIntMap;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.SpanningLayerCell;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommand;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;
import org.eclipse.nebula.widgets.nattable.reorder.event.RowReorderEvent;

public abstract class AbstractRowHideShowLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private MutableIntIntMap cachedVisibleRowIndexPositionMapping;
    private MutableIntIntMap cachedVisibleRowPositionIndexMapping;
    private MutableIntIntMap cachedHiddenRowIndexPositionMapping;
    private MutableIntIntMap startYCache = IntIntMaps.mutable.empty();

    public AbstractRowHideShowLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
    }

    @Override
    protected IUniqueIndexLayer getUnderlyingLayer() {
        return (IUniqueIndexLayer)super.getUnderlyingLayer();
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (this.hasHiddenRows() && event instanceof RowReorderEvent) {
            RowReorderEvent reorderEvent = (RowReorderEvent)event;
            int[] fromPositions = reorderEvent.getBeforeFromRowIndexes().stream().mapToInt(Integer::intValue).map(this::getRowPositionByIndex).filter(pos -> pos >= 0).toArray();
            List<Range> fromRanges = PositionUtil.getRanges(fromPositions);
            int pos2 = -1;
            if (!this.isRowIndexHidden(reorderEvent.getBeforeToRowIndex())) {
                pos2 = this.getRowPositionByIndex(reorderEvent.getBeforeToRowIndex());
            } else {
                int i = 1;
                while (pos2 < 0) {
                    int next = reorderEvent.getBeforeToRowPosition() + i;
                    if (next >= this.underlyingLayer.getColumnCount()) break;
                    pos2 = this.underlyingToLocalRowPosition(this.underlyingLayer, next);
                    ++i;
                }
                if (pos2 >= 0) {
                    reorderEvent.setBeforeToRowIndex(this.getRowIndexByPosition(pos2));
                }
            }
            if (pos2 >= 0) {
                reorderEvent.setConvertedBeforePositions(this, fromRanges, pos2);
            }
        }
        if (event instanceof IStructuralChangeEvent) {
            IStructuralChangeEvent structuralChangeEvent = (IStructuralChangeEvent)event;
            if (structuralChangeEvent.isVerticalStructureChanged()) {
                this.invalidateCache();
            }
        } else if (event instanceof VisualRefreshEvent) {
            this.startYCache = IntIntMaps.mutable.empty();
        }
        super.handleLayerEvent(event);
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ConfigureScalingCommand) {
            this.invalidateCache();
        }
        return super.doCommand(command);
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.getUnderlyingLayer().getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int getRowCount() {
        if (!this.hasHiddenRows()) {
            return super.getRowCount();
        }
        return this.getCachedVisibleRowIndexPositionMapping().size();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        if (rowPosition < 0 || rowPosition >= this.getRowCount()) {
            return -1;
        }
        if (!this.hasHiddenRows()) {
            return super.getRowIndexByPosition(rowPosition);
        }
        return this.getCachedVisibleRowPositionIndexMapping().getIfAbsent(rowPosition, -1);
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        if (!this.hasHiddenRows()) {
            return this.getUnderlyingLayer().getRowPositionByIndex(rowIndex);
        }
        return this.getCachedVisibleRowIndexPositionMapping().getIfAbsent(rowIndex, -1);
    }

    public Collection<Integer> getRowPositionsByIndexes(Collection<Integer> rowIndexes) {
        HashSet<Integer> rowPositions = new HashSet<Integer>();
        for (int rowIndex : rowIndexes) {
            rowPositions.add(this.getRowPositionByIndex(rowIndex));
        }
        return rowPositions;
    }

    public int[] getRowPositionsByIndexes(int ... rowIndexes) {
        return rowIndexes != null && rowIndexes.length > 0 ? Arrays.stream(rowIndexes).map(this::getRowPositionByIndex).toArray() : new int[]{};
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        if (localRowPosition < 0 || localRowPosition >= this.getRowCount()) {
            return -1;
        }
        if (!this.hasHiddenRows()) {
            return localRowPosition;
        }
        int rowIndex = this.getRowIndexByPosition(localRowPosition);
        return this.getUnderlyingLayer().getRowPositionByIndex(rowIndex);
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        if (!this.hasHiddenRows()) {
            return underlyingRowPosition;
        }
        int rowIndex = this.getUnderlyingLayer().getRowIndexByPosition(underlyingRowPosition);
        int rowPosition = this.getRowPositionByIndex(rowIndex);
        if (rowPosition >= 0) {
            return rowPosition;
        }
        return this.getCachedHiddenRowIndexPositionMapping().getIfAbsent(rowIndex, -1);
    }

    @Override
    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        ArrayList<Range> localRowPositionRanges = new ArrayList<Range>(underlyingRowPositionRanges.size());
        for (Range underlyingRowPositionRange : underlyingRowPositionRanges) {
            int startRowPosition = this.getAdjustedUnderlyingToLocalStartPosition(sourceUnderlyingLayer, underlyingRowPositionRange.start, underlyingRowPositionRange.end);
            int endRowPosition = this.getAdjustedUnderlyingToLocalEndPosition(sourceUnderlyingLayer, underlyingRowPositionRange.end, underlyingRowPositionRange.start);
            if (startRowPosition <= -1) continue;
            localRowPositionRanges.add(new Range(startRowPosition, endRowPosition));
        }
        return localRowPositionRanges;
    }

    private int getAdjustedUnderlyingToLocalStartPosition(ILayer sourceUnderlyingLayer, int startUnderlyingPosition, int endUnderlyingPosition) {
        int localStartRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, startUnderlyingPosition);
        int offset = 0;
        while (localStartRowPosition < 0 && startUnderlyingPosition + offset < endUnderlyingPosition) {
            localStartRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, startUnderlyingPosition + offset++);
        }
        return localStartRowPosition;
    }

    private int getAdjustedUnderlyingToLocalEndPosition(ILayer sourceUnderlyingLayer, int endUnderlyingPosition, int startUnderlyingPosition) {
        int localEndRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, endUnderlyingPosition - 1);
        int offset = 0;
        while (localEndRowPosition < 0 && endUnderlyingPosition - offset > startUnderlyingPosition) {
            localEndRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, endUnderlyingPosition - offset++);
        }
        return localEndRowPosition + 1;
    }

    @Override
    public int getHeight() {
        if (this.getRowCount() == 0) {
            return 0;
        }
        int lastRowPosition = this.getRowCount() - 1;
        return this.getStartYOfRowPosition(lastRowPosition) + this.getRowHeightByPosition(lastRowPosition);
    }

    @Override
    public int getRowPositionByY(int y) {
        return LayerUtil.getRowPositionByY(this, y);
    }

    @Override
    public int getStartYOfRowPosition(int localRowPosition) {
        int cachedStartY = this.startYCache.getIfAbsent(localRowPosition, -1);
        if (cachedStartY != -1) {
            return cachedStartY;
        }
        IUniqueIndexLayer underlyingLayer = this.getUnderlyingLayer();
        int underlyingPosition = this.localToUnderlyingRowPosition(localRowPosition);
        if (underlyingPosition < 0) {
            return -1;
        }
        int underlyingStartY = underlyingLayer.getStartYOfRowPosition(underlyingPosition);
        if (underlyingStartY < 0) {
            return -1;
        }
        int[] nArray = this.getHiddenRowIndexesArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int hiddenIndex = nArray[n2];
            int hiddenPosition = underlyingLayer.getRowPositionByIndex(hiddenIndex);
            if (hiddenPosition >= 0 && hiddenPosition <= underlyingPosition) {
                underlyingStartY -= underlyingLayer.getRowHeightByPosition(hiddenPosition);
            }
            ++n2;
        }
        this.startYCache.put(localRowPosition, underlyingStartY);
        return underlyingStartY;
    }

    public abstract boolean isRowIndexHidden(int var1);

    public abstract Collection<Integer> getHiddenRowIndexes();

    public abstract int[] getHiddenRowIndexesArray();

    public abstract boolean hasHiddenRows();

    @Override
    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        ILayerCell cell = super.getCellByPosition(columnPosition, rowPosition);
        if (cell != null && cell.isSpannedCell()) {
            int underlyingColumnPosition = this.localToUnderlyingColumnPosition(columnPosition);
            int underlyingRowPosition = this.localToUnderlyingRowPosition(rowPosition);
            ILayerCell underlyingCell = this.underlyingLayer.getCellByPosition(underlyingColumnPosition, underlyingRowPosition);
            boolean rowSpanUpdated = false;
            int rowSpan = underlyingCell.getRowSpan();
            int row = 0;
            while (row < underlyingCell.getRowSpan()) {
                int rowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingCell.getOriginRowPosition() + row);
                if (this.isRowIndexHidden(rowIndex)) {
                    --rowSpan;
                    rowSpanUpdated = true;
                }
                ++row;
            }
            if (rowSpanUpdated) {
                cell = new SpanningLayerCell(cell, cell.getColumnSpan(), rowSpan);
            }
        }
        return cell;
    }

    protected synchronized void invalidateCache() {
        this.cachedVisibleRowIndexPositionMapping = null;
        this.cachedVisibleRowPositionIndexMapping = null;
        this.cachedHiddenRowIndexPositionMapping = null;
        this.startYCache = IntIntMaps.mutable.empty();
    }

    private synchronized IntIntMap getCachedVisibleRowIndexPositionMapping() {
        if (this.cachedVisibleRowIndexPositionMapping == null) {
            this.cacheVisibleRowIndexes();
        }
        return this.cachedVisibleRowIndexPositionMapping;
    }

    private synchronized IntIntMap getCachedVisibleRowPositionIndexMapping() {
        if (this.cachedVisibleRowPositionIndexMapping == null) {
            this.cacheVisibleRowIndexes();
        }
        return this.cachedVisibleRowPositionIndexMapping;
    }

    private synchronized IntIntMap getCachedHiddenRowIndexPositionMapping() {
        if (this.cachedHiddenRowIndexPositionMapping == null) {
            this.cacheVisibleRowIndexes();
        }
        return this.cachedHiddenRowIndexPositionMapping;
    }

    protected synchronized void cacheVisibleRowIndexes() {
        this.cachedVisibleRowIndexPositionMapping = IntIntMaps.mutable.empty();
        this.cachedVisibleRowPositionIndexMapping = IntIntMaps.mutable.empty();
        this.cachedHiddenRowIndexPositionMapping = IntIntMaps.mutable.empty();
        this.startYCache = IntIntMaps.mutable.empty();
        if (this.hasHiddenRows()) {
            IUniqueIndexLayer underlyingLayer = this.getUnderlyingLayer();
            int rowPosition = 0;
            int parentRowPosition = 0;
            while (parentRowPosition < underlyingLayer.getRowCount()) {
                int rowIndex = underlyingLayer.getRowIndexByPosition(parentRowPosition);
                if (!this.isRowIndexHidden(rowIndex)) {
                    this.cachedVisibleRowIndexPositionMapping.put(rowIndex, rowPosition);
                    this.cachedVisibleRowPositionIndexMapping.put(rowPosition, rowIndex);
                    ++rowPosition;
                } else {
                    this.cachedHiddenRowIndexPositionMapping.put(rowIndex, rowPosition);
                }
                ++parentRowPosition;
            }
        }
    }
}

